/*
  ************************************************************************
  ************************************************************************

    Copyright (C) 1995   Michael J. Oehler

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 Module Description:

  ************************************************************************
  ************************************************************************
*/
#include <Xm/Label.h>
#include <Xm/List.h>
#include "crd.h"


/*
  ************************************************************************
  ************************************************************************
   Name:
      View_Menu_callback

   Purpose:
      This is the callback routine for the "view" sub buttons on the main menu.
      It calls the necessary routines to perform the requested task.

     Calling Sequence:
         This routine is called when the either of the radio
         buttons from the main menu's "View" button are selected.

     Description:
         This routines calls the specific function requested based
         on the integer value passed to the routine. The integer
         represents which button in the sub menu called this
         callback routine.

  ************************************************************************
  ************************************************************************
*/
extern void View_Menu_Callback(widget, item_no)
Widget widget;
int item_no;

{
int i;
Card_Content_Ptr tmp_ptr;
Card_Ptr data_ptr;

switch (item_no) {
 /* "Card view */
 case 0: {

     /* If we are already in "card" view, just return */
     if (head_ptr->card_view) return;
     
     /* Set "card" view on, turn off the scrolled widget */
     head_ptr->card_view = True;
     if (head_ptr->scroll)
	     XtUnmapWidget(head_ptr->scroll);

     /* any_To_Map doesn't expect the first card to be unmapped! */
     XtMapWidget(head_ptr->viewable_cards->form);
     (head_ptr->visible_spots)++;
     (head_ptr->available_spots)--;

     Any_To_Map(head_ptr->cards);
     break;
 }

 /* "List view */
 case 1: {
     if (!head_ptr->card_view) 
	     return;

     /* Set to List View & Get any data entered from the primary card */
     head_ptr->card_view = False;
     Grab_Primary_Card_Data(widget);

     /* Remove all card widgets */
     tmp_ptr = head_ptr->viewable_cards;
     for (i = head_ptr->visible_spots; i > 0; i--) 
     {
	 /* Increase available & decrease visible card_widgets */
	 (head_ptr->available_spots)++;
	 XtUnmapWidget(tmp_ptr->form);
	 tmp_ptr = tmp_ptr->next;
     }
     head_ptr->visible_spots = 0;

     /* Show the Scrolled List Widget */
     XtMapWidget(head_ptr->scroll);
     
     /* Now display map in the data to the scroll list */
     Any_To_Map(head_ptr->cards);
     
 } /* case */
     
 } /* switch */

Redraw_List();	   
} /* end View_Menu_Callback */




/*
  ************************************************************************
  ************************************************************************
   Name:
     List_View_Callback
   Purpose:
    When the user select in item from the list, move internal pointers to
    selected item.
    
   Calling Sequence:
    This procedure can only be called when list view is active.
    The must point and click on an entry in the Scrolled List.
     
   Description:

  ************************************************************************
  ************************************************************************

*/
extern void List_View_Callback(list_w, client_data, cbs)
Widget list_w;
XtPointer client_data;
XmListCallbackStruct *cbs;
{
 int *pos_list, pos_cnt, position;
 Card_Ptr tmp_ptr;
 
	 
 if (XmListGetSelectedPos(head_ptr->scroll, &pos_list, &pos_cnt) ) 
 {
     tmp_ptr = head_ptr->card_data;

     for (position = (int) *pos_list -1; position ; position--)
	     tmp_ptr = tmp_ptr->next;
     head_ptr->primary_card = tmp_ptr;
     XtFree((char *) pos_list);
 }
} /* end List_View_Callback */
