/*****************************************************************************

	callbacks.c

	Environment:    Unix R40V3/Solaris2/Linux.

	Revision history:	@(#)callbacks.c	1.9	97/06/23


	DESCRIPTION: Part of the Mdb Application.
			This module contains the interface
			to the main action callbacks.

        COPYRIGHT NOTICE:
        Permission to use,  copy,  modify,  and  distribute  this
        software  and  its    documentation   is  hereby  granted
        without fee, provided that  the  above  copyright  notice
        appear  in all copies and that both that copyright notice
        and  this  permission   notice   appear   in   supporting
        documentation.  The   author  makes  no   representations
        about   the   suitability   of   this  software  for  any
        purpose.  It  is  provided  "as  is"  without  express or
        implied warranty.

        THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD  TO  THIS
        SOFTWARE,    INCLUDING    ALL   IMPLIED   WARRANTIES   OF
        MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL THE AUTHOR
        BE  LIABLE  FOR  ANY  SPECIAL,  INDIRECT OR CONSEQUENTIAL
        DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS  OF
        USE, DATA OR PROFITS, WHETHER IN AN ACTION  OF  CONTRACT,
        NEGLIGENCE  OR  OTHER  TORTIOUS   ACTION,   ARISING   OUT
        OF   OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
        SOFTWARE.

******************************************************************************/
/******************************************************************************/
#pragma ident "@(#)callbacks.c	1.9	97/06/23"

#include "mdb.h"

/*
 * Externals.
 */
extern items	Item[];

extern void	save(int cd);
extern void	list(Widget top);
extern void	mail(Widget top );
extern void	import(Widget top);
extern void	export(Widget top);
extern void	config(Widget top);
extern void	gsearch(Widget top);
extern void	gchange(Widget top);
extern void	mdbprint(Widget top);
extern char	*ConfigTestFile(void);
extern void	copy_paste(Widget top);
extern void	edit(Widget top, int item);
extern void	search(Widget top, Boolean prev);
extern void	GetXYd( Dimension *x, Dimension *y );

extern void	help_close(Widget top);
extern void	edit_close(Widget top);
extern void	list_close(Widget top);
extern void	copyp_close(Widget top);
extern void	print_close(Widget top);
extern void	export_close(Widget top);
extern void	import_close(Widget top);
extern void	config_close(Widget top);
extern void	gsearch_close(Widget top);
extern void	gchange_close(Widget top);
extern void	printOpt_close(Widget top);
extern void	mail_close(Widget top, Boolean all);

extern void	MdbSens(Boolean stat);
extern void	WrtSens(Boolean stat);

extern Boolean	Case;
extern Boolean	Debug;
extern Boolean	Fmode;
extern long	NextPos;


/*ARGSUSED*/
void main_cb( Widget w, int client_data, XmPushButtonCallbackStruct *cbs )
{

	/*
	 * Take down any Error Dialog.
	 */
	xpmsg_close();

	/*
	 * Quit mdb.
	 */
	if ( (client_data == QUIT) || (client_data == ABORT) ) {
		RemoveTempFiles();
		exit(client_data);
	}

	/*
	 * Launch the List All Dialog.
	 */
	if ( client_data == LIST ) {
		list(GetTopWidget());
		return;
	}

	/*
	 * Launch the Import DB Dialog.
	 */
	if ( client_data == IMP ) {

		if ( Fmode == False ) {
			errno = 0;
			(void)xpmsg( NULL,
				"error: the folder is in read-only state" );
			return;
		}
		reset_cb( NULL, ALL, NULL );
		import(GetTopWidget());
		return;
	}

	/*
	 * Launch the Export DB Dialog.
	 */
	if ( client_data == EXP ) {
		reset_cb( NULL, ALL, NULL );
		export(GetTopWidget());
		return;
	}

	/*
	 * Launch the Print Dialog.
	 */
	if ( client_data == PRINT ) {
		mdbprint(GetTopWidget());
		return;
	}

	/*
	 * Launch the Copy And Paste Dialog.
	 */
	if ( client_data == CUTP ) {

		if ( ! *xread( GetKeyItem() ) ) {
			errno = 0;
			(void)xpmsg(NULL, "error: no %s",
				    Item[GetKeyItem()].title);
			return;
		}
		copy_paste(GetTopWidget());
		return;
	}

	/*
	 * Toggle Case Sensitivity.
	 */
	if ( client_data == CASE ) {
		Case = Case == True ? False : True;
		return;
	}

}


/*ARGSUSED*/
void gsearch_cb( Widget w, int client_data, XmPushButtonCallbackStruct *cbs )
{

	/*
	 * Launch the Global Search Dialog.
	 */
	xpmsg_close();
	list_close(NULL);
	gsearch(GetTopWidget());
}


/*ARGSUSED*/
void gchange_cb( Widget w, int client_data, XmPushButtonCallbackStruct *cbs )
{
	/*
	 * Launch the Global Change Dialog.
	 */
	xpmsg_close();
	gchange(GetTopWidget());
}


/*ARGSUSED*/
void search_cb( Widget w, int client_data, XmPushButtonCallbackStruct *cbs )
{

	/*
	 * Search for Key Items.
	 */
	char *dbuff;
	char dbuff1[1024];
	size_t cnt;

	xpmsg_close();

	/*
	 * Reset search.
	 */
	if ( client_data == GO )
		NextPos = 0;

	dbuff = xread( GetKeyItem() );
	cnt = strlen(dbuff);

	/*
	 * Insert a wildcard into one of the Keys.
	 */
	if ( GetSKeyItem() ) {

		dbuff = xread( GetSKeyItem() );

		if ( strlen(dbuff) && ! cnt ) {
			xwrite( "*", GetKeyItem() );
			cnt++;
		} else if ( cnt && ! strlen(dbuff) ) {
			xwrite( "*", GetSKeyItem() );
			cnt++;
		}

	}

	if ( ! cnt ) {

		(void)sprintf( dbuff,"error: no %s", Item[GetKeyItem()].title );

		if ( GetSKeyItem() ) {
			(void)sprintf( dbuff1, ", or no %s",
					Item[GetSKeyItem()].title );
			(void)strcat( dbuff, dbuff1 );
		}

		errno = 0;
		(void)xpmsg( NULL, dbuff );
		return;
	}

	if ( client_data == PREV )
		search(GetTopWidget(), True);
	else
		search(GetTopWidget(), False);

}


/*ARGSUSED*/
void save_cb( Widget w, int client_data, XmPushButtonCallbackStruct *cbs )
{

	/*
	 * Save or Update Item.
	 */

	xpmsg_close();

	if ( ! *xread( GetKeyItem() ) ) {
		errno = 0;
		(void)xpmsg( NULL, "error: no %s", Item[GetKeyItem()].title );
		return;
	}

	save(client_data);
}


/*ARGSUSED*/
void close_cb( Widget top, Widget w, XmAnyCallbackStruct *cbs )
{

	/*
	 * Honor the WM Request <Close> action.
	 * The routines below decides themselves
	 * whether to honor the request or not.
	 */

	xpmsg_close();
	edit_close(w);
	copyp_close(w);
	list_close(w);
	help_close(w);
	print_close(w);
	import_close(w);
	export_close(w);
	config_close(w);
	gsearch_close(w);
	gchange_close(w);
	printOpt_close(w);
	mail_close(w, True);

}


/*ARGSUSED*/
void reset_cb( Widget w, int client_data, XmPushButtonCallbackStruct *cbs )
{
	int witem;

	/*
	 * Reset the screen to default state.
	 */
	for( witem = 0; witem < GetMaxItems(); witem++ )
		xwrite( "", witem );

	xpmsg_close();
	edit_close(NULL);
	copyp_close(NULL);
	import_close(NULL);
	export_close(NULL);
	gsearch_close(NULL);
	gchange_close(NULL);

	if ( client_data == ALL ) {
		list_close(NULL);
		print_close(NULL);
	}

	if ( ! Debug )
		config_close(NULL);

	NextPos = 0;
	PrvSens(False);

}


/*ARGSUSED*/
void folder_cb( Widget w, int client_data, XmPushButtonCallbackStruct *cbs )
{

	/*
	 * Switch Folder / toggle write protect.
	 */
	char dbuff[PATH_MAX];

	xpmsg_close();

	if ( client_data == PRT ) {
		if ( Fmode == False && db_iswritable() == False ) {
			errno = EACCES;
			(void)xpmsg( NULL,
				"error: Consult your system administrator" );
			XmToggleButtonSetState(  w, False, False );
			return;
		}

		/*
	 	 * Write proteckt Toggle request.
		 */
		WrtSens( Fmode = Fmode == True ? False : True );
		(void)GchSens( Fmode );
		return;
	}

	/*
	 * Take down all Dialogues.
	 */
	reset_cb( NULL, ALL, NULL );
	mail_close(NULL, False);

	Fmode = False;
	WrtSens( Fmode );

	(void)strcpy( dbuff, GetFolderPath() );

	if ( ! strncmp( GetFolder(client_data), FUNDEF, sizeof(FUNDEF)-1 ) ) {
		(void)xpmsg( NULL,
			     "error: Use the Configurator to define folders" );
		return;
	}

	/*
	 * Initialize the folder.
	 */
	if ( db_init( GetFolder(client_data), dbuff ) ) {
		(void)xpmsg( NULL, "error: can't open folder" );
		XtVaSetValues( GetTopWidget(), XtNtitle, "No Folder", NULL );
		MdbSens( False );
		return;
	}

	/*
	 * Verify Layout.
	 */
	if ( strcmp( GetFolderClass(), db_class() ) ) {


		errno = 0;
		(void)xpmsg( NULL,
			"error: incompatible layout - %s", db_class() );

		XtVaSetValues( GetTopWidget(), XtNtitle, "No Folder", NULL );

		MdbSens( False );
		mail_close(NULL, True);
		return;
	}

	/*
	 * Update Title Bar.
	 */
	(void)sprintf( dbuff, "Active Folder is: %s", db_folderrev() );
	XtVaSetValues( GetTopWidget(), XtNtitle, dbuff, NULL );
	MdbSens( True );
	PrvSens( False );

}


/*ARGSUSED*/
void edit_cb( Widget w, int client_data, XmPushButtonCallbackStruct *cbs )
{

	/*
	 * Launch the Edit Remarks Dialog.
	 */
	xpmsg_close();

	edit( GetTopWidget(), client_data );
}


/*ARGSUSED*/
void mail_cb( Widget w, int client_data, XmPushButtonCallbackStruct *cbs )
{

	/*
	 * Toggle E-mail button sensitive.
	 */
	if ( w == Item[GetMailItem()].w ) {
		if ( XmTextGetLastPosition(w) )
			XtSetSensitive( (Widget)client_data, True );
		else
			XtSetSensitive( (Widget)client_data, False );
		return;
	}

	/*
	 * Launch mailer.
	 */
	xpmsg_close();

	mail( GetTopWidget() );
}


/*ARGSUSED*/
void help_cb( Widget w, int client_data, XmPushButtonCallbackStruct *cbs )
{
	/*
	 * Launch the Help Dialog.
	 */
	help( w, client_data, HHE );
}


/*ARGSUSED*/
void layout_cb( Widget w, int client_data, XmPushButtonCallbackStruct *cbs )
{

	/*
	 * Switch layout. Here we are restarting
	 * mdb with the -layout option set.
	 */
	pid_t pid;
	Boolean create = False;
	char dbuff[1024];
	char dbuff1[PATH_MAX];
	char *appc, *arg;
	int i;
	Dimension x, xd, y, yd;

	if ( client_data == TEST ) {
		(void)strcpy( dbuff1, ConfigTestFile() );
		appc = strrchr( dbuff1, '/' );
		appc++;
		Debug = True;
		arg = "-test";
	} else if ( client_data == CHANGED ) {
		appc = GetAppClass();
		arg = "-debug";
	} else {
		(void)strcpy( dbuff1,  GetLayout(client_data) );
		if ( (appc = strrchr( dbuff1, '(' )) == NULL ) {
			errno = 0;
			(void)xpmsg( NULL, "error: invalid layout syntax" );
			return;
		}
		appc++;
		appc[strlen(appc)-1] = '\0';
		arg = "-debug";

		if ( TouchLayout( appc , &create ) == NULL ) {
			errno = 0;
			(void)xpmsg( NULL,
				     "error: \"%s\" not yet Configured", appc );
			return;
		}
	}

	reset_cb( NULL, ALL, NULL );
	mail_close( NULL, True );

	XtVaGetValues( GetTopWidget(), XmNx, &x, XmNy, &y,  NULL );
	GetXYd( &xd, &yd );
	x -= xd; y -= yd;

	(void)sprintf( dbuff, "exec %s -layout %s %s %s -hello -geom +%d+%d",
			GetArgv(), appc, Debug ? arg : "",
			GetAppOrientation() == XmHORIZONTAL ? "-hrz" : "",
			x, y );


	if ( client_data != TEST )
		(void)xpmsg( NULL, "work: Please Wait..." );

	if ( GetStartDir() != NULL )
		(void)chdir( GetStartDir() );

	if ( (pid = fork()) == 0 ) {
		(void)execl( "/bin/sh", "sh", "-c", dbuff, NULL);
		_exit(1);
	}
	if ( pid == -1 ) {
		(void)xpmsg( NULL, "error: Can't change" );
		return;
	}

	/*
	 * Wait a little while, and
	 * then exit this session.
	 * An interrupt keeps this
	 * session, i.e, we get two.
	 */
	if ( client_data != TEST ) {
		for( i = 0; i < 5; i++ ) {
			Wait(1);
			if ( CheckForInterrupt(1) ) {
				(void)xpmsg( NULL, "info: - INTERRUPTED" );
				return;
			}
		}

		main_cb( NULL, QUIT, NULL );
	} else Debug = False;
}


/*ARGSUSED*/
void verify_cb(Widget w, int cd, XmTextVerifyCallbackStruct *cbs)
{
	int i;
	cbs->doit = True;

	/*
	 * Here are som chars we
	 * will deny in Text Fields.
	 * Also called from import.c
	 */
	for ( i = 0; i < cbs->text->length; i++ ) {
		switch (cbs->text->ptr[i]) {
			case '(': cbs->text->ptr[i] = '{'; break;
			case ')': cbs->text->ptr[i] = '}'; break;
			case '[': cbs->text->ptr[i] = '{'; break;
			case ']': cbs->text->ptr[i] = '}'; break;
			case '<': cbs->text->ptr[i] = '{'; break;
			case '>': cbs->text->ptr[i] = '}'; break;
			case '#': cbs->text->ptr[i] = ' '; break;
			case '\n': cbs->text->ptr[i] = ' '; break;
		}
#if ! defined(linux)
		/*
		 * Full locale support required.
		 */
		if ( w == NULL ) {
			if ( isprint(cbs->text->ptr[i]) == False )
				cbs->text->ptr[i] = ' ';
		}
#endif
	}
}


/*ARGSUSED*/
void config_cb( Widget w, int client_data, XmPushButtonCallbackStruct *cbs )
{
	/*
	 * Launch the Config Dialog.
	 */
	reset_cb( NULL, ALL, NULL );
	config( GetTopWidget() );
}
