/*****************************************************************************

	io.c

	Environment:    Unix R40V3/Solaris2/Linux.

	Revision history:	@(#)io.c	1.9	97/06/23


	DESCRIPTION: Part of the Mdb Application.
			Generalized I.O routines.


        COPYRIGHT NOTICE:
        Permission to use,  copy,  modify,  and  distribute  this
        software  and  its    documentation   is  hereby  granted
        without fee, provided that  the  above  copyright  notice
        appear  in all copies and that both that copyright notice
        and  this  permission   notice   appear   in   supporting
        documentation.  The   author  makes  no   representations
        about   the   suitability   of   this  software  for  any
        purpose.  It  is  provided  "as  is"  without  express or
        implied warranty.

        THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD  TO  THIS
        SOFTWARE,    INCLUDING    ALL   IMPLIED   WARRANTIES   OF
        MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL THE AUTHOR
        BE  LIABLE  FOR  ANY  SPECIAL,  INDIRECT OR CONSEQUENTIAL
        DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS  OF
        USE, DATA OR PROFITS, WHETHER IN AN ACTION  OF  CONTRACT,
        NEGLIGENCE  OR  OTHER  TORTIOUS   ACTION,   ARISING   OUT
        OF   OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
        SOFTWARE.

******************************************************************************/
/******************************************************************************/
#pragma ident "@(#)io.c      1.9		97/06/23"

#include "mdb.h"

/*
 * Externals.
 */
extern items	Item[];

/*
 * Local Variables.
 */
static Boolean	Silent = False;


/*
 * Write a db item.
 */
/*ARGSUSED*/
void xwrite( char *lbuff, int item )
{

	Radio *rptr;
	int i;

	if ( ( item >= GetMaxItems() ) || ( Item[item].type == NULLW ) )
		return;

	if ( Silent == True ) {

		Item[item].data[0] = '\0';

		if ( Item[item].type == TOGLW ) {


			if ( toupper(*lbuff) == ACTIVE ) {
				Item[item].data[0] = ACTIVE;
				Item[item].data[1] = '\0';
			}

			return;
		}

		(void)strcpy( Item[item].data, lbuff );

		return;
	}

	if ( Item[item].type == TOGLW ) {
		if ( toupper(*lbuff) == ACTIVE )
			XmToggleButtonSetState(  Item[item].w, True, False );
		else
			XmToggleButtonSetState(  Item[item].w, False, False );
		return;
	}

	if (  Item[item].type == RADIOW ) {

		rptr = (Radio *)Item[item].w;
		i = 0;

		while( rptr->button[i] ) {

			if ( ! *lbuff ) {
				XmToggleButtonSetState( rptr->button[i],
					False, False );
				i++;
				continue;
			}

			if ( ! strcmp( lbuff, &rptr->label[i*MAXRBL] ) ) {
				XmToggleButtonSetState( rptr->button[i],
					True, True );
				break;
			}
			i++;
		}
		return;
	}

	XmTextSetString( Item[item].w, lbuff );
}


/*
 * Read a db item.
 */
/*ARGSUSED*/
char *xread( int item )
{
	int i;
	char *ptr;
	Radio *rptr;

	if ( ( item >= GetMaxItems() ) || ( Item[item].type == NULLW ) )
		return("");

	if ( Silent == True )
		return(Item[item].data);

	if ( Item[item].type == TOGLW ) {

		Item[item].data[0] = '\0';

		if ( XmToggleButtonGetState(Item[item].w) ) {
			Item[item].data[0] = ACTIVE;
			Item[item].data[1] = '\0';
			
		}

		return(Item[item].data);
	}

	if (  Item[item].type == RADIOW ) {

		rptr = (Radio *)Item[item].w;
		i = 0;

		Item[item].data[0] = '\0';

		while( rptr->button[i] ) {

			if ( XmToggleButtonGetState(rptr->button[i]) ) {
				(void)strcpy( Item[item].data,
					&rptr->label[i*MAXRBL] );
				break;
			}
			i++;
		}
		return(Item[item].data);
	}

	ptr = XmTextGetString( Item[item].w );
	(void)strcpy( Item[item].data, ptr );
	XtFree( ptr );

	return(Item[item].data);
}


/*
 * Unpack and view item.
 */
/*ARGSUSED*/
void setitem( char *dbuff )
{

	char *ptr;

	if ( (ptr = strrchr( dbuff, '[' )) != NULL ) {
		*strrchr( dbuff, ']' ) = '\0';
		*--ptr = '\0';
		ptr += 2;
		if ( GetSKeyItem() )
			xwrite( ptr, GetSKeyItem() );
	}

	xwrite( dbuff, GetKeyItem() );
}


/*ARGSUSED*/
void db_silent( Boolean stat )
{
	Silent = stat;
}
