/*****************************************************************************

	misc.c

	Environment:    Unix R40V3/Solaris2/Linux.

	Revision history:	@(#)misc.c	1.9	97/06/23


	DESCRIPTION: Part of the Mdb Application.
			Genralized utility routines to
			create various Motif objects.

        COPYRIGHT NOTICE:
        Permission to use,  copy,  modify,  and  distribute  this
        software  and  its    documentation   is  hereby  granted
        without fee, provided that  the  above  copyright  notice
        appear  in all copies and that both that copyright notice
        and  this  permission   notice   appear   in   supporting
        documentation.  The   author  makes  no   representations
        about   the   suitability   of   this  software  for  any
        purpose.  It  is  provided  "as  is"  without  express or
        implied warranty.

        THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD  TO  THIS
        SOFTWARE,    INCLUDING    ALL   IMPLIED   WARRANTIES   OF
        MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL THE AUTHOR
        BE  LIABLE  FOR  ANY  SPECIAL,  INDIRECT OR CONSEQUENTIAL
        DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS  OF
        USE, DATA OR PROFITS, WHETHER IN AN ACTION  OF  CONTRACT,
        NEGLIGENCE  OR  OTHER  TORTIOUS   ACTION,   ARISING   OUT
        OF   OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
        SOFTWARE.

******************************************************************************/
/******************************************************************************/
#pragma ident "@(#)misc.c      1.9		97/06/23"

#include "mdb.h"
#include <wait.h>

/*
 * Externals.
 */
extern void close_cb( Widget top, Widget w, XmAnyCallbackStruct *cbs );

/*
 * Local Variables.
 */
static XrmDatabase Dbase;
static int TmpIndx = 0;


/*ARGSUSED*/
Widget
CreateRowColumn(Widget parent, String name, unsigned char ori, int border)
{

	Widget widget;
	int n = 0;
	Arg args[10];

	if (border) {
		XtSetArg( args[n], XmNborderWidth, border ); n++;
	}
	XtSetArg( args[n], XmNmarginWidth,	0 ); n++;
	XtSetArg( args[n], XmNmarginHeight,	0 ); n++;
	XtSetArg( args[n], XmNorientation,	ori ); n++;
	XtSetArg( args[n], XmNpacking,		XmPACK_TIGHT ); n++;
	widget = XmCreateRowColumn( parent, name, args, n );

	return(widget);
}


/*ARGSUSED*/
Widget CreateMenuBar( Widget parent_w )
{
	Widget menup_w;
	int n = 0;
	Arg args[10];

	XtSetArg( args[n], XmNpacking,		XmPACK_TIGHT ); n++;
	XtSetArg( args[n], XmNorientation,	XmHORIZONTAL ); n++;
	XtSetArg( args[n], XmNrowColumnType,	XmMENU_BAR ); n++;
	menup_w = XmCreateRowColumn( parent_w, "menuBar", args, n );
	XtManageChild(menup_w);

	return( menup_w );
}


#define TIGHTNESS 20

/*ARGSUSED*/
Widget
CreateActionArea( Widget parent, ActionAreaItem *actions,
	int num_actions,  Widget *activ, int *ind, Widget *butt, Boolean sep )
{
	Widget sep_w, action_area, widget, w;
	WidgetList wl;
	int i;

	action_area = XtVaCreateWidget("action_area", xmFormWidgetClass, parent,
			XmNfractionBase,	TIGHTNESS*num_actions -1,
			XmNskipAdjust,		True,
			NULL );

	/*
	 * If true create a separator
	 * on top of the action area.
	 */
	if ( sep == True ) {
		sep_w = CreateSeparator( action_area, 0 );
		XtVaSetValues( sep_w,
				XmNtopAttachment,	XmATTACH_FORM,
				XmNrightAttachment,	XmATTACH_FORM,
				XmNleftAttachment,	XmATTACH_FORM,
				NULL );
	} else
		sep_w = action_area;

	for( i = 0; i < num_actions; i++ ) {
		widget = XtVaCreateManagedWidget( actions[i].label,
			xmPushButtonGadgetClass,	action_area,
			XmNleftAttachment, i? XmATTACH_POSITION : XmATTACH_FORM,
			XmNleftPosition,		TIGHTNESS*i,
			XmNtopAttachment, sep ? XmATTACH_WIDGET : XmATTACH_FORM,
			XmNtopWidget,			sep_w,
			XmNbottomAttachment,		XmATTACH_FORM,
			XmNrightAttachment,
			  i != num_actions-1? XmATTACH_POSITION : XmATTACH_FORM,
			XmNrightPosition, TIGHTNESS*i + (TIGHTNESS-1),
			XmNdefaultButtonShadowThickness, 1,
			NULL );

		if ( butt != NULL )
			butt[i] = widget;

		if ( actions[i].sens && activ != NULL )
			activ[(*ind)++] = widget;

		if ( actions[i].callback ) {
			XtAddCallback( widget,
				XmNactivateCallback, actions[i].callback,
				(XtPointer)actions[i].data );

			if ( actions[i].data == QUIT ) {

				/*
				 * Make the QUIT <Cancel>
				 * button the default button.
				 */
				w = parent;
				while( ! XtIsWMShell( (w = XtParent(w)) ) );

				XtVaGetValues( w, XmNchildren, &wl, NULL );

				XtVaSetValues( wl[0],
					XmNcancelButton, widget,
					XmNdefaultButton, widget,
					NULL );

				XtVaSetValues( widget,
					XmNshowAsDefault, True,
					NULL );
				
			}
		}

		AddHelp( widget, actions[i].label, actions[i].help );

		if ( i == 0 ) {
			Dimension height, h;
			XtVaGetValues( action_area, XmNmarginHeight, &h, NULL );
			XtVaGetValues( widget, XmNheight, &height, NULL );
			height += 2 * h;
			XtVaSetValues( action_area, 
				XmNdefaultButton,	widget,
				XmNpaneMaximum,		height,
				XmNpaneMinimum,		height,
				NULL );
		}
	}

	XtManageChild(action_area);
	return(action_area);
}


/*ARGSUSED*/
Widget CreateSeparator(Widget parent, unsigned char val)
{
	Widget w;

	w = XtVaCreateManagedWidget("Separator", xmSeparatorGadgetClass, parent,
		XmNseparatorType,	XmSHADOW_ETCHED_IN,
		XmNorientation,		val ? XmVERTICAL : XmHORIZONTAL,
		NULL );

	return(w);
}


/*ARGSUSED*/
Widget CreateTempDialog(Widget parent, String name, XtCP close, XtPointer val )
{

	/*
	 * Create a Popup Dialog to be
	 * mapped later with MapDialog().
	 */
	Widget top, child;
	Atom wm_close;

	top = XtVaCreatePopupShell( name, xmDialogShellWidgetClass, parent,
		XmNmappedWhenManaged,		False,
		XmNinitialResourcesPersistent,	False,
		XmNdeleteResponse,		XmDO_NOTHING,
		XmNmwmFunctions, ~( MWM_HINTS_FUNCTIONS | MWM_FUNC_MINIMIZE ),
		NULL);

	/*
	 * Here we are using form with rubber.
	 * It is subclassed from Bulletin board
	 * but we will have resize event handled
	 * to the viewers expectations.
	 */
	child = XtVaCreateWidget( "mainWin", xmFormWidgetClass, top,
		XmNrubberPositioning, True,
		NULL );

	wm_close =
	    XmInternAtom(XtDisplay(GetTopWidget()), "WM_DELETE_WINDOW", False );
	XmAddWMProtocolCallback( top, wm_close, close, val );

	XtAddCallback( top, XmNdestroyCallback, close, val );

	return(child);
}


/*ARGSUSED*/
Widget CreateDialog(Widget parent, String name)
{

	/*
	 * Create a Popup Dialog to be
	 * mapped later with MapDialog().
	 */
	Widget top, child;
	Atom wm_close;

	top = XtVaCreatePopupShell( name, xmDialogShellWidgetClass, parent,
		XmNmappedWhenManaged,		False,
		XmNinitialResourcesPersistent,	False,
		XmNdeleteResponse,		XmDO_NOTHING,
		XmNmwmFunctions, ~( MWM_HINTS_FUNCTIONS | MWM_FUNC_MINIMIZE ),
		NULL);

	/*
	 * Here we are using form with rubber.
	 * It is subclassed from Bulletin board
	 * but we will have resize event handled
	 * to the viewers expectations.
	 */
	child = XtVaCreateWidget( "mainWin", xmFormWidgetClass, top,
		XmNrubberPositioning, True,
		NULL );

	wm_close =
	    XmInternAtom(XtDisplay(GetTopWidget()), "WM_DELETE_WINDOW", False );
	XmAddWMProtocolCallback( top, wm_close, (XtCP)close_cb, child );

	XtAddCallback( top, XmNdestroyCallback,
		(XtCP)close_cb, (XtPointer)child );


	return(child);
}


/*ARGSUSED*/
void MapDialog( Widget parent, Widget child, Dimension x, Dimension y )
{
	/*
	 * Map the Dialog to (x/y) relative
	 * the parent's position.
	 * x = y = 0, gives centered position.
	 * Keep Dialogs to the right edge of
	 * mdb if VERTICAL == True && x+y.
	 */
	Dimension posx, posy;
	Dimension cw, ch;
	Dimension w, h;
	Widget top = XtParent(child);

	XtManageChild(child);
	XtRealizeWidget(top);

	XtVaGetValues( parent, XmNx, &posx, XmNy, &posy,
			XmNwidth, &w, XmNheight, &h, NULL );

	if ( (GetAppOrientation() == XmVERTICAL) && (x+y > 0) )
		posx += w;
	else
		posx += w/2;

	posy += h/2;

	XtVaGetValues( top, XmNwidth, &cw, XmNheight, &ch, NULL );

	posx -= cw/2;
	posy -= ch/2;

	/*
	 * This may not work as intended
	 * with the fvwm window manager
	 * if the NoPPosition resource is on.
	 */
	XtVaSetValues( top, XmNx, posx+x, XmNy, posy+y, NULL );

	XtMapWidget( top );

}

/*ARGSUSED*/
void DestroyDialog( Widget child )
{

	XtDestroyWidget(XtParent(child));

}


/*ARGSUSED*/
Widget CreateLabel(Widget parent, String name)
{
	Widget widget;

	widget = XmCreateLabelGadget( parent, name, NULL, 0 );
	AddHelp( widget, name, QUICK );

	XtManageChild(widget);
	return(widget);
}


/*ARGSUSED*/
Widget CreateText( Widget parent, String name, String help )
{
	Widget widget;
	int n = 0;
	Arg args[10];

	widget = XmCreateText( parent, name, args, n );
	AddHelp( widget, name, help );

	XtManageChild(widget);
	return(widget);
}


/*ARGSUSED*/
Widget CreatePushButton( Widget parent, String name,
		void (*callback)(), int val, String help )
{
	Widget widget;
	widget = XmCreatePushButtonGadget( parent, name, NULL, 0 );

	if ( callback )
		XtAddCallback( widget,
			XmNactivateCallback, callback, (XtPointer)val );

	AddHelp( widget, name, help );

	XtManageChild(widget);
	return(widget);
}


/*ARGSUSED*/
Widget CreateToggleButton( Widget parent, String name,
		void (*callback)(), int val, String help )
{
	Widget widget;
	widget = XmCreateToggleButtonGadget( parent, name, NULL, 0 );

	if ( callback )
		XtAddCallback( widget,
			XmNvalueChangedCallback, callback, (XtPointer)val );

	AddHelp( widget, name, help );

	XtManageChild(widget);
	return(widget);
}


/*ARGSUSED*/
Widget CreatePulldownMenu( Widget parent, String name,
		MenuItem *items, int num_items, Widget *activ, int *ind )
{

	Widget menup_w;
	Widget tmp_w = NULL;
	int n, i;
	Arg args[10];

	n = 0;
#if defined(XmNtearOffModel)
	XtSetArg( args[n], XmNtearOffModel, XmTEAR_OFF_ENABLED ); n++;
#endif
	menup_w = XmCreatePulldownMenu( parent, "menuPane", args, n );

	n = 0;
	XtSetArg( args[n], XmNsubMenuId, menup_w ); n++;
	XtManageChild( XmCreateCascadeButtonGadget( parent, name, args, n ) );

	for( i = 0; i < num_items; i++ ) {

		if ( items[i].type == 1 ) {
			tmp_w = CreatePushButton( menup_w, items[i].label,
					items[i].callback,
					(int)items[i].data, items[i].help );
		} else if ( items[i].type == 2 ) {
			tmp_w = CreateToggleButton( menup_w, items[i].label,
					items[i].callback,
					(int)items[i].data, items[i].help );
		}

		if ( items[i].sens && activ != NULL )
			activ[(*ind)++] = tmp_w;

		if ( items[i].sep == 1 )
			(void)CreateSeparator( menup_w, 0 );
	}

	return(menup_w);
}


/*ARGSUSED*/
Widget CreateHelpPulldownMenu( Widget parent, String name,
		MenuItem *items, int num_items, Widget *activ, int *ind )
{

	Widget menup_w, tmp_w;
	int n, i;
	Arg args[10];

	n = 0;
#if XmVersion > (XmVERSION * 1000 + 1)
	XtSetArg( args[n], XmNtearOffModel, XmTEAR_OFF_ENABLED ); n++;
#endif
	menup_w = XmCreatePulldownMenu( parent, "menuPane", args, n );

	n = 0;
	XtSetArg( args[n], XmNsubMenuId, menup_w ); n++;
	tmp_w = XmCreateCascadeButtonGadget( parent, name, args, n );

	n = 0;
	XtSetArg( args[n], XmNmenuHelpWidget, tmp_w ); n++;
	XtSetValues( parent, args, n );

	XtManageChild(tmp_w);


	for( i = 0; i < num_items; i++ ) {

		if ( items[i].type == 1 )
			tmp_w = CreatePushButton( menup_w, items[i].label,
					items[i].callback,
					(int)items[i].data, items[i].help );
		else if ( items[i].type == 2 ) {
			tmp_w = CreateToggleButton( menup_w, items[i].label,
					items[i].callback,
					(int)items[i].data, items[i].help );
		}

		if ( items[i].sens && activ != NULL )
			activ[(*ind)++] = tmp_w;

		if ( items[i].sep == 1 )
			(void)CreateSeparator( menup_w, 0 );
	}

	return(menup_w);
}


/*VARARGS*/
char *GetRes( char *fmt, ... )
{
	va_list ap;
	char dbuff[1024];
	XrmValue result;

	va_start(ap, fmt);
	(void)vsprintf( dbuff, fmt, ap );
	va_end(ap);

	if ( Dbase == NULL )
		Dbase = XtDatabase(XtDisplay(GetTopWidget()));

	XrmGetResource( Dbase, dbuff, "", &fmt, &result );

	if ( ! result.size )
		return(NULL);

	return( result.addr );
}


/*ARGSUSED*/
char *TouchLayout( char *lname, Boolean *creat )
{
	struct stat sbuf;
	int i = 0;
	static char ifname[PATH_MAX];
	static char ofname[PATH_MAX];
	char *val, *ptr;

	/*
	 * We are using our private search
	 * paths for resource files in mdb.
	 * See main.c for search order.
	 */
	(void)strcpy( ofname, getenv( "XUSERFILESEARCHPATH" ) );

	/*
	 * Look up file.
	 */
	val =  ptr = ofname;
	while( (ptr = strchr( ptr, ':' )) != NULL ) {

		*ptr = '\0';
		*strrchr( val, '%' ) = '\0';
		(void)sprintf( ifname, "%s/%s", val, lname );

		if ( (i = stat( ifname, &sbuf )) < 0 ) {
			val = ++ptr;
			continue;
		} else if ( (sbuf.st_mode & S_IFMT) == S_IFREG )
			break;
	}

	if ( ! i ) {
		*creat = False;
		return(ifname);
	}

	if ( (*creat == True) && (i) ) {

		/*
		 * Look up directory.
		 */
		(void)strcpy( ofname, getenv( "XUSERFILESEARCHPATH" ) );
		val =  ptr = ofname;
		while( (ptr = strchr( ptr, ':' )) != NULL ) {

			*ptr = '\0';
			*strrchr( val, '%' ) = '\0';

			if ( (i = stat( val, &sbuf )) < 0 ) {
				val = ++ptr;
				continue;
			} else if ( (sbuf.st_mode & S_IFMT) == S_IFDIR )
				break;
		}

		if ( ! i ) {
			return(val);
		}
	}

	return(NULL);
}


/*ARGSUSED*/
char *SetRes( char *res, char *nval )
{

	int i;
	XrmValue val;
	Boolean create = False;
	char *ifname;
	char ofname[PATH_MAX];
	char dbuff[200];
	FILE *fdi, *fdo;

	if ( (ifname = TouchLayout( GetAppClass(), &create )) == NULL )
		return(NULL);

	if ( res == NULL ) {
		errno = 0;
		return(ifname);
	}


	(void)sprintf( ofname, "%s.config", ifname );

	if ( (fdi = fopen( ifname, "r" )) == NULL )
		return(NULL);

	if ( (fdo = fopen( ofname, "w+" )) == NULL ) {
		(void)fclose(fdi);
		return(NULL);
	}

	/*
	 * Update permanently in resource file.
	 */
	while( fgets( dbuff, sizeof(dbuff), fdi ) != NULL ) {
		if ( !strncmp( dbuff, res, strlen(res) ) )
			(void)fprintf( fdo, "%s:\t\t\t%s\n", res, nval );
		else
			(void)fputs( dbuff, fdo );
	}

	if ( ferror( fdo ) ) {
		i = errno;
		(void)fclose(fdi);
		(void)fclose(fdo);
		errno = i;
		return(NULL);
	}

	(void)fclose(fdi);
	(void)fclose(fdo);

	if ( rename( ofname, ifname ) )
		return(NULL);

	if ( Dbase == NULL )
		Dbase = XtDatabase(XtDisplay(GetTopWidget()));

	/*
	 * Update current resource database.
	 */
	val.addr = (XtPointer)nval;
	val.size = strlen(nval)+1;

	XrmPutResource( (XrmDatabase *)Dbase, res, "", &val );

	return(ifname);
}


/*ARGSUSED*/
int Valid( int item, char *fmt )
{

	int val;
	int pval = 0;
	char *ptr;

	/*
	 * Called form Import and Export.
	 * Validate item against item descriptor.
	 */

	if ( ! *fmt )
		return(0);

	ptr = fmt;

	for( ;; ) {

		val = strtol( ptr, &ptr, 0 );

		if ( *ptr == '-' ) {
			pval = val;
			ptr++;
			continue;
		}
		if ( *ptr == ' ' || ! *ptr )
			if ( (item >= pval) && (item <= val) )
				return(0);
		if ( ! *ptr++ )
			break;
	}

	return(1);
}


/*ARGSUSED*/
void Wait( int sec )
{
	while( sec -- ) {
		XmUpdateDisplay(GetTopWidget());
		XFlush(XtDisplay(GetTopWidget()));
		(void)sleep(1);
	}
}


/*
 * Called internally form X-lib.
 */
/*ARGSUSED*/
XtInputCallbackProc
childDone( childStat *chs, int *fid, XtInputId *inputId )
{
	int status = -1;
	size_t cnt;
	char msg[400];
	FILE *fd;

	if ( chs == NULL )
		return(0);
	/*
	 * May be <defunct> or truly dead.
	 */
	if ( kill( chs->pid, 0 ) < 0 )
		status = 0;

	if ( (waitpid( chs->pid, &status, WNOHANG) && WIFEXITED(status)) ) {


		if ( (fd = fopen( chs->file, "r" )) != NULL ) {

			cnt = fread( msg, sizeof(char), sizeof(msg)-1, fd );

			if ( cnt ) {
				msg[cnt] = '\0';
				XtRemoveInput(*inputId);
				/*
				 * Check that the requesting dialog
				 * still exists. If not, the main
				 * window will take the message.
				 */
				(void)xpmsg(*chs->pend == True ? chs->w : NULL,
					     "info: %s", msg );
			}
			(void)fclose(fd);

			if ( (cnt > 0) || (--chs->retry == 0) ) {
				/*
				 * Our child is dead, but it may
				 * still have its own forked childs
				 * that may write to us. Give up
				 * when the retry counter expires.
				 */
				if ( cnt == 0 ) /* Not done above */
					XtRemoveInput(*inputId);
				(void)close(*fid);
				XtFree((char *)chs);
			}
		}
	}
	return(0);
}


/*
 * Return default printer name.
 */
char *
GetPrinter(void)
{
	char *prt;

	if ( (prt = getenv( "PRINTER" )) == NULL )
		prt = GetRes( DEFAULTPRINTER );

	return(prt);
}


/*
 * Global fork print command.
 */
/*ARGSUSED*/
void PrintCommand( Widget w, int typ,
		char *printer, char *file, char *mpotp,
		char *mpp, int ack, Boolean *pend )
{

	int result = -1;
	int stat, ofd;
	char cmd[1024];
	char prt[80];
	char *tmpf;
	childStat *pst;

	/*
	 * Make sure that the print command
	 * is passed as one argument to sh.
	 */
	(void)sprintf( prt, "\"%s\"", printer );

	/*
	 * These routines has bindings to mp (typ 1)
	 * and (typ 2) troff/groff + dpost if groff is not used.
	 */

	if ( typ == MPPRINT ) {
		result = typ;
		(void)sprintf( cmd, MPPRINTCMD, mpotp, mpp, prt, file );
	}

	if ( typ == LABELPRINT ) {
		result = typ;
		(void)sprintf( cmd, LBPRINTCMD , file, prt );
	}

	if ( result < 0 ) {
		/*
		 * To catch what should
		 * be an internal error.
		 */
		errno = 0;
		(void)xpmsg( w, "error: Illegal request to PrintCommand()" );
		return;
	}

	/*
	 * Prepare to catch any messages from lp.
	 */
	if ( ack == 1 )
		ofd = open( tmpf = GetTempFile(ack), O_CREAT | O_WRONLY, 0600 );
	else
		ofd = open( tmpf = GetTempFile(0), O_WRONLY, 0600 );

	if ( (stat = ofd) == -1 ) {
		/*
		 * No ACK to GUI.
		 */
		ofd = STDOUT_FILENO;
	}

	pst = (childStat *)XtMalloc(sizeof(childStat));

	if ( (pst->pid = fork()) == 0 ) {
		(void)dup2( ofd, STDOUT_FILENO );
		(void)dup2( ofd, STDERR_FILENO );
		(void)execl( "/bin/sh", "sh", "-c", cmd, NULL );
		_exit(1);
	}

	if ( pst->pid == -1 ) {
		(void)xpmsg( w, "error: %s", cmd );
		XtFree( (char *)pst );
		if ( stat != -1 )
			(void)close(ofd);
		(void)unlink(tmpf);
		return;
	}

	if ( (ack != 1) || (stat == -1) ) {
		XtFree( (char *)pst );
		if ( stat != -1 )
			(void)close(ofd);
		return;
	}

	pst->w = w;
	pst->retry = 0;
	*pend = True; pst->pend = pend;
	(void)strcpy( pst->file, tmpf );
	*pst->file1 = '\0';

	(void)XtAppAddInput( GetAppContext(), ofd, (XtPointer)XtInputReadMask,
		(XtInputCallbackProc)childDone, (XtPointer)pst );
}


/*ARGSUSED*/
char *GetTempFile(int typ)
{

	/*
	 * General log file.
	 */
	char *tmpf = XtMalloc(100);

	if ( typ != 1 ) {
		(void)strcpy( tmpf, "/dev/null" );
		return(tmpf);
	}

	(void)sprintf( tmpf, "/usr/tmp/mdb%d.%d", (int)getpid(), ++TmpIndx );
	return(tmpf);
}

void RemoveTempFiles(void)
{
	char tmpf[100];

	/*
	 * Here we are facing the risc
	 * of removing a file still due
	 * for print if the user not
	 * have defined the -c option
	 * to lp. This command should
	 * be executed on mdb exit only.
	 */
	while( TmpIndx ) {
		(void)sprintf( tmpf, "/usr/tmp/mdb%d.%d",
			       (int)getpid(), TmpIndx-- );
		(void)unlink(tmpf);
	}
}
