# @(#)$Mu: make/sys.dec-gcc.mk,v 1.24 $
##
## sys.dec-gcc.mk
##	System dependent makefile for OSF/1 (DEC Alpha) with gcc
##
## Copyright (C) 1996  Eric A. Howe
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
## Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
##
##   Authors:	Matthew D. Francey
##		Eric A. Howe (mu@echo-on.net)
##

sysname    = OSF/1 (DEC Alpha) 4.0 (gcc)
sys        = SY_DECOSF1
mk-cde     = yes
mk-putenv  = yes
mk-xpm     = yes
mk-xnt     = no
mk-libhelp = no

cc      = gcc
perl    = /usr/local/bin/perl
warn    = -ansi -pedantic -Wall -Werror -Wmissing-prototypes
defs    = -D$(sys)
opt     = -O
incl    = -I. -I/usr/local/include -I/usr/dt/include -I/usr/X11/include
ldflags = -s $(opt) -L/usr/local/lib -L/usr/lib/X11 -L/usr/dt/lib
xlibs   = -lXm -lXpm -lXmu -lXt -lX11 -lm
hlibs   = -lhlpclient
ar      = ar
arflags = r
m4      = $(top)/tools/p4 -P

dep    = gcc
dflags = -M

mkdir    = mkdirhier
install  = $(top)/tools/mutstall
bindir   = /usr/local/bin
binflags = -o bin -g bin -m 755
mandir   = /usr/local/man/man1
manflags = -o bin -g bin -m 644
docdir   = /usr/local/lib/$(projname)
docflags = $(manflags)
addir    = $(docdir)
adflags  = $(docflags)
