/*
 * mark.c
 *	Page marking callbacks for mgv.
 *
 * Copyright (C) 1996  Eric A. Howe
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *   Authors:	Matthew D. Francey
 *		Eric A. Howe (mu@echo-on.net)
 */
#include	<wlib/rcs.h>
MU_ID("$Mu: mgv/mark.c,v 1.15 $")

#include	<assert.h>
#include	<ctype.h>
#include	<Xm/List.h>

#include	<wlib/wlib.h>
#include	<wlib/typesanity.h>
#include	<mine/mgv.h>
#include	<mine/mark.h>

/*
 * mark->mark, mark->unmark
 */
void
mgv_mark_mark(Widget w, XtPointer closure, XtPointer call)
{
	MGV	*m = (MGV *)closure;
	USEUP(call);
	assert(MgvOK(m));

	mgv_mark(m, m->page, (*XtName(w) == 'm'));
}

/*
 * mark->mark all, mark->unmark all
 */
void
mgv_mark_markall(Widget w, XtPointer closure, XtPointer call)
{
	MGV	*m = (MGV *)closure;
	int	i, max;
	USEUP(w); USEUP(call);
	assert(MgvOK(m));

	max = (m->dsc == NULL) ? 0 : m->dsc->n_pages;
	for(i = 0; i < max; ++i)
		mgv_mark(m, i, (*XtName(w) == 'm'));
}

/*
 * mark->even, mark->odd
 */
void
mgv_mark_evenodd(Widget w, XtPointer closure, XtPointer call)
{
	MGV	*m = (MGV *)closure;
	int	i, n, fudge;
	USEUP(call);
	assert(MgvOK(m));

	fudge = (int)(*XtName(w) == 'o');
	XtVaGetValues(m->list, XmNitemCount, &n, NULL);
	for(i = 0; i < n; ++i)
		mgv_mark(m, i, (i + fudge) % 2);
}

/*
 * mark->invert
 */
void
mgv_mark_invert(Widget w, XtPointer closure, XtPointer call)
{
	MGV	*m = (MGV *)closure;
	int	i, n;
	USEUP(w); USEUP(call);
	assert(MgvOK(m));

	XtVaGetValues(m->list, XmNitemCount, &n, NULL);
	for(i = 0; i < n; ++i)
		mgv_mark(m, i, !m->dsc->pages[i].mark);
}

/*
 * page marking action
 */
void
mgv_action_mark(Widget w, XEvent *ev, String *argv, Cardinal *argc)
{
	int		item, n_items;
	MGV		*m;
	Widget		mainwin;
	USEUP(argv); USEUP(argc);

	mainwin = wl_findup(w, "mainWindow");
	assert(mainwin != NULL);
	XtVaGetValues(mainwin, XmNuserData, &m, NULL);
	assert(MgvOK(m));

	/*
	 * sanity
	 */
	if(w != m->list
	|| ev->type      != ButtonPress
	|| m->dsc        == NULL
	|| m->dsc->pages == NULL) {
		XBell(XtDisplay(mainwin), 100);
		return;
	}

	XtVaGetValues(w, XmNitemCount, &n_items, NULL);
	if((item = XmListYToPos(w, ((XButtonEvent *)ev)->y)) > n_items) {
		XBell(XtDisplay(mainwin), 100);
		return;
	}
	mgv_mark(m, item - 1, !m->dsc->pages[item - 1].mark);
}
