/*
 * strdefs.h
 *	Extra string defs for MGv.
 *
 * Copyright (C) 1996  Eric A. Howe
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *   Authors:	Matthew D. Francey
 *		Eric A. Howe (mu@echo-on.net)
 */
#ifndef	MGV_STRDEFS_H
#define	MGV_STRDEFS_H
MU_HID(strdefs_h, "$Mu: mgv/mine/strdefs.h,v 1.42 $")

extern const char mgv_strdefs[];

#define	MgvNantialiasEPS	((char *)&mgv_strdefs[0])
#define	MgvCAntialiasEPS	((char *)&mgv_strdefs[13])

#define	MgvNautoHeight	((char *)&mgv_strdefs[26])
#define	MgvCAutoHeight	((char *)&mgv_strdefs[37])

#define	MgvNautoWidth	((char *)&mgv_strdefs[48])
#define	MgvCAutoWidth	((char *)&mgv_strdefs[58])

#define	MgvNconfirmExit	((char *)&mgv_strdefs[68])
#define	MgvCConfirmExit	((char *)&mgv_strdefs[80])

#define	MgvNdecompress	((char *)&mgv_strdefs[92])
#define	MgvCDecompress	((char *)&mgv_strdefs[103])

#define	MgvNdefaultPageMedia	((char *)&mgv_strdefs[114])
#define	MgvCDefaultPageMedia	((char *)&mgv_strdefs[131])
#define	MgvRPageMedia		((char *)&mgv_strdefs[148])

#define	MgvNhideLog	((char *)&mgv_strdefs[158])
#define	MgvCHideLog	((char *)&mgv_strdefs[166])

#define	MgvNhideMenuBar	((char *)&mgv_strdefs[174])
#define	MgvCHideMenuBar	((char *)&mgv_strdefs[186])

#define	MgvNhidePageList	((char *)&mgv_strdefs[198])
#define	MgvCHidePageList	((char *)&mgv_strdefs[211])

#define	MgvNhideStatusLine	((char *)&mgv_strdefs[224])
#define	MgvCHideStatusLine	((char *)&mgv_strdefs[239])

#define	MgvNkillChildrenAtExit	((char *)&mgv_strdefs[254])
#define	MgvCKillChildrenAtExit	((char *)&mgv_strdefs[273])

#define	MgvNmagicResistance	((char *)&mgv_strdefs[292])
#define	MgvCMagicResistance	((char *)&mgv_strdefs[308])

#define	MgvNprintCommand	((char *)&mgv_strdefs[324])
#define	MgvCPrintCommand	((char *)&mgv_strdefs[337])

#define	MgvNprinter	((char *)&mgv_strdefs[350])
#define	MgvCPrinter	((char *)&mgv_strdefs[358])

#define	MgvNresetScrollBars	((char *)&mgv_strdefs[366])
#define	MgvCResetScrollBars	((char *)&mgv_strdefs[382])

#define	MgvNreticuleForeground	((char *)&mgv_strdefs[398])
#define	MgvCReticuleForeground	((char *)&mgv_strdefs[417])

#define	MgvNreticuleLineWidth	((char *)&mgv_strdefs[436])
#define	MgvCReticuleLineWidth	((char *)&mgv_strdefs[454])

#define	MgvNshowLabels	((char *)&mgv_strdefs[472])
#define	MgvCShowLabels	((char *)&mgv_strdefs[483])

#define	MgvNshowPageNumbers	((char *)&mgv_strdefs[494])
#define	MgvCShowPageNumbers	((char *)&mgv_strdefs[510])

#define	MgvNtempDir	((char *)&mgv_strdefs[526])
#define	MgvCTempDir	((char *)&mgv_strdefs[534])

#define	MgvNmagicScrolling	((char *)&mgv_strdefs[542])
#define	MgvCMagicScrolling	((char *)&mgv_strdefs[557])

#define	MgvNsmoothScrolling	((char *)&mgv_strdefs[572])
#define	MgvCSmoothScrolling	((char *)&mgv_strdefs[588])

#define	MgvNsmoothness	((char *)&mgv_strdefs[604])
#define	MgvCSmoothness	((char *)&mgv_strdefs[615])

#define	MgvNmagstep	((char *)&mgv_strdefs[626])
#define	MgvCMagstep	((char *)&mgv_strdefs[634])

#define	MgvNsmartSizing	((char *)&mgv_strdefs[642])
#define	MgvCSmartSizing	((char *)&mgv_strdefs[654])

#define	MgvNwmWidth	((char *)&mgv_strdefs[666])
#define	MgvCWmWidth	((char *)&mgv_strdefs[674])

#define	MgvNwmHeight	((char *)&mgv_strdefs[682])
#define	MgvCWmHeight	((char *)&mgv_strdefs[691])

#define	MgvNscrollPercentage	((char *)&mgv_strdefs[700])
#define	MgvCScrollPercentage	((char *)&mgv_strdefs[717])

/*
 * strings
 */
#define	MgvNstringBadArgument	((char *)&mgv_strdefs[734])
#define	MgvCStringBadArgument	((char *)&mgv_strdefs[752])

#define	MgvNstringBadVersion	((char *)&mgv_strdefs[770])
#define	MgvCStringBadVersion	((char *)&mgv_strdefs[787])

#define	MgvNstringCantAllocPixmap	((char *)&mgv_strdefs[804])
#define	MgvCStringCantAllocPixmap	((char *)&mgv_strdefs[826])

#define	MgvNstringCantDecompress	((char *)&mgv_strdefs[848])
#define	MgvCStringCantDecompress	((char *)&mgv_strdefs[869])

#define	MgvNstringCantHideMenu	((char *)&mgv_strdefs[890])
#define	MgvCStringCantHideMenu	((char *)&mgv_strdefs[909])

#define	MgvNstringCantOpen	((char *)&mgv_strdefs[928])
#define	MgvCStringCantOpen	((char *)&mgv_strdefs[943])

#define	MgvNstringCantPrint	((char *)&mgv_strdefs[958])
#define	MgvCStringCantPrint	((char *)&mgv_strdefs[974])

#define	MgvNstringError		((char *)&mgv_strdefs[990])
#define	MgvCStringError		((char *)&mgv_strdefs[1002])

#define	MgvNstringFileExists	((char *)&mgv_strdefs[1014])
#define	MgvCStringFileExists	((char *)&mgv_strdefs[1031])

#define	MgvNstringInterpDone	((char *)&mgv_strdefs[1048])
#define	MgvCStringInterpDone	((char *)&mgv_strdefs[1065])

#define	MgvNstringInterpFailed	((char *)&mgv_strdefs[1082])
#define	MgvCStringInterpFailed	((char *)&mgv_strdefs[1101])

#define	MgvNstringMessage	((char *)&mgv_strdefs[1120])
#define	MgvCStringMessage	((char *)&mgv_strdefs[1134])

#define	MgvNstringNoCoordinates	((char *)&mgv_strdefs[1148])
#define	MgvCStringNoCoordinates	((char *)&mgv_strdefs[1168])

#define	MgvNstringNoDate	((char *)&mgv_strdefs[1188])
#define	MgvCStringNoDate	((char *)&mgv_strdefs[1201])

#define	MgvNstringNoFile	((char *)&mgv_strdefs[1214])
#define	MgvCStringNoFile	((char *)&mgv_strdefs[1227])

#define	MgvNstringNoPrintCommand	((char *)&mgv_strdefs[1240])
#define	MgvCStringNoPrintCommand	((char *)&mgv_strdefs[1261])

#define	MgvNstringPageFinished	((char *)&mgv_strdefs[1282])
#define	MgvCStringPageFinished	((char *)&mgv_strdefs[1301])

#define	MgvNstringUnknown	((char *)&mgv_strdefs[1320])
#define	MgvCStringUnknown	((char *)&mgv_strdefs[1334])

#endif
