/*
 * help-cde.c
 *	Extra help support for the CDE help system.
 *
 * Copyright (C) 1996  Matthew D. Francey
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *   Authors:	Matthew D. Francey
 *		Eric A. Howe (mu@echo-on.net)
 */
#include	<wlib/rcs.h>
MU_ID("$Mu: wlib/help-cde.c,v 1.17 $")

#include	<stdlib.h>

#include	<wlib/wlib.h>
#include	<wlib/wlibP.h>

#if !defined(HAS_CDE)
#	error "You forgot to define HAS_CDE"
#endif

/*
 * CDE help not yet supported so we fall back to plain HTML
 * after giving a single warning
 *
 * Once I can get the help files into the format that CDE wants them in
 * (apparently the helptag DTD is called for), this should be really
 * easy to get going since the CDE help api appears to be pretty clean
 * and simple (perhaps the OSF people were drunk that day...).
 */
Boolean
wlp_help_cde(Widget w, WLP_HELP *h)
{
static	Boolean	warned = False;

	if(!warned) {
		warned = True;
		wl_warn(wl_top(w), wlp_s(w, WlpSnotSupported), "CDE","HTML");
	}
	return wlp_help_html(w, h);
}
