/*
 * help-sgi.c
 *	Extra help support for SGI.
 *
 * Copyright (C) 1996  Matthew D. Francey
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *   Authors:	Matthew D. Francey
 *		Eric A. Howe (mu@echo-on.net)
 */
#include	<wlib/rcs.h>
MU_ID("$Mu: wlib/help-sgi.c,v 1.14 $")

#include	<stdlib.h>

#include	<wlib/wlib.h>
#include	<wlib/wlibP.h>

/*
 * Not yet.
 */
#if 0 /*defined(SY_SGI)*/

#include	<helpapi/HelpBroker.h>

Boolean
wlp_help_sgi(Widget w, WLP_HELP *h)
{
static	int	firsttime = TRUE;
	char	key[1024];

	if(firsttime) {
		char	buf[1024];

		memset((void *)&buf, '\0', sizeof(buf));
		SGIHelpInit(XtDisplay(wl_top(w)),
					wl_appclass(w, buf, sizeof(buf)), ".");
		firsttime = FALSE;
	}

	sprintf(key, "%s::%s", h->chapter, h->section);
	return SGIHelpMsg(key, NULL, NULL) ? True : False;
}

#else

Boolean
wlp_help_sgi(Widget w, WLP_HELP *h)
{
static	Boolean	warned = False;

	if(!warned) {
		warned = True;
		wl_warn(wl_top(w), wlp_s(w, WlpSnotSupported), "SGI", "HTML");
	}
	return wlp_help_html(w, h);
}

#endif
