/*
 * help-xnt.c
 *	Extra help support for the Xnt help system.
 *
 * Copyright (C) 1997 Eric A. Howe
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *   Authors:	Matthew D. Francey
 *		Eric A. Howe (mu@echo-on.net)
 */
#include	<wlib/rcs.h>
MU_ID("$Mu: wlib/help-xnt.c,v 1.4 $")

#include	<stdlib.h>

#include	<wlib/wlib.h>
#include	<wlib/wlibP.h>

#if !defined(HAS_XNT)
#	error "You forgot to define HAS_XNT"
#endif

/*
 * Xnt not yet support so we fall back to plain HTML after
 * giving a single warning.
 *
 * This one should be easy to support once I have some tools to
 * convert linuxdoc-sgml HTML files into the single file that
 * Xnt wants.
 */
Boolean
wlp_help_xnt(Widget w, WLP_HELP *h)
{
static	Boolean	warned = False;

	if(!warned) {
		warned = True;
		wl_warn(wl_top(w), wlp_s(w, WlpSnotSupported), "Xnt","HTML");
	}
	return wlp_help_html(w, h);
}
