#include "akMessageDialog.h"
#include <Xm/MessageB.h>
#include <assert.h>
#include <iostream.h>
////////////////////////////////////////////////////////////////////////////////
//
//	Constructor
//
////////////////////////////////////////////////////////////////////////////////
akMessageDialog::akMessageDialog(Widget parent,
				   char *name,
				   akMessageDialogType type,
				   Boolean modal,
				   const char *text,
			           void  *clientData,
			           akDialogCallback ok,
			           akDialogCallback cancel,
			           akDialogCallback help)
	: akComponent(name)
{
	Widget	button;
	Arg	args[1];

//	Create the dialog

	if (modal)
	  {
	   XtSetArg(args[0],XmNdialogStyle,XmDIALOG_FULL_APPLICATION_MODAL);
	   _w = XmCreateMessageDialog(parent,_name,args,1);
	  }
	else
	  _w = XmCreateMessageDialog(parent,_name,args,0);

//	Set up the callback data structure

	_CBdata = new akDialogCallbackData(clientData,ok,cancel,help);

//	Set the dialog type and text string

	setType(type);
	setText(text);

//	Ensure that all required buttons are available

	button = XmMessageBoxGetChild(_w,XmDIALOG_OK_BUTTON);
	if (!ok)
	  XtUnmanageChild(button);
	else
	  XtManageChild(button);

	button = XmMessageBoxGetChild(_w,XmDIALOG_CANCEL_BUTTON);
	if (!cancel)
	  XtUnmanageChild(button);
	else
	  XtManageChild(button);

	button = XmMessageBoxGetChild(_w,XmDIALOG_HELP_BUTTON);
	if (!help)
	  XtUnmanageChild(button);
	else
	  XtManageChild(button);

//	Set up all callbacks

	XtAddCallback(_w,XmNokCallback, 
		      &akMessageDialog::actionCB,
		      (XtPointer)this);
	XtAddCallback(_w,XmNcancelCallback, 
		      &akMessageDialog::actionCB,
		      (XtPointer)this);
	XtAddCallback(_w,XmNhelpCallback, 
		      &akMessageDialog::actionCB,
		      (XtPointer)this);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Destructor
//
////////////////////////////////////////////////////////////////////////////////
akMessageDialog::~akMessageDialog()
{
	delete _CBdata;
}
////////////////////////////////////////////////////////////////////////////////
//
//	Type update function
//
////////////////////////////////////////////////////////////////////////////////
void akMessageDialog::setType(const akMessageDialogType type)
{
	if (type == ERROR)
	  XtVaSetValues(_w,XmNdialogType,XmDIALOG_ERROR,NULL);
	else if (type == WARNING)
	  XtVaSetValues(_w,XmNdialogType,XmDIALOG_WARNING,NULL);
	else if (type == WORKING)
	  XtVaSetValues(_w,XmNdialogType,XmDIALOG_WORKING,NULL);
	else if (type == INFORMATION)
	  XtVaSetValues(_w,XmNdialogType,XmDIALOG_INFORMATION,NULL);
	else if (type == QUESTION)
	  XtVaSetValues(_w,XmNdialogType,XmDIALOG_QUESTION,NULL);
	else
	  XtVaSetValues(_w,XmNdialogType,XmDIALOG_MESSAGE,NULL);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Title update function
//
////////////////////////////////////////////////////////////////////////////////
void akMessageDialog::setTitle(string title)
{
	if (!title.empty())
	  {
	   XmString xmstr = XmStringCreateLtoR((char *)title.c_str(),XmSTRING_DEFAULT_CHARSET);
	   XtVaSetValues(_w,XmNdialogTitle,xmstr,NULL);
	   XmStringFree(xmstr);
	  }
}
////////////////////////////////////////////////////////////////////////////////
//
//	Text update function
//
////////////////////////////////////////////////////////////////////////////////
void akMessageDialog::setText(string text)
{
	if (!text.empty())
	  {
	   XmString xmstr = XmStringCreateLocalized((char *)text.c_str());
	   XtVaSetValues(_w,XmNmessageString,xmstr,NULL);
	   XmStringFree(xmstr);
	  }
}
////////////////////////////////////////////////////////////////////////////////
//
//	OK Label update function
//
////////////////////////////////////////////////////////////////////////////////
void akMessageDialog::setOKLabel(string label)
{
	if (!label.empty())
	  {
	   XmString xmstr = XmStringCreateLocalized((char *)label.c_str());
	   XtVaSetValues(_w,XmNokLabelString,xmstr,NULL);
	   XmStringFree(xmstr);
	  }
}
////////////////////////////////////////////////////////////////////////////////
//
//	Cancel Label update function
//
////////////////////////////////////////////////////////////////////////////////
void akMessageDialog::setCancelLabel(string label)
{
	if (!label.empty())
	  {
	   XmString xmstr = XmStringCreateLocalized((char *)label.c_str());
	   XtVaSetValues(_w,XmNcancelLabelString,xmstr,NULL);
	   XmStringFree(xmstr);
	  }
}
////////////////////////////////////////////////////////////////////////////////
//
//	Help Label update function
//
////////////////////////////////////////////////////////////////////////////////
void akMessageDialog::setHelpLabel(string label)
{
	if (!label.empty())
	  {
	   XmString xmstr = XmStringCreateLocalized((char *)label.c_str());
	   XtVaSetValues(_w,XmNhelpLabelString,xmstr,NULL);
	   XmStringFree(xmstr);
	  }
}
////////////////////////////////////////////////////////////////////////////////
//
//	Dialog button pressed callback
//
////////////////////////////////////////////////////////////////////////////////
void akMessageDialog::actionCB(Widget,XtPointer clientData,XtPointer callData)
{
	akMessageDialog	*obj = (akMessageDialog *)clientData;
	XmAnyCallbackStruct	*cbs = (XmAnyCallbackStruct *)callData;
	akDialogCallback	callback;

	callback = (akDialogCallback)0;
	switch (cbs->reason)
	  {
	   case XmCR_OK:
	      callback = obj->_CBdata->ok();
	      break;
	   case XmCR_CANCEL:
	      callback = obj->_CBdata->cancel();
	      break;
	   case XmCR_HELP:
	      callback = obj->_CBdata->help();
	      break;
	  };

//	Call required callback

	if (callback)
	  (*callback)(obj->_CBdata->clientData(),callData);
}
