////////////////////////////////////////////////////////////////////////////////
//
//	Class : akOptionMenu
//
//	Author : Andy Jefferson
//
//	Description :
//		The akOptionMenu class provides an option menu convenience
//		object. It provides a Motif Option menu containing the users
//		options, and provides a callback hook to allow dynamic
//		notification of selections.
//
//		Whenever an option is selected, the "callback" is invoked - 
//		allowing dynamic response to a users input. The "callback" is
//		passed the "clientData" as well as the selected option as a
//		string.
//
//		Alternatively to retrieve the selected option at any time,
//		use the access function "selectedOption".
//
//	Public Methods :
//		(constructor) requires :-
//			parent		Parent widget for the component
//			name		Name used in resource specification
//			prompt		Optional prompt label
//			callback	Callback called when option changed
//			clientData	Client-Data passed to callback
//		size()			Function to return no of options
//		add()			Function to add option to menu
//		remove()		Function to remove option from menu
//		removeAll()		Function to remove all options from menu
//		select()		Function to select and option in menu
//		selectedOption()	Retrieval of selected option
//		optionWidget()		Retrieval of an options widget
//		menuWidget()		Retrieval of the menu widget
//
//	Limitations :
//		Doesn't allow direct control over the placement of the label
//		and field - so cannot line up the fields of several objects.
//
////////////////////////////////////////////////////////////////////////////////
#ifndef _akOptionMenu_h
#define _akOptionMenu_h
#ifdef __cplusplus

#include <std/string.h>
#include <Xm/Xm.h>
#include "akComponent.h"

typedef	void	(*akOptionMenuCB) (XtPointer,string);
////////////////////////////////////////////////////////////////////////////////
class akOptionMenu : public akComponent
{
	public:

		// Constructor/destructor

		akOptionMenu(Widget parent,
			      char *name,
			      string prompt,
			      akOptionMenuCB callback=0,
			      XtPointer clientData=0);

		// Access functions

		int	size();
		void	add(string option);
		void	remove(string option);
		void	removeAll();
		void	select(string option);
		string	selectedOption();
		Widget	optionWidget(string option);
		Widget	menuWidget();

		// Class name

		virtual const char *const className(void)
			{return ("akOptionMenu");}

	private:

		akOptionMenuCB	_userCB;
		XtPointer	_userData;

		static	void	selectionCB(Widget,XtPointer,XtPointer);

		Widget		_menu;
		Widget		_pane;
};

inline
int	akOptionMenu::size()
{
	int	numChildren;

	XtVaGetValues(_pane,XmNnumChildren,&numChildren,0);
	return numChildren;
}
inline
Widget	akOptionMenu::menuWidget()
	{return _menu;}

#endif
#endif
