#include <Xm/Xm.h>
#include <Xm/Form.h>
#include <Xm/Label.h>
#include <Xm/TextF.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <stdarg.h>
#include <iostream.h>

#include "akPromptDble.h"
////////////////////////////////////////////////////////////////////////////////
//
//	Constructor function for the akPromptDble object.
//
////////////////////////////////////////////////////////////////////////////////
akPromptDble::akPromptDble(Widget parent,
			     char *name,
			     string variable_name,
			     akPromptDbleCB callback,
			     XtPointer clientData)
	: akPrompt(parent,name,variable_name)
{
	userCB = callback;
	userClientData = clientData;

//	If a label prompt exists, change priority order so that the
//	label varies in size, and field is fixed size.

	if (_label != (Widget)0)
	  {
	   XtVaSetValues(_field,XmNleftAttachment,XmATTACH_NONE,NULL);
	   XtVaSetValues(_label,
			 XmNrightAttachment,XmATTACH_WIDGET,
			 XmNrightWidget,_field,
			 NULL);
	  }

//	Set the initial value to be 0.0

	XmTextFieldSetString(_field,"0.0");
}
////////////////////////////////////////////////////////////////////////////////
//
//	Value retrieval function
//
////////////////////////////////////////////////////////////////////////////////
double	akPromptDble::value(void)
{
	char	*field_string;
	double	double_value;

//	Retrieve field string

	field_string = XmTextFieldGetString(_field);
	double_value = atof(field_string);

	XtFree(field_string);

	return double_value;
}
////////////////////////////////////////////////////////////////////////////////
//
//	Value-changed callback (called when value is changed)
//
////////////////////////////////////////////////////////////////////////////////
void	akPromptDble::changeCB(string value)
{
	double	double_value;

	if (userCB != (akPromptDbleCB)0)
	  {
	   double_value = atof(value.c_str());
	   (*userCB)(userClientData,double_value);
	  }
}
////////////////////////////////////////////////////////////////////////////////
//
//	Set Value utility function
//
////////////////////////////////////////////////////////////////////////////////
void	akPromptDble::setValue(double new_value)
{
	char	new_string[100];

//	LIMITATION NOTE - new_string is size 100.

	sprintf(new_string,"%g",new_value);
	XmTextFieldSetString(_field,new_string);
}
