////////////////////////////////////////////////////////////////////////////////
//
//	Class : akWindow
//
//	Author : Andy Jefferson
//
//	Description :
//		The akWindow class represents a top-level shell. It
//		stores the shell widget as well as the contents widget.
//		It provides manage/unmanage and iconify functions.
//		All classes derived from it must provide a function
//		"createWorkArea" to add the contents of the shell.
//		The akWindow class is not instantiable directly - you
//		must derive a class from it.
//
//	Public Methods :
//		(Constructor) requires :-
//			name		Name used in resource specifications
//		initialize()		Creates the panel
//		manage()		Manages the window
//		unmanage()		Unmanages the window
//		iconify()		Iconises the window
//		busy()			Turns the cursor to a stopwatch
//		ready()			Turns the cursor back to normal
//		setIcon()		Takes either a XPM or XBM representation
//					of a pixmap.
//		setTitle()		Sets the window title
//
//	Limitations :
//
////////////////////////////////////////////////////////////////////////////////
// This code is ADAPTED from the book:
//
// Object-Oriented Programming with C++ and OSF/Motif, 2nd Edition
//    by
// Douglas Young
// Prentice Hall, 1995
// ISBN 0-13-20925507
//
// Copyright 1995 by Prentice Hall
// All Rights Reserved
//
// Permission to use, copy, modify, and distribute this software for 
// any purpose except publication and without fee is hereby granted, provided 
// that the above copyright notice appear in all copies of the software.
//
////////////////////////////////////////////////////////////////////////////////
#ifndef _akWindow_h
#define _akWindow_h
#ifdef __cplusplus

#include <std/string.h>
#include <bool.h>
#include <iostream.h>
#include "akComponent.h"
#include "akPixmap.h"
 
class akWindow : public akComponent
{

	public:

		akWindow(const char *class_name);
		virtual ~akWindow(void);

		// The Application class AUTOMATICALLY calls initialize() 
		// for all registered main window objects. For objects not 
		// registered globally, you MUST call initialize manually.
		virtual void	initialize(void);

		// Manage/Unmanage

		virtual void	manage(void);   // Pop up the window
		virtual void	unmanage(void); // Pop down the window

		// Iconise

		bool		iconified() const;
		virtual void	iconify(void);
		virtual	void	setIcon(string name,char **pix);
		virtual	void	setIcon(string name,int pix_width,int pix_height,char pix_bits[]);
		virtual	void	setTitle(string title);

		// Busy/Ready

		virtual void	busy(void);     // Set cursor to StopWatch
		virtual void	ready(void);    // Set cursor to normal

	protected:

		Widget		_main;
		Widget		_workArea;

		// Derived classes must define this function to 
		// create the application-specific work area

		virtual Widget	createWorkArea(Widget parent) = 0;

		void		installWMClose();

	private:
		void	busyWidget(Widget w);
		void	readyWidget(Widget w);

		akPixmap	*_icon;
		bool		_iconic;

		static	void	wmCloseCB(Widget,XtPointer,XtPointer);
		static	void	stateChangedCB(Widget,XtPointer,XEvent*,Boolean*);
};

inline
bool	akWindow::iconified() const
	{return _iconic;}

#endif
#endif
