#include <iostream.h>
#include <string.h>
#include <stdio.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <Xm/Container.h>
#include <Xm/RowColumn.h>
#include <Xm/CascadeB.h>
#include <Xm/Form.h>
#include <Xm/Frame.h>
#include <Xm/Label.h>
#include <Xm/ScrolledW.h>
#include <Xm/Separator.h>

#include "akApp.h"
#include "mxFtp.h"
#include "mxSetup.h"
#include "mxSetupModify.h"
#include "mxFtpLogo.xpm"
#include "mxFtpIcon.xpm"
#include "mxButtons.xpm"
#include "ajSoft.xpm"
////////////////////////////////////////////////////////////////////////////////
//
//	Constructor
//
////////////////////////////////////////////////////////////////////////////////
mxFtp::mxFtp(char *name,
	     XtCallbackProc callback,
	     XtPointer clientData)
	:akWindow(name),
	 _applicationLogo((akLabel *)0),
	 _animationId(0),
	 _animateLogoNo(0),
	 _helpDocument((akDocView *)0),
	 _ftpProcess((akProcess *)0),
	 _localSystem((mxDirView *)0),
	 _remoteSystem((mxDirView *)0),
	 _date((akClock *)0),
	 _time((akClock *)0),
	 _hostField((akComboBox *)0),
	 _loginField((akPromptString *)0),
	 _passwordField((akPromptPassword *)0),
	 _message((akMessageArea *)0),
	 _transferTypeField((akRadioBox *)0),
	 _connectOption((akButton *)0),
	 _disconnectOption((akButton *)0),
	 _helpOption((akButton *)0),
	 _copyrightOption((akButton *)0),
	 _quitOption((akButton *)0),
	 _connectButton((akButton *)0),
	 _disconnectButton((akButton *)0),
	 _addSiteButton((akButton *)0),
	 _setupButton((akButton *)0),
	 _quitButton((akButton *)0),
	 _helpButton((akButton *)0),
	 _copyToLocalButton((akButton *)0),
	 _copyToRemoteButton((akButton *)0),
	 _localChgDirButton((akButton *)0),
	 _localMkDirButton((akButton *)0),
	 _localRemoveButton((akButton *)0),
	 _remoteChgDirButton((akButton *)0),
	 _remoteMkDirButton((akButton *)0),
	 _remoteRemoveButton((akButton *)0),
	 _copyright((akCopyright *)0),
	 _transferCompleteSound((akSound *)0),
	 _quitDialog((akMessageDialog *)0),
	 _promptDialog((akPromptDialog *)0),
	 _transferMonitor((mxFtpMonitor *)0),
	 _connectCmd(false),
	 _loginCmd(false),
	 _defaultDirCmd(false),
	 _cdCmd(false),
	 _pwdCmd(false),
	 _lsCmd(false),
	 _putCmd(false),
	 _getCmd(false),
	 _mkdirCmd(false),
	 _rmdirCmd(false),
	 _transferFileNo(0),
	 _userCB(callback),
	 _userData(clientData)
{
	_ftpProcess = new akProcess;

//	Create the panel if callback supplied - otherwise it is a global object

	if (_userCB)
	  initialize();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Destructor
//
////////////////////////////////////////////////////////////////////////////////
mxFtp::~mxFtp()
{
	if (_applicationLogo)
	  delete _applicationLogo;
	if (_animationId)
	  XtRemoveTimeOut(_animationId);
	if (_message)
	  delete _message;
	if (_transferTypeField)
	  delete _transferTypeField;
	if (_helpDocument)
	  delete _helpDocument;
	if (_connectOption)
	  delete _connectOption;
	if (_disconnectOption)
	  delete _disconnectOption;
	if (_helpOption)
	  delete _helpOption;
	if (_copyrightOption)
	  delete _copyrightOption;
	if (_quitOption)
	  delete _quitOption;
	if (_connectButton)
	  delete _connectButton;
	if (_disconnectButton)
	  delete _disconnectButton;
	if (_addSiteButton)
	  delete _addSiteButton;
	if (_setupButton)
	  delete _setupButton;
	if (_helpButton)
	  delete _helpButton;
	if (_quitButton)
	  delete _quitButton;
	if (_copyToLocalButton)
	  delete _copyToLocalButton;
	if (_copyToRemoteButton)
	  delete _copyToRemoteButton;
	if (_localChgDirButton)
	  delete _localChgDirButton;
	if (_localMkDirButton)
	  delete _localMkDirButton;
	if (_localRemoveButton)
	  delete _localRemoveButton;
	if (_remoteChgDirButton)
	  delete _remoteChgDirButton;
	if (_remoteMkDirButton)
	  delete _remoteMkDirButton;
	if (_remoteRemoveButton)
	  delete _remoteRemoveButton;
	if (_transferCompleteSound)
	  delete _transferCompleteSound;
	if (_quitDialog)
	  delete _quitDialog;
	if (_promptDialog)
	  delete _promptDialog;
	if (_transferMonitor)
	  delete _transferMonitor;
	if (_ftpProcess)
	  delete _ftpProcess;
	if (_localSystem)
	  delete _localSystem;
	if (_remoteSystem)
	  delete _remoteSystem;
	if (_hostField)
	  delete _hostField;
	if (_loginField)
	  delete _loginField;
	if (_passwordField)
	  delete _passwordField;
	if (_copyright)
	  delete _copyright;
}
////////////////////////////////////////////////////////////////////////////////
//
//	createWorkArea
//
////////////////////////////////////////////////////////////////////////////////
Widget	mxFtp::createWorkArea(Widget parent)
{
	Widget	form;
	Widget	menuBar;
	Widget	toolBar;
	Widget	infoBar;
	Widget	logo_frame;
	Widget	login_frame;
	Widget	local_frame;
	Widget	local_form;
	Widget	local_rowcol;
	Widget	remote_frame;
	Widget	remote_form;
	Widget	remote_rowcol;
	Widget	date_frame;
	Widget	time_frame;
	Widget	rowcol;
	Widget	form1;
	Widget	input_form;
	char	*transfer_options[]=
		{"Ascii","Binary"};

//	Set the icon and title

	setIcon("mxFtp",mxFtp_xpm);

	string	title;
	title  = "mxFtp Version ";
	title += theAkApp->applicationVersion();
	setTitle(title);

//	Add a form to attach contents to

	form = XtVaCreateManagedWidget("Form",xmFormWidgetClass,parent,0);

//	Add application logo

	logo_frame =
		XtVaCreateManagedWidget("Frame",
					xmFrameWidgetClass,
					form,
				        XmNtopAttachment,XmATTACH_FORM,
				        XmNtopOffset,3,
				        XmNrightAttachment,XmATTACH_FORM,
				        XmNrightOffset,3,
				        0);
	_applicationLogo =
	  new akLabel(logo_frame,"Label",mxFtpLogo_xpm);
	_applicationLogo->manage();

//	Add menu bar

	menuBar = createMenuBar(form);
	XtVaSetValues(menuBar,
		      XmNtopAttachment,XmATTACH_FORM,
		      XmNleftAttachment,XmATTACH_FORM,
		      XmNrightAttachment,XmATTACH_WIDGET,
		      XmNrightWidget,logo_frame,
		      0);

//	Add tool bar

	toolBar = createToolBar(form);
	XtVaSetValues(toolBar,
		      XmNtopAttachment,XmATTACH_WIDGET,
		      XmNtopWidget,menuBar,
		      XmNleftAttachment,XmATTACH_FORM,
		      XmNrightAttachment,XmATTACH_WIDGET,
		      XmNrightWidget,logo_frame,
		      0);

//	Add the info bar

	infoBar =
		 XtVaCreateManagedWidget("InfoBar",
					xmFormWidgetClass,
					form,
					XmNleftAttachment,XmATTACH_FORM,
					XmNrightAttachment,XmATTACH_FORM,
					XmNbottomAttachment,XmATTACH_FORM,
					0);
	date_frame =
		XtVaCreateManagedWidget("Frame",
					xmFrameWidgetClass,
					infoBar,
				        XmNleftAttachment,XmATTACH_FORM,
				        XmNleftOffset,3,
				        XmNtopAttachment,XmATTACH_FORM,
				        XmNtopOffset,3,
				        XmNbottomAttachment,XmATTACH_FORM,
				        XmNbottomOffset,3,
				        0);
	_date = new akClock(date_frame,"Date",DATE);
	_date->manage();
	time_frame =
		XtVaCreateManagedWidget("Frame",
					xmFrameWidgetClass,
					infoBar,
				        XmNrightAttachment,XmATTACH_FORM,
				        XmNrightOffset,3,
				        XmNtopAttachment,XmATTACH_FORM,
				        XmNtopOffset,3,
				        XmNbottomAttachment,XmATTACH_FORM,
				        XmNbottomOffset,3,
				        0);
	_time = new akClock(time_frame,"Time",TIME);
	_time->manage();

//	Add the login area

	input_form =
		XtVaCreateManagedWidget("Form",
					xmFormWidgetClass,
					form,
					XmNtopAttachment,XmATTACH_WIDGET,
					XmNtopWidget,toolBar,
					XmNrightAttachment,XmATTACH_FORM,
					XmNleftAttachment,XmATTACH_FORM,
					0);
	_transferTypeField =
	  new akRadioBox(input_form,"TransferType","Type",
			 transfer_options,XtNumber(transfer_options),1,
			 &mxFtp::transferTypeChangedCB,(XtPointer)this);
	XtVaSetValues(_transferTypeField->baseWidget(),
		      XmNtopAttachment,XmATTACH_FORM,
		      XmNbottomAttachment,XmATTACH_FORM,
		      XmNrightAttachment,XmATTACH_FORM,
		      0);
	_transferTypeField->manage();
	_transferTypeField->set(1);
	login_frame =
		XtVaCreateManagedWidget("Frame",
					xmFrameWidgetClass,
					input_form,
				        XmNtopAttachment,XmATTACH_FORM,
				        XmNbottomAttachment,XmATTACH_FORM,
				        XmNrightAttachment,XmATTACH_WIDGET,
				        XmNrightWidget,_transferTypeField->baseWidget(),
				        XmNrightOffset,3,
				        XmNleftAttachment,XmATTACH_FORM,
				        XmNleftOffset,3,
				        0);
	XtVaCreateManagedWidget("Login Details",
				xmLabelWidgetClass,
				login_frame,
				XmNchildType,XmFRAME_TITLE_CHILD,
				0);
	rowcol =
		XtVaCreateManagedWidget("Rowcol",
					xmRowColumnWidgetClass,
					login_frame,
					XmNorientation,XmVERTICAL,
					0);
	_hostField =
	  new akComboBox(rowcol,"Host","FTP Host Name",0,0);
	_hostField->manage();
	form1 =
		XtVaCreateManagedWidget("Form",
					xmFormWidgetClass,
					rowcol,
					0);
	_loginField =
	  new akPromptString(form1,"Login","Login Name");
	XtVaSetValues(_loginField->baseWidget(),
		      XmNleftAttachment,XmATTACH_FORM,
		      0);
	_loginField->manage();
	_passwordField =
	  new akPromptPassword(form1,"Password","Password");
	XtVaSetValues(_passwordField->baseWidget(),
		      XmNrightAttachment,XmATTACH_FORM,
		      XmNleftAttachment,XmATTACH_WIDGET,
		      XmNleftWidget,_loginField->baseWidget(),
		      0);
	_passwordField->manage();

//	Add Ftp messages area

	_message =
	  new akMessageArea(form,"FTPMessage");
	XtVaSetValues(_message->baseWidget(),
		      XmNleftAttachment,XmATTACH_FORM,
		      XmNrightAttachment,XmATTACH_FORM,
		      XmNbottomAttachment,XmATTACH_WIDGET,
		      XmNbottomWidget,infoBar,
		      0);
	_message->manage();

//	Add the local file system display

	local_frame =
		XtVaCreateManagedWidget("LocalFrame",
					xmFrameWidgetClass,
					form,
					XmNtopAttachment,XmATTACH_WIDGET,
					XmNtopWidget,input_form,
					XmNleftAttachment,XmATTACH_FORM,
					XmNleftOffset,3,
					XmNrightAttachment,XmATTACH_POSITION,
					XmNrightPosition,46,
					XmNbottomAttachment,XmATTACH_WIDGET,
					XmNbottomWidget,_message->baseWidget(),
					0);
	XtVaCreateManagedWidget("Local System",
				xmLabelWidgetClass,
				local_frame,
				XmNchildType,XmFRAME_TITLE_CHILD,
				0);
	local_form =
		XtVaCreateManagedWidget("LocalForm",
					xmFormWidgetClass,
					local_frame,
					0);
	local_rowcol =
		XtVaCreateManagedWidget("LocalRowcol",
					xmRowColumnWidgetClass,
					local_form,
					XmNleftAttachment,XmATTACH_FORM,
					XmNrightAttachment,XmATTACH_FORM,
					XmNbottomAttachment,XmATTACH_FORM,
					XmNorientation,XmHORIZONTAL,
					XmNadjustLast,FALSE,
					0);
	_localChgDirButton =
	  new akButton(local_rowcol,"ChgDir","ChgDir",
		       &mxFtp::localChgDirCB,(XtPointer)this);
	_localChgDirButton->manage();
	_localMkDirButton =
	  new akButton(local_rowcol,"MkDir","MkDir",
		       &mxFtp::localMkDirCB,(XtPointer)this);
	_localMkDirButton->manage();
	_localRemoveButton =
	  new akButton(local_rowcol,"Remove","Remove",
		       &mxFtp::localRemoveCB,(XtPointer)this);
	_localRemoveButton->manage();
	string	home;
	home = theMxSetup->ftpDefaultLocalDir();
	if (home.empty())
	  {
	   if (getenv("HOME"))
	     home = getenv("HOME");
	   else
	     home = ".";
	  }
	_localSystem =
	  new mxDirView(local_form,"LocalList",home,localLsListing(home),
			&mxFtp::localDirChangedCB,(XtPointer)this);
	XtVaSetValues(_localSystem->baseWidget(),
		      XmNleftAttachment,XmATTACH_FORM,
		      XmNrightAttachment,XmATTACH_FORM,
		      XmNtopAttachment,XmATTACH_FORM,
		      XmNbottomAttachment,XmATTACH_WIDGET,
		      XmNbottomWidget,local_rowcol,
		      0);
	_localSystem->manage();

//	Add the transfer buttons

	_copyToLocalButton =
	  new akButton(form,"CopyToLocal",mxCopyToLocal_xpm,
		       &mxFtp::copyToLocalCB,(XtPointer)this);
	_copyToLocalButton->installHelp("Copy the remote file\nto the local system");
	_copyToLocalButton->manage();
	XtVaSetValues(_copyToLocalButton->baseWidget(),
		      XmNleftAttachment,XmATTACH_WIDGET,
		      XmNleftWidget,local_frame,
		      XmNtopAttachment,XmATTACH_POSITION,
		      XmNtopPosition,50,
		      0);
	_copyToRemoteButton =
	  new akButton(form,"CopyToRemote",mxCopyToRemote_xpm,
		       &mxFtp::copyToRemoteCB,(XtPointer)this);
	_copyToRemoteButton->installHelp("Copy the local file\nto the remote system");
	_copyToRemoteButton->manage();
	XtVaSetValues(_copyToRemoteButton->baseWidget(),
		      XmNleftAttachment,XmATTACH_WIDGET,
		      XmNleftWidget,local_frame,
		      XmNtopAttachment,XmATTACH_WIDGET,
		      XmNtopWidget,_copyToLocalButton->baseWidget(),
		      0);

//	Add the remote file system display

	remote_frame =
		XtVaCreateManagedWidget("RemoteFrame",
					xmFrameWidgetClass,
					form,
					XmNtopAttachment,XmATTACH_WIDGET,
					XmNtopWidget,input_form,
					XmNleftAttachment,XmATTACH_WIDGET,
					XmNleftWidget,_copyToLocalButton->baseWidget(),
					XmNrightAttachment,XmATTACH_FORM,
					XmNrightOffset,3,
					XmNbottomAttachment,XmATTACH_WIDGET,
					XmNbottomWidget,_message->baseWidget(),
					0);
	XtVaCreateManagedWidget("Remote System",
				xmLabelWidgetClass,
				remote_frame,
				XmNchildType,XmFRAME_TITLE_CHILD,
				0);
	remote_form =
		XtVaCreateManagedWidget("RemoteForm",
					xmFormWidgetClass,
					remote_frame,
					0);
	remote_rowcol =
		XtVaCreateManagedWidget("RemoteRowcol",
					xmRowColumnWidgetClass,
					remote_form,
					XmNleftAttachment,XmATTACH_FORM,
					XmNrightAttachment,XmATTACH_FORM,
					XmNbottomAttachment,XmATTACH_FORM,
					XmNorientation,XmHORIZONTAL,
					XmNadjustLast,FALSE,
					0);
	_remoteChgDirButton =
	  new akButton(remote_rowcol,"ChgDir","ChgDir",
		       &mxFtp::remoteChgDirCB,(XtPointer)this);
	_remoteChgDirButton->manage();
	_remoteMkDirButton =
	  new akButton(remote_rowcol,"MkDir","MkDir",
		       &mxFtp::remoteMkDirCB,(XtPointer)this);
	_remoteMkDirButton->manage();
	_remoteRemoveButton =
	  new akButton(remote_rowcol,"Remove","Remove",
		       &mxFtp::remoteRemoveCB,(XtPointer)this);
	_remoteRemoveButton->manage();
	_remoteSystem =
	  new mxDirView(remote_form,"RemoteList","","",
			&mxFtp::remoteDirChangedCB,(XtPointer)this);
	XtVaSetValues(_remoteSystem->baseWidget(),
		      XmNleftAttachment,XmATTACH_FORM,
		      XmNrightAttachment,XmATTACH_FORM,
		      XmNtopAttachment,XmATTACH_FORM,
		      XmNbottomAttachment,XmATTACH_WIDGET,
		      XmNbottomWidget,remote_rowcol,
		      0);
	_remoteSystem->manage();

//	Initialise the panel details

	setState();
	for (int i=0;i<theMxSetup->ftpNoOfSites();i++)
	   {
	    _hostField->addOption(theMxSetup->ftpSite(i));
	   }
	_loginField->setValue("anonymous");
	string	password;
	password  = "user@organization.com";
	_passwordField->setValue(password);

//	Create the directory prompt

	_promptDialog = new akPromptDialog(_w,"PromptDialog",true,
					   "Directory",(XtPointer)this,
					   &mxFtp::localChgDirOK,
					   &mxFtp::dummyCB);
	_promptDialog->setMessageLabel(" ");
	XtVaSetValues(_promptDialog->baseWidget(),XmNwidth,500,0);

//	Create animation pixmaps

	_logoPixmaps[0]  = new akPixmap(mxFtpLogo_xpm);
	_logoPixmaps[1]  = new akPixmap(mxFtpLogo1_xpm);
	_logoPixmaps[2]  = new akPixmap(mxFtpLogo2_xpm);
	_logoPixmaps[3]  = new akPixmap(mxFtpLogo3_xpm);
	_logoPixmaps[4]  = new akPixmap(mxFtpLogo4_xpm);
	_logoPixmaps[5]  = new akPixmap(mxFtpLogo5_xpm);
	_logoPixmaps[6]  = new akPixmap(mxFtpLogo6_xpm);
	_logoPixmaps[7]  = new akPixmap(mxFtpLogo7_xpm);
	_logoPixmaps[8]  = new akPixmap(mxFtpLogo8_xpm);
	_logoPixmaps[9]  = new akPixmap(mxFtpLogo9_xpm);
	_logoPixmaps[10] = new akPixmap(mxFtpLogo10_xpm);
	_logoPixmaps[11] = new akPixmap(mxFtpLogo11_xpm);

	return form;
}
////////////////////////////////////////////////////////////////////////////////
//
//	createMenuBar
//
////////////////////////////////////////////////////////////////////////////////
Widget	mxFtp::createMenuBar(Widget parent)
{
	Widget	menu;
	Widget	pulldown;
	Widget	cascade;

	menu = XmCreateMenuBar(parent,"MenuBar",NULL,0);

//	Create File menu

	pulldown = XmCreatePulldownMenu(menu,"Connection",NULL,0);
	_connectOption =
	  new akButton(pulldown,"Connect","Connect",
		       &mxFtp::connectCB,(XtPointer)this);
	_connectOption->manage();

	_disconnectOption =
	  new akButton(pulldown,"Disconnect","Disconnect",
		       &mxFtp::disconnectCB,(XtPointer)this);
	_disconnectOption->manage();
	_disconnectOption->deactivate();

	XtVaCreateManagedWidget("Sep",xmSeparatorWidgetClass,pulldown,0);
	_quitOption =
	  new akButton(pulldown,"Quit","Quit",
		       &mxFtp::quitCB,(XtPointer)this);
	_quitOption->manage();
	cascade =
		XtVaCreateManagedWidget("Connection",
					xmCascadeButtonWidgetClass,
					menu,
					XmNsubMenuId,pulldown,
					0);

//	Create Help menu

	pulldown = XmCreatePulldownMenu(menu,"Help",NULL,0);
	_setupOption =
	  new akButton(pulldown,"Setup","Setup",
		       &mxFtp::setupCB,(XtPointer)this);
	_setupOption->manage();

	_helpOption =
	  new akButton(pulldown,"Help","Help",
		       &mxFtp::helpCB,(XtPointer)this);
	_helpOption->manage();

	_copyrightOption =
	  new akButton(pulldown,"Copyright","Copyright",
		       &mxFtp::copyrightCB,(XtPointer)this);
	_copyrightOption->manage();

	cascade =
		XtVaCreateManagedWidget("Help",
					xmCascadeButtonWidgetClass,
					menu,
					XmNsubMenuId,pulldown,
					0);

	XtVaSetValues(menu,XmNmenuHelpWidget,cascade,0);
	XtManageChild(menu);

	return menu;
}
////////////////////////////////////////////////////////////////////////////////
//
//	createToolBar
//
////////////////////////////////////////////////////////////////////////////////
Widget	mxFtp::createToolBar(Widget parent)
{
	Widget	rowcol;

	rowcol =
		XtVaCreateManagedWidget("ToolBar",
					xmRowColumnWidgetClass,
					parent,
					XmNorientation,XmHORIZONTAL,
					XmNadjustLast,FALSE,
					0);

	_quitButton =
	  new akButton(rowcol,"Button",mxClose_xpm,
		       &mxFtp::quitCB,(XtPointer)this);
	_quitButton->installHelp("Quit mxFtp");
	_quitButton->manage();

	_connectButton =
	  new akButton(rowcol,"Button",mxConnect_xpm,
		       &mxFtp::connectCB,(XtPointer)this);
	_connectButton->installHelp("Connect to the FTP host");
	_connectButton->manage();

	_disconnectButton =
	  new akButton(rowcol,"Button",mxDisconnect_xpm,
		       &mxFtp::disconnectCB,(XtPointer)this);
	_disconnectButton->installHelp("Disconnect from the FTP host");
	_disconnectButton->manage();

	_addSiteButton =
	  new akButton(rowcol,"Button",mxAdd_xpm,
		       &mxFtp::addSiteCB,(XtPointer)this);
	_addSiteButton->installHelp("Add the current FTP\nSite to the favourites list");
	_addSiteButton->manage();

	_setupButton =
	  new akButton(rowcol,"Button",mxSetup_xpm,
		       &mxFtp::setupCB,(XtPointer)this);
	_setupButton->installHelp("View/Modify setup details");
	_setupButton->manage();

	_helpButton =
	  new akButton(rowcol,"Button",mxHelp_xpm,
		       &mxFtp::helpCB,(XtPointer)this);
	_helpButton->installHelp("View the help");
	_helpButton->manage();

	return rowcol;
}
////////////////////////////////////////////////////////////////////////////////
//
//	Receive output from FTP process - parse output for success/fail text
//
////////////////////////////////////////////////////////////////////////////////
void	mxFtp::receiveOutput(XtPointer clientData,string output)
{
	mxFtp	*obj = (mxFtp *)clientData;
	string	command;
	int	pos;

//	Check whether process has completed

	if (output.empty())
	  {
	   obj->_outputText.remove();
	   obj->_ftpProcess->stop();
	   return;
	  }
	obj->_outputText += output;

//	"ls" Command

	if (obj->_lsCmd)
	  {
	   output.remove();	// Remove output since sending to display instead
	   if ((pos = obj->_outputText.find("150 Opening")) >= 0 &&
	       (pos = obj->_outputText.find("226 Transfer ")) >= 0)
	     {
	      string	listing;
	      int	pos1,pos2;

	      pos  = obj->_outputText.find("150 Opening");
	      pos1 = obj->_outputText.find('\n',pos);
	      pos2 = obj->_outputText.find("226 Transfer ");
	      listing.assign(obj->_outputText,pos1+1,pos2-pos1-1);
	      obj->_remoteSystem->update(obj->_remoteSystem->currentDirectory(),
					 listing);
	      obj->_lsCmd = false;
	      output.assign(obj->_outputText,0,pos1+1);
	      output.append(obj->_outputText,pos2,obj->_outputText.size()-pos2);
	      obj->_outputText.remove();
	      obj->setState();
	     }
	  }

//	"pwd" Command

	if (obj->_pwdCmd)
	  {
	   // Successful pwd
	   if ((pos = obj->_outputText.find("257 ")) >= 0 &&
	       (pos = obj->_outputText.find(" is current directory")) >= 0)
	     {
	      int	pos1,pos2;
	      string	cwd;
	      pos = obj->_outputText.find("257 ");
	      pos1 = obj->_outputText.find('"',pos);
	      if (pos1 >= 0)
		{
	         pos2 = obj->_outputText.find('"',pos1+1);
		 if (pos2 >= 0)
		   {
	            cwd.assign(obj->_outputText,pos1+1,pos2-pos1-1);
		    obj->_remoteSystem->update(cwd,"");
		   }
		}
	      pos = obj->_outputText.find('\n',pos2);
	      if (pos >= 0)
	        obj->_outputText.remove(0,pos);
	      else
	        obj->_outputText.remove();

	      obj->_pwdCmd = false;
	      command = "ls -alF";
	      obj->_lsCmd = true;
	      obj->setState();
	      obj->_ftpProcess->input(command);
	     }
	  }

//	"cd" Command

	if (obj->_cdCmd)
	  {
	   // Successful cd
	   if ((pos = obj->_outputText.find("250 CWD command successful")) >= 0)
	     {
	      obj->_outputText.remove();
	      obj->_cdCmd = false;
	      obj->_pwdCmd = true;
	      obj->setState();
	      command = "pwd";
	      obj->_ftpProcess->input(command);
	     }

	   // Errors in cd
	   if ((pos = obj->_outputText.find("No such file or directory")) >= 0)
	     {
	      obj->_outputText.remove();
	      XBell(XtDisplay(obj->_w),50);
	      obj->_cdCmd = false;
	      obj->setState();
	     }
	  }

//	"defaultDir" Command

	if (obj->_defaultDirCmd)
	  {
	   // Errors in default dir setting
	   if ((pos = obj->_outputText.find("No such file or directory")) >= 0 ||
	       (pos = obj->_outputText.find("Permission denied")) >= 0)
	     XBell(XtDisplay(obj->_w),50);

	   // Directory set (or 'default start point' used)
	   if ((pos = obj->_outputText.find("250 CWD command successful")) >= 0 ||
	       (pos = obj->_outputText.find("No such file or directory")) >= 0 ||
	       (pos = obj->_outputText.find("Permission denied")) >= 0)
	     {
	      obj->_outputText.remove();
	      obj->_defaultDirCmd = false;
	      obj->_pwdCmd = true;
	      obj->setState();
	      command = "pwd";
	      obj->_ftpProcess->input(command);
	     }
	  }

//	"login" Command

	if (obj->_loginCmd)
	  {
	   // Successful login
	   if ((pos = obj->_outputText.find("230 User")) >= 0 ||
	       (pos = obj->_outputText.find("230-User")) >= 0 ||
	       (pos = obj->_outputText.find("230 Guest")) >= 0)
	     {
	      obj->_outputText.remove();
	      obj->_loginCmd = false;

	      // Set transfer type, turn prompting OFF, and set local directory
	      if (obj->_transferTypeField->selected() == 0)
		obj->_ftpProcess->input("ascii");
	      else
		obj->_ftpProcess->input("bin");
	      obj->_ftpProcess->input("prompt");
	      command = "lcd " + obj->_localSystem->currentDirectory();
	      obj->_ftpProcess->input(command);

	      // Set remote directory to 'default'
	      if (theMxSetup->ftpDefaultRemoteDir().empty())
		command = "cd .";
	      else
		command = "cd " + theMxSetup->ftpDefaultRemoteDir();
	      obj->_defaultDirCmd = true;
	      obj->setState();
	      obj->_ftpProcess->input(command);
	     }

	   // Errors in login
	   if ((pos = obj->_outputText.find("Login incorrect")) >= 0 ||
	       (pos = obj->_outputText.find("530 User anonymous access denied")) >= 0)
	     {
	      obj->_outputText.remove();
	      XBell(XtDisplay(obj->_w),50);
	      obj->_loginCmd = false;
	      obj->_ftpProcess->stop();
	      obj->setState();
	     }
	  }

//	"connect" Command

	if (obj->_connectCmd)
	  {
	   // Successful connection
	   if ((pos = obj->_outputText.find("Connected")) >= 0)
	     {
	      obj->_outputText.remove();
	      obj->_connectCmd = false;

	      command = "user " + obj->_loginField->value() + " " + obj->_passwordField->value();
	      obj->_loginCmd = true;
	      obj->setState();
	      obj->_ftpProcess->input(command);
	     }

	   // Errors in connection
	   if ((pos = obj->_outputText.find("Network is unreachable")) >= 0 ||
	       (pos = obj->_outputText.find("Host name lookup failure")) >= 0 ||
	       (pos = obj->_outputText.find("Unknown host")) >= 0)
	     {
	      XBell(XtDisplay(obj->_w),50);
	      obj->_connectCmd = false;
	      obj->_ftpProcess->stop();
	      obj->setState();
	     }
	  }

//	"put" Command

	if (obj->_putCmd)
	  {
	   // Successful put
	   if ((pos = obj->_outputText.find("226 Transfer complete")) >= 0)
	     {
	      obj->_outputText.remove();
	      if (!obj->transferNextFile())
		{
		 obj->_putCmd = false;
		 obj->_lsCmd = true;
		 obj->setState();
		 command = "ls -alF";
		 obj->_ftpProcess->input(command);
		 if (theMxSetup->ftpTransferSound())
		   {
		    string soundfile = theMxSetup->audioDirectory() + "completeSound";
		    if (!obj->_transferCompleteSound)
		      obj->_transferCompleteSound = new akSound(soundfile);
		    obj->_transferCompleteSound->play();
		   }
		}
	     }
	   // Errors in put
	   if ((pos = obj->_outputText.find("Permission denied")) >= 0)
	     {
	      obj->_outputText.remove();
	      obj->_putCmd = false;
	      obj->setState();
	      XBell(XtDisplay(obj->_w),50);
	     }
	  }

//	"get" Command

	if (obj->_getCmd)
	  {
	   // Transfer started - display transfer monitor
	   if ((pos = obj->_outputText.find("150 Opening ")) >= 0)
	     {
	      int	pos1,pos2;
	      string	sizestr;
	      pos1 = obj->_outputText.find("(",pos);
	      pos2 = obj->_outputText.find(")",pos);
	      if (pos1 >= 0 && pos2 >= 0)
		{
		 sizestr.assign(obj->_outputText,pos1+1,pos2-pos1-7);
		 obj->_outputText.remove(0,pos2);

		 // Start/Reset the file transfer monitor
		 if (!obj->_transferMonitor)
		   obj->_transferMonitor =
		     new mxFtpMonitor(obj->_w,"FTPMonitor",
				      atoi((char *)sizestr.c_str()),
				      obj->_transferFilesLocal[obj->_transferFileNo-1]);
		 else
		   obj->_transferMonitor->change(atoi((char *)sizestr.c_str()),
						 obj->_transferFilesLocal[obj->_transferFileNo-1]);
		 obj->_transferMonitor->manage();
		}
	     }
	   // Successful get
	   if ((pos = obj->_outputText.find("226 Transfer complete")) >= 0)
	     {
	      obj->_outputText.remove();
	      if (!obj->transferNextFile())
		{
		 obj->_getCmd = false;

		 obj->_localSystem->update(obj->_localSystem->currentDirectory(),
					   obj->localLsListing(obj->_localSystem->currentDirectory()));
		 obj->setState();
		 obj->_transferMonitor->unmanage();
		 if (theMxSetup->ftpTransferSound())
		   {

		    string soundfile = theMxSetup->audioDirectory() + "completeSound";
		    if (!obj->_transferCompleteSound)
		      obj->_transferCompleteSound = new akSound(soundfile);
		    obj->_transferCompleteSound->play();
		   }
		}
	     }
	   // Errors in get
	   if ((pos = obj->_outputText.find("Permission denied")) >= 0)
	     {
	      obj->_outputText.remove();
	      obj->_getCmd = false;
	      obj->setState();
	      XBell(XtDisplay(obj->_w),50);
	     }
	  }

//	"mkdir" Command

	if (obj->_mkdirCmd)
	  {
	   // Successful mkdir
	   if ((pos = obj->_outputText.find("command successful")) >= 0)
	     {
	      obj->_outputText.remove();
	      obj->_mkdirCmd = false;

	      command = "ls -alF";
	      obj->_lsCmd = true;
	      obj->setState();
	      obj->_ftpProcess->input(command);
	     }
	   // Errors in mkdir
	   if ((pos = obj->_outputText.find("No such file or directory")) >= 0 ||
	       (pos = obj->_outputText.find("Permission denied")) >= 0)
	     {
	      obj->_outputText.remove();
	      obj->_mkdirCmd = false;
	      obj->setState();
	      XBell(XtDisplay(obj->_w),50);
	     }
	  }

//	"rmdir" Command

	if (obj->_rmdirCmd)
	  {
	   // Successful rmdir
	   if ((pos = obj->_outputText.find("command successful")) >= 0)
	     {
	      obj->_outputText.remove();
	      obj->_rmdirCmd = false;

	      command = "ls -alF";
	      obj->_lsCmd = true;
	      obj->setState();
	      obj->_ftpProcess->input(command);
	     }
	   // Errors in rmdir
	   if ((pos = obj->_outputText.find("No such file or directory")) >= 0 ||
	       (pos = obj->_outputText.find("Permission denied")) >= 0 ||
	       (pos = obj->_outputText.find("Directory not empty")) >= 0)
	     {
	      obj->_outputText.remove();
	      obj->_rmdirCmd = false;
	      obj->setState();
	      XBell(XtDisplay(obj->_w),50);
	     }
	  }

//	Write FTP output to message area

	obj->_message->write(AK_CONTINUE,(char *)output.c_str());
}
////////////////////////////////////////////////////////////////////////////////
//
//	Set state of various buttons/options depending on process state
//
////////////////////////////////////////////////////////////////////////////////
void	mxFtp::setState()
{
//	Process is connected

	if (_ftpProcess->active())
	  {

	   // Process is ACTIVE

	   if (_putCmd || _getCmd || _lsCmd || _pwdCmd || _cdCmd ||
	       _defaultDirCmd || _loginCmd || _connectCmd || _mkdirCmd || _rmdirCmd)
	     {
	      busy();
	      _connectButton->deactivate();
	      _connectOption->deactivate();
	      _disconnectButton->deactivate();
	      _disconnectOption->deactivate();
	      _hostField->deactivate();
	      _loginField->deactivate();
	      _passwordField->deactivate();
	      _copyToLocalButton->deactivate();
	      _copyToRemoteButton->deactivate();
	      _localSystem->deactivate();
	      _remoteSystem->deactivate();
	      _transferTypeField->deactivate();
	      _localChgDirButton->deactivate();
	      _localMkDirButton->deactivate();
	      _localRemoveButton->deactivate();
	      _remoteChgDirButton->deactivate();
	      _remoteMkDirButton->deactivate();
	      _remoteRemoveButton->deactivate();
	      if (!_animationId)
		{
		 _animateLogoNo = 1;
		 animateLogoCB((XtPointer)this,0);
	         setIcon("mxFtp",mxFtp_Active_xpm);
		}
	     }

	   // Process is INACTIVE

	   else
	     {
	      ready();
	      _connectButton->deactivate();
	      _connectOption->deactivate();
	      _disconnectButton->activate();
	      _disconnectOption->activate();
	      _hostField->deactivate();
	      _loginField->deactivate();
	      _passwordField->deactivate();
	      _copyToLocalButton->activate();
	      _copyToRemoteButton->activate();
	      _localSystem->activate();
	      _remoteSystem->activate();
	      _transferTypeField->activate();
	      _localChgDirButton->activate();
	      _localMkDirButton->activate();
	      _localRemoveButton->activate();
	      _remoteChgDirButton->activate();
	      _remoteMkDirButton->activate();
	      _remoteRemoveButton->activate();
	      if (_animationId)
		XtRemoveTimeOut(_animationId);
	      _animationId = 0;
	      _applicationLogo->updatePixmap(_logoPixmaps[1]);
	      setIcon("mxFtp",mxFtp_Inactive_xpm);
	     }
	  }

//	Process is not connected

	else
	  {
	   ready();
	   _connectButton->activate();
	   _connectOption->activate();
	   _disconnectButton->deactivate();
	   _disconnectOption->deactivate();
	   _hostField->activate();
	   _loginField->activate();
	   _passwordField->activate();
	   _copyToLocalButton->deactivate();
	   _copyToRemoteButton->deactivate();
	   _localSystem->activate();
	   _remoteSystem->deactivate();
	   _transferTypeField->activate();
	   _localChgDirButton->activate();
	   _localMkDirButton->activate();
	   _localRemoveButton->activate();
	   _remoteChgDirButton->deactivate();
	   _remoteMkDirButton->deactivate();
	   _remoteRemoveButton->deactivate();
	   if (_animationId)
	     XtRemoveTimeOut(_animationId);
	   _animationId = 0;
	   _applicationLogo->updatePixmap(_logoPixmaps[0]);
	   setIcon("mxFtp",mxFtp_xpm);
	  }
}
////////////////////////////////////////////////////////////////////////////////
//
//	Start the transfer of the next file
//
////////////////////////////////////////////////////////////////////////////////
bool	mxFtp::transferNextFile()
{
	string	command;

//	Return failure if put/get not running or filenames not set up
//	or no more files to transfer

	if (!_getCmd && !_putCmd)
	  return false;

	if (_transferFilesLocal.empty() || _transferFilesRemote.empty())
	  return false;

	if (_transferFileNo >= _transferFilesLocal.size() ||
	    _transferFileNo >= _transferFilesRemote.size())
	  return false;

//	Transferring file from REMOTE to LOCAL

	if (_getCmd)
	  {
	   // Send the FTP command to transfer this file
	   command  = "get ";
	   command += _transferFilesRemote[_transferFileNo];
	   command += " ";
	   command += _transferFilesLocal[_transferFileNo];
	   _transferFileNo++;
	   _ftpProcess->input(command);
	  }

//	Transferring file from LOCAL to REMOTE

	else if (_putCmd)
	  {
	   // Send the FTP command to transfer this file
	   command  = "put ";
	   command += _transferFilesLocal[_transferFileNo];
	   command += " ";
	   command += _transferFilesRemote[_transferFileNo];
	   _transferFileNo++;
	   _ftpProcess->input(command);
	  }

	return true;
}
////////////////////////////////////////////////////////////////////////////////
//
//	Generate local 'ls' listing
//
////////////////////////////////////////////////////////////////////////////////
string	mxFtp::localLsListing(string directory)
{
	string		list;
	string		command;
	FILE		*fp;
	char		line[BUFSIZ];

	command = "ls -alF " + directory;
	if (directory[directory.size()-1] != '/')
	  command += '/';
	fp = popen((char *)command.c_str(),"r");
	if (fp == NULL)
	  return list;

	while (fgets(line,BUFSIZ,fp) != NULL)
	  list += line;
	pclose(fp);

	return list;
}
//******************************************************************************
//	Function callbacks below here
//******************************************************************************
////////////////////////////////////////////////////////////////////////////////
//
//	Connect callback
//
////////////////////////////////////////////////////////////////////////////////
void	mxFtp::connectCB(Widget,XtPointer clientData,XtPointer)
{
	mxFtp	*obj = (mxFtp *)clientData;

	obj->busy();

//	If not currently active, start up process with connect command

	if (!obj->_ftpProcess->active())
	  {
	   string	command;

	   command = theMxSetup->ftpProcessFilename() + " -nv " + obj->_hostField->value();
	   obj->_message->write(AK_INFO,"Logging in to FTP host %s\n",
				(char *)obj->_hostField->value().c_str());
	   obj->_connectCmd = true;
	   obj->_ftpProcess->start(command,&mxFtp::receiveOutput,(XtPointer)obj);
	   obj->setState();
	  }
	obj->ready();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Disconnect callback
//
////////////////////////////////////////////////////////////////////////////////
void	mxFtp::disconnectCB(Widget,XtPointer clientData,XtPointer)
{
	mxFtp	*obj = (mxFtp *)clientData;

	obj->busy();
	if (obj->_ftpProcess->active())
	  obj->_ftpProcess->stop();
	obj->_remoteSystem->update("","");
	obj->_message->write(AK_INFO,"FTP Session disconnected\n");
	obj->_connectCmd    = false;
	obj->_loginCmd      = false;
	obj->_defaultDirCmd = false;
	obj->_cdCmd         = false;
	obj->_pwdCmd        = false;
	obj->_lsCmd         = false;
	obj->_putCmd        = false;
	obj->_getCmd        = false;
	obj->_mkdirCmd      = false;
	obj->_rmdirCmd      = false;
	obj->setState();
	obj->ready();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Add Site callback
//
////////////////////////////////////////////////////////////////////////////////
void	mxFtp::addSiteCB(Widget,XtPointer clientData,XtPointer)
{
	mxFtp	*obj = (mxFtp *)clientData;
	string	site=obj->_hostField->value();

	if (!site.empty())
	   {
	    for (int i=0;i<theMxSetup->ftpNoOfSites();i++)
	       {
		if (theMxSetup->ftpSite(i) == site)
		  return;
	       }
	    obj->_hostField->addOption(site);
	    obj->_hostField->select(site);
	    theMxSetup->addFtpSite(site);
	    theMxSetup->write();
	   }
}
////////////////////////////////////////////////////////////////////////////////
//
//	Copy to local callback
//
////////////////////////////////////////////////////////////////////////////////
void	mxFtp::copyToLocalCB(Widget,XtPointer clientData,XtPointer)
{
	mxFtp	*obj = (mxFtp *)clientData;

	obj->busy();

//	If remote file(s) not selected, then give error

	if (obj->_remoteSystem->noSelectedFiles() == 0)
	  {
	   obj->_message->write(AK_ERROR,"Remote file(s) not specified\n");
	   XBell(XtDisplay(obj->_w),50);
	   obj->ready();
	   return;
	  }

//	Reset the transfer files

	obj->_transferFilesLocal.erase(obj->_transferFilesLocal.begin(),
				       obj->_transferFilesLocal.end());
	obj->_transferFilesRemote.erase(obj->_transferFilesRemote.begin(),
					obj->_transferFilesRemote.end());

//	Extract source and destination filename(s)

	string	*selections;
	selections = obj->_remoteSystem->selectedFiles();

	for (int i=0;i<obj->_remoteSystem->noSelectedFiles();i++)
	  {
	   string	source_file=selections[i];

	   // Remove path from selection (just use the filename)
	   int	pos=source_file.rfind('/');
	   if (pos >= 0)
	     source_file.remove(0,pos+1);

	   // Set up destination filename - same filename, in current directory
	   string destination_file = obj->_localSystem->currentDirectory() + "/" + source_file;

	   // Add the files to the transferFile array
	   obj->_transferFilesLocal.push_back(destination_file);
	   obj->_transferFilesRemote.push_back(source_file);
	  }

//	Delete the selected files array

	delete []selections;

//	Start the transfer

	obj->_getCmd = true;
	obj->setState();
	obj->_transferFileNo = 0;
	if (!obj->transferNextFile())
	  {
	   obj->_getCmd = false;
	   obj->setState();
	  }

	obj->ready();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Copy to remote callback
//
////////////////////////////////////////////////////////////////////////////////
void	mxFtp::copyToRemoteCB(Widget,XtPointer clientData,XtPointer)
{
	mxFtp	*obj = (mxFtp *)clientData;

	obj->busy();

//	If local file(s) not selected, then give error

	if (obj->_localSystem->noSelectedFiles() == 0)
	  {
	   obj->_message->write(AK_ERROR,"Local file(s) not specified\n");
	   XBell(XtDisplay(obj->_w),50);
	   obj->ready();
	   return;
	  }

//	Reset the transfer files

	obj->_transferFilesLocal.erase(obj->_transferFilesLocal.begin(),
				       obj->_transferFilesLocal.end());
	obj->_transferFilesRemote.erase(obj->_transferFilesRemote.begin(),
					obj->_transferFilesRemote.end());

//	Extract source and destination filename(s)

	string	*selections;
	selections = obj->_localSystem->selectedFiles();

	for (int i=0;i<obj->_localSystem->noSelectedFiles();i++)
	  {
	   string	source_file=selections[i];

	   // Remove path from selection (just use the filename)
	   int	pos=source_file.rfind('/');
	   if (pos >= 0)
	     source_file.remove(0,pos+1);

	   // Set up destination filename - same filename, in current directory
	   string destination_file = obj->_remoteSystem->currentDirectory() + "/" + source_file;

	   // Add the files to the transferFile array
	   obj->_transferFilesRemote.push_back(destination_file);
	   obj->_transferFilesLocal.push_back(source_file);
	  }

//	Delete the selected files array

	delete []selections;

//	Start the transfer

	obj->_putCmd = true;
	obj->setState();
	obj->_transferFileNo = 0;
	if (!obj->transferNextFile())
	  {
	   obj->_putCmd = false;
	   obj->setState();
	  }

	obj->ready();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Error callback
//
////////////////////////////////////////////////////////////////////////////////
void	mxFtp::dummyCB(XtPointer clientData,XtPointer)
{
	mxFtp	*obj = (mxFtp *)clientData;

	if (obj->_promptDialog)
	  obj->_promptDialog->unmanage();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Setup callback
//
////////////////////////////////////////////////////////////////////////////////
void	mxFtp::setupCB(Widget,XtPointer clientData,XtPointer)
{
	mxFtp	*obj = (mxFtp *)clientData;

	obj->busy();
	if (!theMxSetupModify)
	  {
	   theMxSetupModify = new mxSetupModify(obj->_w,"SetupModify",
						   &mxFtp::setupChangedCB,
						   (XtPointer)obj);
	   theMxSetupModify->update();
	   theMxSetupModify->manage();
	   theMxSetupModify->setSection(MXSETUP_FTP);
	  }
	else
	  {
	   theMxSetupModify->update();
	   theMxSetupModify->manage();
	  }
	obj->ready();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Setup changed callback
//
////////////////////////////////////////////////////////////////////////////////
void	mxFtp::setupChangedCB(Widget,XtPointer clientData,XtPointer)
{
	mxFtp	*obj = (mxFtp *)clientData;

//	Update the displays to pick up (potentially) changed show parameters

	obj->_localSystem->update();
	obj->_remoteSystem->update();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Quit callback
//
////////////////////////////////////////////////////////////////////////////////
void	mxFtp::quitCB(Widget,XtPointer clientData,XtPointer)
{
	mxFtp	*obj = (mxFtp *)clientData;

	if (!obj->_quitDialog)
	  obj->_quitDialog = new akMessageDialog(obj->_w,"MessageDialog",
						    QUESTION,true,
						    "Confirm Quit mxFtp",
						    (XtPointer)obj,
						    &mxFtp::quitOK,
						    &mxFtp::quitCancel);
	obj->_quitDialog->setTitle("Confirm Quit");
	obj->_quitDialog->manage();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Quit OK callback
//
////////////////////////////////////////////////////////////////////////////////
void	mxFtp::quitOK(XtPointer clientData,XtPointer)
{
	mxFtp	*obj = (mxFtp *)clientData;

//	Make sure that disconnected

	if (obj->_ftpProcess->active())
	  {
	   obj->_ftpProcess->stop();
	   disconnectCB(obj->_w,clientData,0);
	  }

	if (obj->_userCB)
	  obj->_userCB(obj->_w,obj->_userData,obj);
	else
	  exit(1);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Quit Cancel callback
//
////////////////////////////////////////////////////////////////////////////////
void	mxFtp::quitCancel(XtPointer clientData,XtPointer)
{
//	Empty
}
////////////////////////////////////////////////////////////////////////////////
//
//	Copyright callback
//
////////////////////////////////////////////////////////////////////////////////
void	mxFtp::copyrightCB(Widget,XtPointer clientData,XtPointer)
{
	mxFtp	*obj = (mxFtp *)clientData;

	if (!obj->_copyright)
	  obj->_copyright = new akCopyright(theAkApp->baseWidget(),
					"CopyrightPanel",
					"AJ Soft Limited","1997",
					ajSoft_xpm);
	obj->_copyright->manage();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Help callback
//
////////////////////////////////////////////////////////////////////////////////
void	mxFtp::helpCB(Widget,XtPointer clientData,XtPointer)
{
	mxFtp	*obj = (mxFtp *)clientData;
	string	helpfile=theMxSetup->helpDirectory() + "mxFtp.html";

	obj->busy();
	XmUpdateDisplay(obj->_w);
	if (!obj->_helpDocument)
	  obj->_helpDocument = new akDocView("HelpDocument",helpfile);
	obj->_helpDocument->manage();
	obj->ready();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Transfer Type changed callback
//
////////////////////////////////////////////////////////////////////////////////
void	mxFtp::transferTypeChangedCB(Widget,XtPointer clientData,XtPointer callData)
{
	mxFtp	*obj = (mxFtp *)clientData;
	int	selection = (int)callData;

	if (obj->_ftpProcess->active())
	  {
	   obj->busy();
	   if (selection == 0)
	     obj->_ftpProcess->input("ascii");
	   else
	     obj->_ftpProcess->input("bin");
	   obj->ready();
	  }
}
////////////////////////////////////////////////////////////////////////////////
//
//	Local ChgDir callback
//
////////////////////////////////////////////////////////////////////////////////
void	mxFtp::localChgDirCB(Widget,XtPointer clientData,XtPointer)
{
	mxFtp	*obj = (mxFtp *)clientData;

	obj->busy();
	obj->_promptDialog->setTitle("LOCAL ChgDir");
	obj->_promptDialog->setPrompt("Directory");
	if (!obj->_localSystem->selectedDirectory().empty())
	  obj->_promptDialog->setValue(obj->_localSystem->selectedDirectory());
	else
	  obj->_promptDialog->setValue(obj->_localSystem->currentDirectory());
	obj->_promptDialog->setEditable(true);
	obj->_promptDialog->post((XtPointer)obj,
				 &mxFtp::localChgDirOK,
				 &mxFtp::dummyCB);
	obj->ready();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Local ChgDir OK callback
//
////////////////////////////////////////////////////////////////////////////////
void	mxFtp::localChgDirOK(XtPointer clientData,XtPointer callData)
{
	mxFtp		*obj = (mxFtp *)clientData;
	char		*selection = (char *)callData;
	struct stat	stbuf;

	obj->busy();
	if (stat(selection,&stbuf) != -1)
	   {
	    localDirChangedCB(clientData,selection);
	    obj->_promptDialog->unmanage();
	   }
	else
	   {
	    XBell(XtDisplay(obj->_w),50);
	    obj->_message->write(AK_ERROR,"Specified directory does not exist\n");
	   }
	obj->ready();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Local MkDir callback
//
////////////////////////////////////////////////////////////////////////////////
void	mxFtp::localMkDirCB(Widget,XtPointer clientData,XtPointer)
{
	mxFtp	*obj = (mxFtp *)clientData;

	obj->busy();
	obj->_promptDialog->setTitle("LOCAL MkDir");
	obj->_promptDialog->setPrompt("Directory");
	if (!obj->_localSystem->selectedDirectory().empty())
	  obj->_promptDialog->setValue(obj->_localSystem->selectedDirectory());
	else
	  obj->_promptDialog->setValue(obj->_localSystem->currentDirectory());
	obj->_promptDialog->setEditable(true);
	obj->_promptDialog->post((XtPointer)obj,
				 &mxFtp::localMkDirOK,
				 &mxFtp::dummyCB);
	obj->ready();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Local MkDir OK callback
//
////////////////////////////////////////////////////////////////////////////////
void	mxFtp::localMkDirOK(XtPointer clientData,XtPointer callData)
{
	mxFtp	*obj = (mxFtp *)clientData;
	char	*selection = (char *)callData;

	obj->busy();
	if (mkdir(selection,0755) == -1)
	   {
	    XBell(XtDisplay(obj->_w),50);
	    obj->_message->write(AK_ERROR,"Cannot create specified directory\n");
	   }
	else
	   {
	    obj->_localSystem->update(obj->_localSystem->currentDirectory(),
				    obj->localLsListing(obj->_localSystem->currentDirectory()));
	    obj->_promptDialog->unmanage();
	   }
	obj->ready();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Local Remove callback
//
////////////////////////////////////////////////////////////////////////////////
void	mxFtp::localRemoveCB(Widget,XtPointer clientData,XtPointer)
{
	mxFtp	*obj = (mxFtp *)clientData;
	string	selections;

	obj->busy();

//	Add any selected directory

	if (!obj->_localSystem->selectedDirectory().empty())
	  selections = obj->_localSystem->selectedDirectory() + " ";

//	Add any selected files

	if (obj->_localSystem->noSelectedFiles() > 0)
	  {
	   string	*selected_files;
	   selected_files = obj->_localSystem->selectedFiles();

	   for (int i=0;i<obj->_localSystem->noSelectedFiles();i++)
	     selections += selected_files[i] + " ";
	   delete []selected_files;
	  }

	obj->_promptDialog->setValue(selections);
	obj->_promptDialog->setTitle("LOCAL Remove");
	obj->_promptDialog->setPrompt("Directory/File");
	obj->_promptDialog->setEditable(false);
	obj->_promptDialog->post((XtPointer)obj,
				 &mxFtp::localRemoveOK,
				 &mxFtp::dummyCB);
	obj->ready();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Local Remove OK callback
//
////////////////////////////////////////////////////////////////////////////////
void	mxFtp::localRemoveOK(XtPointer clientData,XtPointer callData)
{
	mxFtp		*obj = (mxFtp *)clientData;
	string		selection = (char *)callData;
	struct stat	stbuf;
	int		pos;

	obj->busy();

//	Split off items and remove each item in turn

	while ((pos=selection.find(' ')) >= 0)
	  {
	   string	name;

	   name.assign(selection,0,pos);
	   selection.remove(0,pos+1);

	   // Check if can access specified file/directory and check type
	   if (stat((char *)name.c_str(),&stbuf) == -1)
	     {
	      obj->_message->write(AK_ERROR,"%s does not exist\n",
				   (char *)name.c_str());
	      XBell(XtDisplay(obj->_w),50);
	     }

	   // Entry is a Directory
	   if ((stbuf.st_mode & S_IFMT) == S_IFDIR)
	     {
	      if (rmdir((char *)name.c_str()) == -1)
	        {
		 XBell(XtDisplay(obj->_w),50);
		 obj->_message->write(AK_ERROR,"Cannot remove directory %s\n",
				      (char *)name.c_str());
		}
	     }
	   // Entry is a File
	   else
	     {
	      if (unlink((char *)name.c_str()) == -1)
		{
		 XBell(XtDisplay(obj->_w),50);
		 obj->_message->write(AK_ERROR,"Cannot remove file %s\n",
				      (char *)name.c_str());
		}
	     }
	  }

//	Update directory display

	obj->_localSystem->update(obj->_localSystem->currentDirectory(),
				  obj->localLsListing(obj->_localSystem->currentDirectory()));
	obj->_promptDialog->unmanage();

	obj->ready();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Remote ChgDir callback
//
////////////////////////////////////////////////////////////////////////////////
void	mxFtp::remoteChgDirCB(Widget,XtPointer clientData,XtPointer)
{
	mxFtp	*obj = (mxFtp *)clientData;

	obj->busy();
	obj->_promptDialog->setTitle("REMOTE ChgDir");
	obj->_promptDialog->setPrompt("Directory");
	if (!obj->_remoteSystem->selectedDirectory().empty())
	  obj->_promptDialog->setValue(obj->_remoteSystem->selectedDirectory());
	else
	  obj->_promptDialog->setValue(obj->_remoteSystem->currentDirectory());
	obj->_promptDialog->setEditable(true);
	obj->_promptDialog->post((XtPointer)obj,
				 &mxFtp::remoteChgDirOK,
				 &mxFtp::dummyCB);
	obj->ready();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Remote ChgDir OK callback
//
////////////////////////////////////////////////////////////////////////////////
void	mxFtp::remoteChgDirOK(XtPointer clientData,XtPointer callData)
{
	mxFtp	*obj = (mxFtp *)clientData;
	char	*selection = (char *)callData;

	obj->busy();
	remoteDirChangedCB(clientData,selection);
	obj->_promptDialog->unmanage();
	obj->ready();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Remote MkDir callback
//
////////////////////////////////////////////////////////////////////////////////
void	mxFtp::remoteMkDirCB(Widget,XtPointer clientData,XtPointer)
{
	mxFtp	*obj = (mxFtp *)clientData;

	obj->busy();
	obj->_promptDialog->setTitle("REMOTE MkDir");
	obj->_promptDialog->setPrompt("Directory");
	if (!obj->_remoteSystem->selectedDirectory().empty())
	  obj->_promptDialog->setValue(obj->_remoteSystem->selectedDirectory());
	else
	  obj->_promptDialog->setValue(obj->_remoteSystem->currentDirectory());
	obj->_promptDialog->setEditable(true);
	obj->_promptDialog->post((XtPointer)obj,
				 &mxFtp::remoteMkDirOK,
				 &mxFtp::dummyCB);
	obj->ready();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Remote MkDir OK callback
//
////////////////////////////////////////////////////////////////////////////////
void	mxFtp::remoteMkDirOK(XtPointer clientData,XtPointer callData)
{
	mxFtp	*obj = (mxFtp *)clientData;
	char	*selection = (char *)callData;
	string	command;

	obj->busy();
	command  = "mkdir ";
	command += selection;
	obj->_mkdirCmd = true;
	obj->setState();
	obj->_ftpProcess->input(command);
	obj->_promptDialog->unmanage();
	obj->ready();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Remote Remove callback
//	NOTE : Currently this limits to removal of one file/dir at a time
//	       due to rmdirCmd stuff (remoteRemoveOK etc).
//
////////////////////////////////////////////////////////////////////////////////
void	mxFtp::remoteRemoveCB(Widget,XtPointer clientData,XtPointer)
{
	mxFtp	*obj = (mxFtp *)clientData;
	string	selections;

	obj->busy();

//	Add any selected directory

	if (!obj->_remoteSystem->selectedDirectory().empty())
	  selections = obj->_remoteSystem->selectedDirectory() + " ";

//	Add a selected file

	else if (obj->_remoteSystem->noSelectedFiles() > 0)
	  {
	   string	*selected_files;
	   selected_files = obj->_remoteSystem->selectedFiles();
	   selections += selected_files[0] + " ";
	   delete []selected_files;
	  }

	obj->_promptDialog->setValue(selections);
	obj->_promptDialog->setTitle("REMOTE Remove");
	obj->_promptDialog->setPrompt("Directory/File");
	obj->_promptDialog->setEditable(false);
	obj->_promptDialog->post((XtPointer)obj,
				 &mxFtp::remoteRemoveOK,
				 &mxFtp::dummyCB);
	obj->ready();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Remote Remove OK callback
//
////////////////////////////////////////////////////////////////////////////////
void	mxFtp::remoteRemoveOK(XtPointer clientData,XtPointer callData)
{
	mxFtp	*obj = (mxFtp *)clientData;
	string	selection = (char *)callData;
	int	pos;

	obj->busy();

//	Split off items and remove each item in turn

	while ((pos=selection.find(' ')) >= 0)
	  {
	   string	name;

	   name.assign(selection,0,pos);
	   selection.remove(0,pos+1);

	   // Use delete rather than rmdir since copes with files as well
	   string	command = "delete " + name;
	   obj->_rmdirCmd = true;
	   obj->setState();
	   obj->_ftpProcess->input(command);
	  }
	obj->_promptDialog->unmanage();

	obj->ready();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Local directory change callback - 'selection' always exists
//
////////////////////////////////////////////////////////////////////////////////
void	mxFtp::localDirChangedCB(XtPointer clientData,string selection)
{
	mxFtp	*obj = (mxFtp *)clientData;

	obj->busy();
	obj->_localSystem->update(selection,obj->localLsListing(selection));
	if (obj->_ftpProcess->active())
	  {
	   string command = "lcd " + selection;
	   obj->_ftpProcess->input(command);
	  }
	obj->ready();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Remote directory change callback
//
////////////////////////////////////////////////////////////////////////////////
void	mxFtp::remoteDirChangedCB(XtPointer clientData,string selection)
{
	mxFtp	*obj = (mxFtp *)clientData;

	obj->busy();
	obj->_cdCmd = true;
	obj->setState();
	string command = "cd " + selection;
	obj->_ftpProcess->input(command);
	obj->ready();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Logo Animation - Ftp active
//
////////////////////////////////////////////////////////////////////////////////
void	mxFtp::animateLogoCB(XtPointer clientData,XtIntervalId *id)
{
	mxFtp	*obj = (mxFtp *)clientData;

	obj->_animateLogoNo++;
	if (obj->_animateLogoNo > 11)
	  obj->_animateLogoNo = 2;
	obj->_applicationLogo->updatePixmap(obj->_logoPixmaps[obj->_animateLogoNo]);

	obj->_animationId =
	  XtAppAddTimeOut(theAkApp->appContext(),
			  50,
			  &mxFtp::animateLogoCB,
			  (XtPointer)obj);
}
