#include <string.h>
#include <stdlib.h>
#include <iostream.h>
#include <fstream.h>
#include <stdio.h>
#include <Xm/Notebook.h>
#include <Xm/ScrolledW.h>
#include <Xm/RowColumn.h>
#include <Xm/PushB.h>
#include <Xm/MessageB.h>
#include <Xm/PanedW.h>
#include <Xm/Text.h>
#include <Xm/Form.h>
#include <Xm/Label.h>
#include <X11/cursorfont.h>
#include <X11/xpm.h>
#include <X11/Xmu/Editres.h>

#include "akFileDialogMgr.h"
#include "mxMailBoxDisplay.h"
#include "mxSetup.h"
#include "mxMailCompose.h"
#include "mxMailBoxDisplayIcon.xpm"
#include "mxButtons.xpm"
////////////////////////////////////////////////////////////////////////////////
//
//	Constructor
//
////////////////////////////////////////////////////////////////////////////////
mxMailBoxDisplay::mxMailBoxDisplay(char *name,
				   mxMailBox *box,
				   mxMailAddressBook *book,
				   mxMailSpamBook *spam,
				   XtCallbackProc callback,
				   XtPointer clientData)
	:akWindow(name),
	 _mailbox(box),
	 _addressbook(book),
	 _spambook(spam),
	 _currentMessageNo(-1),
	 _readStatusUpdated(false),
	 _messageView((mxMailMsgDisplay *)0),
	 _messageList((akList *)0),
	 _closeButton((akButton *)0),
	 _deleteButton((akButton *)0),
	 _undeleteButton((akButton *)0),
	 _replyButton((akButton *)0),
	 _forwardButton((akButton *)0),
	 _copyButton((akButton *)0),
	 _moveButton((akButton *)0),
	 _spamButton((akButton *)0),
	 _findButton((akButton *)0),
	 _sortByDateButton((akButton *)0),
	 _sortByAuthorButton((akButton *)0),
	 _sortBySubjectButton((akButton *)0),
	 _sortBySizeButton((akButton *)0),
	 _mailboxSelector((mxMailBoxSelector *)0),
	 _findDialog((akPromptDialog *)0),
	 _findLocation(-1),
	 _userCB(callback),
	 _userData(clientData)
{
//	Create the panel

	initialize();

	installWMClose();

	if (box->type() == INBOX)
	  setIcon("INBOX Display",mxMailBoxDisplayIcon_xpm);
	else if (box->type() == OUTBOX)
	  setIcon("OUTBOX Display",mxMailBoxDisplayIcon_xpm);
	else if (box->type() == FOLDER)
	   {
	    string	folder=box->filename();
	    int		pos=folder.rfind('/');
	    if (pos >= 0)
	      folder.remove(0,pos+1);
	    folder += " Display";
	    setIcon(folder,mxMailBoxDisplayIcon_xpm);
	   }
}
////////////////////////////////////////////////////////////////////////////////
//
//	Destructor
//
////////////////////////////////////////////////////////////////////////////////
mxMailBoxDisplay::~mxMailBoxDisplay()
{
	if (_messageList)
	  delete _messageList;
	if (_messageView)
	  delete _messageView;
	if (_closeButton)
	  delete _closeButton;
	if (_deleteButton)
	  delete _deleteButton;
	if (_undeleteButton)
	  delete _undeleteButton;
	if (_replyButton)
	  delete _replyButton;
	if (_forwardButton)
	  delete _forwardButton;
	if (_copyButton)
	  delete _copyButton;
	if (_moveButton)
	  delete _moveButton;
	if (_spamButton)
	  delete _spamButton;
	if (_findButton)
	  delete _findButton;
	if (_sortByDateButton)
	  delete _sortByDateButton;
	if (_sortByAuthorButton)
	  delete _sortByAuthorButton;
	if (_sortBySubjectButton)
	  delete _sortBySubjectButton;
	if (_sortBySizeButton)
	  delete _sortBySizeButton;
	if (_mailboxSelector)
	  delete _mailboxSelector;
	if (_findDialog)
	  delete _findDialog;
}
////////////////////////////////////////////////////////////////////////////////
//
//	Manage function
//
////////////////////////////////////////////////////////////////////////////////
void	mxMailBoxDisplay::manage()
{
	akWindow::manage();

	update();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Update function	- (re)sets content of list and view.
//	NB Typically called after _mailbox updated
//
////////////////////////////////////////////////////////////////////////////////
void	mxMailBoxDisplay::update()
{
//	Delete all existing list and view items

	_messageList->empty();

//	Update mailbox messages to reflect 'readIds', and update 'readIds' also

	for (int i=0;i<_readIds.size();i++)
	   {
	    for (int j=0;j<_mailbox->noOfMsgs();j++)
	       {
		mxMsgSummary	msg=_mailbox->message(j);
		if (msg.messageId() == _readIds[i] && !msg.status())
		   {
		    msg.setStatus(true);
		    break;
		   }
	       }
	   }
	_readIds.erase(_readIds.begin(),_readIds.end());
	for (int i=0;i<_mailbox->noOfMsgs();i++)
	   {
	    mxMsgSummary	msg=_mailbox->message(i);
	    if (msg.status())
	      _readIds.push_back(msg.messageId());
	   }

//	Check that messages equating to deletionIds still exist

	for (int i=_deletionIds.size()-1;i>=0;i--)
	   {
	    bool	message_still_exists=false;
	    for (int j=0;j<_mailbox->noOfMsgs();j++)
	       {
		if (_mailbox->message(j).messageId() == _deletionIds[i])
		   {
		    message_still_exists = true;
		    break;
		   }
	       }
	    if (!message_still_exists)
	       {
		_deletionIds.erase(_deletionIds.begin()+i);
	       }
	   }

//	Add messages to list

	for (int i=0;i<_mailbox->noOfMsgs();i++)
	   {
	    _messageList->insert(titleForMessage(i));
	   }

//	Update title on display panel window frame

	char	display_title[200];
	if (_mailbox->type() == INBOX)
	  sprintf(display_title,"mxMail - INBOX    %d messages",
		  _mailbox->noOfMsgs());
	else if (_mailbox->type() == OUTBOX)
	  sprintf(display_title,"mxMail - OUTBOX    %d messages",
		  _mailbox->noOfMsgs());
	else
	  {
	   string	tempstr=_mailbox->filename();
	   int		pos=tempstr.rfind("/");
	   if (pos >= 0)
	     tempstr.remove(0,pos+1);
	   sprintf(display_title,"mxMail - FOLDER (%s)    %d messages",
		   (char *)tempstr.c_str(),
		   _mailbox->noOfMsgs());
	  }
	setTitle(display_title);

//	Re-select the previous selection, else the first message, else none

	int	msg_no=-1;
	for (int i=0;i<_mailbox->noOfMsgs();i++)
	   {
	    if (_mailbox->message(i).messageId() == _selectedId)
	       {
		msg_no = i;
		break;
	       }
	   }
	if (msg_no < 0)
	  _currentMessageNo = -1;

	// Current message is not there anymore, so go for first one
	if (msg_no < 0 && _mailbox->noOfMsgs() > 0)
	  msg_no = 0;
	if (msg_no >= 0)
	  selectMessage(msg_no);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Panel creation function
//
////////////////////////////////////////////////////////////////////////////////
Widget	mxMailBoxDisplay::createWorkArea(Widget parent)
{
	Arg		args[10];
	Widget		form,messagebox,pane;

//	Add editres support

	XtAddEventHandler(parent,(EventMask)0,TRUE,
			  (XtEventHandler)_XEditResCheckMessages,0);

//	Add a form to attach everything to

	form =
		XtVaCreateManagedWidget("ViewForm",
					xmFormWidgetClass,
					parent,
					NULL);

//	Add messagebox to hold buttons

	messagebox =
		XtVaCreateWidget("ButtonBar",
				xmMessageBoxWidgetClass,
				form,
			 	XmNleftAttachment,XmATTACH_FORM,
			 	XmNrightAttachment,XmATTACH_FORM,
			 	XmNbottomAttachment,XmATTACH_FORM,
			 	XmNtopAttachment,XmATTACH_FORM,
				NULL);

//	Set up option buttons

	_closeButton =
	  new akButton(messagebox,"Close",mxClose_xpm,
		       &mxMailBoxDisplay::closeCB,(XtPointer)this);
	_closeButton->installHelp("Close the display panel and\ndelete any delete-tagged messages");
	_closeButton->manage();
	_deleteButton =
	  new akButton(messagebox,"Delete",mxDelete_xpm,
		       &mxMailBoxDisplay::deleteCB,(XtPointer)this);
	_deleteButton->installHelp("Tag the selected message\nto be deleted");
	_deleteButton->manage();
	_undeleteButton =
	  new akButton(messagebox,"Undelete",mxUndelete_xpm,
		       &mxMailBoxDisplay::undeleteCB,(XtPointer)this);
	_undeleteButton->installHelp("Remove any deletion tag\nfrom the selected message");
	_undeleteButton->manage();
	_forwardButton =
	  new akButton(messagebox,"Forward",mxForward_xpm,
		       &mxMailBoxDisplay::forwardCB,(XtPointer)this);
	_forwardButton->installHelp("Forward the selected message");
	_forwardButton->manage();
	_replyButton =
	  new akButton(messagebox,"Reply",mxReply_xpm,
		       &mxMailBoxDisplay::replyCB,(XtPointer)this);
	_replyButton->installHelp("Reply to the selected message");
	_replyButton->manage();
	_copyButton =
	  new akButton(messagebox,"Copy",mxCopy_xpm,
		       &mxMailBoxDisplay::copyCB,(XtPointer)this);
	_copyButton->installHelp("Copy the selected message\nto a specified folder");
	_copyButton->manage();
	_moveButton =
	  new akButton(messagebox,"Move",mxMove_xpm,
		       &mxMailBoxDisplay::moveCB,(XtPointer)this);
	_moveButton->installHelp("Move the selected message\nto a specified folder");
	_moveButton->manage();
	// Only add SPAM button on INBOX (where the incoming messages go)
	if (_mailbox->type() == INBOX)
	   {
	    _spamButton =
	      new akButton(messagebox,"Spam",mxSpam_xpm,
		       &mxMailBoxDisplay::spamCB,(XtPointer)this);
	    _spamButton->installHelp("Mark the current message as SPAM !");
	    _spamButton->manage();
	   }
	_findButton =
	      new akButton(messagebox,"Find",mxFind_xpm,
		       &mxMailBoxDisplay::findCB,(XtPointer)this);
	_findButton->installHelp("Find a string in\nthe current message");
	_findButton->manage();
	XtUnmanageChild(XmMessageBoxGetChild(messagebox,XmDIALOG_OK_BUTTON));
	XtUnmanageChild(XmMessageBoxGetChild(messagebox,XmDIALOG_CANCEL_BUTTON));
	XtUnmanageChild(XmMessageBoxGetChild(messagebox,XmDIALOG_HELP_BUTTON));
	XtUnmanageChild(XmMessageBoxGetChild(messagebox,XmDIALOG_MESSAGE_LABEL));
	XtUnmanageChild(XmMessageBoxGetChild(messagebox,XmDIALOG_SYMBOL_LABEL));
	XtManageChild(messagebox);
	XtVaSetValues(messagebox,XmNdefaultButton,_closeButton->baseWidget(),0);

//	Add paned window to contain mail list and contents

	pane =
	      XtVaCreateManagedWidget("PanedWindow",
				      xmPanedWindowWidgetClass,
				      messagebox,
				      XmNrefigureMode,TRUE,
				      XmNseparatorOn,TRUE,
				      0);

//	Add list area to show available mail messages and option buttons

	Widget	list_form,list_rowcol;
	list_form =
		XtVaCreateManagedWidget("MailList",
					xmFormWidgetClass,
					pane,
					0);
	list_rowcol =
		XtVaCreateManagedWidget("ListOptions",
					xmRowColumnWidgetClass,
					list_form,
					XmNtopAttachment,XmATTACH_FORM,
					XmNbottomAttachment,XmATTACH_FORM,
					XmNrightAttachment,XmATTACH_FORM,
					XmNnumColumns,2,
					XmNpacking,XmPACK_COLUMN,
					XmNorientation,XmVERTICAL,
					0);
	_sortByDateButton =
	  new akButton(list_rowcol,"SortByDate",mxSortByDate_xpm,
		       &mxMailBoxDisplay::sortByDateCB,(XtPointer)this);
	_sortByDateButton->installHelp("Sort the messages by date/time");
	_sortByDateButton->manage();
	_sortByAuthorButton =
	  new akButton(list_rowcol,"SortByAuthor",mxSortByAuthor_xpm,
		       &mxMailBoxDisplay::sortByAuthorCB,(XtPointer)this);
	_sortByAuthorButton->installHelp("Sort the messages by author");
	_sortByAuthorButton->manage();
	_sortBySubjectButton =
	  new akButton(list_rowcol,"SortBySubject",mxSortBySubject_xpm,
		       &mxMailBoxDisplay::sortBySubjectCB,(XtPointer)this);
	_sortBySubjectButton->installHelp("Sort the messages by subject");
	_sortBySubjectButton->manage();
	_sortBySizeButton =
	  new akButton(list_rowcol,"SortBySize",mxSortBySize_xpm,
		       &mxMailBoxDisplay::sortBySizeCB,(XtPointer)this);
	_sortBySizeButton->installHelp("Sort the messages by size");
	_sortBySizeButton->manage();
	_messageList =
	  new akList(list_form,"MailList",
		     &mxMailBoxDisplay::listPageChanged,(XtPointer)this);
	XtVaSetValues(_messageList->baseWidget(),
		XmNtopAttachment,XmATTACH_FORM,
		XmNbottomAttachment,XmATTACH_FORM,
		XmNleftAttachment,XmATTACH_FORM,
		XmNrightAttachment,XmATTACH_WIDGET,
		XmNrightWidget,list_rowcol,
		0);
	_messageList->manage();

//	Add display area to show selected mail message

	mxMailMsg	msg;

	_messageView =
	   new mxMailMsgDisplay(pane,
			"mxMailMsgDisplay",
			MX_MSG_DISPLAY,
			msg,
			_addressbook);
	_messageView->manage();

	return form;
}
////////////////////////////////////////////////////////////////////////////////
//
//	listPageChanged - update view to display selected message.
//
////////////////////////////////////////////////////////////////////////////////
void 	mxMailBoxDisplay::listPageChanged(Widget w,XtPointer clientData,XtPointer callData)
{
	mxMailBoxDisplay	*obj = (mxMailBoxDisplay *)clientData;
	XmListCallbackStruct 	*cbs = (XmListCallbackStruct *)callData;

	obj->busy();
	obj->selectMessage(cbs->item_position-1);

	obj->ready();
}
////////////////////////////////////////////////////////////////////////////////
//
//	selectMessage - select a message (msg_no from 0 to noOfMsgs()-1)
//
////////////////////////////////////////////////////////////////////////////////
void	mxMailBoxDisplay::selectMessage(int msgNo)
{
	if (msgNo < 0 || msgNo >= _mailbox->noOfMsgs())
	  return;

//	Select the message in the list

	_messageList->select(msgNo+1);

//	If was previously selected, do nothing more

	if (_currentMessageNo >= 0 &&
	    _currentMessageNo < _mailbox->noOfMsgs() &&
	    _mailbox->message(_currentMessageNo).messageId() ==
	    _mailbox->message(msgNo).messageId())
	   {
	    _currentMessageNo = msgNo;
	    return;
	   }

//	Update the current message number and message id

	_currentMessageNo = msgNo;
	_selectedId = _mailbox->message(_currentMessageNo).messageId();

//	Update the message being displayed

	mxMailMsg	msg;
	msg.setMessage(_mailbox->messageText(_currentMessageNo));
	_messageView->setMessage(msg);

//	Mark message as 'read' if not already

	mxMsgSummary	msg_summary=_mailbox->message(_currentMessageNo);
	if (!msg_summary.status())
	   {
	    _readStatusUpdated = true;
	    msg_summary.setStatus(true);
	    _readIds.push_back(msg_summary.messageId());
	    _mailbox->modify(_currentMessageNo,msg_summary);
	    _messageList->replace(_currentMessageNo+1,titleForMessage(_currentMessageNo));
	    _messageList->select(_currentMessageNo+1);
	   }
}
////////////////////////////////////////////////////////////////////////////////
//
//	Close Callback
//
////////////////////////////////////////////////////////////////////////////////
void 	mxMailBoxDisplay::closeCB(Widget,XtPointer clientData,XtPointer)
{
	mxMailBoxDisplay	*obj = (mxMailBoxDisplay *)clientData;

	obj->busy();

//	Copy 'deleted' messages into 'Deleted-Mail' folder for now

	string	deletion_mailbox = theMxSetup->mailFolderDirectory() + "Deleted-Mail";
	if (obj->_mailbox->filename() == deletion_mailbox)
	   {
	   }
	else
	   {
	    for (int i=0;i<obj->_deletionIds.size();i++)
	       {
	 	for (int j=0;j<obj->_mailbox->noOfMsgs();j++)
		   {
		    string	deletion_folder=theMxSetup->mailFolderDirectory() + "Deleted-Mail";

		    if (obj->_deletionIds[i] == obj->_mailbox->message(j).messageId())
		       {
			ofstream	outfile((char *)deletion_folder.c_str(),ios::app);
			outfile << obj->_mailbox->messageText(j);
			outfile.close();
		       }
		   }
	       }
	   }

//	Delete required messages (including any duplicates !)

	bool	messages_deleted=false;
	for (int i=0;i<obj->_deletionIds.size();i++)
	   {
	    for (int j=obj->_mailbox->noOfMsgs()-1;j>=0;j--)
	       {
		if (obj->_deletionIds[i] == obj->_mailbox->message(j).messageId())
		   {
		    obj->_mailbox->remove(j);
		    messages_deleted=true;
		   }
	       }
	   }

//	Write the mailbox (always, rather than just when messages deleted)

	if (obj->_readStatusUpdated || messages_deleted)
	  obj->_mailbox->write();
	obj->_readStatusUpdated = false;
	obj->_readIds.erase(obj->_readIds.begin(),obj->_readIds.end());

//	INBOX : PENDING messages - move 'read' messages across to PENDING folder

	messages_deleted = false;
	if (obj->_mailbox->type() == INBOX)
	   {
	    string	pending_file=theMxSetup->mailInboxReadFolder();
	    if (pending_file.size() > 0)
	       {
		ofstream	outfile((char *)pending_file.c_str(),ios::app);

		if (outfile)
		   {
		    // Copy to PENDING folder
		    for (int i=0;i<obj->_mailbox->noOfMsgs();i++)
		       {
			// Check if message has been 'read'
			if (obj->_mailbox->message(i).status())
			   {
			    outfile << obj->_mailbox->messageText(i);
			   }
		       }
		    outfile.close();

		    // Remove 'read' messages from the INBOX
		    for (int i=obj->_mailbox->noOfMsgs()-1;i>=0;i--)
		       {
			// If message has been 'read', remove it
			if (obj->_mailbox->message(i).status())
			   {
			    obj->_mailbox->remove(i);
			    messages_deleted = true;
			   }
		       }

		    // Keep mailbox in step with deletion of messages
		    if (messages_deleted)
		      obj->_mailbox->write();
		   }
	       }
	   }

//	Remove the display panel

	if (obj->_findDialog)
	  obj->_findDialog->unmanage();
	obj->unmanage();
	obj->ready();

//	Call users callback

	if (obj->_userCB)
	  obj->_userCB(obj->_w,obj->_userData,(XtPointer)obj);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Delete Callback
//
////////////////////////////////////////////////////////////////////////////////
void 	mxMailBoxDisplay::deleteCB(Widget,XtPointer clientData,XtPointer)
{
	mxMailBoxDisplay	*obj = (mxMailBoxDisplay *)clientData;
	mxMsgSummary		msg;

	obj->busy();

//	If message is already set for deletion don't do anything

	msg = obj->_mailbox->message(obj->_currentMessageNo);
	for (int i=0;i<obj->_deletionIds.size();i++)
	   {
	    if (obj->_deletionIds[i] == msg.messageId())
	       {
		obj->ready();
		return;
	       }
	   }

//	Add selected message's messageId to deletionId list

	obj->_deletionIds.push_back(msg.messageId());

//	Update title of current messageId and set list selection

	string	item_title = obj->titleForMessage(obj->_currentMessageNo);
	obj->_messageList->replace(obj->_currentMessageNo+1,item_title);
	if (obj->_mailbox->noOfMsgs() > obj->_currentMessageNo+1)
	  obj->selectMessage(obj->_currentMessageNo+1);
	else
	  obj->selectMessage(obj->_currentMessageNo);
	obj->ready();
}
////////////////////////////////////////////////////////////////////////////////
//
//	UnDelete Callback
//
////////////////////////////////////////////////////////////////////////////////
void 	mxMailBoxDisplay::undeleteCB(Widget,XtPointer clientData,XtPointer)
{
	mxMailBoxDisplay	*obj = (mxMailBoxDisplay *)clientData;
	mxMsgSummary		msg;

	obj->busy();

//	If message isn't already set for deletion don't do anything

	msg = obj->_mailbox->message(obj->_currentMessageNo);

	int	deletion_id_no = -1;
	for (int i=0;i<obj->_deletionIds.size();i++)
	   {
	    if (obj->_deletionIds[i] == msg.messageId())
	       {
		deletion_id_no = i;
		break;
	       }
	   }
	if (deletion_id_no < 0)
	   {
	    obj->ready();
	    return;
	   }

//	Set deletion flag for message and save it in mailbox

	obj->_deletionIds.erase(obj->_deletionIds.begin()+deletion_id_no);

//	Update title of selected message and reselect it in list

	string	item_title = obj->titleForMessage(obj->_currentMessageNo);
	obj->_messageList->replace(obj->_currentMessageNo+1,item_title);
	obj->selectMessage(obj->_currentMessageNo);

	obj->ready();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Reply Callback
//
////////////////////////////////////////////////////////////////////////////////
void 	mxMailBoxDisplay::replyCB(Widget,XtPointer clientData,XtPointer)
{
	mxMailBoxDisplay	*obj = (mxMailBoxDisplay *)clientData;
	int			msgNo;
	mxMailMsg		msg;
	mxMailCompose		*compose;
	string			text;
	int			*selections;

	obj->busy();

//	Find which message is selected

	selections = obj->_messageList->selectedPos();
	msgNo = selections[0];
	msg.setMessage(obj->_mailbox->messageText(msgNo-1));

//	Create an mxMailCompose object passing this message in as 'reply'

	compose = new mxMailCompose("mxMailCompose",obj->_addressbook,
				    MX_MAIL_COMPOSE_REPLY,0,&msg,
				    &mxMailBoxDisplay::composeClosedCB,
				    (XtPointer)obj);
	compose->manage();

	obj->ready();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Forward Callback
//
////////////////////////////////////////////////////////////////////////////////
void 	mxMailBoxDisplay::forwardCB(Widget,XtPointer clientData,XtPointer)
{
	mxMailBoxDisplay	*obj = (mxMailBoxDisplay *)clientData;
	int			msgNo;
	mxMailMsg		msg;
	mxMailCompose		*compose;
	int			*selections;

	obj->busy();

//	Find which message is selected

	selections = obj->_messageList->selectedPos();
	msgNo = selections[0];
	msg.setMessage(obj->_mailbox->messageText(msgNo-1));

//	Create an mxMailCompose object passing this message in as 'forward'

	compose = new mxMailCompose("mxMailCompose",obj->_addressbook,
				    MX_MAIL_COMPOSE_FORWARD,0,&msg,
				    &mxMailBoxDisplay::composeClosedCB,
				    (XtPointer)obj);
	compose->manage();

	obj->ready();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Compose Closed Callback
//
////////////////////////////////////////////////////////////////////////////////
void 	mxMailBoxDisplay::composeClosedCB(Widget,XtPointer,XtPointer callData)
{
	mxMailCompose		*compose = (mxMailCompose *)callData;

	if (compose)
	  delete compose;
}
////////////////////////////////////////////////////////////////////////////////
//
//	Copy Callback - copy message to a folder
//
////////////////////////////////////////////////////////////////////////////////
void 	mxMailBoxDisplay::copyCB(Widget,XtPointer clientData,XtPointer)
{
	mxMailBoxDisplay	*obj = (mxMailBoxDisplay *)clientData;

	if (!obj->_mailboxSelector)
	  obj->_mailboxSelector = new mxMailBoxSelector(obj->_w,
							"MailboxSelector",
							FALSE,
							&mxMailBoxDisplay::copyOK,
							(XtPointer)obj);
	obj->_mailboxSelector->manage();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Copy Messge OK - copy message to a folder
//
////////////////////////////////////////////////////////////////////////////////
void 	mxMailBoxDisplay::copyOK(XtPointer clientData,string selection)
{
	mxMailBoxDisplay	*obj = (mxMailBoxDisplay *)clientData;
	string			selected_message;

	if (selection.empty())
	  return;

//	Get the selected message and append to the chosen folder

	obj->busy();
	selected_message = obj->_mailbox->messageText(obj->_currentMessageNo);
	ofstream	outfile((char *)selection.c_str(),ios::app);
	if (outfile)
	  outfile << selected_message;
	outfile.close();
	obj->ready();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Move Callback - move message to a folder
//
////////////////////////////////////////////////////////////////////////////////
void 	mxMailBoxDisplay::moveCB(Widget w,XtPointer clientData,XtPointer callData)
{
	mxMailBoxDisplay	*obj = (mxMailBoxDisplay *)clientData;

	if (!obj->_mailboxSelector)
	  obj->_mailboxSelector = new mxMailBoxSelector(obj->_w,
							"MailboxSelector",
							FALSE,
							&mxMailBoxDisplay::moveOK,
							(XtPointer)obj);
	obj->_mailboxSelector->manage();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Move Message OK - move message to folder and tag as 'delete'
//
////////////////////////////////////////////////////////////////////////////////
void 	mxMailBoxDisplay::moveOK(XtPointer clientData,string selection)
{
	mxMailBoxDisplay	*obj = (mxMailBoxDisplay *)clientData;
	string			selected_message;

	if (selection.empty())
	  return;

//	Get the selected message and append to the chosen folder

	obj->busy();
	selected_message = obj->_mailbox->messageText(obj->_currentMessageNo);
	ofstream	outfile((char *)selection.c_str(),ios::app);
	if (outfile)
	  outfile << selected_message;
	outfile.close();

//	Tag the message for deletion

	deleteCB(obj->_w,(XtPointer)obj,0);

	obj->ready();
}
////////////////////////////////////////////////////////////////////////////////
//
//	spam Callback - Mark current message as spam.
//
////////////////////////////////////////////////////////////////////////////////
void 	mxMailBoxDisplay::spamCB(Widget,XtPointer clientData,XtPointer)
{
	mxMailBoxDisplay	*obj = (mxMailBoxDisplay *)clientData;
	mxMsgSummary		msg;

	obj->busy();
	msg = obj->_mailbox->message(obj->_currentMessageNo);

//	Tag current message for deletion

	deleteCB(obj->_w,(XtPointer)obj,0);

//	Add mail-id to spam book

	obj->_spambook->add(msg.mailid());
	obj->_spambook->write();

	obj->ready();
}
////////////////////////////////////////////////////////////////////////////////
//
//	find Callback
//
////////////////////////////////////////////////////////////////////////////////
void 	mxMailBoxDisplay::findCB(Widget,XtPointer clientData,XtPointer)
{
	mxMailBoxDisplay	*obj = (mxMailBoxDisplay *)clientData;

	obj->busy();
	if (!obj->_findDialog)
	   {
	    obj->_findDialog = new akPromptDialog(obj->_messageList->baseWidget(),
						"PromptDialog",FALSE,
						"Find:",(XtPointer)obj,
						&mxMailBoxDisplay::findNextCB,
						&mxMailBoxDisplay::findPrevCB,
						&mxMailBoxDisplay::findCloseCB);
	    obj->_findDialog->setOKLabel("Find Next");
	    obj->_findDialog->setCancelLabel("Find Previous");
	    obj->_findDialog->setHelpLabel("Close");
	    string	dialog_title;
	    if (obj->_mailbox->type() == INBOX)
	      dialog_title = "INBOX : Find string in message";
	    else if (obj->_mailbox->type() == OUTBOX)
	      dialog_title = "OUTBOX : Find string in message";
	    else if (obj->_mailbox->type() == FOLDER)
	       {
		string	folder=obj->_mailbox->filename();
		int	pos=folder.rfind('/');
		if (pos >= 0)
		  folder.remove(0,pos+1);
		dialog_title = folder + " : Find string in message";
	       }
	    obj->_findDialog->setTitle(dialog_title);
	   }
	obj->_findDialog->setMessageLabel(" ");
	obj->_findDialog->manage();
	obj->ready();
}
////////////////////////////////////////////////////////////////////////////////
//
//	find Next Callback
//
////////////////////////////////////////////////////////////////////////////////
void 	mxMailBoxDisplay::findNextCB(XtPointer clientData,XtPointer callData)
{
	mxMailBoxDisplay	*obj = (mxMailBoxDisplay *)clientData;
	char			*tempstr=(char *)callData;
	string			find_string=tempstr;

	if (find_string.empty() || find_string.size() == 0)
	   {
	    obj->_findDialog->setMessageLabel("Error : No String Entered");
	    XBell(XtDisplay(obj->_w),50);
	    return;
	   }

	string		body_text=obj->_messageView->msg().bodyText();

	// Find next occurence of 'find_string' after _findLocation
	// NB Convert all to upper-case before searching
	for (int i=0;i<find_string.size();i++)
	  find_string[i] = (char)toupper((int)find_string[i]);
	for (int i=0;i<body_text.size();i++)
	  body_text[i] = (char)toupper((int)body_text[i]);
	int	new_pos=body_text.find(find_string,obj->_findLocation+1);

	// Not found - give beep and message, and go to top of message
	if (new_pos < 0)
	   {
	    obj->_messageView->removeBodyTextHighlights();
	    obj->_findDialog->setMessageLabel("Bottom of message reached");
	    XBell(XtDisplay(obj->_w),50);
	    obj->_findLocation = -1;
	    return;
	   }
	else
	   {
	    obj->_findDialog->setMessageLabel(" ");
	    obj->_messageView->highlightAndShowBodyText(new_pos,new_pos+find_string.size());
	    obj->_findLocation = new_pos;
	   }
}
////////////////////////////////////////////////////////////////////////////////
//
//	find Prev Callback
//
////////////////////////////////////////////////////////////////////////////////
void 	mxMailBoxDisplay::findPrevCB(XtPointer clientData,XtPointer callData)
{
	mxMailBoxDisplay	*obj = (mxMailBoxDisplay *)clientData;
	char			*tempstr=(char *)callData;
	string			find_string=tempstr;

	if (find_string.empty() || find_string.size() == 0)
	   {
	    obj->_findDialog->setMessageLabel("Error : No String Entered");
	    XBell(XtDisplay(obj->_w),50);
	    return;
	   }

	string		body_text=obj->_messageView->msg().bodyText();

	// Find next occurence of 'find_string' after _findLocation
	// NB Convert all to upper-case before searching
	for (int i=0;i<find_string.size();i++)
	  find_string[i] = (char)toupper((int)find_string[i]);
	for (int i=0;i<body_text.size();i++)
	  body_text[i] = (char)toupper((int)body_text[i]);

	// At start of message - so give message
	if (obj->_findLocation <= 0)
	   {
	    obj->_messageView->removeBodyTextHighlights();
	    obj->_findDialog->setMessageLabel("Top of message reached");
	    XBell(XtDisplay(obj->_w),50);
	    obj->_findLocation = body_text.size();
	    return;
	   }

	int	new_pos=body_text.rfind(find_string,obj->_findLocation-1);

	// Not found - give beep and message, and go to top of message
	if (new_pos < 0)
	   {
	    obj->_messageView->removeBodyTextHighlights();
	    obj->_findDialog->setMessageLabel("Top of message reached");
	    XBell(XtDisplay(obj->_w),50);
	    obj->_findLocation = body_text.size();
	    return;
	   }
	else
	   {
	    obj->_findDialog->setMessageLabel(" ");
	    obj->_messageView->highlightAndShowBodyText(new_pos,new_pos+find_string.size());
	    obj->_findLocation = new_pos;
	   }
}
////////////////////////////////////////////////////////////////////////////////
//
//	find Close Callback
//
////////////////////////////////////////////////////////////////////////////////
void 	mxMailBoxDisplay::findCloseCB(XtPointer clientData,XtPointer callData)
{
	mxMailBoxDisplay	*obj = (mxMailBoxDisplay *)clientData;

//	Remove highlighting and the find dialog

	obj->_messageView->removeBodyTextHighlights();
	obj->_findDialog->unmanage();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Sorting functions
//
////////////////////////////////////////////////////////////////////////////////
void 	mxMailBoxDisplay::sortByDateCB(Widget,XtPointer clientData,XtPointer)
{
	mxMailBoxDisplay	*obj = (mxMailBoxDisplay *)clientData;

	obj->busy();
	obj->_mailbox->sortByDate();
	obj->update();
	obj->ready();
}
void 	mxMailBoxDisplay::sortByAuthorCB(Widget,XtPointer clientData,XtPointer)
{
	mxMailBoxDisplay	*obj = (mxMailBoxDisplay *)clientData;

	obj->busy();
	obj->_mailbox->sortByAuthor();
	obj->update();
	obj->ready();
}
void 	mxMailBoxDisplay::sortBySubjectCB(Widget,XtPointer clientData,XtPointer)
{
	mxMailBoxDisplay	*obj = (mxMailBoxDisplay *)clientData;

	obj->busy();
	obj->_mailbox->sortBySubject();
	obj->update();
	obj->ready();
}
void 	mxMailBoxDisplay::sortBySizeCB(Widget,XtPointer clientData,XtPointer)
{
	mxMailBoxDisplay	*obj = (mxMailBoxDisplay *)clientData;

	obj->busy();
	obj->_mailbox->sortBySize();
	obj->update();
	obj->ready();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Return title for message for list
//
////////////////////////////////////////////////////////////////////////////////
string 	mxMailBoxDisplay::titleForMessage(int no)
{
//	Check for incorrect input

	if (no < 0 || no >= _mailbox->noOfMsgs())
	  return "";

	mxMsgSummary	msg=_mailbox->message(no);

//	Add reflection of 'deletion' status

	string	title;
	bool	to_be_deleted=false;
	for (int i=0;i<_deletionIds.size();i++)
	   {
	    if (_deletionIds[i] == msg.messageId())
	       {
		to_be_deleted = true;
		break;
	       }
	   }
	if (to_be_deleted)
	  title = "Del ";
	else
	  title = "    ";

//	Add reflection of 'read' status

	if (msg.status())
	  title += "  ";
	else
	  title += "* ";

//	Add reflection of 'size' of message

	char	tempstr[20];
	sprintf(tempstr,"%3d %6d ",no+1,msg.length());
	title += tempstr;

//	Add reflection of 'author' and 'subject'

	if (_mailbox->type() == OUTBOX)
	  title += msg.toAddressee();
	else
	  title += msg.author();
	title += " '" + msg.subject() + "'";

	return title;
}
