#include <Xm/Xm.h>
#include <Xm/Form.h>
#include <Xm/Scale.h>
#include <Xm/Label.h>
#include <Xm/Frame.h>
#include <Xm/List.h>
#include <Xm/RowColumn.h>
#include <Xm/ScrolledW.h>
#include <Xm/DrawingA.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <stdarg.h>
#include <time.h>
#include <iostream.h>

#include "akApp.h"
#include "akColor.h"

static const char *colorResources[] =
{
	"*ColorView.height:			50",
	"*SliderFrame.width:			80",
	"*DefinedFrame.width:			130",
	"*redSlider*showValue:			TRUE",
	"*blueSlider*showValue:			TRUE",
	"*greenSlider*showValue:		TRUE",
	"*redSlider*troughColor:		red",
	"*greenSlider*troughColor:		green",
	"*blueSlider*troughColor:		blue",
	NULL,
};
////////////////////////////////////////////////////////////////////////////////
//
//	Constructor function for the akColor object.
//
////////////////////////////////////////////////////////////////////////////////
akColor::akColor(Widget parent,
		   char *name,
		   int theRed,
		   int theGreen,
		   int theBlue)
	: akComponent(name)
{
	Arg		args[1];
	Widget		rowcol;
	Widget		label;
	Widget		view_frame;
	Widget		slider_frame;
	Widget		defined_frame;
	int		status;
	Pixel		pixels[1];
	XmString	title_string;

//	Load default resources

	setDefaultResources(parent,colorResources);

//	Create form to contain view and controls

	_w = XmCreateForm(parent,_name,args,0);

	installDestroyHandler();

//	Allocate pixel to contain 'current' display area color

	status = XAllocColorCells(XtDisplay(_w),theAkApp->colormap(),
//		DefaultColormap(XtDisplay(_w),DefaultScreen(XtDisplay(_w))),
				  FALSE,NULL,0,pixels,1);
	if (status == FALSE)	// Will give FALSE on monochrome screens
	  {
	   XtVaGetValues(parent,XmNbackground,&_pixel,NULL);
	   cout << "ERROR : Could not allocate color for display" << endl;
	   _enabled = 0;
	  }
	else
	  {
	   _pixel = pixels[0];
	   _enabled = 1;
	  }

//	Color display area

	view_frame =
		XtVaCreateManagedWidget("ColorViewFrame",
					xmFrameWidgetClass,
					_w,
					XmNtopAttachment,XmATTACH_FORM,
					XmNleftAttachment,XmATTACH_FORM,
					XmNrightAttachment,XmATTACH_FORM,
					XmNmarginWidth,2,
					XmNmarginHeight,2,
					NULL);
	label =
		XtVaCreateManagedWidget("Selected Color",
					xmLabelWidgetClass,
					view_frame,
					XmNchildType,XmFRAME_TITLE_CHILD,
					NULL);
	colorView =
		XtVaCreateManagedWidget("ColorView",
					xmDrawingAreaWidgetClass,
					view_frame,
					XmNbackground,_pixel,
					NULL);

//	Defined colour list

	defined_frame =
		XtVaCreateManagedWidget("DefinedFrame",
					xmFrameWidgetClass,
					_w,
					XmNtopAttachment,XmATTACH_WIDGET,
					XmNtopWidget,view_frame,
					XmNleftAttachment,XmATTACH_FORM,
					XmNbottomAttachment,XmATTACH_FORM,
					XmNmarginWidth,2,
					XmNmarginHeight,2,
					NULL);
	label =
		XtVaCreateManagedWidget("Defined Colors",
					xmLabelWidgetClass,
					defined_frame,
					XmNchildType,XmFRAME_TITLE_CHILD,
					NULL);
	XtSetArg(args[0],XmNlistSizePolicy,XmRESIZE_IF_POSSIBLE);
	definedList =
		XmCreateScrolledList(defined_frame,
				     "DefinedList",
				     args,1);
	XtAddCallback(definedList,
		      XmNbrowseSelectionCallback,
		      &akColor::definedSelectionCB,
		      (XtPointer)this);
	addDefinedColors();
	XtManageChild(definedList);

//	Slider (manual) color controllers

	slider_frame =
		XtVaCreateManagedWidget("SliderFrame",
					xmFrameWidgetClass,
					_w,
					XmNtopAttachment,XmATTACH_WIDGET,
					XmNtopWidget,view_frame,
					XmNrightAttachment,XmATTACH_FORM,
					XmNbottomAttachment,XmATTACH_FORM,
					XmNleftAttachment,XmATTACH_WIDGET,
					XmNleftWidget,defined_frame,
					NULL);
	label =
		XtVaCreateManagedWidget("Color Component Control",
					xmLabelWidgetClass,
					slider_frame,
					XmNchildType,XmFRAME_TITLE_CHILD,
					NULL);
	rowcol =
		XtVaCreateManagedWidget("rowColumn",
					xmRowColumnWidgetClass,
					slider_frame,
					XmNnumColumns,1,
					NULL);

	title_string = XmStringCreateLocalized("Red");
	redSlider =
		XtVaCreateManagedWidget("redSlider",
					xmScaleWidgetClass,
					rowcol,
					XmNminimum,0,
					XmNmaximum,255,
					XmNorientation,XmHORIZONTAL,
					XmNtitleString,title_string,
					NULL);
	XmStringFree(title_string);
	XtAddCallback(redSlider,
		      XmNvalueChangedCallback,
		      redSliderChangedCB,
		      (XtPointer)this);
	XtAddCallback(redSlider,
		      XmNdragCallback,
		      redSliderChangedCB,
		      (XtPointer)this);
	title_string = XmStringCreateLocalized("Green");
	greenSlider =
		XtVaCreateManagedWidget("greenSlider",
					xmScaleWidgetClass,
					rowcol,
					XmNminimum,0,
					XmNmaximum,255,
					XmNorientation,XmHORIZONTAL,
					XmNtitleString,title_string,
					NULL);
	XmStringFree(title_string);
	XtAddCallback(greenSlider,
		      XmNvalueChangedCallback,
		      greenSliderChangedCB,
		      (XtPointer)this);
	XtAddCallback(greenSlider,
		      XmNdragCallback,
		      greenSliderChangedCB,
		      (XtPointer)this);
	title_string = XmStringCreateLocalized("Blue");
	blueSlider =
		XtVaCreateManagedWidget("blueSlider",
					xmScaleWidgetClass,
					rowcol,
					XmNminimum,0,
					XmNmaximum,255,
					XmNorientation,XmHORIZONTAL,
					XmNtitleString,title_string,
					NULL);
	XmStringFree(title_string);
	XtAddCallback(blueSlider,
		      XmNvalueChangedCallback,
		      blueSliderChangedCB,
		      (XtPointer)this);
	XtAddCallback(blueSlider,
		      XmNdragCallback,
		      blueSliderChangedCB,
		      (XtPointer)this);

//	Update values of colour components

	updateRed(theRed);
	updateGreen(theGreen);
	updateBlue(theBlue);

//	Update view

	updateView();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Destructor
//
////////////////////////////////////////////////////////////////////////////////
akColor::~akColor(void)
{
	Pixel	pixels[1];

//	Free the pixel allocated

	if (_enabled == 1)
	  {
	   pixels[0] = _pixel;
	   XFreeColors(XtDisplay(_w),theAkApp->colormap(),
//		DefaultColormap(XtDisplay(_w),DefaultScreen(XtDisplay(_w))),
		pixels,1,0);
	  }
}
////////////////////////////////////////////////////////////////////////////////
//
//	Read in X11 predefined colors
//
////////////////////////////////////////////////////////////////////////////////
void	akColor::addDefinedColors(void)
{
	FILE		*fp;
	// NB This filename is different on different systems !!
	char		*rgbfile="/usr/X11/lib/rgb.txt";
	int		linelen=256;
	char		line[256];
	char		field[100];
	int		theRed,theGreen,theBlue;
	int		ret;
	akDefinedColor	color;
	XmString	list_string;

//	Open file for reading

	fp = fopen(rgbfile,"r");
	if (fp == (FILE *)0)
	  {
	   return;
	  }

//	Extract colors line-by-line

	while (fgets(line,linelen,fp) != NULL)
	  {
	   if (line[strlen(line)-1] == '\n')
	     line[strlen(line)-1] = '\0';

	   // Extract the color details

	   theRed   = 0;
	   theGreen = 0;
	   theBlue  = 0;
	   sprintf(field,"Unknown");
	   ret = sscanf(line,"%d %d %d %s",&theRed,&theGreen,&theBlue,&field);

	   // Add the color to the predefined array

	   color.red   = theRed;
	   color.green = theGreen;
	   color.blue  = theBlue;
	   color.name  = strstr(line,field);
	   defined_colors.push_back(color);

	   // Add to List

	   list_string = XmStringCreateLocalized((char *)color.name.c_str());
	   XmListAddItem(definedList,list_string,0);
	   XmStringFree(list_string);
	  }

//	Close rgb.txt file

	fclose(fp);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Defined color selected callback
//
////////////////////////////////////////////////////////////////////////////////
void	akColor::definedSelectionCB(Widget,
				     XtPointer ClientData,
				     XtPointer CallData)
{
	XmListCallbackStruct *cbs = (XmListCallbackStruct *)CallData;
	akColor *obj	   	  = (akColor *)ClientData;

//	Update slider controls to reflect selected 'predefined' color

	if (cbs->item_position > 0)
	  {
	   obj->updateRed(obj->defined_colors[cbs->item_position-1].red);
	   obj->updateGreen(obj->defined_colors[cbs->item_position-1].green);
	   obj->updateBlue(obj->defined_colors[cbs->item_position-1].blue);
	   obj->updateView();
	  }
}
////////////////////////////////////////////////////////////////////////////////
//
//	Update the red ak component
//
////////////////////////////////////////////////////////////////////////////////
void	akColor::updateRed(int value)
{
	_red = value;
	XtVaSetValues(redSlider,XmNvalue,_red,NULL);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Update the green ak component
//
////////////////////////////////////////////////////////////////////////////////
void	akColor::updateGreen(int value)
{
	_green = value;
	XtVaSetValues(greenSlider,XmNvalue,_green,NULL);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Update the blue ak component
//
////////////////////////////////////////////////////////////////////////////////
void	akColor::updateBlue(int value)
{
	_blue = value;
	XtVaSetValues(blueSlider,XmNvalue,_blue,NULL);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Red component has been updated
//
////////////////////////////////////////////////////////////////////////////////
void	akColor::redSliderChangedCB(Widget,
					   XtPointer ClientData,
					   XtPointer CallData)
{
	XmScaleCallbackStruct *cbs = (XmScaleCallbackStruct *)CallData;
	akColor *obj		   = (akColor *)ClientData;

	obj->_red = cbs->value;
	XmListDeselectAllItems(obj->definedList);

	obj->updateView();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Green component has been updated
//
////////////////////////////////////////////////////////////////////////////////
void	akColor::greenSliderChangedCB(Widget,
					   XtPointer ClientData,
					   XtPointer CallData)
{
	XmScaleCallbackStruct *cbs = (XmScaleCallbackStruct *)CallData;
	akColor *obj		   = (akColor *)ClientData;

	obj->_green = cbs->value;
	XmListDeselectAllItems(obj->definedList);

	obj->updateView();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Blue component has been updated
//
////////////////////////////////////////////////////////////////////////////////
void	akColor::blueSliderChangedCB(Widget,
					   XtPointer ClientData,
					   XtPointer CallData)
{
	XmScaleCallbackStruct *cbs = (XmScaleCallbackStruct *)CallData;
	akColor *obj		   = (akColor *)ClientData;

	obj->_blue = cbs->value;
	XmListDeselectAllItems(obj->definedList);

	obj->updateView();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Update the displayed color
//
////////////////////////////////////////////////////////////////////////////////
void	akColor::updateView(void)
{
	XColor	color;

	if (_enabled == 1)
	  {

	   // Convert from API range of 0-255 to X range 0-65535

	   color.red   = 257*_red;
	   color.green = 257*_green;
	   color.blue  = 257*_blue;
	   color.flags = DoRed | DoGreen | DoBlue;
	   color.pixel = _pixel;

	   XStoreColor(XtDisplay(_w),theAkApp->colormap(),
//		DefaultColormap(XtDisplay(_w),DefaultScreen(XtDisplay(_w))),
		&color);
	  }
}
