////////////////////////////////////////////////////////////////////////////////
//
//	Object Name 		: akList
//	File Name		: akList.h
//
// DESCRIPTION:
// ------------
//	The akList class provides a scrolled Motif list widget.
//
//	Access functions provided allow for addition, removal, and changing
//	of list items, as well as emptying of the list. Additionally the user
//	can specify an action callback (called when the user double-clicks
//	on an item).
//
////////////////////////////////////////////////////////////////////////////////
#ifndef _akList_h
#define _akList_h

#ifdef __cplusplus

#include <Xm/Xm.h>
#include <std/string.h>

#include "akComponent.h"

typedef enum
{
	SINGLE,BROWSE,MULTIPLE,EXTENDED
} akListPolicy;
////////////////////////////////////////////////////////////////////////////////
class akList : public akComponent
{
	public:

		// Constructor

		akList(Widget parent,
			char *name,
			XtCallbackProc browseCallback=0,
			XtPointer browseClientData=0,
			XtCallbackProc actionCallback=0,
			XtPointer actionClientData=0);

		// Access functions

		void	setPolicy(akListPolicy);
		void	insert(string item,int pos=0);
		void	remove(string item);
		void	remove(int pos);
		void	replace(string old_item,string new_item);
		void	replace(int pos,string new_item);
		void	select(string item);
		void	select(int pos);
		string	*selectedItems();
		int	noSelectedItems();
		int	*selectedPos();
		int	noSelectedPos();
		void	empty();
		void	deselectAll();

		// Class name

		virtual const char *const className(void)
			{return ("akList");}

	private:

		Widget		_list;

		static	void	browseCB(Widget,XtPointer,XtPointer);
		static	void	actionCB(Widget,XtPointer,XtPointer);

		XtCallbackProc	_userBrowseCB;
		XtPointer	_userBrowseData;
		XtCallbackProc	_userActionCB;
		XtPointer	_userActionData;
};

#endif
#endif
