#include <Xm/Xm.h>
#include <Xm/ScrolledW.h>
#include <Xm/Text.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <stdarg.h>

#include "akMessageArea.h"
////////////////////////////////////////////////////////////////////////////////
//
//	Constructor function for the akMessageArea object.
//
////////////////////////////////////////////////////////////////////////////////
akMessageArea::akMessageArea(Widget parent,char *name)
	: akComponent(name)
{
	Arg	args[4];

//	Create message widget

	XtSetArg(args[0],XmNeditable,FALSE);
	XtSetArg(args[1],XmNeditMode,XmMULTI_LINE_EDIT);
	XtSetArg(args[2],XmNautoShowCursorPosition,TRUE);
	XtSetArg(args[3],XmNcursorPositionVisible,FALSE);

	_text = XmCreateScrolledText(parent,_name,args,4);
	_w = XtParent(_text);
	XtUnmanageChild(_w);
	XtManageChild(_text);

	installDestroyHandler();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Write Message function.
//
////////////////////////////////////////////////////////////////////////////////
void 	akMessageArea::write(akMessageType type,const char *format, ...)
{
	char		message_text[2024];
	char		*current_string;
	char		*new_string;
	XmTextPosition	end_position;
	va_list		args;

//	If widget is NULL then return immediately

	if (!_text) return;

//	Start parse of input

	va_start(args,format);

//	Extract string to add

	vsprintf(message_text,format,args);

	XmTextDisableRedisplay(_text);

//	Insert a new line unless first message, or a continuation

	current_string = XmTextGetString(_text);
	if (current_string[0] != '\0' && type != AK_CONTINUE)
	   XmTextInsert(_text,XmTextGetLastPosition(_text),"\n");
	XtFree(current_string);

//	Construct string to update message area with

	switch (type)
	  {
	   case AK_ERROR:
	     {
	      new_string = new char[strlen(message_text)+10];
	      sprintf(new_string,"ERROR >> %s",message_text);
	      XBell(XtDisplay(_text),30);
	      break;
	     }
	   case AK_WARNING:
	     {
	      new_string = new char[strlen(message_text)+12];
	      sprintf(new_string,"WARNING >> %s",message_text);
	      break;
	     }
	   default:
	   case AK_INFO:
	     {
	      new_string = new char[strlen(message_text)+1];
	      strcpy(new_string,message_text);
	      break;
	     }
	   case AK_CONTINUE:
	     {
	      new_string = new char[strlen(message_text)+1];
	      strcpy(new_string,message_text);
	      break;
	     }
	  }

	end_position = XmTextGetLastPosition(_text);
	XmTextInsert(_text,end_position,new_string);
	delete new_string;
	if (XtIsRealized(_text))
	  XmTextShowPosition(_text,end_position);

//	Update message area widget

	XmTextEnableRedisplay(_text);
	XFlush(XtDisplay(_text));

	XmUpdateDisplay(_text);

//	Clean up variable args

	va_end(args);
}
