////////////////////////////////////////////////////////////////////////////////
//
//	Class : akPromptDbles
//
//	Author : Andy Jefferson
//
//	Description :
//		The akPromptDbles class provides a data entry prompt
//		for double values. It creates a widget consisting of an optional
//		variable name label, together with the actual data entry field.
//		The user can retrieve the values from the class via
//		the function "value", or use a callback hook to receive
//		updates when changes are made.
//		The user is responsible for deleting the array of doubles returned
//		by 'value' and the user callback.
//
//	Public Methods :
//		(Constructor) requires :-
//			parent		Parent widget of component
//			name		Name used in resources
//			prompt		Prompt label
//			callback	Callback called when return pressed
//			clientData	Data passed to callback
//		value()			Return the doubles from the text field
//		setValue()		Sets the values in the text field
//
//	Limitations :
//
////////////////////////////////////////////////////////////////////////////////
#ifndef _akPromptDbles_h
#define _akPromptDbles_h
#ifdef __cplusplus

#include <std/string.h>
#include <Xm/Xm.h>
#include "akPrompt.h"

typedef void (*akPromptDblesCB) (XtPointer clientData,double *values,int num);

class akPromptDbles : public akPrompt
{
	public:

		// Constructor

		akPromptDbles(Widget parent,
			       char *name,
			       string variable_name,
			       akPromptDblesCB callback=0,
			       XtPointer clientData=0);

		// Class name

		virtual const char *const className(void)
			{return ("akPromptDbles");}

		// Access functions

		virtual double	*value(int *num);
		virtual void	setValue(double *new_values,int num);
		virtual void	setValue(double new_value);

	protected:

		akPromptDblesCB	userCB;
		XtPointer		userClientData;

		virtual void	changeCB(string field_string);

	private:

		double		*parseValues(const char *string,int *num_values);
};

#endif
#endif
