#include <iostream.h>
#include <string.h>
#include <stdio.h>
#include <signal.h>
#include <unistd.h>
#include <stdlib.h>
#include <X11/xpm.h>
#include <Xm/Frame.h>
#include <Xm/Label.h>

#include "akApp.h"
#include "mxSetup.h"
#include "mxMailLogo.h"
#include "mxMailLogo.xpm"
////////////////////////////////////////////////////////////////////////////////
//
//	Constructor
//
////////////////////////////////////////////////////////////////////////////////
mxMailLogo::mxMailLogo(Widget parent,char *name)
	:akComponent(name),
	 _logo(0),
	 _newMailSound(0),
	 _checkMailSound(0),
	 _animateLogoNo(0),
	 _animationId(0)
{

//	Set up logo animation pixmaps
//	Pixmaps 0  - 16 are the van driving to half way
//	Pixmaps 17 - 23 are the van driving off without leaving mail
//	Pixmaps 24 - 35 are the van driving off leaving mail

	_logoPixmaps[0]  = new akPixmap(mxMailLogo_xpm);
	_logoPixmaps[1]  = new akPixmap(mxMailLogo1_xpm);
	_logoPixmaps[2]  = new akPixmap(mxMailLogo2_xpm);
	_logoPixmaps[3]  = new akPixmap(mxMailLogo3_xpm);
	_logoPixmaps[4]  = new akPixmap(mxMailLogo4_xpm);
	_logoPixmaps[5]  = new akPixmap(mxMailLogo5_xpm);
	_logoPixmaps[6]  = new akPixmap(mxMailLogo6_xpm);
	_logoPixmaps[7]  = new akPixmap(mxMailLogo7_xpm);
	_logoPixmaps[8]  = new akPixmap(mxMailLogo8_xpm);
	_logoPixmaps[9]  = new akPixmap(mxMailLogo9_xpm);
	_logoPixmaps[10] = new akPixmap(mxMailLogo10_xpm);
	_logoPixmaps[11] = new akPixmap(mxMailLogo11_xpm);
	_logoPixmaps[12] = new akPixmap(mxMailLogo12_xpm);
	_logoPixmaps[13] = new akPixmap(mxMailLogo13_xpm);
	_logoPixmaps[14] = new akPixmap(mxMailLogo14_xpm);
	_logoPixmaps[15] = new akPixmap(mxMailLogo15_xpm);
	_logoPixmaps[16] = new akPixmap(mxMailLogo16_xpm);
	_logoPixmaps[17] = new akPixmap(mxMailLogo17_xpm);
	_logoPixmaps[18] = new akPixmap(mxMailLogo18_xpm);
	_logoPixmaps[19] = new akPixmap(mxMailLogo19_xpm);
	_logoPixmaps[20] = new akPixmap(mxMailLogo20_xpm);
	_logoPixmaps[21] = new akPixmap(mxMailLogo21_xpm);
	_logoPixmaps[22] = new akPixmap(mxMailLogo22_xpm);
	_logoPixmaps[23] = new akPixmap(mxMailLogo23_xpm);
	_logoPixmaps[24] = new akPixmap(mxMailLogo24_xpm);
	_logoPixmaps[25] = new akPixmap(mxMailLogo25_xpm);
	_logoPixmaps[26] = new akPixmap(mxMailLogo26_xpm);
	_logoPixmaps[27] = new akPixmap(mxMailLogo27_xpm);
	_logoPixmaps[28] = new akPixmap(mxMailLogo28_xpm);
	_logoPixmaps[29] = new akPixmap(mxMailLogo29_xpm);
	_logoPixmaps[30] = new akPixmap(mxMailLogo30_xpm);
	_logoPixmaps[31] = new akPixmap(mxMailLogo31_xpm);
	_logoPixmaps[32] = new akPixmap(mxMailLogo32_xpm);
	_logoPixmaps[33] = new akPixmap(mxMailLogo33_xpm);
	_logoPixmaps[34] = new akPixmap(mxMailLogo34_xpm);
	_logoPixmaps[35] = new akPixmap(mxMailLogo35_xpm);

//	Create the logo

	_w =
		XtVaCreateManagedWidget(name,
					xmFrameWidgetClass,
					parent,
				        0);
	installDestroyHandler();

	_logo =
	  new akLabel(_w,"Label",mxMailLogo_xpm);
	_logo->manage();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Destructor
//
////////////////////////////////////////////////////////////////////////////////
mxMailLogo::~mxMailLogo()
{
	if (_animationId)
	  XtRemoveTimeOut(_animationId);

//	Delete the logo component, and the animation pixmaps

	if (_logo)
	  delete _logo;
	for (int i=0;i<36;i++)
	   {
	    if (_logoPixmaps[i])
	      delete _logoPixmaps[i];
	   }

//	Delete the sounds

	if (_newMailSound)
	  delete _newMailSound;
	if (_checkMailSound)
	  delete _checkMailSound;
}
////////////////////////////////////////////////////////////////////////////////
//
//	Animate
//
////////////////////////////////////////////////////////////////////////////////
void	mxMailLogo::animate(bool newmail)
{
//	Play audio sound if appropriate, and animate the logo

	if (newmail)
	   {
	    if (theMxSetup->newMailSound())
	       {
		if (!_newMailSound)
		   {
		    string	soundfile=theMxSetup->audioDirectory() + "newmailSound";
		    _newMailSound = new akSound(soundfile);
		   }
		_newMailSound->play();
	       }

	    animateMailCB((XtPointer)this,0);
	   }
	else
	   {
	    if (theMxSetup->checkMailSound())
	       {
		if (!_checkMailSound)
		   {
		    string	soundfile=theMxSetup->audioDirectory() + "checkmailSound";
		    _checkMailSound = new akSound(soundfile);
		   }
		_checkMailSound->play();
	       }

	    animateNoMailCB((XtPointer)this,0);
	   }
}
////////////////////////////////////////////////////////////////////////////////
//
//	Animation - New Mail
//
////////////////////////////////////////////////////////////////////////////////
void	mxMailLogo::animateMailCB(XtPointer clientData,XtIntervalId *id)
{
	mxMailLogo	*obj = (mxMailLogo *)clientData;

	obj->_animateLogoNo++;
	if (obj->_animateLogoNo > 35)
	  {
	   obj->_animateLogoNo = 0;
	   obj->_animationId   = 0;
	   obj->_logo->updatePixmap(obj->_logoPixmaps[0]);
	   return;
	  }
	if (obj->_animateLogoNo == 17)
	  obj->_animateLogoNo = 24;
	obj->_logo->updatePixmap(obj->_logoPixmaps[obj->_animateLogoNo]);

	obj->_animationId =
	  XtAppAddTimeOut(theAkApp->appContext(),
			  30,
			  &mxMailLogo::animateMailCB,
			  (XtPointer)obj);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Animation - No New Mail
//
////////////////////////////////////////////////////////////////////////////////
void	mxMailLogo::animateNoMailCB(XtPointer clientData,XtIntervalId *id)
{
	mxMailLogo	*obj = (mxMailLogo *)clientData;

	obj->_animateLogoNo++;
	if (obj->_animateLogoNo > 23)
	  {
	   obj->_animateLogoNo = 0;
	   obj->_animationId   = 0;
	   obj->_logo->updatePixmap(obj->_logoPixmaps[0]);
	   return;
	  }
	obj->_logo->updatePixmap(obj->_logoPixmaps[obj->_animateLogoNo]);

	obj->_animationId =
	  XtAppAddTimeOut(theAkApp->appContext(),
			  30,
			  &mxMailLogo::animateNoMailCB,
			  (XtPointer)obj);
}
