#include "akFileDialogMgr.h"
#include "akApp.h"
#include <Xm/MessageB.h>
#include <Xm/FileSB.h>
#include <cassert>
#include <iostream>

akFileDialogMgr *theAkFileDialogMgr =
	new akFileDialogMgr("FileDialog");
////////////////////////////////////////////////////////////////////////////////
//
//	Constructor
//
////////////////////////////////////////////////////////////////////////////////
akFileDialogMgr::akFileDialogMgr(const char *name)
	:akComponent(name)
{
// 	Empty
}
////////////////////////////////////////////////////////////////////////////////
//
//	Dialog generation function
//
////////////////////////////////////////////////////////////////////////////////
Widget akFileDialogMgr::getDialog(void)
{
	Widget newDialog = NULL;

// 	If the permanent widget exists and is not in use - just return it

	if (_w && !XtIsManaged(_w))
	  return (_w);

// 	Permanent widget unavailable so create a new one (deleted later)

	newDialog = createDialog(theAkApp->baseWidget());

//	Set up callbacks for buttons

	if (newDialog != _w)
	  {

	   XtAddCallback(newDialog,XmNokCallback, 
			 &akFileDialogMgr::actionCallback,
			 (XtPointer)this);
	   XtAddCallback(newDialog,XmNcancelCallback, 
			 &akFileDialogMgr::actionCallback,
			 (XtPointer)this);
	   XtAddCallback(newDialog,XmNhelpCallback, 
			 &akFileDialogMgr::actionCallback,
			 (XtPointer)this);
	  }

	if (!_w)           // If this is the first dialog to be 
	  _w = newDialog;  // created, save it to be used again

	return(newDialog);
}
////////////////////////////////////////////////////////////////////////////////
//
//	User access function
//
////////////////////////////////////////////////////////////////////////////////
Widget akFileDialogMgr::post(const char    *title,
			      const char    *pattern,
			      void          *clientData,
			      akDialogCallback ok,
			      akDialogCallback cancel,
			      akDialogCallback help)
{
	Widget			w;
	akDialogCallbackData	*old_dcd;

// 	Get a dialog widget from the cache

	Widget dialog = getDialog();

// 	Make sure the dialog exists, and that it is an XmFileSelectionBox
// 	or subclass, since the callbacks assume these widget types

	assert (dialog);
	assert (XtIsSubclass(dialog,xmFileSelectionBoxWidgetClass));

// 	Convert the title string to a compound string and 
// 	specify this to be the dialog title

	if (title != (char *)0)
	  {
	   XmString xmstr = XmStringCreateLtoR((char *)title,XmSTRING_DEFAULT_CHARSET);
	   XtVaSetValues(dialog,XmNdialogTitle,xmstr,NULL);
	   XmStringFree(xmstr);
	  }

// 	Convert the pattern string to a compound string and 
// 	specify this to be the file pattern to be used

	if (pattern != (char *)0)
	  {
	   XmString xmstr = XmStringCreateLocalized((char *)pattern);
	   XtVaSetValues(dialog,XmNpattern,xmstr,NULL);
	   XmStringFree(xmstr);
	  }

//	Reset resources likely to have been changed by user

	XtVaSetValues(dialog,
		      XmNdialogStyle,XmDIALOG_FULL_APPLICATION_MODAL,
		      XmNautoUnmanage,TRUE,
		      XmNdefaultPosition,TRUE,
		      XmNresizePolicy,XmRESIZE_ANY,
		      XmNfileTypeMask,XmFILE_REGULAR,
		      NULL);

// 	Delete any existing callbackData (stored in XmNuserData).
// 	Allocate new callbackData and store in XmNuserData.

	XtVaGetValues(dialog,XmNuserData,&old_dcd,NULL);
	if (old_dcd != (akDialogCallbackData *)0)
	  delete old_dcd;
	akDialogCallbackData *dcd =
	  new akDialogCallbackData(clientData,ok,cancel,help);
	XtVaSetValues(dialog,XmNuserData,dcd,NULL);

//	Ensure that all required buttons are present

	w = XmFileSelectionBoxGetChild(dialog,XmDIALOG_OK_BUTTON);
	if (!ok)
	  XtUnmanageChild(w);
	else
	  XtManageChild(w);

	w = XmFileSelectionBoxGetChild(dialog,XmDIALOG_CANCEL_BUTTON);
	if (!cancel)
	  XtUnmanageChild(w);
	else
	  XtManageChild(w);

	w = XmFileSelectionBoxGetChild(dialog,XmDIALOG_HELP_BUTTON);
	if (!help)
	  XtUnmanageChild(w);
	else
	  XtManageChild(w);

// 	Post the dialog

	XtManageChild(dialog);
	return (dialog);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Dialog button press callback
//
////////////////////////////////////////////////////////////////////////////////
void akFileDialogMgr::actionCallback(Widget    w, 
				       XtPointer clientData,
				       XtPointer callData )
{
	XmFileSelectionBoxCallbackStruct *cbs =
		(XmFileSelectionBoxCallbackStruct *) callData;
	akFileDialogMgr	*obj = (akFileDialogMgr *) clientData;
	akDialogCallback	callback;
	akDialogCallbackData	*dcd;

//	Retrieve callback data

	XtVaGetValues(w,XmNuserData,&dcd,NULL);

	switch (cbs->reason)
	  {
	   case XmCR_OK:
	      callback = dcd->ok();
	      break;
	   case XmCR_CANCEL:
	      callback = dcd->cancel();
	      break;
	   case XmCR_HELP:
	      callback = dcd->help();
	      break;
	  };

//	Call callback

	if (callback)
          (*callback)(dcd->clientData(),callData);

//	If dialog is not the permanent one, delete it
//	N.B The only undesirable effect of this is that the user may have
//	    (re-)set autoUnmanage to FALSE and want to leave it on the screen
//	    for another dialog message etc - but this removes it !
//	    Should cater for 95% of all cases as it is though.

	if (obj->baseWidget() != w)
	  {

//	   Delete the callback data

	   delete dcd;

//	   Delete the widget

           XtDestroyWidget(w);
	  }
}
////////////////////////////////////////////////////////////////////////////////
//
//	New dialog creation function
//
////////////////////////////////////////////////////////////////////////////////
Widget	akFileDialogMgr::createDialog(Widget parent)
{
	Arg	args[2];
	Widget	dialog;

	XtSetArg(args[0],XmNautoUnmanage,TRUE);
	XtSetArg(args[1],XmNdialogStyle,XmDIALOG_FULL_APPLICATION_MODAL);
	dialog = XmCreateFileSelectionDialog(parent,_name,args,2);

	return dialog;
}
