////////////////////////////////////////////////////////////////////////////////
//
//	Class : akComboBox
//
//	Author : Andy Jefferson
//
//	Description :
//		The akComboBox class provides a combo-box convenience
//		object. It provides a Motif ComboBox containing the users
//		options, and provides a callback hook to allow dynamic
//		notification of selections.
//
//		Whenever an option is selected, the "callback" is invoked - 
//		allowing dynamic response to a users input. The "callback" is
//		passed the "clientData" as well as an XmRowColumnCallbackStruct
//		as callData. The XmRowColumnCallbackStruct provides the widget
//		which was selected - and whose 'name' is the same as the
//		selected option (extract using "XtName(cbs->widget)").
//
//		Alternatively to retrieve the selected option at any time,
//		use the access function "selectedOption".
//
//	Public Methods :
//		(constructor) requires :-
//			parent		Parent widget for the component
//			name		Name used in resource specification
//			prompt		Optional prompt label
//			callback	Callback called when option changed
//			clientData	Client-Data passed to callback
//		size()			Function to return no of options
//		setOptions()		Function to set the options
//		select()		Function to select and option in menu
//		selectedOption()	Retrieval of selected option
//
//	Limitations :
//		Doesn't allow direct control over the placement of the label
//		and field - so cannot line up the fields of several objects.
//
////////////////////////////////////////////////////////////////////////////////
#ifndef _akComboBox_h
#define _akComboBox_h
#ifdef __cplusplus

#include <string>
#include <Xm/Xm.h>
#include "akComponent.h"

typedef	void	(*akComboBoxCB) (XtPointer,string);
////////////////////////////////////////////////////////////////////////////////
class akComboBox : public akComponent
{
	public:

		// Constructor/destructor

		akComboBox(Widget parent,
			    char *name,
			    string prompt,
			    akComboBoxCB callback=0,
			    XtPointer clientData=0);

		// Access functions

		int	noOfOptions();
		string	selectedOption();
		string	value();

		// Update functions

		void	addOption(string option);
		void	setOptions(string *opts,int nopts);
		void	select(string option);

		// Class name

		virtual const char *const className(void)
			{return ("akComboBox");}

	private:

		Widget		_combo;
		akComboBoxCB	_userCB;
		XtPointer	_userData;

		static	void	selectionCB(Widget,XtPointer,XtPointer);
};

inline
int	akComboBox::noOfOptions()
{
	int	no_items;
	XtVaGetValues(_w,XmNitemCount,&no_items,0);
	return no_items;
}

#endif
#endif
