#include <iostream>
#include <string>
#include <cstdio>
#include <signal.h>
#include <unistd.h>
#include <cstdlib>
#include <sys/stat.h>
#include <X11/xpm.h>
#include <Xm/Container.h>
#include <Xm/RowColumn.h>
#include <Xm/CascadeB.h>
#include <Xm/Form.h>
#include <Xm/Frame.h>
#include <Xm/Label.h>
#include <Xm/ScrolledW.h>
#include <Xm/Separator.h>

#include "akApp.h"
#include "mxMail.h"
#include "mxSetup.h"
#include "mxSetupModify.h"
#include "mxMailCompose.h"
#include "mxMailIcon.xpm"
#include "mxButtons.xpm"
#include "ajSoft.xpm"

mxMailSpamBook		*mxMail::_spambook = 0;
mxMailAddressBook	*mxMail::_addressbook = 0;
mxMailAddressView	*mxMail::_addressview = 0;
////////////////////////////////////////////////////////////////////////////////
//
//	Constructor
//
////////////////////////////////////////////////////////////////////////////////
mxMail::mxMail(char *name,
	       XtCallbackProc callback,
	       XtPointer clientData)
	:akWindow(name),
	 _userCB(callback),
	 _userData(clientData),
	 _mailboxContainer((Widget)0),
	 _logo((mxMailLogo *)0),
	 _helpDocument((akDocView *)0),
	 _date((akClock *)0),
	 _time((akClock *)0),
	 _openOption((akButton *)0),
	 _closeOption((akButton *)0),
	 _deleteOption((akButton *)0),
	 _composeOption((akButton *)0),
	 _addressbookOption((akButton *)0),
	 _setupOption((akButton *)0),
	 _quitOption((akButton *)0),
	 _helpOption((akButton *)0),
	 _copyrightOption((akButton *)0),
	 _addressbookButton((akButton *)0),
	 _composeButton((akButton *)0),
	 _quitButton((akButton *)0),
	 _setupButton((akButton *)0),
	 _helpButton((akButton *)0),
	 _messageDialog((akMessageDialog *)0),
	 _mailboxSelector((mxMailBoxSelector *)0),
	 _copyright((akCopyright *)0),
	 _deleteConfirmDialog((akMessageDialog *)0)
{
//	If mail-folder doesn't exist, create it

	struct stat	stbuf;
	if (stat((char *)theMxSetup->mailFolderDirectory().c_str(),&stbuf) == -1)
	   {
	    if (mkdir((char *)theMxSetup->mailFolderDirectory().c_str(),0755) == -1)
	       {
		cout << "ERROR : Couldn't create mail folder " <<
			theMxSetup->mailFolderDirectory() << endl;
	       }
	    else
	       {
		cout << "INFO : Mail folder " <<
			theMxSetup->mailFolderDirectory() << " created" << endl;
	       }
           }

//	Clear out the Deleted-Mail folder if exists

	string	deletion_folder;
	deletion_folder = theMxSetup->mailFolderDirectory() + "Deleted-Mail";
	unlink(deletion_folder.c_str());

//	Create the addressbook if not already created

	if (!_addressbook)
	  _addressbook = new mxMailAddressBook(theMxSetup->mailAddressbookName());

//	Create spam book if not already created

	if (!_spambook)
	  _spambook = new mxMailSpamBook(theMxSetup->mailSpambookName());

//	If callback provided, then create the panel (otherwise created as global)
	if (_userCB)
	  initialize();

//	Cope with termination signals

	signal(SIGTERM,&mxMail::TerminateCB);
	signal(SIGQUIT,&mxMail::TerminateCB);
	signal(SIGINT,&mxMail::TerminateCB);

//	Catch 'exit' - called at end of application

	atexit(&mxMail::ExitCB);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Destructor
//
////////////////////////////////////////////////////////////////////////////////
mxMail::~mxMail()
{
	if (_logo)
	  delete _logo;
	if (_helpDocument)
	  delete _helpDocument;
	if (_composeOption)
	  delete _composeOption;
	if (_openOption)
	  delete _openOption;
	if (_closeOption)
	  delete _closeOption;
	if (_deleteOption)
	  delete _deleteOption;
	if (_setupOption)
	  delete _setupOption;
	if (_helpOption)
	  delete _helpOption;
	if (_copyrightOption)
	  delete _copyrightOption;
	if (_quitOption)
	  delete _quitOption;
	if (_addressbookOption)
	  delete _addressbookOption;
	if (_composeButton)
	  delete _composeButton;
	if (_addressbookButton)
	  delete _addressbookButton;
	if (_quitButton)
	  delete _quitButton;
	if (_setupButton)
	  delete _setupButton;
	if (_helpButton)
	  delete _helpButton;
	if (_messageDialog)
	  delete _messageDialog;
	if (_mailboxSelector)
	  delete _mailboxSelector;
	if (_copyright)
	  delete _copyright;
	if (_deleteConfirmDialog)
	  delete _deleteConfirmDialog;
}
////////////////////////////////////////////////////////////////////////////////
//
//	createWorkArea
//
////////////////////////////////////////////////////////////////////////////////
Widget	mxMail::createWorkArea(Widget parent)
{
	Widget	form;
	Widget	menuBar;
	Widget	toolBar;
	Widget	infoBar;
	Widget	mailbox_frame;
	Widget	date_frame;
	Widget	time_frame;
	Widget	scroll;
	string	title;

//	Set the icon and title

	setIcon("mxMail",mxMail_NoMail_xpm);
	title  = "mxMail Version ";
	title += theAkApp->applicationVersion();
	setTitle(title);

//	Add a form to attach contents to

	form = XtVaCreateManagedWidget("Form",xmFormWidgetClass,parent,0);

//	Add application logo

	_logo = new mxMailLogo(form,"mxMailLogo");
	_logo->manage();
	XtVaSetValues(_logo->baseWidget(),
		XmNtopAttachment,XmATTACH_FORM,
		XmNtopOffset,3,
		XmNrightAttachment,XmATTACH_FORM,
		XmNrightOffset,3,
		0);

//	Add menu bar

	menuBar = createMenuBar(form);
	XtVaSetValues(menuBar,
		      XmNtopAttachment,XmATTACH_FORM,
		      XmNleftAttachment,XmATTACH_FORM,
		      XmNrightAttachment,XmATTACH_WIDGET,
		      XmNrightWidget,_logo->baseWidget(),
		      0);

//	Add tool bar

	toolBar = createToolBar(form);
	XtVaSetValues(toolBar,
		      XmNtopAttachment,XmATTACH_WIDGET,
		      XmNtopWidget,menuBar,
		      XmNleftAttachment,XmATTACH_FORM,
		      XmNrightAttachment,XmATTACH_WIDGET,
		      XmNrightWidget,_logo->baseWidget(),
		      0);

//	Add the info bar

	infoBar =
		 XtVaCreateManagedWidget("InfoBar",
					xmFormWidgetClass,
					form,
					XmNleftAttachment,XmATTACH_FORM,
					XmNrightAttachment,XmATTACH_FORM,
					XmNbottomAttachment,XmATTACH_FORM,
					0);
	date_frame =
		XtVaCreateManagedWidget("Frame",
					xmFrameWidgetClass,
					infoBar,
				        XmNleftAttachment,XmATTACH_FORM,
				        XmNleftOffset,3,
				        XmNtopAttachment,XmATTACH_FORM,
				        XmNtopOffset,3,
				        XmNbottomAttachment,XmATTACH_FORM,
				        XmNbottomOffset,3,
				        0);
	_date = new akClock(date_frame,"Date",DATE);
	_date->manage();
	time_frame =
		XtVaCreateManagedWidget("Frame",
					xmFrameWidgetClass,
					infoBar,
				        XmNrightAttachment,XmATTACH_FORM,
				        XmNrightOffset,3,
				        XmNtopAttachment,XmATTACH_FORM,
				        XmNtopOffset,3,
				        XmNbottomAttachment,XmATTACH_FORM,
				        XmNbottomOffset,3,
				        0);
	_time = new akClock(time_frame,"Time",TIME);
	_time->manage();

//	Add mailbox container and set up selection callback

	mailbox_frame =
		XtVaCreateManagedWidget("Frame",
					xmFrameWidgetClass,
					form,
					XmNtopAttachment,XmATTACH_WIDGET,
					XmNtopWidget,toolBar,
					XmNleftAttachment,XmATTACH_FORM,
					XmNleftOffset,3,
					XmNrightAttachment,XmATTACH_FORM,
					XmNrightOffset,3,
					XmNbottomAttachment,XmATTACH_WIDGET,
					XmNbottomWidget,infoBar,
					0);
//	XtVaCreateManagedWidget("Mail Boxes",
//				xmLabelWidgetClass,
//				mailbox_frame,
//				XmNchildType,XmFRAME_TITLE_CHILD,
//				0);
	scroll =
		XtVaCreateManagedWidget("Scroll",
					xmScrolledWindowWidgetClass,
					mailbox_frame,
					XmNtopAttachment,XmATTACH_FORM,
					XmNbottomAttachment,XmATTACH_FORM,
					XmNleftAttachment,XmATTACH_FORM,
					XmNrightAttachment,XmATTACH_FORM,
					XmNscrollingPolicy,XmAUTOMATIC,
					XmNscrollBarDisplayPolicy,XmAS_NEEDED,
					0);
	XmString	details[4];
	details[0] = XmStringCreateLocalized(" ");
	details[1] = XmStringCreateLocalized("Mailbox");
	details[2] = XmStringCreateLocalized("Msgs");
	details[3] = XmStringCreateLocalized("Unread");
	_mailboxContainer =
		XtVaCreateManagedWidget("MailboxContainer",
					xmContainerWidgetClass,
					scroll,
					XmNlayoutType,XmDETAIL,
					XmNentryViewType,XmSMALL_ICON,
					XmNoutlineIndentation,0,
					XmNoutlineLineStyle,XmNO_LINE,
					XmNdetailColumnHeading,details,
					XmNdetailColumnHeadingCount,4,
					0);
	for (int i=0;i<4;i++)
	  XmStringFree(details[i]);
	XtAddCallback(_mailboxContainer,
		      XmNselectionCallback,
		      &mxMail::mailboxSelectedCB,
		      (XtPointer)this);
	XtAddCallback(_mailboxContainer,
		      XmNdefaultActionCallback,
		      &mxMail::displayMailboxCB,
		      (XtPointer)this);

//	Initialise mailboxes etc

	update();

	return form;
}
////////////////////////////////////////////////////////////////////////////////
//
//	createMenuBar
//
////////////////////////////////////////////////////////////////////////////////
Widget	mxMail::createMenuBar(Widget parent)
{
	Widget	menu;
	Widget	pulldown;
	Widget	cascade;

	menu = XmCreateMenuBar(parent,"MenuBar",NULL,0);

//	Create File menu

	pulldown = XmCreatePulldownMenu(menu,"FileMenuOption",NULL,0);
	_openOption =
	  new akButton(pulldown,"OpenFolderOption",(char *)0,
		       &mxMail::openCB,(XtPointer)this);
	_openOption->manage();
	_closeOption =
	  new akButton(pulldown,"CloseFolderOption",(char *)0,
		       &mxMail::closeCB,(XtPointer)this);
	_closeOption->manage();
	_deleteOption =
	  new akButton(pulldown,"DeleteFolderOption",(char *)0,
		       &mxMail::deleteCB,(XtPointer)this);
	_deleteOption->manage();
	XtVaCreateManagedWidget("Sep",xmSeparatorWidgetClass,pulldown,0);
	_quitOption =
	  new akButton(pulldown,"QuitOption",(char *)0,
		       &mxMail::quitCB,(XtPointer)this);
	_quitOption->manage();
	cascade =
		XtVaCreateManagedWidget("FileMenuOption",
					xmCascadeButtonWidgetClass,
					menu,
					XmNsubMenuId,pulldown,
					0);

//	Create Message menu

	pulldown = XmCreatePulldownMenu(menu,"MessageMenuOption",NULL,0);
	_composeOption =
	  new akButton(pulldown,"ComposeMessageOption",(char *)0,
		       &mxMail::composeCB,(XtPointer)this);
	_composeOption->manage();
	_addressbookOption =
	  new akButton(pulldown,"ViewAddressbookOption",(char *)0,
		       &mxMail::addressbookCB,(XtPointer)this);
	_addressbookOption->manage();
	cascade =
		XtVaCreateManagedWidget("MessageMenuOption",
					xmCascadeButtonWidgetClass,
					menu,
					XmNsubMenuId,pulldown,
					0);

//	Create Help menu

	pulldown = XmCreatePulldownMenu(menu,"HelpMenuOption",NULL,0);
	_setupOption =
	  new akButton(pulldown,"SetupOption",(char *)0,
		       &mxMail::setupCB,(XtPointer)this);
	_setupOption->manage();
	_helpOption =
	  new akButton(pulldown,"HelpOption",(char *)0,
		       &mxMail::helpCB,(XtPointer)this);
	_helpOption->manage();
	_copyrightOption =
	  new akButton(pulldown,"CopyrightOption",(char *)0,
		       &mxMail::copyrightCB,(XtPointer)this);
	_copyrightOption->manage();
	cascade =
		XtVaCreateManagedWidget("HelpMenuOption",
					xmCascadeButtonWidgetClass,
					menu,
					XmNsubMenuId,pulldown,
					0);

	XtVaSetValues(menu,XmNmenuHelpWidget,cascade,0);
	XtManageChild(menu);

	return menu;
}
////////////////////////////////////////////////////////////////////////////////
//
//	createToolBar
//
////////////////////////////////////////////////////////////////////////////////
Widget	mxMail::createToolBar(Widget parent)
{
	Widget	rowcol;

	rowcol =
		XtVaCreateManagedWidget("ToolBar",
					xmRowColumnWidgetClass,
					parent,
					XmNorientation,XmHORIZONTAL,
					XmNadjustLast,FALSE,
					0);

	_quitButton =
	  new akButton(rowcol,"Quit",mxClose_xpm,
		       &mxMail::quitCB,(XtPointer)this);
	_quitButton->installHelp("Quit mxMail");
	_quitButton->manage();

	_composeButton =
	  new akButton(rowcol,"Compose",mxCompose_xpm,
		       &mxMail::composeCB,(XtPointer)this);
	_composeButton->installHelp("Compose a new message");
	_composeButton->manage();

	_addressbookButton =
	  new akButton(rowcol,"Addressbook",mxAddressbook_xpm,
		       &mxMail::addressbookCB,(XtPointer)this);
	_addressbookButton->installHelp("View the addressbook");
	_addressbookButton->manage();

	_setupButton =
	  new akButton(rowcol,"Setup",mxSetup_xpm,
		       &mxMail::setupCB,(XtPointer)this);
	_setupButton->installHelp("Inspect/Modify the\nsetup parameters");
	_setupButton->manage();

	_helpButton =
	  new akButton(rowcol,"Help",mxHelp_xpm,
		       &mxMail::helpCB,(XtPointer)this);
	_helpButton->installHelp("View the help");
	_helpButton->manage();

	return rowcol;
}
////////////////////////////////////////////////////////////////////////////////
//
//	update
//
////////////////////////////////////////////////////////////////////////////////
void	mxMail::update()
{
//	Add the INBOX

	addMailbox(theMxSetup->mailInboxName(),INBOX);

//	Add the OUTBOX

	addMailbox(theMxSetup->mailOutboxName(),OUTBOX);

//	Add the startup folders

	for (int i=0;i<theMxSetup->mailNoStartupFolders();i++)
	  {
	   string	folder;

	   folder = theMxSetup->mailFolderDirectory() +
		    theMxSetup->mailStartupFolder(i);
	   addMailbox(folder,FOLDER);
	  }
}
////////////////////////////////////////////////////////////////////////////////
//
//	Open folder callback
//
////////////////////////////////////////////////////////////////////////////////
void	mxMail::openCB(Widget,XtPointer clientData,XtPointer)
{
	mxMail	*obj = (mxMail *)clientData;

	obj->busy();
	if (!obj->_mailboxSelector)
	  obj->_mailboxSelector = new mxMailBoxSelector(obj->_w,
							"MailBoxSelector",
							true,
							&mxMail::openFolderOK,
							(XtPointer)obj);
	obj->_mailboxSelector->manage();
	obj->ready();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Open folder OK callback
//
////////////////////////////////////////////////////////////////////////////////
void	mxMail::openFolderOK(XtPointer clientData,string selection)
{
	mxMail	*obj = (mxMail *)clientData;
	bool	boxOpen=false;

	if (!selection.empty())
	  {
	   obj->busy();
	   for (int i=0;i<obj->_boxes.size();i++)
	     if (obj->_boxes[i]->filename() == selection)
	       boxOpen = true;
	   if (!boxOpen)
	     obj->addMailbox(selection,FOLDER);
	   obj->ready();
	  }
}
////////////////////////////////////////////////////////////////////////////////
//
//	Close folder callback
//
////////////////////////////////////////////////////////////////////////////////
void	mxMail::closeCB(Widget w,XtPointer clientData,XtPointer)
{
	mxMail	*obj = (mxMail *)clientData;
	Widget	*selections;
	int	nselections;
	int	no_closed=0;

	obj->busy();
	XtVaGetValues(obj->_mailboxContainer,
		      XmNselectedObjects,&selections,
		      XmNselectedObjectCount,&nselections,
		      0);
	// No folder selected
	if (nselections == 0)
	   {
	    XBell(XtDisplay(w),50);
	    return;
	   }

	for (int i=0;i<obj->_boxes.size();i++)
	   {
	    for (int j=0;j<nselections;j++)
	       {
		if (selections[j] == obj->_boxes[i]->baseWidget())
		   {
		    if (obj->_boxes[i]->type() == FOLDER)
		       {
			obj->deleteMailbox(i);
			no_closed++;
		       }
		   }
	       }
	   }

	// Inbox or Outbox selected (not closable)
	if (no_closed == 0)
	  XBell(XtDisplay(w),50);
	// Folder closed, so redraw the XmContainer contents
	else
	  XClearArea(XtDisplay(obj->_mailboxContainer),
		     XtWindow(obj->_mailboxContainer),0,0,0,0,TRUE);
	obj->ready();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Delete folder callback
//
////////////////////////////////////////////////////////////////////////////////
void	mxMail::deleteCB(Widget w,XtPointer clientData,XtPointer)
{
	mxMail	*obj = (mxMail *)clientData;
	Widget	*selections;
	int	nselections;

	XtVaGetValues(obj->_mailboxContainer,
		      XmNselectedObjects,&selections,
		      XmNselectedObjectCount,&nselections,
		      0);
	// No folder selected
	if (nselections == 0)
	   {
	    XBell(XtDisplay(w),50);
	    return;
	   }

	// Folder(s) selected - give confirm dialog
	if (!obj->_deleteConfirmDialog)
	  obj->_deleteConfirmDialog =
		new akMessageDialog(obj->_w,"MessageDialog",
			QUESTION,true,
			"Confirm delete all selected folders AND contents",
			(XtPointer)obj,
			&mxMail::deleteOK,
			&mxMail::deleteCancel);
	obj->_deleteConfirmDialog->setTitle("Confirm Cancel");
	obj->_deleteConfirmDialog->manage();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Delete OK callback
//
////////////////////////////////////////////////////////////////////////////////
void	mxMail::deleteOK(XtPointer clientData,XtPointer)
{
	mxMail	*obj = (mxMail *)clientData;
	Widget	*selections;
	int	nselections;
	int	no_deleted=0;

	XtVaGetValues(obj->_mailboxContainer,
		      XmNselectedObjects,&selections,
		      XmNselectedObjectCount,&nselections,
		      0);
	// No folder selected
	if (nselections == 0)
	   {
	    XBell(XtDisplay(obj->_mailboxContainer),50);
	    return;
	   }

	obj->busy();

	// Folders selected - close and delete them
	for (int i=0;i<obj->_boxes.size();i++)
	   {
	    for (int j=0;j<nselections;j++)
	       {
		if (selections[j] == obj->_boxes[i]->baseWidget())
		   {
		    if (obj->_boxes[i]->type() == FOLDER)
		       {
			string	folder_filename = obj->_boxes[i]->filename();
			obj->deleteMailbox(i);
			unlink((char *)folder_filename.c_str());
			no_deleted++;
		       }
		   }
	       }
	   }

	// Inbox or Outbox selected (not deletable)
	if (no_deleted == 0)
	  XBell(XtDisplay(obj->_mailboxContainer),50);
	// Folder deleted, so redraw the XmContainer contents
	else
	  XClearArea(XtDisplay(obj->_mailboxContainer),
		     XtWindow(obj->_mailboxContainer),0,0,0,0,TRUE);
	obj->ready();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Delete Cancel callback
//
////////////////////////////////////////////////////////////////////////////////
void	mxMail::deleteCancel(XtPointer clientData,XtPointer)
{
//	Empty
}
////////////////////////////////////////////////////////////////////////////////
//
//	Compose callback
//
////////////////////////////////////////////////////////////////////////////////
void	mxMail::composeCB(Widget,XtPointer clientData,XtPointer)
{
	mxMail	*obj = (mxMail *)clientData;
	mxMailCompose	*compose;

	obj->busy();
	compose = new mxMailCompose("mxMailCompose",
				    _addressbook,
				    MX_MAIL_COMPOSE_BASIC,0,0,
				    &mxMail::composeClosedCB,
				    (XtPointer)obj);
	compose->manage();
	obj->ready();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Compose closed callback
//
////////////////////////////////////////////////////////////////////////////////
void	mxMail::composeClosedCB(Widget,XtPointer clientData,XtPointer callData)
{
	mxMail		*obj = (mxMail *)clientData;
	mxMailCompose	*compose = (mxMailCompose *)callData;

	if (compose)
	  delete compose;
}
////////////////////////////////////////////////////////////////////////////////
//
//	Addressbook callback
//
////////////////////////////////////////////////////////////////////////////////
void	mxMail::addressbookCB(Widget,XtPointer clientData,XtPointer)
{
	mxMail	*obj = (mxMail *)clientData;

	obj->busy();
	if (!_addressview)
	  _addressview = new mxMailAddressView(theAkApp->baseWidget(),
					       "AddressBook",_addressbook,
					       &mxMail::addressbookClosedCB,
					       (XtPointer)obj);
	_addressview->manage();
	obj->ready();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Addressbook closed callback
//
////////////////////////////////////////////////////////////////////////////////
void	mxMail::addressbookClosedCB(Widget,XtPointer clientData,XtPointer callData)
{
	mxMail	*obj = (mxMail *)clientData;
}
////////////////////////////////////////////////////////////////////////////////
//
//	Setup callback
//
////////////////////////////////////////////////////////////////////////////////
void	mxMail::setupCB(Widget,XtPointer clientData,XtPointer)
{
	mxMail	*obj = (mxMail *)clientData;

	obj->busy();
	if (!theMxSetupModify)
	  {
	   theMxSetupModify = new mxSetupModify(obj->_w,"SetupModify",
						&mxMail::setupChangedCB,
						(XtPointer)obj);
	   theMxSetupModify->update();
	   theMxSetupModify->manage();
	   theMxSetupModify->setSection(MXSETUP_MAIL);
	  }
	else
	  {
	   theMxSetupModify->update();
	   theMxSetupModify->manage();
	  }
	obj->ready();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Setup changed callback
//
////////////////////////////////////////////////////////////////////////////////
void	mxMail::setupChangedCB(Widget,XtPointer clientData,XtPointer)
{
	mxMail	*obj = (mxMail *)clientData;

	obj->busy();

//	Check if INBOX/OUTBOX changed - update if so

	for (int i=0;i<obj->_boxes.size();i++)
	  {
	   if (obj->_boxes[i]->type() == INBOX)
	     {
	      if (!(obj->_boxes[i]->filename() == theMxSetup->mailInboxName()))
		{
		 obj->deleteMailbox(i);
		 obj->addMailbox(theMxSetup->mailInboxName(),INBOX);
		}
	     }
	   if (obj->_boxes[i]->type() == OUTBOX)
	     {
	      if (!(obj->_boxes[i]->filename() == theMxSetup->mailOutboxName()))
		{
		 obj->deleteMailbox(i);
		 obj->addMailbox(theMxSetup->mailOutboxName(),OUTBOX);
		}
	     }
	  }

//	Check if Addressbook changed - update if so

	if (_addressbook)
	  {
	   if (!(_addressbook->filename() == theMxSetup->mailAddressbookName()))
	     {
	      delete _addressbook;
	      _addressbook = new mxMailAddressBook(theMxSetup->mailAddressbookName());
	      if (_addressview)
	        _addressview->setBook(_addressbook);
	     }
	  }
	obj->ready();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Quit callback
//
////////////////////////////////////////////////////////////////////////////////
void	mxMail::quitCB(Widget,XtPointer clientData,XtPointer)
{
	mxMail	*obj = (mxMail *)clientData;

	if (!obj->_messageDialog)
	  obj->_messageDialog = new akMessageDialog(obj->_w,"MessageDialog",
						    QUESTION,true,
						    "Confirm Quit mxMail",
						    (XtPointer)obj,
						    &mxMail::quitOK,
						    &mxMail::quitCancel);
	obj->_messageDialog->setTitle("Confirm Quit");
	obj->_messageDialog->manage();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Quit OK callback
//
////////////////////////////////////////////////////////////////////////////////
void	mxMail::quitOK(XtPointer clientData,XtPointer)
{
	mxMail	*obj = (mxMail *)clientData;

//	Quit the object

	if (obj->_userCB)
	  obj->_userCB(obj->_w,obj->_userData,obj);
	else
	  exit(1);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Quit Cancel callback
//
////////////////////////////////////////////////////////////////////////////////
void	mxMail::quitCancel(XtPointer clientData,XtPointer)
{
//	Empty
}
////////////////////////////////////////////////////////////////////////////////
//
//	Help callback
//
////////////////////////////////////////////////////////////////////////////////
void	mxMail::helpCB(Widget,XtPointer clientData,XtPointer)
{
	mxMail	*obj = (mxMail *)clientData;
	string	helpfile=theMxSetup->helpDirectory() + "mxMail.html";

	obj->busy();
	XmUpdateDisplay(obj->_w);
	if (!obj->_helpDocument)
	  obj->_helpDocument = new akDocView("HelpDocument",helpfile);
	obj->_helpDocument->manage();
	obj->ready();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Copyright callback
//
////////////////////////////////////////////////////////////////////////////////
void	mxMail::copyrightCB(Widget,XtPointer clientData,XtPointer)
{
	mxMail	*obj = (mxMail *)clientData;

	if (!obj->_copyright)
	  obj->_copyright = new akCopyright(theAkApp->baseWidget(),
					    "CopyrightPanel",
					    "AJ Soft Limited","1997-1999",
					    ajSoft_xpm);
	obj->_copyright->manage();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Inbox Updated callback
//
////////////////////////////////////////////////////////////////////////////////
void	mxMail::inboxUpdatedCB(XtPointer clientData,XtPointer callData,bool new_mail)
{
	mxMail			*obj = (mxMail *)clientData;
	mxMailBoxControl	*box = (mxMailBoxControl *)callData;
	int			no_of_messages;
	int			no_of_messages_read;

//	Update icon and animation

	no_of_messages = box->noOfMsgs();
	no_of_messages_read = box->noOfMsgsRead();

//	Set icon accordingly

	if (new_mail || no_of_messages > no_of_messages_read)
	  obj->setIcon("mxMail",mxMail_NewMail_xpm);
	else if (no_of_messages > 0)
	  obj->setIcon("mxMail",mxMail_Mail_xpm);
	else
	  obj->setIcon("mxMail",mxMail_NoMail_xpm);

//	Update animation sequence accordingly (if appropriate)

	if (!obj->iconified() || new_mail)
	  obj->_logo->animate(new_mail);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Mailbox selected callback - update the no of messages etc
//
////////////////////////////////////////////////////////////////////////////////
void	mxMail::mailboxSelectedCB(Widget,XtPointer clientData,XtPointer callData)
{
	mxMail	*obj = (mxMail *)clientData;
	XmContainerSelectCallbackStruct *cbs =
		(XmContainerSelectCallbackStruct *)callData;

	if (cbs->selected_item_count > 0 && cbs->event)
	   {
	    if (cbs->event->type == ButtonRelease)
	       {
		Widget	selection = cbs->selected_items[0];

		// Find which box was selected, and select it

//		for (int i=0;i<obj->_boxes.size();i++)
//		   {
//		    if (obj->_boxes[i]->baseWidget() == selection)
//		       {
//			obj->_boxes[i]->update();
//		       }
//		   }
	       }
	   }
}
////////////////////////////////////////////////////////////////////////////////
//
//	Display Mailbox callback - update the no of messages and display it
//
////////////////////////////////////////////////////////////////////////////////
void	mxMail::displayMailboxCB(Widget,XtPointer clientData,XtPointer callData)
{
	mxMail	*obj = (mxMail *)clientData;
	XmContainerSelectCallbackStruct *cbs =
		(XmContainerSelectCallbackStruct *)callData;

	if (cbs->selected_item_count > 0)
	   {
	    Widget	selection = cbs->selected_items[0];

	    // Find which box was selected, and select it

	    for (int i=0;i<obj->_boxes.size();i++)
	       {
		if (obj->_boxes[i]->baseWidget() == selection)
		   {
		    obj->_boxes[i]->select();
		   }
	       }
	   }
}
////////////////////////////////////////////////////////////////////////////////
//
//	Add a mailbox to the display
//
////////////////////////////////////////////////////////////////////////////////
void	mxMail::addMailbox(string filename,mxMailBoxType type)
{
	mxMailBoxControl	*box;

	if (!_addressview)
	  _addressview = new mxMailAddressView(theAkApp->baseWidget(),
					       "AddressBook",_addressbook,
					       &mxMail::addressbookClosedCB,
					       (XtPointer)this);
	if (type == INBOX)
	  box = new mxMailBoxControl(_mailboxContainer,"Mailbox",filename,
				     type,_addressbook,_spambook,
				     &mxMail::inboxUpdatedCB,(XtPointer)this);
	else
	  box = new mxMailBoxControl(_mailboxContainer,"Mailbox",filename,
				     type,_addressbook,_spambook);
	box->manage();

	_boxes.push_back(box);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Remove a mailbox from the display
//
////////////////////////////////////////////////////////////////////////////////
void	mxMail::deleteMailbox(int boxNo)
{
	mxMailBoxControl	*box;

	if (boxNo < 0 || boxNo >= _boxes.size())
	  return;

	box = _boxes[boxNo];
	_boxes.erase(_boxes.begin()+boxNo);
	delete box;
}
////////////////////////////////////////////////////////////////////////////////
//
//	Method called when signal received
//
////////////////////////////////////////////////////////////////////////////////
void	mxMail::TerminateCB(int pid)
{
//	Call exit - this calls the method below

	exit(1);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Method called when exit() is called - clean up
//
////////////////////////////////////////////////////////////////////////////////
void	mxMail::ExitCB()
{
	string	deletion_folder;

//	Clear out the Deleted-Mail folder

	deletion_folder = theMxSetup->mailFolderDirectory() + "Deleted-Mail";
	unlink(deletion_folder.c_str());
}
