#include <string>
#include <iostream>
#include <cstdio>
#include <Xm/Notebook.h>
#include <Xm/ScrolledW.h>
#include <Xm/Protocols.h>
#include <Xm/RowColumn.h>
#include <Xm/FileSB.h>
#include <Xm/MessageB.h>
#include <Xm/PanedW.h>
#include <Xm/Text.h>
#include <Xm/Form.h>
#include <Xm/List.h>
#include <Xm/Label.h>
#include <Xm/Frame.h>
#include <Xm/PushB.h>
#include <Xm/TextF.h>
#include <X11/Xmu/Editres.h>

#include "mxMailAddressSelect.h"
#include "mxButtons.xpm"
////////////////////////////////////////////////////////////////////////////////
//
//	Constructor
//
////////////////////////////////////////////////////////////////////////////////
mxMailAddressSelect::mxMailAddressSelect(Widget parent,
				     char *name,
				     mxMailAddressBook *book,
				     mxMailAddressSelectCB callback,
				     XtPointer clientData)
	:akDialog(name),
	 _addressbook(book),
	 _addressList((akList *)0),
	 _closeButton((akButton *)0),
	 _toButton((akButton *)0),
	 _ccButton((akButton *)0),
	 _bccButton((akButton *)0),
	 _userCB(callback),
	 _userData(clientData)
{

//	Create addressbook viewing panel

	initialize(parent);

//	Update values in panel

	update();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Destructor
//
////////////////////////////////////////////////////////////////////////////////
mxMailAddressSelect::~mxMailAddressSelect()
{
	if (_addressList)
	  delete _addressList;
	if (_closeButton)
	  delete _closeButton;
	if (_toButton)
	  delete _toButton;
	if (_ccButton)
	  delete _ccButton;
	if (_bccButton)
	  delete _bccButton;
}
////////////////////////////////////////////////////////////////////////////////
//
//	createWorkArea - create the panel contents
//
////////////////////////////////////////////////////////////////////////////////
Widget	mxMailAddressSelect::createWorkArea(Widget parent)
{
	Widget		form;
	Widget		list_rowcol;

//	Enable editres support

	XtAddEventHandler(_w,(EventMask)0,TRUE,
			  (XtEventHandler)_XEditResCheckMessages,0);

//	Add a form to attach panel components to

	form =
		XtVaCreateManagedWidget("AddressForm",
					xmFormWidgetClass,
					parent,
					NULL);

//	Add buttons to messagebox

	XtVaSetValues(_w,
		      XmNautoUnmanage,FALSE,
		      XmNresizePolicy,XmRESIZE_NONE,
		      XmNwidth,425,
		      XmNheight,325,
		      0);
	_closeButton =
	  new akButton(_w,"Close",mxClose_xpm,
			&mxMailAddressSelect::closeCB,(XtPointer)this);
	_closeButton->installHelp("Close the Address Book Selector");
	_closeButton->manage();
	XtVaSetValues(_w,XmNdefaultButton,_closeButton->baseWidget(),0);

//	Add list showing current addresses, and sorting buttons

	list_rowcol =
		XtVaCreateManagedWidget("AddressListRowcol",
					xmRowColumnWidgetClass,
					form,
					XmNtopAttachment,XmATTACH_FORM,
					XmNrightAttachment,XmATTACH_FORM,
					XmNbottomAttachment,XmATTACH_FORM,
					XmNadjustLast,FALSE,
					NULL);
	_toButton =
	  new akButton(list_rowcol,"Button",mxAddTo_xpm,
			&mxMailAddressSelect::toCB,(XtPointer)this);
	_toButton->installHelp("Add address to To:");
	_toButton->manage();
	_ccButton =
	  new akButton(list_rowcol,"Button",mxAddCc_xpm,
			&mxMailAddressSelect::ccCB,(XtPointer)this);
	_ccButton->installHelp("Add address to Cc:");
	_ccButton->manage();
	_bccButton =
	  new akButton(list_rowcol,"Button",mxAddBcc_xpm,
			&mxMailAddressSelect::bccCB,(XtPointer)this);
	_bccButton->installHelp("Add address to Bcc:");
	_bccButton->manage();

	_addressList =
	  new akList(form,"AddressList",0,0);
	XtVaSetValues(_addressList->baseWidget(),
		      XmNleftAttachment,XmATTACH_FORM,
		      XmNrightAttachment,XmATTACH_WIDGET,
		      XmNrightWidget,list_rowcol,
		      XmNtopAttachment,XmATTACH_FORM,
		      XmNbottomAttachment,XmATTACH_FORM,
		      NULL);
	_addressList->manage();

	return form;
}
////////////////////////////////////////////////////////////////////////////////
//
//	Addressbook update function
//
////////////////////////////////////////////////////////////////////////////////
void 	mxMailAddressSelect::setBook(mxMailAddressBook *book)
{
	_addressbook = book;

	update();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Update function - re-read the addressbook and reset the list
//
////////////////////////////////////////////////////////////////////////////////
void 	mxMailAddressSelect::update()
{
//	Remove current addresses from list (if any)

	_addressList->empty();

//	Add addresses to list

	for (int addr_no=0;addr_no<_addressbook->noOfAddresses();addr_no++)
	  _addressList->insert(_addressbook->addressTitle(addr_no));

//	Set display panel title line

	string	title_line;
	title_line = "AddressBook (" + _addressbook->filename() + ")";
	setTitle(title_line);
}
////////////////////////////////////////////////////////////////////////////////
void 	mxMailAddressSelect::closeCB(Widget,XtPointer clientData,XtPointer)
{
	mxMailAddressSelect	*obj = (mxMailAddressSelect *)clientData;

	obj->busy();
	obj->unmanage();
	obj->ready();
}
////////////////////////////////////////////////////////////////////////////////
void 	mxMailAddressSelect::toCB(Widget w,XtPointer clientData,XtPointer)
{
	mxMailAddressSelect	*obj = (mxMailAddressSelect *)clientData;
	mxMailAddress		address;
	mxMailAddressSelection	selection;

	obj->busy();

//	Check if address selected

	if (obj->_addressList->noSelectedItems() == 0)
	   {
	    XBell(XtDisplay(w),50);
	    obj->ready();
	    return;
	   }

	if (obj->_userCB)
	   {
	    int	*positions=obj->_addressList->selectedPos();

	    // Extract the address selected
	    address = obj->_addressbook->address(positions[0]-1);
	    delete []positions;

	    selection.destination = MX_MAIL_ADDRESS_TO;
	    selection.address     = address;
	    obj->_userCB(obj->_userData,selection);
	   }

	obj->ready();
}
////////////////////////////////////////////////////////////////////////////////
void 	mxMailAddressSelect::ccCB(Widget w,XtPointer clientData,XtPointer)
{
	mxMailAddressSelect	*obj = (mxMailAddressSelect *)clientData;
	mxMailAddress		address;
	mxMailAddressSelection	selection;

	obj->busy();

//	Check if address selected

	if (obj->_addressList->noSelectedItems() == 0)
	   {
	    XBell(XtDisplay(w),50);
	    obj->ready();
	    return;
	   }

	if (obj->_userCB)
	   {
	    int	*positions=obj->_addressList->selectedPos();

	    // Extract the address selected
	    address = obj->_addressbook->address(positions[0]-1);
	    delete []positions;

	    selection.destination = MX_MAIL_ADDRESS_CC;
	    selection.address     = address;
	    obj->_userCB(obj->_userData,selection);
	   }

	obj->ready();
}
////////////////////////////////////////////////////////////////////////////////
void 	mxMailAddressSelect::bccCB(Widget w,XtPointer clientData,XtPointer)
{
	mxMailAddressSelect	*obj = (mxMailAddressSelect *)clientData;
	mxMailAddress		address;
	mxMailAddressSelection	selection;

	obj->busy();

//	Check if address selected

	if (obj->_addressList->noSelectedItems() == 0)
	   {
	    XBell(XtDisplay(w),50);
	    obj->ready();
	    return;
	   }

	if (obj->_userCB)
	   {
	    int	*positions=obj->_addressList->selectedPos();

	    // Extract the address selected
	    address = obj->_addressbook->address(positions[0]-1);
	    delete []positions;

	    selection.destination = MX_MAIL_ADDRESS_BCC;
	    selection.address     = address;
	    obj->_userCB(obj->_userData,selection);
	   }

	obj->ready();
}
