////////////////////////////////////////////////////////////////////////////////
//
//	Class : mxSetupModify
//
//	Author : Andy Jefferson
//
//	Description :
//		mxSetupModify allows modification of the 'mx' setup params.
//
//	Public Methods :
//		(Constructor) requires :
//			parent		Widget used as parent of the panel.
//			name		Name used for resource specifications.
//			callback	Callback called when panel is closed.
//			clientData	Client Data passed to the callback.
//
//		update()	Removes all addresses from the list and
//				re-adds them. The fields are cleared.
//
//	Limitations :
//		Operates using the GLOBAL mxSetup object ONLY.
//
////////////////////////////////////////////////////////////////////////////////
#ifndef mxSetupModify_h
#define mxSetupModify_h
#ifdef __cplusplus

#include <string>
#include "akDialog.h"
#include "akButton.h"
#include "akPromptFile.h"
#include "akPromptString.h"
#include "akPromptPassword.h"
#include "akPromptDble.h"
#include "akPromptIntRange.h"
#include "akCheckBox.h"
#include "akRadioBox.h"
#include "akComboBox.h"
#include "akOptionMenu.h"
#include "akList.h"

typedef enum
{
	MXSETUP_GENERAL,
	MXSETUP_FTP,
	MXSETUP_MAIL,
	MXSETUP_NEWS,
	MXSETUP_NET
} mxSetupSectionType;

class mxSetupModify : public akDialog
{
	public:

		// Constructor and destructor

		mxSetupModify(Widget parent,
			      char *name,
			      XtCallbackProc callback=0,
			      XtPointer clientData=0);
		~mxSetupModify();

		// Update

		void		update();
		void		manage();
		void		setSection(mxSetupSectionType);

	private:

		// Panel functions/components

		Widget		createWorkArea(Widget parent);
		void		createGeneralPage(Widget parent,int page_no);
		void		createFtpPage(Widget parent,int page_no);
		void		createMailPage(Widget parent,int page_no);
		void		createNewsPage(Widget parent,int page_no);
		void		createNetPage(Widget parent,int page_no);
		Widget		_notebook;

		bool		_generalPageUsed;
		bool		_ftpPageUsed;
		bool		_mailPageUsed;
		bool		_newsPageUsed;
		bool		_netPageUsed;

		XtCallbackProc	_userCB;
		XtPointer	_userData;

		// General items

		akPromptString		*_organisationField;
		akPromptFile		*_tempDirField;
		akPromptFile		*_helpDirField;
		akPromptFile		*_audioDirField;
		akCheckBox		*_audioCheckBox;

		// FTP items

		akCheckBox		*_ftpCheckBox;
		akPromptString		*_ftpDefaultLocalDirField;
		akPromptString		*_ftpDefaultRemoteDirField;
		akPromptFile		*_ftpProcessFilenameField;

		// Mail items

		akPromptString		*_mailSenderField;
		akPromptFile		*_mailInboxField;
		akPromptFile		*_mailOutboxField;
		akPromptFile		*_mailAddressbookField;
		akPromptFile		*_mailSpambookField;
		akPromptFile		*_mailSignatureField;
		akPromptFile		*_mailFolderDirectoryField;
		akPromptFile		*_mailInboxReadFolderField;
		akPromptString		*_mailIndentStringField;
		akPromptFile		*_mailProcessFilenameField;
		akPromptIntRange	*_mailUpdateIntervalField;
		akRadioBox		*_mailMimeFormatField;
		akList			*_mailStartupFolderList;
		void			setMailFolders();

		// News items

		akPromptFile		*_newsBaseDirectoryField;

		// Net items

		akOptionMenu		*_netModemSpeedField;
		akRadioBox		*_netModemPortField;
		akPromptString		*_netModemInitField;
		akPromptIntRange	*_netModemIdleField;
		akPromptIntRange	*_netModemNoRetriesField;
		akComboBox		*_netSupplierNameField;
		akComboBox		*_netSupplierLocationField;
		akPromptString		*_netSupplierPhoneNoField;
		akPromptString		*_netSupplierLoginField;
		akPromptPassword	*_netSupplierPasswordField;
		akPromptFile		*_netWWWCommandField;
		akPromptFile		*_netNewsCommandField;

		// Option callbacks

		static void	saveCB(Widget,XtPointer,XtPointer);
		static void	cancelCB(Widget,XtPointer,XtPointer);

		static void	mailFolderDirectoryChangedCB(XtPointer,string);
		static void	pageChangedCB(Widget,XtPointer,XtPointer);
};
// Single global instance
extern mxSetupModify	*theMxSetupModify;

#endif
#endif
