
#include "cgetopts.h"
#include <stdio.h>

static int extract_option(cget_opts_ptr_t get_opts, const char* format);

void cget_opts_init(cget_opts_t *getopts, int argc, char* argv[], char opt_char)
{
    getopts->argv     = argv;
    getopts->argc     = argc;
    getopts->opt_char = opt_char;
    getopts->arg_str  = NULL;
    getopts->opt_str  = NULL;
    getopts->last_opt = '\0';
} /* cget_opts_init */

int cget_opts_next(cget_opts_ptr_t get_opts, const char* format)
{
    int ret;

    get_opts->arg_str = NULL;
    if (   (get_opts->opt_str == NULL)
	|| (*(get_opts->opt_str) == '\0'))
    {
        if (get_opts->argc > 0)
        {
    	    get_opts->opt_str = *get_opts->argv; 
	    if (*(get_opts->opt_str) == get_opts->opt_char)
	    {
	        /* found an option */
	        get_opts->argv++;
		get_opts->argc--;
                get_opts->opt_str++;
	        ret = extract_option(get_opts, format);
	    }
	    else
	    {
		ret = EOF;
            }
        }
        else
        {
            ret = EOF;
	}
    }
    else
    {
        ret = extract_option(get_opts, format);
    }
    return(ret);
} /* cget_opts_next */ 

char* cget_opts_next_arg(cget_opts_ptr_t get_opts)
{
    char* ret;

    if (get_opts->argc > 0)
    {
	ret = *(get_opts->argv);
        get_opts->arg_str = ret;
	get_opts->argv++;
        get_opts->argc--;
    }
    else
    {
        ret = NULL;
    }
    return(ret);
} /* cgetr_opts_next_arg */

static int extract_option(cget_opts_ptr_t get_opts, const char* format)
{
    int ret;

    get_opts->last_opt = *get_opts->opt_str;
    while ((*format != '\0') && (*format != *(get_opts->opt_str)))
    {
        format++;
    }
    if (*format != '\0')
    {
        /* found the option */
	format++;
	ret = *(get_opts->opt_str);
        get_opts->opt_str++;
	if (*format == ':')
	{
	    if (*(get_opts->opt_str) != '\0')
	    {
		get_opts->arg_str = get_opts->opt_str;
		get_opts->opt_str = NULL;
	    }
	    else
	    {
	        get_opts->arg_str = cget_opts_next_arg(get_opts);
		if (   (get_opts->arg_str == NULL
		    || (*(get_opts->arg_str) == get_opts->opt_char)))
		{
                    ret = '?';
                }
            }
	}
	else
	{
	    /* no further string required */   
        }
    }
    else
    {
	ret = '?';
	get_opts->opt_str++;
    }
    return(ret);
} /* extract_option */










