/* cpts.h */

/* Copyright (c) 1995 Dean Collins */

#include "pts.h"

/* MAXERROR is the maximum length of an error message.
 */
#ifndef MAXERROR
#define MAXERROR 1000
#endif

/* ReadProblem() takes one of two flags:
 *      UNSOLVEDPROB    -- Read the i'th unsolved problem.
 *      ANYPROB         -- Read the i'th problem, solved or not.
 *
 * "i" is the index into the list of summaries being shown.  
 * The first (top) element in the list is 0.
 */
#define UNSOLVEDPROB    69
#define ANYPROB         70


typedef struct
{	char *Title1 ;
 	char *Title2 ;
	char **Items ;
	char **Helptext ;
} ScnRec ;

/************** FUNCTION PROTOTYPES ******************/

/* main.c */
int main(int argc, char* argv[]) ;

/* scnrec.c */
ScnRec *NewScnRec(void) ;
void PrintScnRec(ScnRec *sr) ;

/* dommselect.c */
int DoMMSelection(CursesObj **CurMenup, WINDOW *win, int Selection,
		  char **list, int helplen, int *CurItemp,
		  UserInfo *UserInfoRecp, ProblemTree *ProbTree) ;

/* doppselect.c */
int DoPPSelection(CursesObj **CurMenup, WINDOW *win, int Selection, 
                  char **list, int helplen, int *CurItemp,
                  UserInfo *UserInfoRecp, ProblemTree *ProbTree,
                  char *Path) ;

/* dopsselect.c */
int DoPSSelection(CursesObj **CurMenup, WINDOW *win, int Selection, 
                  char **list, int helplen, int *CurItemp,
                  UserInfo *UserInfoRecp, ProblemTree *ProbTree,
                  char *Path) ;


/* pickprob.c */
int PickProblemMenu(CursesObjp cur, WINDOW *win, UserInfo *UserInfoRecp,
		    ProblemTree *ProbTree, char *OldPath, int OldItem) ;


/* viewprob.c */
int ViewProblem(CursesObjp cur, WINDOW *win, UserInfo *UserInfoRecp,
                ProblemTree *ProbTree, char *Path, Summary *Summaries,
                int index, int flag) ;


/* STUBS */
#define ShowAllUnsolvedMenu()	;
#define EditMOTD()		;

