/* Copyright (c) 1995 Dean Collins */

#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>

#include "zdbm.h"               /* Zombie Database Manager header file */
#include "cloud.h"              /* Nebulous Cloud header file */
#include "clouderror.h"         /* Nebulous Cloud error rtn. header file */

#include "CURcurses.h"
#include "text.h"
#include "cpts.h"


char *MainMenuHelp[]={
	"b=blah, x=extra blah, o=options, /=search",
	"j=line down, k=line up, q=quit",
	NULL} ;
char *MainMenuItems[]={
	"Report a Problem",
	"Show All Unsolved Problems",
	"Update the System Message of the Day",
	NULL} ;

int main(int argc, char* argv[])
{
   ScnRec *scnrec=NULL ;
   CursesObjp cur=NULL ;
   WINDOW *MainMenuWin=NULL ;
   int CurItem=0 ;
   int done=0 ;
   int Selection ;
   UserInfo UserInfoRec ;	/* Information about the user. */
   ProblemTree *ProbTree ;	/* The problem types tree. */



   scnrec = NewScnRec() ;

   scnrec->Title1 = "CPTS v.0.0" ;
   scnrec->Title2 = "Main Menu" ;
   scnrec->Items = MainMenuItems ;
   scnrec->Helptext = MainMenuHelp ;

   cur = CURnew() ;
   CURenter(cur) ;
   noecho() ;
   nonl() ;
   cbreak() ;
   MainMenuWin = newwin (0,0,0,0) ; /* a full-screen window */
   CURwenter(cur,MainMenuWin) ;

   ListWin(cur, MainMenuWin, scnrec->Title1, scnrec->Title2, "?=help",
	   scnrec->Items, scnrec->Helptext, 0) ;
   wrefresh(MainMenuWin) ;

     /* Get information about the user and read the problem hierarchy. */
#ifdef DEBUG
   fprintf(stderr,"main(): calling Setup()...\n") ;
#endif
/*CLD*/   if (Setup(&UserInfoRec, &ProbTree) == False)
   {  fprintf(stderr, "Error in configuration file %s !\n", CONFIGFILE) ;
      exit(1); 
   }
#ifdef DEBUG
   fprintf(stderr,"main(): returned from Setup()...\n") ;
   fprintf(stderr,"main():\tUserInfoRec.sysopflag = %d\n", UserInfoRec.sysopflag);
   fprintf(stderr,"main():\tUserInfoRec.username  = %s\n", UserInfoRec.username) ;
   fprintf(stderr,"main():\tUserInfoRec.realname  = %s\n", UserInfoRec.realname) ;
#endif


   while (!done)
   {
      HilightItem(cur,MainMenuWin, &CurItem, scnrec->Items, 2) ;
      Selection=GetSelection(cur, MainMenuWin) ;
      done=DoMMSelection(&cur, MainMenuWin, Selection, scnrec->Items, 2,
                         &CurItem, &UserInfoRec, ProbTree) ;
   }

/* OK, let's get the hell outa here. */
   Exit(done) ;


}



