/* Copyright (c) 1995 Dean Collins */

#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>

#include "zdbm.h"		/* Zombie Database Manager header file */
#include "cloud.h"		/* Nebulous Cloud header file */
#include "clouderror.h"		/* Nebulous Cloud error rtn. header file */

#include "CURcurses.h"
#include "text.h"
#include "cpts.h"

char *ViewerHelp[]={
        "space=next page, p=previous page, q=quit viewer",
        NULL} ;

char **Str2Strs(char *s)
{
   int i=0,j=0,x=0 ;
   int maxlen=0 ;
   int totlen=0 ;
   int lines=1 ;
   char **strs=NULL ;

#  ifdef DEBUG
   fprintf(stderr,"Entering Str2Strs()\n") ;
#  endif

   if (s==NULL)
      return NULL ;

   totlen=strlen(s) ;

   /* Count number of lines in string */
   for (j=0; j<totlen; ++j)
      if (s[j] == '\n')
         ++lines ;

#  ifdef DEBUG
   fprintf(stderr,"lines=%d\n",lines) ;
#  endif

   strs=malloc((lines + 1) * sizeof(char *)) ;

   for (j=0; j<totlen; ++j)
   {
#     ifdef DEBUG
      fprintf(stderr,"%d:%d:%d:%d\n",x,i,j,maxlen);
#     endif
      if (s[j] == '\n' || s[j] == '\0')
      {  
         strs[x] = malloc((j-i+2) * sizeof(char)) ;
         if (i==j)
            strcpy(strs[x],"") ;
         else
         {
            nl_strncpy (strs[x], &(s[i]), j-i+1) ;
            if (j-i > maxlen)
               maxlen = j-i ;
#           ifdef DEBUG
            fprintf(stderr,"line %d='%s'\n", x, strs[x]) ;
#           endif
         }
         i=j+1 ;
         x++ ;
      }
   }

   strs[x] = NULL ;

#  ifdef DEBUG
   fprintf(stderr,"Leaving Str2Strs()\n") ;
#  endif

   return (strs) ;
}



int ViewProblem(CursesObjp cur, WINDOW *win, UserInfo *UserInfoRecp,
                ProblemTree *ProbTree, char *Path, Summary *Summaries,
		int index, int flag)
{
   WINDOW *ViewerWin ; 
   char **errorstrs=NULL ;
   problem_record *ProblemRecord ;
   int i ;
   char **ProbLines=NULL ;
   char tfname[PATH_MAX+1] ;
   FILE *tfile=NULL ;


   if (flag == UNSOLVEDPROB)
   {
#     ifdef DEBUG
      fprintf(stderr,"ViewProblem(): calling ReadUnsolved()...\n") ;
#     endif
/*CLD*/ ProblemRecord = ReadUnsolved(ProbTree, Path, Summaries, index) ;

   }
   else if (flag == ANYPROB)
   {
#     ifdef DEBUG
      fprintf(stderr,"ViewProblem(): calling ReadUnsolved()...\n") ;
#     endif
/*CLD*/ ProblemRecord = ReadProblem(ProbTree, Path, index, Summaries) ;
   }
#  ifdef DEBUG
   else fprintf(stderr,"ViewProblem(): Uh-oh!  flag was not valid! \n") ;
#  endif

   if (ProblemRecord == NULL)
   {  errorstrs=malloc(10*sizeof(char *)) ;
      for (i=0; i<10; ++i)
         errorstrs[i] = malloc(81) ;
      strcpy(errorstrs[0], "Error reading problem!") ;
      strcpy(errorstrs[1], "") ;
      strcpy(errorstrs[2], "Possible error cause:") ;
      strncpy(errorstrs[3], CloudStrerror(), 80) ;
      free(errorstrs[3]) ;
      errorstrs[3] = NULL ;

      CURNotice(cur, " ERROR! ", errorstrs) ;
      touchwin(win) ;
      wrefresh(win) ;

      for (i=0; i<10; ++i)
         if (errorstrs[i])
            free (errorstrs[i]) ;
      free(errorstrs) ;

      return ;
   }

/*
   ProbLines = Str2Strs (FormatProblem(ProblemRecord,Path)) ;
*/

   strcpy(tfname, tmpnam(NULL)) ;
   tfile = fopen(tfname,"w") ;
   fprintf(tfile,"%s",FormatProblem(ProblemRecord,Path)) ;
/*   fprintf(tfile,"\n[end log]\n") ;*/
   fclose(tfile) ;

   ViewerWin = newwin(0,0,0,0) ; /* New full-screen window */
   CURwenter(cur,ViewerWin) ;
   wclear(ViewerWin) ;
   touchwin(ViewerWin) ; 
   wrefresh(ViewerWin) ; 

#ifdef BITEME

/*   nocbreak();*/
/*   echo() ;*/
/*   nl() ;*/
/*   nodelay(ViewerWin, FALSE);*/

CURexit(cur) ;
 nocbreak() ;
 nodelay(ViewerWin, FALSE);
 endwin() ;
raw() ;
noecho();
/*system("/usr/bin/vi") ;*/
system("/bin/more /var/X11R6/lib/doc/README.cirrus") ;
nl() ;
printf("Press <RETURN> to continue") ;
fflush(stdin) ;
fflush(stdout) ;
noraw();
noecho();
cbreak() ;
nonl() ;

getchar() ;
fflush(stdout) ;
CURenter(cur) ;

#endif


   nl() ;
   Ourpager(cur, tfname) ;
   nonl() ;

/*   printf("Press <RETURN> to continue") ;
   fflush(stdin) ;
   fflush(stdout) ;
   getchar() ;
   fflush(stdout) ;
*/
   wclear(ViewerWin) ;
   touchwin(ViewerWin) ; 
   wrefresh(ViewerWin) ; 
   CURenter(cur) ;
   touchwin(win) ;
   wrefresh(win) ; 
   delwin(ViewerWin) ;

   unlink(tfname) ;
}



/* From gopher 1.1 */
/*
 * ZapCRLF removes all carriage returns and linefeeds from a C-string.
 */

void
ZapCRLF(inputline)
  char *inputline;
{
     char *cp;

     cp = strchr(inputline, '\r');    /* Zap CR-LF */
     if (cp != NULL)
          *cp = '\0';
     else {
          cp = strchr(inputline, '\n');
          if (cp != NULL)
               *cp = '\0';
     }
}




/* From gopher 1.1 */
/*
** This mini pager is intended for people worried about shell escapes from
** more or less or whatever
*/


Ourpager(CursesObjp CursesScreen, char *filename)
{
     FILE *InFile;
     int i;
     char inputline[512], *cp;
     int Done = FALSE;
     char ZeTypedChar;
     
     if ((InFile = fopen(filename, "r")) == NULL)
          return;

     while (Done == FALSE) {
          tputs(CURgetCLS(CursesScreen),1,CURoutchar);

          for (i=0 ; i < LINES-1; i++) {
               cp = fgets(inputline, 512, InFile);
               if (cp != NULL) 
               {  ZapCRLF(inputline);
                  puts(inputline);
               }
               else puts("") ;
          }

          if (!feof(InFile))
	       printf("----Press <ENTER> for next page, q to exit------");
          else printf("----Press any key to continue------");
          
          cbreak();
          ZeTypedChar = getchar();
          
          if ((ZeTypedChar == 'q') || (cp == NULL)) {
               printf("\n");
               Done = TRUE;
          }
     }

     cbreak();
     fclose(InFile);
}



