/* clouderror.c -- Error routines for libcloud.a.
 * Author:  Luke Sheneman
 *
 * Modified: Dean Collins Sat Feb 12 17:09:09 1994
 * Modification recommended by Jaap Haalboom (haalboom@prl.philips.nl).
 * Changed the definition of the string returned by CloudStrerror()
 * to be a static to avoid memory problems.
 */

/*
 * Copyright (c) 1992 Luke Sheneman.
 * Copyright (c) 1992 University of Idaho, Moscow, Idaho.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation free of charge for any purpose is hereby granted without
 * fee, provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear in
 * supporting documentation, and that neither the name of Luke Sheneman
 * nor the University of Idaho be used in advertising or publicity pertaining
 * to distribution of the software without specific, written prior permission.
 * Luke Sheneman and the University of Idaho make no representations about
 * the suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * LUKE SHENEMAN AND THE UNIVERSITY OF IDAHO DISCLAIM ALL WARRANTIES WITH
 * REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS. IN NO EVENT SHALL LUKE SHENEMAN OR THE UNIVERSITY OF IDAHO
 * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

/* The following functions are defined in this source file: 
 *
 * CloudStrerror() - returns a useful error string based on the global variable
 * 	cld_errno.
 *
 */

#include <stdio.h>
#include <zdbm.h>
#include "clouderror.h"

int cld_errno=0;	/* our global error flag */

char *CloudStrerror()
{
	static char error[MAXERRORSTRING]; /*changed to 'static' 2/14/94 DC*/

	switch(cld_errno)
	{
		case CLD_ERR1:
		{
			strcpy(error,"Cloud Error:  Could Not Get Password Information For User.\n");		
			break;
		}
		case CLD_ERR2:
		{
			strcpy(error,"Cloud Error:  Could Not Parse Config File Information.\n");
			break;
		}
		case CLD_ERR3:
		{
			strcpy(error,"Cloud Error:  Could Not Read Next Unsolved Problem From Database.\n\n");
			strcat(error,"Possible Database Info:\n");
			sprintf(error,"%s%s\n",error,zdbm_strerror(db_errorno));
			break;
		}	
		case CLD_ERR4:
		{
			strcpy(error,"Cloud Error:  Could Not Read Next Reopen Requested Problem From Database.\n\n");
			strcat(error,"Possible Database Info:\n");
			sprintf(error,"%s%s\n",error,zdbm_strerror(db_errorno));
			break;
		}	
		case CLD_ERR5:
		{
			strcpy(error,"Cloud Error:  Could Not Read Next Solved Problem From Database.\n\n");
			strcat(error,"Possible Database Info:\n");
			sprintf(error,"%s%s\n",error,zdbm_strerror(db_errorno));
			break;
		}
		case CLD_ERR6:
		{
			strcpy(error,"Cloud Error:  Could Not Read Particular Unsolved Problem From Database.\n\n");
			strcat(error,"Possible Database Info:\n");
			sprintf(error,"%s%s\n",error,zdbm_strerror(db_errorno));
			break;
		}
		case CLD_ERR7:
		{
			strcpy(error,"Cloud Error:  Could Not Read Particular Reopen Requested Problem From Database.\n\n");
			strcat(error,"Possible Database Info:\n");
			sprintf(error,"%s%s\n",error,zdbm_strerror(db_errorno));
			break;
		}
		case CLD_ERR8:
		{
			strcpy(error,"Cloud Error:  Invalid Problem Status Passed To ReadUnsolved().\n\n");
			break;
		}
		case CLD_ERR9:
		{
			strcpy(error,"Cloud Error:  Trying To Read Summaries From An Empty List!\n\n");
			break;
		}
		case CLD_ERR10:
		{
			strcpy(error,"Cloud Error:  Invalid Path In Problem Tree.\n\n");
			break;
		}
		case CLD_ERR11:
		{
			strcpy(error,"Cloud Error:  Specified Branch Has No Children In Problem Tree.\n\n");
			break;
		}
		case CLD_ERR12:
		{
			strcpy(error,"Cloud Error:  Non-existant Branch In Problem Tree.\n\n");
			break;
		}
		case CLD_ERR13:
		{
			strcpy(error,"Cloud Error:  General Error In Moving To Specified Branch In Problem Tree.\n\n");
			break;
		}
		case CLD_ERR14:
		{
			strcpy(error,"Cloud Error:  Requested Problem Does Not Exist In Problem Tree.\n\n");
			break;
		}
		case CLD_ERR15:
		{
			strcpy(error,"Cloud Error:  Requested Problem Does Not Exist In Problem Tree.\n\n");
			strcat(error,"Possible Database Info:\n");
			sprintf(error,"%s%s\n",error,zdbm_strerror(db_errorno));
			break;
		}
		case CLD_ERR16:
		{
			strcpy(error,"Cloud Error:  Error Locking Problem In Database.\n\n");
			strcat(error,"Possible Database Info:\n");
			sprintf(error,"%s%s\n",error,zdbm_strerror(db_errorno));
			break;
		}
		case CLD_ERR17:
		{
			strcpy(error,"Cloud Error:  Error Unlocking Problem In Database.\n\n");
			strcat(error,"Possible Database Info:\n");
			sprintf(error,"%s%s\n",error,zdbm_strerror(db_errorno));
			break;
		}
		case CLD_ERR18:
		{
			strcpy(error,"Cloud Error:  Error Solving Problem In Database.\n\n");
			strcat(error,"Possible Database Info:\n");
			sprintf(error,"%s%s\n",error,zdbm_strerror(db_errorno));
			break;
		}
		case CLD_ERR19:
		{
			strcpy(error,"Cloud Error:  Error Reopening Problem In Database.\n\n");
			strcat(error,"Possible Database Info:\n");
			sprintf(error,"%s%s\n",error,zdbm_strerror(db_errorno));
			break;
		}
		case CLD_ERR20:
		{
			strcpy(error,"Cloud Error:  Error Requesting The Reopening Of A Problem In The Database.\n\n");
			strcat(error,"Possible Database Info:\n");
			sprintf(error,"%s%s\n",error,zdbm_strerror(db_errorno));
			break;
		}
		case CLD_ERR21:
		{
			strcpy(error,"Cloud Error:  Unable To Open Temp Mail File For Deny Letter.\n\n");
			break;
		}
		case CLD_ERR22:
		{
			strcpy(error,"Cloud Error:  Error Denying A Reopen Request Of A Problem In The Database.\n\n");
			strcat(error,"Possible Database Info:\n");
			sprintf(error,"%s%s\n",error,zdbm_strerror(db_errorno));
			break;
		}
		case CLD_ERR23:
		{
			strcpy(error,"Cloud Error:  Error Adding Reporter To The Reporter List For This Problem.\n\n");
			strcat(error,"Possible Database Info:\n");
			sprintf(error,"%s%s\n",error,zdbm_strerror(db_errorno));
			break;
		}
		case CLD_ERR24:
		{
			strcpy(error,"Cloud Error:  Error Deleting Problem From The Database.\n\n");
			strcat(error,"Possible Database Info:\n");
			sprintf(error,"%s%s\n",error,zdbm_strerror(db_errorno));
			break;
		}
		case CLD_ERR25:
		{
			strcpy(error,"Cloud Error:  Source Path Invalid For Moving Problem In Database.\n\n");
			break;
		}
		case CLD_ERR26:
		{
			strcpy(error,"Cloud Error:  Destination Path Invalid For Moving Problem In Database.\n\n");
			break;
		}
		case CLD_ERR27:
		{
			strcpy(error,"Cloud Error:  Error Moving Problem In The Database.\n\n");
			strcat(error,"Possible Database Info:\n");
			sprintf(error,"%s%s\n",error,zdbm_strerror(db_errorno));
			break;
		}
		case CLD_ERR28:
		{
			strcpy(error,"Cloud Error:  Source Path Invalid For Linking Problem In Database.\n\n");
			break;
		}
		case CLD_ERR29:
		{
			strcpy(error,"Cloud Error:  Destination Path Invalid For Linking Problem In Database.\n\n");
			break;
		}
		case CLD_ERR30:
		{
			strcpy(error,"Cloud Error:  Error Linking Problem In The Database.\n\n");
			strcat(error,"Possible Database Info:\n");
			sprintf(error,"%s%s\n",error,zdbm_strerror(db_errorno));
			break;
		}
		case CLD_ERR31:
		{
			strcpy(error,"Cloud Error:  Error Opening Temporary File For Printing A Problem.\n\n");
			break;
		}
		case CLD_ERR32:
		{
			strcpy(error,"Cloud Error:  Error Writing Problem To The Database.\n\n");
			strcat(error,"Possible Database Info:\n");
			sprintf(error,"%s%s\n",error,zdbm_strerror(db_errorno));
			break;
		}
		case CLD_ERR33:
		{
			strcpy(error,"Cloud Error:  Error Appending Problem Log To A Problem In The Database.\n\n");
			strcat(error,"Possible Database Info:\n");
			sprintf(error,"%s%s\n",error,zdbm_strerror(db_errorno));
			break;
		}
		case CLD_ERR34:
		{
			strcpy(error,"Cloud Error:  Subtree Not Found In Tree At Specified Path.\n\n");
			break;
		}
		case CLD_ERR35:
		{
			strcpy(error,"Cloud Error:  Error Reopening A Problem In The Database.\n\n");
			strcat(error,"Possible Database Info:\n");
			sprintf(error,"%s%s\n",error,zdbm_strerror(db_errorno));
			break;
		}
		default:
		{
			strcpy(error,"Unknown Error.\n");
			break;
		}
	}

	return(error);
}
