/* Author:  Luke Sheneman */

/* Modified: Dean Collins Thu Jun 16 17:53:08 1994
 * Moved TraverseList() to subtree.c.
 *
 * Modified: Dean Collins Sun May 21 14:14:20 PDT 1995
 * Changed return(NULL) to return(0) since NULL is often a pointer
 * and return value needed to be an int.
 */

/*
 * Copyright (c) 1992 Luke Sheneman.
 * Copyright (c) 1992 University of Idaho, Moscow, Idaho.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation free of charge for any purpose is hereby granted without
 * fee, provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear in
 * supporting documentation, and that the names of the University of Idaho
 * Dean Collins and Luke Sheneman not be used in advertising or publicity
 * pertaining to distribution of the software without specific, written
 * prior permission.  The University of Idaho, Luke Sheneman and Dean Collins
 * make no representations about the suitability of this software for
 * any purpose.  It is provided "as is" without express or implied warranty.
 *
 * THE UNIVERSITY OF IDAHO, LUKE SHENEMAN, AND DEAN COLLINS  DISCLAIM ALL
 * WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS.  IN NO EVENT SHALL THE UNIVERSITY OF IDAHO
 * LUKE SHENEMAN OR DEAN COLLINS BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
 * OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */

/* These functions are marginally useful for debugging purposes only.  These
   functions are not necessary for the normal operation of the PTS system, 
   but can provide help in the case of debugging.
*/

/* tester.c provides definitions for the following functions:
 *
 * PrintUserInfo() - Prints out a given userinfo structure.
 * P_code() - Remnants of the past...no longer useful.
 * PrintParts() - Prints out an array of path part strings.
 * PrintUnsolvedSummaries() - Prints out an array of unsolved summary
 * 	strings.
 * TraverseSummaries() - Traverses a linked list of Summary structures,
 *  	printing the members of the structure as it goes.
 * printsummary() - prints the contents of a summary structure.
 *
 */


#define NUMPATHS 6

#include <stdio.h>
#include "zdbm.h"
#include "cloud.h"
#include "clouderror.h"

void PrintUserInfo(userinfo)
UserInfo *userinfo;
{
	cld_errno=0;

	zdebug1("SYSOP: %d\n",userinfo->sysopflag);
	zdebug1("USERNAME: %s\n",userinfo->username);
	zdebug1("REALNAME: %s\n",userinfo->realname);

}

int P_code(flag,ppath)
struct Full_path **ppath;
{
	int loop;
        char table[NUMPATHS][DBPATHLEN];
        struct Full_path *temp;
	struct Full_path *path;

	cld_errno=0;

        strcpy(table[0],"/Help/Me");
        strcpy(table[1],"/Help/Me/Now");
        strcpy(table[2],"/Help/Me/Later");
        strcpy(table[3],"/Help/You");
        strcpy(table[4],"/Help/You/Junk");
        strcpy(table[5],"/PTS/REOPEN");

        path=(struct Full_path *)malloc(sizeof(struct Full_path));
        strcpy(path->path,table[0]);
        path->next=NULL;

        for(loop=1;loop<NUMPATHS;loop++)
	{
                struct Full_path *t;

                t=(struct Full_path *)malloc(sizeof(struct Full_path));
                strcpy(t->path,table[loop]);
                t->next=path;
                path=t;
        }

        temp=path;
	*ppath=path;
        return(0);
}

void PrintParts(parts)
char parts[MAXBRANCHES][DBPATHLEN];
{
	int loop=0;

	cld_errno=0;

	zdebug("\n");

	while(strcmp(parts[loop],""))
	{
		zdebug1("PrintParts() - %s\n",parts[loop]);

		loop++;
	}	

	zdebug("\n");

}

void PrintUnsolvedSummaries(unsummaries)
char unsummaries[MAXSUMMARIES][MAXSUMLEN];
{
	int loop;

	cld_errno=0;

	while(strcmp(unsummaries[loop],""));
	{

		zdebug1("%s\n",unsummaries[loop]);

		loop++;
	}
}


void TraverseSummaries(summaries)
Summary *summaries;
{
	Summary *s;

	cld_errno=0;

	zdebug("In TraverseSummaries() about to traverse linked list of summaries.\n");
	
	s=summaries;
	while(s)
	{
		zdebug1("TraverseSummaries() - summary ptr=%p\n",s);
		zdebug1("		      summary prid=%s\n",s->prid);
		zdebug1("		      summary summary=%s\n",s->summary);
		zdebug1("		      summary path=%s\n",s->path);
		zdebug1("		      summary status=%d\n",s->status);

		s=s->next;
	}
}


void printsummary(summary)
Summary *summary;
{
	cld_errno=0;

	zdebug("printsummary() - \n");
	zdebug1("^^^ prid: %s\n",summary->prid);
	zdebug1("^^^ path: %s\n",summary->path);
	zdebug1("^^^ summary: %s\n",summary->summary);
	zdebug1("^^^ status: %d\n",summary->prid);

}
