/* ptstypes.c -- command-line utility to list the problem types
 * in the PTS database (the leaves).
 * Dean Collins
 * created: Sun Mar  5 19:15:12 PST 1995
 * 	Stole core code from newprob.c
 */

/*
 * Copyright (c) 1995,1994 Dean Collins
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation free of charge for any purpose is hereby granted without
 * fee, provided that the above copyright notices appear in all copies and
 * that both those copyright notices and this permission notice appear in
 * supporting documentation, and that the name of Dean Collins not be used
 * in advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.  Dean Collins makes no
 * representations about the suitability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 *
 * DEAN COLLINS DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS.
 * IN NO EVENT SHALL DEAN COLLINS BE LIABLE FOR ANY SPECIAL, INDIRECT
 * OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#include <stdlib.h>		/* General C utilities header file */
#include <stdio.h>              /* Standard input/output utilities hdr. file */
#include <sys/param.h>          /* System parameters header file */
#include "pts.h"
#include "zdbm.h"               /* Zombie Database Manager header file */
#include "cloud.h"              /* Nebulous Cloud header file */
#include "clouderror.h"         /* Nebulous Cloud error rtn. header file */
#include "config.h"             /* Config. file parser header file */
#include "patchlevel.h"		/* For version info. */


	/* Needed for or getopt() */
#include <unistd.h>
extern char *optarg;
/*extern int optind, opterr, optopt;*/


/* The maximum # of characters on a line of input or in a single
 * command-line option argument.  Really shouldn't be more that about
 * 80 characters or so.
 */
#ifndef MAXLINELEN
#define MAXLINELEN 1024
#endif /*MAXLINELEN*/


/******************** MODULES *************************************/
/*
______________________________________________________________________
main()

FUNCTION DESCRIPTION:

	This function is the main routine for the ptstypes utility.
______________________________________________________________________
UNIT TESTING:
     This function has been tested by using a combination of white-box and
black-box tests.
______________________________________________________________________
REVISION HISTORY:
     Author:  Dean Collins      Date:  3/5/95
______________________________________________________________________
*/


int
main(int   argc,
     char *argv[])

     /* Interface description:
         INPUT:
          argc  - Number of command line arguments, including command itself.
          argv  - An array of command-line arguments.
         OUTPUT:
          None.
         RETURN VALUE:
          int   - Zero if successful completion, non-zero otherwise.
     */

{
     /* Internal variables: */
          /* Major */
   ProblemTree *ProbTree = NULL ;	/* The tree of problem types. */
   UserInfo UserInfoRec ;		/* Information about the user. */
   struct Full_path pathlist ;
   char *Path = NULL ;			/* The tree leaf for the new problem. */
   char *Summary = NULL ;		/* The summary    "   "   "     "     */
   char *Desc = NULL ;		 	/* The description "  "   "     "     */
   char Node[MAXHOSTNAMELEN+1] ;	/* The hostname   "   "   "     "     */
   char Reporter[MAXMAILADDR+1] ;	/* The reporter   "   "   "     "     */
   signed char Priority=0 ;		/* The priority   "   "   "     "     */

          /* Minor */
   int Status = 0 ;			/* A return value */
   int c ;				/* A command-line option character */
   char Str[MAXLINELEN] ; /* Maximum amound of data on a single line of input */
   char *Buffer ;			/* A temporary buffer of characters */
   

   /*---------------------- Start of main() routine -----------------------*/

   pathlist.next = NULL ;  /* Much-needed initialization added 10/8/94, DC */

   Node[0]='\0' ;
   Reporter[0]='\0' ;

	/* Parse the command line.  */
   while ( (c = getopt(argc, argv, "?")) != -1 )
   {  switch(c)
      { 
	 default:		/* Invalid or misused options, '-?', etc. */
		fprintf(stderr, 
		      "PTS ptstypes utility, Version %s.%s\n"
		      "Usage: \n"
		      "  %s [-?]\n",
		      VERSION, PATCHLEVEL, argv[0]) ;
		exit(-1) ;
      }
   }

     /* Get information about the user and read the problem hierarchy
      * from the config file.
      */
#ifdef DEBUG
   fprintf(stderr,"calling Setup()...\n") ;
#endif
/*CLD*/   if (Setup(&UserInfoRec, &ProbTree) == False)
   {  fprintf(stderr, "Error in configuration file %s !\n", CONFIGFILE) ;
      exit(1);
   }
#ifdef DEBUG
   fprintf(stderr,"returned from Setup()...\n") ;
   fprintf(stderr,"\tUserInfoRec.sysopflag = %d\n", UserInfoRec.sysopflag);
   fprintf(stderr,"\tUserInfoRec.username  = %s\n", UserInfoRec.username) ;
   fprintf(stderr,"\tUserInfoRec.realname  = %s\n", UserInfoRec.realname) ;
#endif

   gethostname(Node, MAXHOSTNAMELEN) ; /* Can be over-ridden below...*/

	/* Get the problem tree into a list of leaves more easily printed.*/
        /* Then print the list of problem types (leaves only.) */
/*CLD*/  TraverseLeaves(ProbTree, &pathlist) ;
/*CLD*/  TraverseList(stdout,&pathlist) ;


   exit(0) ;

}  /*-------------------------- End of main() -----------------------------*/

/* end of newprob.c */

