/********************************************************************
 * $Author: lindner $
 * $Revision: 1.1 $
 * $Date: 1992/12/10 23:32:16 $
 * $Source: /home/mudhoney/GopherSrc/gopher1.1/gopher/RCS/CURcurses.h,v $
 * $Status: $
 *
 * Paul Lindner, University of Minnesota CIS.
 *
 * Copyright 1991, 1992 by the Regents of the University of Minnesota
 * see the file "Copyright" in the distribution for conditions of use.
 *********************************************************************
 * MODULE: CURcurses.h
 * Header file access methods for CURcurses.c
 *********************************************************************
 * Revision History:
 * $Log: CURcurses.h,v $
 * Revision 1.1  1992/12/10  23:32:16  lindner
 * gopher 1.1 release
 *
 * Revision 1.1  1992/12/10  06:16:51  lindner
 * Initial revision
 *
 *
 *********************************************************************/

#include <ctype.h>

#if defined(ultrix)
#  include <cursesX.h>
#else
#  include <curses.h>
#endif

#include "boolean.h"
#include "STRstring.h"

#ifdef KEY_RIGHT
#define SYSVCURSES
#endif

struct CursesStruct {
     WINDOW *Screen;
     String *Termtype;

     /** Termcap/terminfo stuff **/
     String *Clearscreen;
     String *AudibleBell;
     String *Highlighton;
     String *Highlightoff;
     
     boolean inCurses;
     
     int COLS;
     int ROWS;
     
     void (*sigtstp)();
     void (*sigwinch)();
};

typedef struct CursesStruct CursesObj;
typedef struct CursesStruct *CursesObjp;

#ifndef SYSVCURSES
#define KEY_DOWN        0402           /* The four arrow keys ...*/
#define KEY_UP          0403
#define KEY_LEFT        0404
#define KEY_RIGHT       0405           
#define KEY_NPAGE       0522           /* Next page */
#define KEY_PPAGE       0523           /* Previous page */
#define KEY_ENTER       0527
#define KEY_BACKSPACE   0407
#endif

/*
 * Definitions for character graphics
 */

#if defined(SYSVCURSES) && !defined(ultrix) && !defined(hpux) && !defined(_AUX_SOURCE)
#define BOX_UL          ('l'|A_ALTCHARSET)
#define BOX_UR          'k'|A_ALTCHARSET
#define BOX_LL          'm'|A_ALTCHARSET
#define BOX_LR          'j'|A_ALTCHARSET
#define BOX_VLINE       'x'|A_ALTCHARSET
#define BOX_HLINE       'q'|A_ALTCHARSET
#else
#define BOX_UL          '+'
#define BOX_UR          '+'
#define BOX_LL          '+'
#define BOX_LR          '+'
#define BOX_VLINE       '|'
#define BOX_HLINE       '-'
#endif

#if defined(VMS) || defined(__convex__) || defined(sequent)
#if !defined(cbreak)
#define cbreak crmode
#endif
#endif


/*
 * access functions
 */

#define CURgetScreen(a)    ((a)->Screen)
#define CURgetTerm(a)      (STRget((a)->Termtype))
#define CURgetCLS(a)       (STRget((a)->Clearscreen))
#define CURgetBell(a)      (STRget((a)->AudibleBell))
#define CURgetHighon(a)    (STRget((a)->Highlighton))
#define CURgetHighoff(a)   (STRget((a)->Highlightoff))

#define CURsetScreen(a,b)  ((a)->Screen=(b))
#define CURsetTerm(a,b)    (STRset((a)->Termtype, (b)))
#define CURsetCLS(a,b)     (STRset((a)->Clearscreen,(b)))
#define CURsetBell(a,b)    (STRset((a)->AudibleBell,(b)))
#define CURsetHighon(a,b)  (STRset((a)->Highlighton,(b)))
#define CURsetHighoff(a,b) (STRset((a)->Highlightoff,(b)))
#define CURsetSIGTSTP(a,b) ((a)->sigtstp=(b))
#define CURsetSIGWINCH(a,b) ((a)->sigwinch=(b))


CursesObj *CURnew();
void      CURinit();
void      CURcenterline();
void      CURwcenterline(); /*Added DC*/
void      CURenter();
void      CURexit();
int       CURgetstr();
int       CURgetch();
void      CURresize();
int       CURoutchar();
int       CURGetOneOption();
void      CURBeep();
void      CURwenter();
