/*
 * sctoa.c --   Convert an integer to an ascii value.
 *
 * Dean Collins 
 * created: Sat Nov 19 19:55:22 PST 1994
 */

/* This is so basic I didn't even bother to put the copyright here. */


#include <stdlib.h>             /* General C utilities header file */
#include <stdio.h>
#include "util.h"



/******************** MODULES *************************************/

/*
______________________________________________________________________
sctoa()

FUNCTION DESCRIPTION:

     This function converts a signed character to a string.
Has a built-in limit of 100 digits, not that you could use that many.
______________________________________________________________________
REVISION HISTORY:
     Author:  Dean Collins      Date:  Sat Nov 19 19:58:14 PST 1994
______________________________________________________________________
*/


char *sctoa(int Num)

     /* Interface description:
         INPUT:
          Num    - The integer to convert.
         OUTPUT:
          None.
         RETURN VALUE:
          char * - The string.  This is static data, and must
			be copied to be used.
     */

{
     /* Internal variables: */
          /* Major */
	  /* NONE */
          /* Minor */
   char tmpstr1[100] ;
   static char *tmpstr2=NULL ;
   int i=0 ;
   int digits=0 ;
   int INum=0 ;


   /*------------------- Start of sctoa() routine --------------------*/

#ifdef DEBUG
   fprintf(stderr,"sctoa() converting integer %d\n", Num) ;
#endif

   INum = Num & 0xff ; /* Convert the #@!# thing to an integer */

   if (tmpstr2)
      free(tmpstr2) ;
   
   if (Num == 0)
   {  
#ifdef DEBUG
      fprintf(stderr,"Num=0\n") ;
#endif
      tmpstr2 = malloc(2) ;
      tmpstr2[0] = '0' ;
      tmpstr2[1] = '\0' ;
   }
   else if (Num > 0)
   {
#ifdef DEBUG
      fprintf(stderr,"Num>0\n") ;
#endif
      while (Num)
      {  tmpstr1[i++] = Num % 10 + '0' ;
         Num /= 10 ;
      }
      digits=i ;
      tmpstr2 = (char *)malloc(digits + 1) ;
      for (i=0; i<digits; ++i)
      {  tmpstr2[i] = tmpstr1[digits - i - 1] ;
      }
      tmpstr2[digits] = '\0' ;
   }
   else
   {
#ifdef DEBUG
      fprintf(stderr,"Num<0\n") ;
#endif
      Num = - Num ;
      i=1 ;
      while (Num)
      {  tmpstr1[i++] = Num % 10 + '0' ;
         Num /= 10 ;
      }
      digits=i ;
      tmpstr2 = (char *)malloc(digits + 2) ;
      tmpstr2[0] = '-' ;
      for (i=0; i<digits; ++i)
      {  tmpstr2[i+1] = tmpstr1[digits - i - 1] ;
      }
      tmpstr2[digits] = '\0' ;
   }

#ifdef DEBUG
   fprintf(stderr,"sctoa() string='%s'\n",tmpstr2) ;
#endif

   return(tmpstr2) ;

}  /*-------- End of sctoa() ---------------------------*/


/* end of sctoa.c */
