/* html.c -- A couple of HTML-related routines.
 *
 * Dean Collins
 */

/*
 * Copyright (c) 1995 Dean Collins.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation free of charge for any purpose is hereby granted without
 * fee, provided that the above copyright notices appear in all copies and
 * that both those copyright notices and this permission notice appear in
 * supporting documentation, and that the name of Dean Collins not
 * be used in advertising or publicity pertaining to distribution of
 * the software without specific, written prior permission.  Dean Collins
 * makes no representations about the suitability of this software for
 * any purpose.  It is provided "as is" without express or implied warranty.
 *
 * DEAN COLLINS DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS.
 * IN NO EVENT SHALL DEAN COLLINS BE LIABLE FOR ANY SPECIAL, INDIRECT
 * OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */

#include <stdlib.h>		/* General C utilities header file */
#include <stdio.h>		/* Standard input/output utilities hdr. file */
#include <string.h>
#include <sys/param.h>
#include "pts.h"
#include "html.h"		/* A couple of HTML-related routines */
#include "zdbm.h"		/* Zombie Database Manager header file */



/******************** MODULES *************************************/

/*
______________________________________________________________________
HTMLHeader()

FUNCTION DESCRIPTION:

     This function will spit out a generic HTML header which includes
the HTML constructs commonly present at the top of an HTML document.
______________________________________________________________________
REVISION HISTORY:
     Author:  Dean Collins                      Date: 6/95
______________________________________________________________________
*/

void
HTMLHeader(FILE *fp,
           char *title,
           char *header,
           char *refresh)

     /* Interface description:
         INPUT:
          fp		- File ptr. of where to print the header to.
	  title		- String for <TITLE> HTML construct.
	  header	- String for an <H1> HTML header at top of screen.
	  refresh	- String specifying a value for Netscape's
			  dynamic-documents construct.  (A value of 600 would
			  be indicated by the string "600".)  A value
			  of NULL should be given if no refresh is desired.
			  If a Refresh value is specified and the user
			  is using Netscape 1.1 or better the document
			  specified number of seconds.  This can be useful
			  for documents that change.
         OUTPUT:
          None.
         RETURN VALUE:
          None.
     */
{
     /* Internal variables: */

          /* Major */
	  /* NONE  */
          /* Minor */
	  /* NONE  */

   /*----------------- Start of HTMLHeader() routine ------------------*/

	fprintf (fp, "<HTML>%c", 10) ;
	fprintf (fp, "<HEAD>%c", 10) ;
	fprintf (fp, "<TITLE>%s</TITLE>%c", title, 10) ;

	/* Tell Netscape-based viewers to refresh this page after 10 minutes
	 * (HTML_REFRESH seconds [typically 600]).
	 */
	if (strlen(refresh) > 0)
		fprintf (fp, "<META HTTP-EQUIV=\"Refresh\" CONTENT=%s>%c", refresh, 10);

	fprintf (fp, "</HEAD>%c", 10) ;
	fprintf (fp, "<BODY BACKGROUND=\"%s/%s\">%c%c", IMAGES, BGIMAGE, 10, 10) ;
	fprintf (fp, "<H1>%s</H1>%c", header, 10) ;
	fprintf (fp, "<IMG SRC=\"%s/%s\"%c", IMAGES, LINEIMAGE1, 10) ;
	fprintf (fp, "  ALT=\"----------------------------------------------------------------------\">%c", 10) ;
	fprintf (fp, "<P>%c", 10) ;
	fprintf (fp, "%c", 10) ;

}  /*--------------------- End of HTMLHeader() ------------------------*/




/*
______________________________________________________________________
HTMLFooter()

FUNCTION DESCRIPTION:
     This function will spit out a generic HTML footer which includes
the HTML constructs commonly present at the bottom of an HTML document.
______________________________________________________________________
REVISION HISTORY:
     Author:  Dean Collins                      Date:  6/95
______________________________________________________________________
*/


void
HTMLFooter(FILE *fp)

     /* Interface description:
         INPUT:
          fp		- File ptr. of where to print the header to.
         OUTPUT:
          None.
         RETURN VALUE:
          None.
     */

{
     /* Internal variables: */
          /* Major */
          /* NONE  */
          /* Minor */
          /* NONE  */


   /*------------------ Start of HTMLFooter() routine -------------------*/

	fprintf (fp, "%c", 10) ;
	fprintf (fp, "<P>%c", 10) ;
	fprintf (fp, "<IMG SRC=\"%s/%s\"%c", IMAGES, LINEIMAGE1, 10) ;
	fprintf (fp, "  ALT=\"----------------------------------------------------------------------\">%c", 10) ;
	fprintf (fp, "<BR>%c", 10) ;

	fprintf (fp, "<ADDRESS>%c", 10) ;
	fprintf (fp, "<IMG SRC=\"%s/%s\" ALT=\" \">%c", IMAGES, ZOMBIERIMAGE, 10) ;

	fprintf (fp, "<EM>") ;
	fprintf (fp, OWNER_NAME) ;
	fprintf (fp, ", <A HREF=\"mailto:") ;
	fprintf (fp, OWNER_EMAIL) ;
	fprintf (fp, "\">") ;
	fprintf (fp, OWNER_EMAIL) ;
	fprintf (fp, "</A>") ;
	fprintf (fp, "</EM>%c", 10) ;

	fprintf (fp, "<IMG SRC=\"%s/%s\" ALT=\" \">%c", IMAGES, ZOMBIEIMAGE, 10) ;
	fprintf (fp, "</ADDRESS>%c", 10) ;

	fprintf (fp, "</BODY>%c", 10) ;
	fprintf (fp, "</HTML>%c", 10) ;

}  /*--------------------- End of HTMLFooter() ------------------------*/




/*
______________________________________________________________________
PostQuery()

FUNCTION DESCRIPTION:
     This function handles a POST type of CGI query.  It prints
the necessary MIME header and reads in the user-supplied values.
______________________________________________________________________
REVISION HISTORY:
     Author:  Dean Collins                      Date:  6/95
	This function is inspired by the post-query.c sample
	available at: file://ftp.ncsa.uiuc.edu/Web/httpd/Unix/ncsa_httpd/cgi/cgi-src/post-query.c
______________________________________________________________________
*/

int
PostQuery(FILE       *fp,
          post_entry  entries[],
          int         max_entries)

     /* Interface description:
         INPUT:
          fp		-- File pointer to spew output to.
	  entries	-- An array of name/value pairs to fill up.
	  max_entries	-- The maximum number of name/value pairs to be read.
         OUTPUT:
          None.
         RETURN VALUE:
          int		-- Number of name/value pairs read in.
     */

{
     /* Internal variables: */
          /* Major */
   int count=0 ;	/* Number of entries found */
   int len=0 ;		/* Value of CONTENT_LENGTH */

          /* Minor */
          /* NONE  */


   /*--------------- Start of PostQuery() routine ----------------*/

   zdebug("Entering PostQuery()...\n") ;

   fprintf(fp, "Content-type: text/html%c%c", 10, 10) ;

   if (strcmp (getenv ("REQUEST_METHOD"), "POST"))
   {
      zdebug("REQUEST_METHOD is not POST.  Not good...\n") ;
      fprintf (fp, "This script should be referenced with a METHOD of%c", 10) ;
      fprintf (fp, "POST. If you don't understand this, see this%c", 10) ;
      fprintf (fp, "<A HREF=\"http://www.ncsa.uiuc.edu/SDG/Software/Mosaic/Docs/fill-out-forms/overview.html\">forms overview</A>.%c", 10) ;
      exit (1);
   }
   zdebug("REQUEST_METHOD is \"POST\".   Good!\n") ;

   if (strcmp (getenv ("CONTENT_TYPE"), "application/x-www-form-urlencoded"))
   {
      zdebug("CONTENT_TYPE is NOT \"application/x-www-form-urlencoded\".  ") ;
      zdebug("Not good...\n") ;
      fprintf(fp, "This script can only be used to decode form results.%c",10) ;
      exit(1);
   }
   zdebug("CONTENT_TYPE is \"application/x-www-form-urlencoded\".  Good!\n") ;

   len = atoi (getenv ("CONTENT_LENGTH")) ;
   zdebug1("CONTENT_LENGTH is %d\n", len) ;

   while (!feof(stdin) && len != 0 && count < max_entries)
   { 
      entries[count].value = fmakeword (stdin, '&', &len) ;
      zdebug1("PostQuery: value1 = '%s'\n", entries[count].value) ;

      plustospace (entries[count].value) ;
      zdebug1("PostQuery: value2 = '%s'\n", entries[count].value) ;

      unescape_url (entries[count].value) ;
      zdebug1("PostQuery: value3 = '%s'\n", entries[count].value) ;

      entries[count].name = makeword(entries[count].value, '=') ;
      zdebug1("%d:\n", count) ;
      zdebug2("\t%s = %s\n", entries[count].name, entries[count].value) ;

      ++count ;
   }

   if (count >= max_entries)
   {  zdebug("WARNING:  PostQuery() found the maximum number of name/value pairs.\n") ;
      zdebug("          Increase MAX_ENTRIES to avoid grief.\n\n") ;
   }


   zdebug1("Leaving PostQuery with %d name/value pairs.\n\n", count) ;
   return (count) ;

}  /*--------------------- End of PostQuery() -------------------*/




/*
______________________________________________________________________
GetQuery()

FUNCTION DESCRIPTION:
     This function handles a GET type of CGI query.  It prints
the necessary MIME header and reads in the user-supplied values.
______________________________________________________________________
REVISION HISTORY:
     Author:  Dean Collins                      Date:  6/95
        This function is inspired by the query.c sample
        available at: file://ftp.ncsa.uiuc.edu/Web/httpd/Unix/ncsa_httpd/cgi/cgi-src/query.c
______________________________________________________________________
*/

int
GetQuery (FILE      *fp,
          get_entry  entries[],
	  int        max_entries)

     /* Interface description:
         INPUT:
          fp		-- File pointer to spew output to.
          entries	-- An array of name/value pairs to fill up.
	  max_entries	-- The maximum number of name/value pairs to be read.
         OUTPUT:
          None.
         RETURN VALUE:
          int		-- Number of name/value pairs read in.
     */

{
     /* Internal variables: */
          /* Major */
   int count=0 ;	/* Number of entries found */
   char *str=NULL ;	/* The information from the user to decode */

          /* Minor */
          /* NONE  */


   /*--------------- Start of GetQuery() routine ----------------*/

   zdebug("Entering PostQuery()...\n") ;

   printf ("Content-type: text/html%c%c", 10, 10) ;

   if (strcmp (getenv ("REQUEST_METHOD"), "GET"))
   {
      zdebug("REQUEST_METHOD is not GET.  Not good...\n") ;
      fprintf (fp, "This script should be referenced with a METHOD of%c", 10) ;
      fprintf (fp, "GET.  If you don't understand this, see this%c", 10) ;
      fprintf (fp, "<A HREF=\"http://www.ncsa.uiuc.edu/SDG/Software/Mosaic/Docs/fill-out-forms/overview.html\">forms overview</A>.%c", 10) ;
      exit (1);
   }
   zdebug("REQUEST_METHOD is \"GET\".   Good!\n") ;

   str = getenv("QUERY_STRING") ;
   if (str == NULL)
   {
      zdebug("Ack!  str was NULL!\n") ;
      printf("No query information to decode.\n");
      exit(1);
   }
   zdebug1("QUERY_STRING is \"%s\"\n", str) ;

   while (str[0] && count < max_entries)
   {
      getword (entries[count].value, str, '&') ;
      zdebug1("GetQuery: value1 = '%s'\n", entries[count].value) ;

      plustospace (entries[count].value) ;
      zdebug1("GetQuery: value2 = '%s'\n", entries[count].value) ;

      unescape_url (entries[count].value) ;
      zdebug1("GetQuery: value3 = '%s'\n", entries[count].value) ;

      getword (entries[count].name, entries[count].value, '=') ;
      zdebug1("%d:\n", count) ;
      zdebug2("\t%s = %s\n", entries[count].name, entries[count].value) ;

      ++count ;
   }

   if (count >= max_entries)
   {  zdebug("WARNING:  GetQuery() found the maximum number of name/value pairs.\n") ;
      zdebug("          Increase MAX_ENTRIES to avoid grief.\n\n") ;
   }

   zdebug1("Leaving GetQuery with %d name/value pairs.\n\n", count) ;
   return (count) ;

}  /*--------------------- End of GetQuery() -------------------*/


/* End of html.c */
