/*
 * pts-append2.c -- PTS CGI utility to process a form for appending
 *                  an entry to the problem log.
 */

/*
 * Copyright (c) 1995 Dean Collins.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation free of charge for any purpose is hereby granted without
 * fee, provided that the above copyright notices appear in all copies and
 * that both those copyright notices and this permission notice appear in
 * supporting documentation, and that the name of Dean Collins not
 * be used in advertising or publicity pertaining to distribution of
 * the software without specific, written prior permission.  Dean Collins
 * makes no representations about the suitability of this software for
 * any purpose.  It is provided "as is" without express or implied warranty.
 *
 * DEAN COLLINS DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS.
 * IN NO EVENT SHALL DEAN COLLINS BE LIABLE FOR ANY SPECIAL, INDIRECT
 * OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */

#include <sys/types.h>
#include <stdlib.h>             /* General C utilities header file */
#include <stdio.h>              /* Standard input/output utilities hdr. file */
#include <errno.h>		/* Error utilities header file */
#include <sys/param.h>          /* System parameters header file */
#include "pts.h"
#include "zdbm.h"               /* Zombie Database Manager header file */
#include "cloud.h"              /* Nebulous Cloud header file */
#include "clouderror.h"         /* Nebulous Cloud error rtn. header file */
#include "config.h"             /* Config. file parser header file */
#include "patchlevel.h"         /* For version info. */
#include "html.h"		/* A couple of HTML-related routines */



/******************** MODULES *************************************/

/*
______________________________________________________________________
main()

FUNCTION DESCRIPTION:

     This function is the main routine for this program.
______________________________________________________________________
REVISION HISTORY:
     Author:  Dean Collins                      Date: 6/95
______________________________________________________________________
*/

int
main (int   argc,
      char *argv[])

     /* Interface description:
         INPUT:
          argc  - The number of command-line arguments.
          argv  - An array of command-line arguments.
         OUTPUT:
          None.
         RETURN VALUE:
          int   - Status flag.  Non-zero is error.
     */
{
     /* Internal variables: */

          /* Major */
    post_entry entries[MAX_ENTRIES] ;
    int count=0 ;
    char *path=NULL ;
    char *prid=NULL ;
    char *email=NULL ;
    char *fullname=NULL ;
    char *text=NULL ;
    char *ttext=NULL ;
    problem_record *problem=NULL ;
    char *full_log=NULL ;
    char info[256] ;
    int timeval=0 ;

          /* Minor */
    int x=0 ;


   /*----------------- Start of main() routine ------------------*/

#   ifdef DEBUG
    freopen ("/tmp/debug", "w", stderr) ;
    setbuf(stderr,NULL) ;
    setbuf(stdout,NULL) ;
    zdebug1("Debug output for: %s\n\n", argv[0]) ;
#   endif

    count = PostQuery (stdout, entries, MAX_ENTRIES) ;

    for(x=0; x < count; x++)
    {  if (strcmp("type",     entries[x].name) == 0)	path     = entries[x].value ;
       if (strcmp("prid",     entries[x].name) == 0)	prid     = entries[x].value ;
       if (strcmp("email",    entries[x].name) == 0)	email    = entries[x].value ;
       if (strcmp("fullname", entries[x].name) == 0)	fullname = entries[x].value ;
       if (strcmp("text",     entries[x].name) == 0)	text     = entries[x].value ;
    }


        /* Desc. seems to get "^M" characters in it, so nuke them.... */
    if (text)
    {   ttext = malloc(strlen(text)+1) ;
        for (x=0; x<strlen(text); ++x)
        {   if (text[x] == '\r')
                 ttext[x] = ' ' ;
            else ttext[x] = text[x] ;
        }
        text = ttext ;
    }

    HTMLHeader (stdout, "Problem Tracking System", "Append Problem", "") ;

    printf("Problem type: %s<BR>%c", path, 10) ;
    printf("Problem ID: %s<BR>%c", prid, 10) ;
    printf("E-mail address: %s<BR>%c", email, 10) ;
    printf("Text: %s<P>%c", text, 10) ;

	/* Are any of the required fields empty??? */
    if ( ! (strlen(path) && strlen(prid) && strlen(email) && strlen(fullname) && strlen(text)))
    {
	printf ("ERROR reporting the problem again:<P>%c",10) ;
	printf ("Not all required fields were provided.<P>%c", 10) ;
    }
    else
    {  if (LockProblemPRID(path,prid))
       {   /* OK, we've got sole write access to the problem, so let's
	    * retrieve the existing log so we can play with it.
            */
/*ZDBM*/    problem=get_problem(path,prid,PARTICULAR,0,LINKS,FULLRECORD);

	   /* Now append the new log entry to the existing log */
	   full_log = malloc(strlen(problem->log_file) + strlen(text) + 500) ;
	   strcpy (full_log, problem->log_file) ;
	   strcat (full_log, LOG_ENTRY_STR) ;
	   timeval=time(0) ;
	   sprintf(info,"%s   %s (%s)\n", ctime((time_t *)&timeval), email, fullname);
	   strcat (full_log, info) ;
	   strcat (full_log, text) ;

	   /* Now write the new log & unlock problem */
	   if (AppendProblemPRID(path,prid,email,full_log))
	   {
	       printf ("Your log entry was successfully added for this problem.%c", 10) ;
	       printf ("<P>%c", 10) ;
	       printf ("<I>NOTE:  There will be a short delay before your log entry appears %c", 10) ;
	       printf ("in the problem log shown in the Web page for this problem.</I><P>%c", 10) ;
	   }
	   else
           {
	      printf ("ERROR adding a log entry:<P>%c",10) ;
/*CLD*/       printf ("<PRE>%s</PRE><P>%c", CloudStrerror(), 10) ;
           }
	   free (full_log) ;
       }
       else
       {
	    printf ("ERROR adding a log entry:<P>%c",10) ;
/*CLD*/     printf ("<PRE>%s</PRE><P>%c", CloudStrerror(), 10) ;
       }
    }

    HTMLFooter(stdout) ;

}  /*--------------------- End of main() ------------------------*/



/*
______________________________________________________________________
AppendProblemPRID()

FUNCTION DESCRIPTION:

     This function is used to append a log entry to a problem log.
This is similar in purpose to AppendProblem() in The Cloud, it just
take a different argument list.
______________________________________________________________________
REVISION HISTORY:
     Author:  Dean Collins                      Date: 6/95
______________________________________________________________________
*/

int
AppendProblemPRID(char *path,
                  char *prid,
                  char *email,
                  char *text)

     /* Interface description:
         INPUT:
          path  - The path (node) in the problem tree where the problem is.
          prid  - The problem ID for the problem to update.
          email - The e-mail address of the person adding to the log.
          text  - The new text to append to the log.
         OUTPUT:
          None.
         RETURN VALUE:
          int   - Status flag.  True on success, False on failure.
     */
{
     /* Internal variables: */

          /* Major */
	int res;
	char newpath[DBPATHLEN];

          /* Minor */
          /* NONE  */

   /*-------------- Start of AppendProblemPRID() routine ---------------*/

	cld_errno=0;

	strcpy(newpath,FixPath(path));

	zdebug1("AppendProblemPRID() - newpath = %s\n",newpath);

	res=edit_log(newpath,prid,text,END,0,NULL);

	zdebug1("AppendProblemPRID() - res = %d\n",res);

	if(!res)
	{
		cld_errno=CLD_ERR33;
		return(False);
	}
	else
		return(True);

}  /*------------------ End of AppendProblemPRID() ---------------------*/



/*
______________________________________________________________________
LockProblemPRID()

FUNCTION DESCRIPTION:

     This function is used to lock a problem in the database.
This is similar in purpose to LockProblemPRID() in The Cloud, it just
take a different argument list.
______________________________________________________________________
REVISION HISTORY:
     Author:  Dean Collins                      Date: 6/95
______________________________________________________________________
*/

int
LockProblemPRID(char *path,
                char *prid)

     /* Interface description:
         INPUT:
          path  - The path (node) in the problem tree where the problem is.
          prid  - The problem ID for the problem to update.
         OUTPUT:
          None.
         RETURN VALUE:
          int   - Status flag.  True on success, False on failure.
     */
{
     /* Internal variables: */

          /* Major */
	int res;
	char newpath[DBPATHLEN];

          /* Minor */
          /* NONE  */

   /*----------------- Start of LockProblemPRID() routine ------------------*/

        cld_errno=0;

        zdebug1("The path at beginning of LockProblemPRID() = %s\n",path);

        strcpy(newpath,FixPath(path));

        zdebug1(" In LockProblemPRID() - newpath = %s\n",newpath);

/*ZDBM*/res=edit_log(newpath,prid,NULL,START,0,NULL);

        if(!res)
        {
                cld_errno=CLD_ERR16;
                return(False);
        }
        else
                return(True);

}  /*--------------------- End of LockProblemPRID() ------------------------*/


/* end of pts-append2.c */

