/*
 * pts-repagain.c -- PTS CGI utility to generate a form for reporting
 *                   a problem again.
 */

/*
 * Copyright (c) 1995 Dean Collins.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation free of charge for any purpose is hereby granted without
 * fee, provided that the above copyright notices appear in all copies and
 * that both those copyright notices and this permission notice appear in
 * supporting documentation, and that the name of Dean Collins not
 * be used in advertising or publicity pertaining to distribution of
 * the software without specific, written prior permission.  Dean Collins
 * makes no representations about the suitability of this software for
 * any purpose.  It is provided "as is" without express or implied warranty.
 *
 * DEAN COLLINS DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS.
 * IN NO EVENT SHALL DEAN COLLINS BE LIABLE FOR ANY SPECIAL, INDIRECT
 * OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */

#include <sys/types.h>
#include <stdlib.h>             /* General C utilities header file */
#include <stdio.h>              /* Standard input/output utilities hdr. file */
#include <sys/param.h>          /* System parameters header file */
#include "pts.h"
#include "zdbm.h"               /* Zombie Database Manager header file */
#include "cloud.h"              /* Nebulous Cloud header file */
#include "clouderror.h"         /* Nebulous Cloud error rtn. header file */
#include "config.h"             /* Config. file parser header file */
#include "patchlevel.h"         /* For version info. */
#include "html.h"		/* A couple of HTML-related routines */


/******************** MODULES *************************************/

/*
______________________________________________________________________
main()

FUNCTION DESCRIPTION:

     This function is the main routine for this program.
______________________________________________________________________
REVISION HISTORY:
     Author:  Dean Collins                      Date: 6/95
______________________________________________________________________
*/

int
main(int   argc,
     char *argv[])

     /* Interface description:
         INPUT:
          argc  - The number of command-line arguments.
          argv  - An array of command-line arguments.
         OUTPUT:
          None.
         RETURN VALUE:
          int   - Status flag.  Non-zero is error.
     */
{
     /* Internal variables: */

          /* Major */
    get_entry entries[MAX_ENTRIES] ;
    int count=0 ;
    char *Path=NULL ;
    char *PRID=NULL ;

          /* Minor */
    int x=0 ;

   /*----------------- Start of main() routine ------------------*/

#   ifdef DEBUG
    freopen ("/tmp/debug", "w", stderr) ;
    zdebug1("Debug output for: %s\n\n", argv[0]) ;
#   endif

    count = GetQuery (stdout, entries, MAX_ENTRIES) ;

    for(x=0; x < count; x++)
    {  if (strcmp("type", entries[x].name) == 0)  Path = entries[x].value ;
       if (strcmp("prid", entries[x].name) == 0)  PRID = entries[x].value ;
    }

    HTMLHeader (stdout, "Problem Tracking System", "Report Problem Again", "") ;

    printf("To add yourself to the list of reporters for this problem, %c",10) ;
    printf("enter the information requested below.%c",10) ;
    printf("You would do this if you are experiencing the same problem, %c",10) ;
    printf("and would like to be notified when and/or how it is solved.<P>%c",10) ;
    printf("<HR>%c",10) ;

    printf("%c",10) ;
    printf("<FORM METHOD=\"POST\" ACTION=\"%s/pts-repagain2\">%c", CGIBIN_URL, 10) ;
    printf("%c",10) ;
    printf("Your e-mail address:%c",10) ;
    printf("<BR>%c",10) ;
    printf("<INPUT SIZE=50 NAME=\"email\"><P>%c",10) ;
    printf("%c",10) ;
    printf("The host the problem occured on:%c",10) ;
    printf("<BR>%c",10) ;
    printf("<INPUT SIZE=50 NAME=\"node\"><P>%c",10) ;
    printf("<P>%c",10) ;

    printf ("<INPUT TYPE=\"hidden\" NAME=\"type\" VALUE=\"%s\">%c", Path, 10) ;
    printf ("<INPUT TYPE=\"hidden\" NAME=\"prid\" VALUE=\"%s\">%c", PRID, 10) ;

    printf("<INPUT TYPE=\"submit\" VALUE=\"Submit\">%c",10) ;
    printf("<INPUT TYPE=\"reset\" VALUE=\"Clear Form\">%c",10) ;

    printf("<P>%c",10) ;
    printf("%c",10) ;
    printf("</FORM>%c",10) ;

    HTMLFooter (stdout) ;

    exit (0) ;

}  /*--------------------- End of main() ------------------------*/


/* end of pts-repagain.c */

