/*
 * activate.c -- Button activation routines for the X user interface
 *               to the Problem Tracking System (PTS) database.
 *
 * Author:	Dean Collins 
 * created:	Fri Apr 24 10:10:58 PDT 1992
 * Version 1.0:	Sat Jan  9 10:20:51 PST 1993
 */

/*
 * Copyright (c) 1995,1994,1993,1992 Dean Collins.
 * Copyright (c) 1992 University of Idaho, Moscow, Idaho.
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation free of charge for any purpose is hereby granted without
 * fee, provided that the above copyright notices appear in all copies and
 * that both those copyright notices and this permission notice appear in
 * supporting documentation, and that neither the name of the University of
 * Idaho nor the name of Dean Collins be used in advertising or publicity
 * pertaining to distribution of the software without specific, written
 * prior permission from both parties.  Neither The University of Idaho
 * nor Dean Collins make any representations about the suitability of
 * this software for any purpose.  It is provided "as is" without express
 * or implied warranty.
 * 
 * THE UNIVERSITY OF IDAHO AND DEAN COLLINS DISCLAIM ALL WARRANTIES WITH
 * REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS.  IN NO EVENT SHALL THE UNIVERSITY OF IDAHO
 * OR DEAN COLLINS BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
 * PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF
 * THIS SOFTWARE.
 */

#include <stdlib.h>		/* General C utilities header file */
#include <stdio.h>		/* Standard input/output utilities hdr. file */

#include <X11/Intrinsic.h>	/* Include standard Toolkit Header file. */
#include <X11/StringDefs.h>	/* Include StringDefs header file */
#include <X11/Shell.h>		/* Include the Shell header file for popups */

#include <X11/Xaw/AsciiText.h>	/* Include the ascii Text widget hdr. file */
#include <X11/Xaw/Box.h>	/* Include the Box widget header file */
#include <X11/Xaw/Command.h>	/* Include the Command widget header file */
#include <X11/Xaw/Dialog.h>	/* Include the Dialog widget header file */
#include <X11/Xaw/Form.h>	/* Include the Form widget header file */
#include <X11/Xaw/List.h>	/* Include the List widget header file */
#include <X11/Xaw/Paned.h>	/* Include the Paned widget header file */
#include <X11/Xaw/Viewport.h>	/* Include the Viewport widget header file */

#include <X11/Xaw/Cardinals.h>	/* Definitions of ZERO, ONE, etc... */

#include "zdbm.h"		/* Zombie Database Manager header file */
#include "cloud.h"		/* Nebulous Cloud header file */
#include "clouderror.h"		/* Nebulous Cloud error rtn. header file */
#include "xpts.h"		/* Xpts header file */


extern bool NoQuit ;		/* True if user started PTS in "no-quit" mode, */
				/* false otherwise. */

      /* The current problem record.  This ideally would
       * be part of a new widget.  The widget would have the
       * resources listed in ProblemType.  It would have functions
       * to display, read and write the problem.
       * Next version, maybe...
       */
extern problem_record * ProblemRecord ;

      /* The current list of problem summaries.  Similar
       * comment to that above.
       */
extern String *SummaryItems ;

        /* The problem types tree. */
extern ProblemTree *ProbTree ;

        /* Information about the user. */
extern UserInfo UserInfoRec ;

        /* The path for the problem types tree. */
extern char Path[] ;

extern char Node[] ;

extern char ProblemText[] ;

extern String *ProblemItems ;

/* The following string will be displayed by the "About PTS" button
 * on the Main Menu: 
 */
extern /*const*/ char PTSInfoText[] ;

extern Summary *CloudUnSummaries ;
extern Summary *CloudSummaries ;


/******************** MODULES *************************************/
/*
______________________________________________________________________
MainMenuActivate()

FUNCTION DESCRIPTION:

     This function will determine which main menu item was selected and create
the corresponding popup.
______________________________________________________________________
REVISION HISTORY:
     Author:  Dean Collins			Date:  2/21/92
     Version 1.0 finalized: Dean Collins	Date:  1/9/93
______________________________________________________________________
*/


void
MainMenuActivate(Widget		w,
		XtPointer	client_data,
		XtPointer	call_data)

     /* Interface description:
         INPUT:
          w		- The widget for which this callback is registered.
          client_data	- Specifies arbitrary client-supplied data
                           that the widget w should pass back to the
                           client when the widget executes the client's
                           callback procedure.  In this callback, 
                           this is the parent of the created popup.
          call_data	- Specifies any callback-specific data the widget w
                           wants to pass to the client.  In this callback,
                           this is a pointer to a record containing
                           information about the list selection.
         OUTPUT:
          None.
         RETURN VALUE:
          None.
     */
{
     /* Internal variables: */
          /* Major */
   XawListReturnStruct *item ;  /* Pointer to structure containing info. */
                                /* about the list, such as which list item */
                                /* was selected. */
   Widget parent ;
          /* Minor */
          /* NONE */



   /*------------ Start of MainMenuActivate() routine ----------------------*/
#ifdef DEBUG
   printf("XPTS(activate.c): Entering MainMenuActivate()\n") ;
#endif

   XawListUnhighlight(w) ; /* Unhighlight the selected item. */
   parent = (Widget) client_data ;

     /* Initialize item to point to the structure pointed to
      * by the call_data pointer. 
      */
   item = (XawListReturnStruct *) call_data ;

     /* Call the correct function for selected item item->list_index.
      * The first list item is index 0.
      */
    switch (item->list_index)
    {
       case 0:  PickProblemPopup(w, parent) ;		break ; 
       case 1:  PickProblemPopup(w, parent) ;		break ;
       case 2:  ShowAllUnsolvedPopup(w, parent) ;	break ;
       case 3:  SysopMenuPopup(w, parent) ;		break ;
    }

#ifdef DEBUG
   printf("XPTS(activate.c): Leaving MainMenuActivate()\n") ;
#endif

}  /*--------------------- End of MainMenuActivate() ------------------------*/


/*
______________________________________________________________________
PickProblemActivate()

FUNCTION DESCRIPTION:

     This function will allow the user to select a sub-type of the current
problem type.  Selecting a sub-type which contains no further sub-types causes
a list of problem summaries for that sub-type to be displayed.
______________________________________________________________________
REVISION HISTORY:
     Author:  Dean Collins			Date:  2/21/92
     Version 1.0 finalized: Dean Collins	Date:  1/9/93
______________________________________________________________________
*/


void
PickProblemActivate(Widget	w,
		XtPointer	client_data,
		XtPointer	call_data)

     /* Interface description:
         INPUT:
          w		- The widget for which this callback is registered.
          client_data	- Specifies arbitrary client-supplied data
                           that the widget w should pass back to the
                           client when the widget executes the client's
                           callback procedure.  In this callback, 
                           this is an array of information to be
                           passed to ChangeList().  It is defined in
			   the following manner:
	                        client_data[0] = list widget
       	                    	client_data[1] = dialog widget
                           	client_data[2] = parent widget
                           	client_data[3] = quitButton widget
                           	client_data[4] = previousButton widget
                           	client_data[5] = newProblem widget
                           	client_data[6] = pickProblem popup widget

          call_data	- Specifies any callback-specific data the widget w
                           wants to pass to the client.  In this callback,
                           this is a pointer to a record containing
                           information about the list selection.
         OUTPUT:
          None.
         RETURN VALUE:
          None.
     */
      
{
     /* Internal variables: */
          /* Major */
      XawListReturnStruct *item ;	/* Pointer to structure containing
					 * info. about the list, such as which
					 * list item was selected.
					 */
      Widget previousButton, quitButton ;
   int selected_item ;

          /* Minor */
   XtPointer *ptrlist ;

   /*------------ Start of PickProblemActivate() routine -------------*/
#ifdef DEBUG
   printf("XPTS(activate.c): Entering PickProblemActivate()\n") ;
/*   printf("XPTS(activate.c): setting widget to be insensitive\n") ;*/
   printf("\tclient_data=%p\n"
          "\tclient_data[0]=%p\n"
          "\tclient_data[1]=%p\n"
          "\tclient_data[2]=%p\n"
          "\tclient_data[3]=%p\n"
          "\tclient_data[4]=%p\n"
          "\tclient_data[5]=%p\n"
          "\tclient_data[6]=%p\n",
          client_data,
	  ((XtPointer *)client_data)[0],
          ((XtPointer *)client_data)[1],
	  ((XtPointer *)client_data)[2],
	  ((XtPointer *)client_data)[3],
	  ((XtPointer *)client_data)[4],
	  ((XtPointer *)client_data)[5],
	  ((XtPointer *)client_data)[6]) ;

#endif
/*   XtSetSensitive(w,False) ;*/

   previousButton = (Widget) (((XtPointer *)client_data)[4]) ;
   quitButton     = (Widget) (((XtPointer *)client_data)[3]) ;

#ifdef DEBUG
printf("XPTS(activate.c): managing previousButton, unmanaging quitButton\n") ;
#endif
   XtManageChild (previousButton) ;
   XtUnmanageChild (quitButton) ;

     /* Determine which problem type was selected using the index
      * of the list item selected. 
      */
   item =  (XawListReturnStruct *) call_data ;
   selected_item=item->list_index ;

     /* Use ChangeList() to change the list to that problem type. */
   ChangeList(Path, selected_item, INC_TYPE, client_data) ;
/*
#ifdef DEBUG
   printf("XPTS(activate.c): setting widget to be sensitive again.\n") ;
#endif
   XtSetSensitive(w,True) ;
*/
#ifdef DEBUG
   printf("XPTS(activate.c): Leaving PickProblemActivate()\n") ;
#endif
}  /*---------------- End of PickProblemActivate() -------------------*/


/*
______________________________________________________________________
SysopMenuActivate()

FUNCTION DESCRIPTION:

     This function will determine which sysop menu item was selected and
create the corresponding popup.
______________________________________________________________________
REVISION HISTORY:
     Author:  Dean Collins			Date:  2/25/92
     Version 1.0 finalized: Dean Collins	Date:  1/9/93
______________________________________________________________________
*/


void
SysopMenuActivate(Widget	w,
		XtPointer	client_data,
		XtPointer	call_data)

     /* Interface description:
         INPUT:
          w		- The widget for which this callback is registered.
          client_data 	- Specifies arbitrary client-supplied data
                           that the widget w should pass back to the
                           client when the widget executes the client's
                           callback procedure.  In this callback, 
                           this is the parent of the created popup.
          call_data	- Specifies any callback-specific data the widget w
                           wants to pass to the client.  In this callback,
                           this is a pointer to a record containing
                           information about the list selection.
         OUTPUT:
          None.
         RETURN VALUE:
          None.
     */
{
     /* Internal variables: */
          /* Major */
   XawListReturnStruct *item ;	/* Pointer to structure containing info. 
				 * about the list, such as which list item 
				 * was selected.
				 */
   Widget parent ;
          /* Minor */
          /* NONE */



   /*----------------- Start of SysopMenuActivate() routine -------------*/
#ifdef DEBUG
   printf("XPTS(activate.c): Entering SysopMenuActivate()\n") ;
#endif


     /* Make sure only sysops are executing this function. */
   if (!IsSysop(&UserInfoRec)) 
   { 
#ifdef DEBUG
        fprintf(stderr,
   "XPTS(activate.c): Illegal access to SysopMenuActivate() by non-sysop.\n") ;
#endif
     return ;
   }

   XawListUnhighlight(w) ; /* Unhighlight the selected item. */
   parent = (Widget) client_data ;

     /* Initialize item to point to the structure pointed to
      * by the call_data pointer. 
      */
   item = (XawListReturnStruct *) call_data ;

     /* Call the correct function for selected item item->list_index.
      * The first list item is index 0.
      */
   switch (item->list_index)
   {
      case 0:  ShowAllUnsolvedPopup(w, parent) ; 	break ; 
      case 1:  EditMOTDPopup(w, parent) ; 		break ;
      case 2:  PickProblemPopup(w, parent) ; 		break ;
   }

#ifdef DEBUG
   printf("XPTS(activate.c): Leaving SysopMenuActivate()\n") ;
#endif

}  /*--------------------- End of SysopMenuActivate() -------------------*/


/*
______________________________________________________________________
ViewProblemActivate()

FUNCTION DESCRIPTION:

     This function will determine which problem was selected by the user and
display the full problem log for that problem.   A callback will be added to
allow the user to reopen the problem if it is solved or a callback will be
added to allow the user to add their name to the list of reporters if it is
unsolved.   If the user is a sysop, callbacks will also be added to allow the
sysop to add to the problem dialog for unsolved problems or solve unsolved
problems.
______________________________________________________________________
REVISION HISTORY:
     Author:  Dean Collins			Date:  2/21/92
     Version 1.0 finalized: Dean Collins	Date:  1/9/93
______________________________________________________________________
*/


void
ViewProblemActivate(Widget	w,
		XtPointer	client_data,
		XtPointer	call_data)

     /* Interface description:
         INPUT:
          w		- The widget for which this callback is registered.
          client_data	- Specifies arbitrary client-supplied data
                           that the widget w should pass back to the
                           client when the widget executes the client's
                           callback procedure.  In this callback, 
                           this is an array like this:
			     client_data[0] - the parent of the created popup.
			     client_data[1] - a flag, with the values:
				UNSOLVEDPROB: Read a problem from the 
						unsolved list.
				ANYPROB: Read a problem from the general
						problem list.

          call_data	- Specifies any callback-specific data the widget w
                           wants to pass to the client.  In this callback,
                           this is a pointer to a record containing
                           information about the list selection.
 
         OUTPUT:
          None. 
         RETURN VALUE:
          None.
     */
      
{
     /* Internal variables: */
          /* Major */
   XawListReturnStruct *item ;	/* A ptr. to a record provided by 
				 * the widget w.
				 */
   Widget parent ;
   Widget probViewer ;
   Widget type=NULL ;		/* The problem type dialog box. */
   Widget summary=NULL ;	/* The problem summary dialog box. */
   Widget priority=NULL ;	/* The problem priority dialog box. */
   Widget text, edit ;

          /* Minor */
   Arg args[3] ;
   XtPointer *ptrlist ;
   int flag ;
   char errorstr[1000] ;
   static char tmppath[DBPATHLEN+1] ;
   Widget tmpwidget ;



   /*----------- Start of ViewProblemActivate() routine -----------------*/
#ifdef DEBUG
   printf("XPTS(activate.c): Entering ViewProblemActivate()\n") ;
#endif

   ptrlist = (XtPointer *)client_data ;
   parent = (Widget) (ptrlist[0]) ;
   flag = (int) (ptrlist[1]) ;
#ifdef DEBUG
   printf("XPTS(activate.c): ViewProblemActivate() flag = %d\n", flag) ;
   printf("XPTS(activate.c): Setting parent to be not sensitive.\n") ;
#endif
   XtSetSensitive(parent,False) ;


   XawListUnhighlight(w) ; /* Unhighlight the selected item. */


   ProblemRecord = NULL ;

   if (flag == UNSOLVEDPROB)
   {
     /* Set item to equal (XawListReturnStruct *)call_data. */
   item = (XawListReturnStruct *) call_data ;

     /* Determine which list item caused this callback to
      * be called, using item->list_index as the index.
      * Read the corresponding problem from the database using
      * ReadUnsolved().  ReadUnsolved() is like ReadProblem(), except
      * it takes the pointer to the linked list that the cloud generated
      * called CloudUnSummaries and uses it to determine the Path.
      */
#ifdef DEBUG
      printf("XPTS(activate.c): Calling ReadUnsolved()\n") ;
#endif
/*CLD*/  ProblemRecord = ReadUnsolved(ProbTree, Path, CloudUnSummaries,
					item->list_index) ;
   }
   else if (flag == ANYPROB)
   {
     /* Determine which list item caused this callback to
      * be called, using item->list_index as the index.
      * Read the corresponding problem from the database using
      * ReadProblem().
      */
#ifdef DEBUG
      printf("XPTS(activate.c): Calling ReadProblem()...\n") ;
#endif
/*CLD*/  ProblemRecord = ReadProblem(ProbTree, Path, (int)call_data, CloudSummaries) ;
#ifdef DEBUG
      printf("XPTS(activate.c): Returned from ReadProblem()...\n") ;
#endif
   }
#ifdef DEBUG
   else printf("XPTS(activate.c): Uh-oh!  flag was not valid! \n") ;
#endif
   
   if (ProblemRecord == NULL)
   {  sprintf(errorstr, "Error reading problem!\n\nPossible error cause:\n%s\n",
/*CLD*/		CloudStrerror()) ;
              ErrorPopup("error", parent, errorstr) ;
      return ;
   }

   strcpy (ProblemText,FormatProblem(ProblemRecord,Path)) ;
   if (ProblemText == NULL)
   {  sprintf(errorstr,
                "Error formating problem!\n\nPossible error cause:\n%s\n",
/*CLD*/         CloudStrerror()) ;
              ErrorPopup("error", parent, errorstr) ;
      return ;
   }

     /* Use ProblemViewerPopup() to create the popup for
      * viewing the problem.
      */
#ifdef DEBUG
   printf("XPTS(activate.c): Creating a ProblemViewerPopup with a parent of %p\n", parent) ;
#endif
   ProblemViewerPopup("probViewer", &probViewer, parent, 
                      &type, &summary, &priority, &text, &edit) ;

     /* Set the value of the text widget for the problem viewer. */
   XtSetArg(args[0], XtNtype, XawAsciiString) ;
   XtSetArg(args[1], XtNstring, ProblemText) ;
   XtSetValues(text, args, TWO) ;
/* For now, set the value of ProblemRecord.log_file to be ProblemText. */
/*strcpy (ProblemRecord.log_file, ProblemText) ;*/


     /* Set the values of each of the problem viewer fields. */

	/* The problem type */
   strcpy(tmppath, FixPath(Path)) ;
   XtVaGetValues(type, XtNtextSource, &tmpwidget, NULL) ;
   XtVaSetValues(tmpwidget,
		XtNstring,      tmppath,
		XtNtype,        XawAsciiString,
		NULL) ;

        /* The problem summary*/
   XtVaGetValues(summary, XtNtextSource, &tmpwidget, NULL) ;
   XtVaSetValues(tmpwidget,
		XtNstring,      ProblemRecord->short_description,
		XtNtype,        XawAsciiString,
		NULL) ;


        /* The problem priority */
   SetPriorityValue(priority, ProblemRecord->priority) ;


     /* Realize the popup. */
#ifdef DEBUG
   printf("XPTS(activate.c): about to popup the problem viewer.\n") ;
#endif
   XtPopup(probViewer, XtGrabExclusive) ;
#ifdef DEBUG
   printf("XPTS(activate.c): about to popdown the parent. parent=%p\n",parent) ;
#endif
#ifdef DEBUG
   printf("XPTS(activate.c): Leaving ViewProblemActivate()\n") ; 
#endif

}  /*--------------- End of ViewProblemActivate() -----------------------*/

/* end of activate.c */
