/*
 * macros.h -- X interface to the Problem Tracking System (PTS) database.
 * Dean Collins -- Tue Mar 24 12:39:39 PST 1992
 *
 * Modified: Dean Collins 11/95
 * Added SetPriorityValue macro.
 *
 * Modified: Dean Collins Sat May 13 11:04:49 PDT 1995
 * Modified SetPriorityValue.
 */

/*
 * Copyright (c) 1995,1994,1993,1992 Dean Collins.
 * Copyright (c) 1992 University of Idaho, Moscow, Idaho.
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation free of charge for any purpose is hereby granted without
 * fee, provided that the above copyright notices appear in all copies and
 * that both those copyright notices and this permission notice appear in
 * supporting documentation, and that neither the name of the University of
 * Idaho nor the name of Dean Collins be used in advertising or publicity
 * pertaining to distribution of the software without specific, written
 * prior permission from both parties.  Neither The University of Idaho
 * nor Dean Collins make any representations about the suitability of
 * this software for any purpose.  It is provided "as is" without express
 * or implied warranty.
 * 
 * THE UNIVERSITY OF IDAHO AND DEAN COLLINS DISCLAIM ALL WARRANTIES WITH
 * REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS.  IN NO EVENT SHALL THE UNIVERSITY OF IDAHO
 * OR DEAN COLLINS BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
 * PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF
 * THIS SOFTWARE.
 */


/* NoticePopup() -- This function is for important notices that the user
 * 		    should be informed about, and that they need to 
 *		    acknowledge.  It is basically the same as the ErrorPopup().
 *		    The only difference comes from the X resources.
 */
#define NoticePopup(n,p,m) ErrorPopup(n,p,m)


/* Raisewidget() -- This function raises the specified widget so that it
 *		    is in front of all other windows.  It will not de-iconify
 *		    a widget in order to display it, (yet).
 */
#define RaiseWidget(w) XRaiseWindow(XtDisplay(w),XtWindow(w))


/* forever() -- A cute little thang... */
#define forever() while(1)


/* SetPriorityValue(w,sc) -- This sets the label for the priority widget w
 *			     to be the signed character sc.
/*			     NOTE:  It seems that setting the label resets
 *			     the size to be minimum, so setting width and
 *			     height is unfortunatly required.
 */
#define SetPriorityValue(w,sc)			\
	w ? XtVaSetValues(w,			\
                XtNlabel,       sctoa(sc),	\
                XtNwidth,       5,		\
                XtNheight,      45,		\
                NULL) : 0


/* end of macros.h */

