/*
 * xpts.c -- X user interface to the Problem Tracking System (PTS) database.
 * Dean Collins 
 * created: Tue Mar 24 11:35:18 PST 1992
 */

/*
 * Copyright (c) 1995,1994,1993,1992 Dean Collins.
 * Copyright (c) 1992 University of Idaho, Moscow, Idaho.
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation free of charge for any purpose is hereby granted without
 * fee, provided that the above copyright notices appear in all copies and
 * that both those copyright notices and this permission notice appear in
 * supporting documentation, and that neither the name of the University of
 * Idaho nor the name of Dean Collins be used in advertising or publicity
 * pertaining to distribution of the software without specific, written
 * prior permission from both parties.  Neither The University of Idaho
 * nor Dean Collins make any representations about the suitability of
 * this software for any purpose.  It is provided "as is" without express
 * or implied warranty.
 * 
 * THE UNIVERSITY OF IDAHO AND DEAN COLLINS DISCLAIM ALL WARRANTIES WITH
 * REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS.  IN NO EVENT SHALL THE UNIVERSITY OF IDAHO
 * OR DEAN COLLINS BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
 * PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF
 * THIS SOFTWARE.
 *
 * Modified: Dean Collins, Fri May 20 16:52:22 1994
 * Set the effective user-id to be the user's "real" uid during call to
 * XtAppInitialize(), which is trying to access "~/.Xauthority" if you're
 * using xauth.  Unfortunatly, since xpts is normally installed set-uid,
 * X ends up examining the wrong .Xauthority file.  By default this is
 * turned on.  You can turn this back off by defining -DNO_XAUTH in OS_DEFINES.
 *
 * Modified: Dean Collins, Sun May 22 00:22:09 1994
 * Added NOSETEUID hack since HP-UX doesn't have seteuid(), which is needed
 * for the .Xauthority fix above.  Define this if seteuid is not defined
 * on your system.  Hopefully setuid() works in it's place.  If not,
 * define NO_XAUTH and avoid the whole blasted thing.
 *
 * Modified: Dean Collins, Wed Jun 15 21:40:53 1994
 * Well, apparently you're supposed to use setreuid() on HP-UX to do the
 * above, so I've made the requested changes.  Use SETEUID(), which should
 * be defined as the correct function automagically (in ../util/util.h).
 * Removed NOSETEUID and test for __hppa instead.
 *
 * Modified: Dean Collins Wed Nov 16 12:27:50 PST 1994
 * Added Priority variable.
 *
 * Modified: Dean Collins Tue Nov 22 16:20:08 PST 1994
 * Enable Editres usage.  This should not be necessary under X11R5 or
 * later, but since HP-UX ships with an X11R4 libXaw.a, this seems
 * to be necessary.  Enabled by setting DEBUG and ALLOW_EDITRES.
 */

#include <stdlib.h>             /* General C utilities header file */
#include <stdio.h>		/* Standard input/output utilities hdr. file */
#include <sys/param.h>          /* System parameters header file */

#include <X11/Intrinsic.h>      /* Include standard Toolkit Header file. */
#include <X11/StringDefs.h>     /* Include StringDefs header file */
#include <X11/Shell.h>          /* Include the Shell header file for popups */

#include <X11/Xaw/AsciiText.h>  /* Include the ascii Text widget hdr. file */
#include <X11/Xaw/Box.h>        /* Include the Box widget header file */
#include <X11/Xaw/Command.h>    /* Include the Command widget header file */
#include <X11/Xaw/Dialog.h>     /* Include the Dialog widget header file */
#include <X11/Xaw/Form.h>       /* Include the Form widget header file */
#include <X11/Xaw/List.h>       /* Include the List widget header file */
#include <X11/Xaw/Paned.h>      /* Include the Paned widget header file */
#include <X11/Xaw/Viewport.h>   /* Include the Viewport widget header file */

#include <X11/Xaw/Cardinals.h>  /* Definitions of ZERO, ONE, etc... */

/* Allow Editres to work.  Should not be necessary on most systems, I think.*/
#if defined(DEBUG) && defined(ALLOW_EDITRES)
#include <X11/Editres/Editres.h>
#endif


#include "zdbm.h"               /* Zombie Database Manager header file */
#include "cloud.h"		/* Nebulous Cloud header file */
#include "clouderror.h"         /* Nebulous Cloud error rtn. header file */
#include "config.h"             /* Config. file parser header file */
#include "xpts.h"               /* Xpts header file */
#include "resources.h"          /* Default X resource values */


char CopyrightString[]=COPYRIGHT ;

bool NoQuit = FALSE ;		/* True if user started PTS in "no-quit" mode, */
				/* false otherwise. */

      /* The current problem record.  This ideally would
       * be part of a new widget.  The widget would have the
       * resources listed in ProblemType.  It would have functions
       * to display, read and write the problem.
       * Next version, (_maybe_...definatly won't be easy)
       */
problem_record * ProblemRecord ;

String *SummaryItems=NULL ;


	/* The problem types tree. */
ProblemTree *ProbTree ;

	/* Information about the user. */
UserInfo UserInfoRec ;

	/* The current path for the problem types tree. */
char Path[DBPATHLEN+1] = ROOTSTR ;
char ProblemText[MAXTEXT+1] ;
char Node[MAXHOSTNAMELEN+1] ;
/*signed char Priority=DEF_PRIORITY ; /* Added 11/16/94 DC*/


String *ProblemItems=NULL ;

Summary *CloudUnSummaries = NULL ;
Summary *CloudSummaries = NULL ;


Widget GlobalMainMenuWidget=NULL ; 
Widget GlobalNewProblemButton=NULL ;
Widget GlobalPreviousButton=NULL ;

int WarningFlag=FALSE ;


/* The following string will be displayed by the "About PTS" button
 * on the Main Menu:
 */
const char PTSInfoText[] = PTS_INFO_STR ;


/******************** MODULES *************************************/
/*
______________________________________________________________________
main()

FUNCTION DESCRIPTION:

     This function is the PTS main routine.  It will initialize the
user-interface and call the X11 event loop.  If PTS is started in "no-quit"
mode, the sleep button is realized, otherwise the main menu is realized. 
Callbacks are created to switch to/from the sleep icon and to exit the PTS
application.  After realizing either the sleep button or the main menu, the
X Toolkit event loop is called, which never returns.
______________________________________________________________________
UNIT TESTING:
     This function will be tested by using a combination of white-box and
black-box tests.
______________________________________________________________________
REVISION HISTORY:
     Author:  Dean Collins      Date:  3/24/92
______________________________________________________________________
*/


int
main(int   argc,
     char *argv[])

     /* Interface description:
         INPUT:
          argc  - Number of command line arguments, including command itself.
          argv  - An array of command-line arguments.
         OUTPUT:
          None.
         RETURN VALUE:
          int   - Zero if successful completion, non-zero otherwise.
     */
      
{
     /* Internal variables: */
          /* Major */
   XtAppContext app_con ;      /* The PTS application context */
   Widget topLevel ;           /* The ancestor widget of all PTS widgets. */
   Widget mainMenu=NULL ;      /* The main menu widget. */
   Widget list=NULL ;          /* The main menu list of selections */
   Widget buttonBox=NULL ;     /* Container for command buttons */
   Widget quitButton=NULL ;    /* Used to quit PTS, either completely or  */
                               /* to the icon box.                        */
   Widget helpButton=NULL ;    /* Used to display the PTS help screen. */
   Widget infoButton=NULL ;    /* Used to display the PTS information screen. */
   Widget sleepPopup=NULL ;    /* The sleep-button popup widget (contains the */
			       /*  button) */
   Widget sleepButton=NULL ;   /* The sleep-button widget */

   static String MainMenuItems1[] = { /* for sysop users */
       "    Report a Problem ",
       "    View a Problem ",
       "    Show All Unsolved Problems ",
       "    Sysop Menu ",
       NULL
   } ;

   static String MainMenuItems2[] = { /* for non-sysop users */
       "    Report a Problem ",
       "    View a Problem ",
       "    Show All Unsolved Problems ",
       NULL
   } ;

   static XrmOptionDescRec options[] = {
   {"-label", "*wintitle.label", XrmoptionSepArg, NULL}
   } ;


   static XtActionsRec actionTable[] = {
	{"NoOp", (XtActionProc)NoOp},
   } ;


          /* Minor */
   XtPointer *client_data ;
   int n ;
   char logstr[80] ;
   int timeval=0 ;
   FILE *fp ;

#  ifndef NO_XAUTH
   int initial_uid ;
   int initial_euid ;
#  endif /* NO_XAUTH */

   /*---------------------- Start of main() routine -----------------------*/

#ifdef DEBUG
     /* This makes stdout not be buffered.  This is so stdout and stderr
      * keep in synch.
      */
   setbuf(stdout,NULL) ;
#endif /* DEBUG */

   fprintf(stderr, "\n%s By %s\n%s\nInternet e-mail:  %s\nCompiled:  %s, %s\n",
	   Version(), Authors(), Copyright(), AuthorsEmail(),
           CompileDate(), CompileTime()) ;

#ifdef DEBUG
   printf("XPTS(xpts.c): Beginning spew...\n") ;
#endif

   /* If user is root (or xpts is installed as set-uid "root"), EXIT!
    * SEE THE COMMENTS IN defines.h THAT ELABORATE ON THIS.
    * DO NOT DISABLE THIS.  DO NOT RUN XPTS AS ROOT.
    * DO NOT PASS "GO".  DO NOT COLLECT $200.
    */
   if (geteuid() == 0)
   {  fprintf(stderr,NO_ROOTUSERS) ;
      exit(1) ;
   }

     /* Try to change to the sysop group.  If we're a member of the group,
      * even if it's not our primary group, this should work.
      */
/*This doesn't work.  Only root can setegid() ?
   if (setegid(SYSOPGID))
	fprintf(stderr, "(non-sysop version)\n") ;
   else fprintf(stderr, "(sysop version)\n") ;
*/


#ifndef NOSIGNALS
   InitSignalHandler() ;     /* Initialize the signal handler. */
#endif /* NOSIGNALS */


#  ifndef NO_XAUTH
	/* set euid to user's "real" uid so that Xlib can access
	 * "~/.Xauthority" during XtAppInitialize().  This is needed since
	 * xpts is normally installed set-uid support.
	 */
   initial_uid = getuid() ;
   initial_euid = geteuid() ;
   SETEUID(initial_uid) ;
#  endif /* NO_XAUTH */


     /* Initialize the application using XtAppInitialize().  Give the
      * application the name "Xpts" for resource gathering.  Use the
      * fallback_resources in case the app-defaults file hasn't been
      * installed.
      */
   topLevel = XtAppInitialize(&app_con, "Xpts",
                              options, XtNumber(options),
                              (&argc), argv,
			      fallback_resources,
                              NULL, ZERO) ;

#if defined(DEBUG) && defined(ALLOW_EDITRES)
   XtAddEventHandler(toplevel,
	(EventMask) 0, True, _XEditResCheckMessages, NULL) ;
#endif



#  ifndef NO_XAUTH
   SETEUID(initial_euid) ;	/* restore the euid we got from the suid bit */
   if (geteuid() != initial_euid) {
       fprintf(stderr,"Fatal PTS startup error (geteuid() != initial_euid)!\n") ;
       fprintf(stderr,"Try rebuilding PTS using -DNO_XAUTH\n") ;
       exit (1) ;
   }
#  endif /* NO_XAUTH */


     /*Ok, so I don't know how to use XrmOptionDescRec yet... So sue me. :-)*/
   for (n=0; n<argc; n++)
   {   if (strcmp(argv[n], "-noquit") == 0)
       {  NoQuit = TRUE ;
          argc-- ;
	  n=argc ;
       }
   }

     /* Explain command-line syntax using Syntax(), which doesn't return,
      * if there's a command-line error. XtAppInitialize() automatically
      * extracts all the options it understands, so if any are left,
      * there may have been an error.
      */

   if (argc != 1)
      Syntax(app_con, argv[0]) ;

     /* Get information about the user and read the problem hierarchy. */
#ifdef DEBUG
   printf("XPTS(xpts.c): calling Setup()...\n") ;
#endif
/*CLD*/   if (Setup(&UserInfoRec, &ProbTree) == False)
   {  fprintf(stderr, "Error in configuration file %s !\n", CONFIGFILE) ;
      exit(1) ;
   }
#ifdef DEBUG
   printf("XPTS(xpts.c): returned from Setup()...\n") ;
   printf("XPTS(xpts.c):\tUserInfoRec.sysopflag = %d\n", UserInfoRec.sysopflag) ;
   printf("XPTS(xpts.c):\tUserInfoRec.username  = %s\n", UserInfoRec.username) ;
   printf("XPTS(xpts.c):\tUserInfoRec.realname  = %s\n", UserInfoRec.realname) ;
#endif

#ifdef USERLOG
     /* Keep a log of who is using xpts.  This is optional and undocumented. */
   timeval=time(0) ;
   sprintf(logstr, "%s (%s) %s", UserInfoRec.username, UserInfoRec.realname,
           ctime(&timeval)) ;
  if (fp = fopen(LOGFILE, "a"))
  {  fprintf(fp, "%s", logstr) ;
     fclose(fp) ;
  }
#endif



     /* Add application actions using XtAppAddActions() */
   XtAppAddActions(app_con, actionTable, ONE) ;
   

     /* Create the main menu widget using ListPopup(), making the list have
      * only one column. 
      */
   ListPopup("mainMenu", ONE, &mainMenu, topLevel, &list, &buttonBox,
	     &quitButton) ;
   GlobalMainMenuWidget=mainMenu ;

   if (IsSysop(&UserInfoRec))
	XawListChange(list, MainMenuItems1, ZERO, ZERO, TRUE) ;
   else XawListChange(list, MainMenuItems2, ZERO, ZERO, TRUE) ;

     /* Add a help button to the mainMenu's buttonBox widget.
      * Add a callback for the helpButton widget that calls HelpPopup() with
      * mainMenu in it's argument list.  This callback will create a text widget
      * containing the general help file when the helpButton is selected.
      */
   helpButton = XtCreateManagedWidget("helpButton", commandWidgetClass,
				      buttonBox, NULL, ZERO) ;
   XtAddCallback(helpButton, XtNcallback, HelpPopup, (XtPointer)mainMenu) ;

     /* Add an info button to the mainMenu's buttonBox widget.
      * Add a callback for the infoButton widget that calls InfoPopup() with
      * mainMenu in it's argument list.  This callback will create a text widget
      * containing the PTS info file.
      */
   infoButton = XtCreateManagedWidget("infoButton", commandWidgetClass,
				      buttonBox, NULL, ZERO) ;
   XtAddCallback(infoButton, XtNcallback, InfoPopup, mainMenu) ;

     /* Create the sleep button widget using ButtonPopup(). */
   ButtonPopup("sleepPopup", &sleepPopup, topLevel, &sleepButton) ;

     /* Add a callback for the list widget that calls MainMenuActivate() with
      * client_data equal to mainMenu.
      */
   XtAddCallback(list, XtNcallback, MainMenuActivate, mainMenu) ;

     /* Add a callback  for the quitButton widget that calls
      * QuitMainMenuSelect() with an argument list containing the widgets
      * app_con, mainMenu and sleepPopup.  This callback will unmanage
      * the mainMenu widget and manage the sleepPopup widget if "no-quit"
      * mode was selected, otherwise it will exit the application.
      */
   client_data = (XtPointer *)XtCalloc(3, sizeof(XtPointer)) ;
   client_data[0] = (XtPointer)app_con ;
   client_data[1] = (XtPointer)mainMenu ;
   client_data[2] = (XtPointer)sleepPopup ;
   XtAddCallback(quitButton, XtNcallback, QuitMainMenuSelect,
                 (XtPointer)client_data) ;

     /* Add a callback  for the sleepButton widget that calls
      * SleepButtonSelect() with an argument list containing the widgets
      * topLevel, mainMenu and sleepPopup.  This callback will unmanage
      * the sleepPopup widget and manage the mainMenu widget.
      */
   XtAddCallback(sleepButton, XtNcallback, SleepButtonSelect,
                 (XtPointer)client_data) ;

     /* If "no-quit" mode was selected, pop-up the sleep button,
      * otherwise, pop-up the main menu widget.
      */
   if (NoQuit) XtPopup(sleepPopup, XtGrabNone) ;
   else        XtPopup(mainMenu, XtGrabNone) ;

#ifdef DEBUG
#ifdef DO_STARTUP_NOTICE
   if (NoQuit) NoticePopup("notice", sleepPopup, STARTUP_NOTICE) ;
   else        NoticePopup("notice", mainMenu, STARTUP_NOTICE) ;
#endif
#endif

     /* Set up the X Error Handlers. */
   XSetIOErrorHandler(PTS_XIOErrorHandler) ;
   XSetErrorHandler(PTS_XErrorHandler) ;

     /* Now process the events and never return.
      */
   AppMainLoop(app_con) ;
/*   XtAppMainLoop(app_con) ;*/

}  /*-------------------------- End of main() -----------------------------*/

/* end of xpts.c */
