/*
 * xpts.h -- X interface to the Problem Tracking System (PTS) database.
 * Dean Collins -- Tue Mar 24 12:39:39 PST 1992
 */

/*
 * Copyright (c) 1995,1994,1993,1992 Dean Collins.
 * Copyright (c) 1992 University of Idaho, Moscow, Idaho.
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation free of charge for any purpose is hereby granted without
 * fee, provided that the above copyright notices appear in all copies and
 * that both those copyright notices and this permission notice appear in
 * supporting documentation, and that neither the name of the University of
 * Idaho nor the name of Dean Collins be used in advertising or publicity
 * pertaining to distribution of the software without specific, written
 * prior permission from both parties.  Neither The University of Idaho
 * nor Dean Collins make any representations about the suitability of
 * this software for any purpose.  It is provided "as is" without express
 * or implied warranty.
 * 
 * THE UNIVERSITY OF IDAHO AND DEAN COLLINS DISCLAIM ALL WARRANTIES WITH
 * REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS.  IN NO EVENT SHALL THE UNIVERSITY OF IDAHO
 * OR DEAN COLLINS BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
 * PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF
 * THIS SOFTWARE.
 */

#ifdef XPTS

#include "pts.h"
#include "patchlevel.h"
#include "copyright.h"
#include "defines.h"
#include "macros.h"
#include "util.h"


	/* TYPES */

      /* Pretty generic definitions, used in various places.
       */
typedef int bool ;


/* See signal.c for an explanation of NOSIGNALS */
#ifndef NOSIGNALS

typedef struct 
{  int count ;
   int signal ;
   int type ;   /* USERSIG=user interrupts, SYSSIG=system interrupts */
} SigType ;

#define USERSIG 1
#define SYSSIG 2

#endif /*NOSIGNALS*/



	/* Funtion prototypes */

/* activate.c */
void	ButtonActivate      (Widget w, XtPointer client_data, XtPointer call_data);
void	MainMenuActivate    (Widget w, XtPointer client_data, XtPointer call_data);
void	PickProblemActivate (Widget w, XtPointer client_data, XtPointer call_data);
void	SysopMenuActivate   (Widget w, XtPointer client_data, XtPointer call_data);
void	ViewProblemActivate (Widget w, XtPointer client_data, XtPointer call_data);

/* xpts.c */
int main(int argc, char *argv[]) ;

/* misc.c */
void	ChangeList(String type, int item, int flag, XtPointer client_data) ;
void	DoDeleteProblem(Widget w, XtPointer client_data, XtPointer call_data) ;
void	DoMoveProblem1 (Widget w, XtPointer client_data, XtPointer call_data) ;
void	DoMoveProblem2 (Widget w, XtPointer client_data, XtPointer call_data) ;
void	GotoProblemType(Widget w, XtPointer client_data, XtPointer call_data) ;
XtActionProc NoOp(void) ;
void	Syntax(XtAppContext app_con, char *call) ;
void	AllocProblemItems(void) ;
void	FreeItems(char **Items, int MaxItems) ;
void	AppMainLoop(XtAppContext app_con) ;
void    PrintNewProblemLabel(void) ;
int	LockedProblem(int newflag) ;
int	PTS_XIOErrorHandler(Display *display) ;
int	PTS_XErrorHandler(Display *dpy, XErrorEvent *event) ;
int	XPrintDefaultError(Display *dpy, XErrorEvent *event, FILE *fp) ;
int	ReadList(Widget popup, Widget probViewer) ;
void	ShutDownDB(int AllowPopups) ;
int	SuperWarningPopup(String name, Widget parent, String message) ;
int     SuperWarningTrue (Widget w, XtPointer client_data, XtPointer call_data);
int     SuperWarningFalse(Widget w, XtPointer client_data, XtPointer call_data);

/* popup.c */
void	ButtonPopup(String name, Widget *popupp, Widget parent, Widget *buttonp) ;
void    DestroyPopup(Widget w, XtPointer client_data, XtPointer call_data) ;
void    EditMOTDPopup(Widget w, Widget parent) ;
void	ErrorPopup(String name, Widget parent, String message) ;
void    HelpPopup(Widget w, XtPointer client_data, XtPointer call_data) ;
void    InfoPopup(Widget w, XtPointer client_data, XtPointer call_data) ;
void	ListPopup(String  name,
		  int     columns,
	          Widget *popupp,
		  Widget  parent,
		  Widget *listp,
	          Widget *buttonBoxp,
		  Widget *quitButtonp) ;
void    PickProblemPopup(Widget w, Widget parent) ;
void    ProblemEntryPopup(Widget w, XtPointer client_data, XtPointer call_data);
void	ProblemViewerPopup(String       name,
	                   Widget      *probViewerp,
	                   Widget       parent,
	                   Widget      *dialog1p,
	                   Widget      *dialog2p,
	                   Widget      *dialog3p,
	                   Widget      *textp,
	                   Widget      *editp) ;
void    ShowAllUnsolvedPopup(Widget w, Widget parent) ;
void	StringEntryPopup(String     name,
	                 Widget    *popupp,
	                 Widget     parent,
	                 String     prompt,
	                 XtPointer  successFunc) ;
void    SysopMenuPopup(Widget w, Widget parent) ;
void	ViewTextPopup(String     name,
	              Widget    *popupp,
	              Widget     parent,
	              Widget    *textp,
	              Widget    *buttonBoxp,
	              Widget    *quitButtonp) ;
void	WarningPopup(String     name,
	             Widget     parent,
	             String     message,
	             XtPointer  ok_func,
	             XtPointer  ok_client_data) ;

/* select.c */
void	AddProblemSelect    (Widget w, XtPointer client_data, XtPointer call_data) ;
void	CancelReopenSelect  (Widget w, XtPointer client_data, XtPointer call_data) ;
void	CancelSaveSelect    (Widget w, XtPointer client_data, XtPointer call_data) ;
void	DeleteProblemSelect (Widget w, XtPointer client_data, XtPointer call_data) ;
void	EditProblemSelect   (Widget w, XtPointer client_data, XtPointer call_data) ;
void	MoveProblemSelect   (Widget w, XtPointer client_data, XtPointer call_data) ;
void	PreviousMenuSelect  (Widget w, XtPointer client_data, XtPointer call_data) ;
void	PrintProblemSelect  (Widget w, XtPointer client_data, XtPointer call_data) ;
void	QuitMainMenuSelect  (Widget w, XtPointer client_data, XtPointer call_data) ;
void	ReopenAcceptSelect  (Widget w, XtPointer client_data, XtPointer call_data) ;
void	ReopenDenyCancelSelect(Widget w, XtPointer client_data, XtPointer call_data) ;
void	ReopenDenyMailSelect(Widget w, XtPointer client_data, XtPointer call_data) ;
void	ReopenDenySelect    (Widget w, XtPointer client_data, XtPointer call_data) ;
void	ReopenRequestSelect (Widget w, XtPointer client_data, XtPointer call_data) ;
void	ReopenSelect        (Widget w, XtPointer client_data, XtPointer call_data) ;
void	ReportAgainSelect   (Widget w, XtPointer client_data, XtPointer call_data) ;
void	SaveMOTDButtonSelect(Widget w, XtPointer client_data, XtPointer call_data) ;
void	SaveProblemSelect   (Widget w, XtPointer client_data, XtPointer call_data) ;
void	SleepButtonSelect   (Widget w, XtPointer client_data, XtPointer call_data) ;
void	SolveProblemSelect  (Widget w, XtPointer client_data, XtPointer call_data) ;
void	PriorityIncSelect   (Widget w, XtPointer client_data, XtPointer call_data) ;
void	PriorityDecSelect   (Widget w, XtPointer client_data, XtPointer call_data) ;

/* signal.c */
#ifndef NOSIGNALS
/* If your system requires that signal handlers be defined of a type
 * other than void, include -DSIGHANDLER=xxx in OS_DEFINES in ../Imake.config.
 * This is needed on some (all?) Linux versions, which require signal
 * handlers be of type __sighandler_t rather than void.
 */
#ifndef SIGHANDLER
#define SIGHANDLER void
#endif /*!SIGHANDLER*/
void	InitSignalHandler(void) ;
SIGHANDLER XSignalHandler(int Signal) ;
void	DoSignal(int Signal) ;
char	*signalstr(int Signal) ;
void	SuperErrorSelect (Widget w, XtPointer client_data, XtPointer call_data) ;
#endif /* NOSIGNALS */

/* xutil.h */
int	FileExists(char *fname) ;
int	IsWritable(char *fname) ;



#endif /* XPTS */

/* end of xpts.h */
