static char rcsid[] = "$Id: File.c,v 1.5 1995/05/10 09:11:08 richardo Exp $ (c) Richard M. Offer 1994,1995";

/*  Source for the FileSelector

    Copyright (c) Richard M. Offer 1994,1995

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


Although the GPL allows you to modify the code to your hearts content,
could you be polite and send me a copy of any changes (but not patches, my
code may have changed). If you are considering adding additional
features, you might me better contacting me to make sure I'm not one
step ahead of you :-)

richard.

*/


/* this is for the system directory manipulation functions */

#include <stdio.h>
#include <stdlib.h> /* for qsort */
#include <dirent.h>
#include <sys/stat.h>
#include <unistd.h>


#include <Rws/FileP.h>
#include <Xm/LabelG.h>
#include <Xm/List.h>
#include <Xm/TextF.h>
#include <Xm/Form.h>

#ifndef HAVE_MOTIF_1_1
#include <Xm/DrawP.h>	/* for boder/shadow drawing functions. */
#endif

#include <X11/StringDefs.h>

static void Initialize(
#if NeedFunctionPrototypes
                        Widget request_w,
                        Widget new_w,
                        ArgList args,
                        Cardinal *num_args
#endif
		       );

static void Destroy( 
#if NeedFunctionPrototypes
                        Widget wid
#endif
) ;

static void Redisplay (
#if NeedFunctionPrototypes
                        Widget w,
                        XEvent *event,
                        Region region
#endif
);

static Boolean SetValues (
#if NeedFunctionPrototypes
			  Widget old_w,
			  Widget request_w,
			  Widget new_w,
			  ArgList args,
			  Cardinal *num_args 
#endif
);


static XtGeometryResult GeometryManager (
#if NeedFunctionPrototypes 
					 Widget w,
					 XtWidgetGeometry *request,
					 XtWidgetGeometry *reply
#endif
					 );

static void ChangeManaged (
#if NeedFunctionPrototypes
			   Widget w
#endif
			   );

static XtGeometryResult QueryGeometry (
#if NeedFunctionPrototypes
				       Widget w,
				       XtWidgetGeometry *request,
				       XtWidgetGeometry *reply
#endif
				       );

static void updateFileList (
#if NeedFunctionPrototypes
			   Widget w
#endif
			   );

static int sortDir(
#if NeedFunctionPrototypes
		    _Xconst void	*s1,
		    _Xconst void	*s2
#endif
		    );


static void textfieldCB(
#if NeedFunctionPrototypes
			Widget		text,
			XtPointer	file_widget,
			XtPointer	call
#endif
			);


static void listCB(
#if NeedFunctionPrototypes
			Widget		text,
			XtPointer	file_widget,
			XmListCallbackStruct   *call
#endif
			);


static void Resize(
#if NeedFunctionPrototypes
		      Widget	w
#endif
		      );


static void doLayout(
#if NeedFunctionPrototypes
		      Widget	w
#endif
		      );
static void calcSize(
#if NeedFunctionPrototypes
		     Widget	w,
		     Dimension 	*width,
		     Dimension	*height
#endif
		      );



#define FILE_FONT "file-font"
#define DIR_FONT "dir-fonr"
#define MAX(a,b) ((a)>(b)?(a):(b))

static XtResource	resources[] = {
      { 
	    RwsNfileEntryFont,
	    XtCFont,
	    XtRFontStruct,
	    sizeof(XFontStruct *),
	    XtOffsetOf(RwsFileSelectorRec, file.file_font),
	    XmRString,
	    (XtPointer) "8x13",
      },
      { 
	    RwsNdirEntryFont,
	    XtCFont,
	    XtRFontStruct,
	    sizeof(XFontStruct *),
	    XtOffsetOf(RwsFileSelectorRec, file.dir_font),
	    XmRString,
	    (XtPointer) "8x13bold",
      },
      { 
	    RwsNfileSelectedCallback,
	    XmCCallback,
	    XmRCallback,
	    sizeof(XtCallbackList),
	    XtOffsetOf(RwsFileSelectorRec, file.file_selected_cb),
	    XmRImmediate,
	    (XtPointer) NULL,
      },
      { 
	    XmNeditable,
	    XmCEditable,
	    XmRBoolean,
	    sizeof(Boolean),
	    XtOffsetOf(RwsFileSelectorRec, file.editable),
	    XmRImmediate,
	    (XtPointer) True,
      },
      { 
	    RwsNcurrentDirectory,
	    RwsCCurrentDirectory,
	    XmRString,
	    sizeof(String),
	    XtOffsetOf(RwsFileSelectorRec, file.current_dir),
	    XmRImmediate,
	    (XtPointer) ".",
      },
      { 
	    RwsNnumDirEntriesVisible,
	    RwsCNumDirEntriesVisible,
	    XmRInt,
	    sizeof(int),
	    XtOffsetOf(RwsFileSelectorRec, file.num_dir_entries),
	    XmRImmediate,
	    (XtPointer) 5,
      },
      { 
	    RwsNautoOpenDirectories,
	    RwsCAutoOpenDirectories,
	    XmRBoolean,
	    sizeof(Boolean),
	    XtOffsetOf(RwsFileSelectorRec, file.auto_open_dirs),
	    XmRImmediate,
	    (XtPointer) True,
      },
/* override the manager-classes shadowthickness resource */
      { 
	    XmNshadowThickness,
	    XmCShadowThickness,
	    XmRHorizontalDimension,
	    sizeof(Dimension),
	    XtOffsetOf(RwsFileSelectorRec, manager.shadow_thickness),
	    XmRImmediate,
	    (XtPointer) 2,
      },
      { 
	    XmNshadowType,
	    XmCShadowType,
	    XmRShadowType,
	    sizeof(unsigned char),
	    XtOffsetOf(RwsFileSelectorRec, file.shadow_type),
	    XmRImmediate,
	    (XtPointer) XmSHADOW_ETCHED_IN,
      },

};


externaldef(rwsfileselectorclassrec) RwsFileSelectorClassRec rwsFileSelectorClassRec = 
{ 
  { /* Here is the Core class record. */ 
    /* superclass */                 (WidgetClass) &xmManagerClassRec, 
    /* class_name */                 "RwsFileSelector",
    /* widget_size */                sizeof(RwsFileSelectorRec),
    /* class_initialize */           NULL,
    /* class_part_initialize */      NULL, 
    /* class_inited */               FALSE,
    /* initialize */                 Initialize,
    /* initialize_hook */            NULL,
    /* realize */                    XtInheritRealize,
    /* actions */                    NULL,
    /* num_actions */                0,
    /* resources */                  resources,
    /* num_resources */              XtNumber(resources),
    /* xrm_class */                  NULLQUARK,
    /* compress_motion */            TRUE,
    /* compress_exposure */          XtExposeCompressMaximal,
    /* compress_enterleave */        TRUE,
    /* visible_interest */           FALSE,
    /* destroy */                    Destroy,
    /* resize */                     Resize,
    /* expose */                     Redisplay,
    /* set_values */                 SetValues,
    /* set_values_hook */            NULL,
    /* set_values_almost */          NULL,
    /* get_values_hook */            NULL,
    /* accept_focus */               NULL,
    /* version */                    XtVersion,
    /* callback_private */           NULL,
    /* tm_table */                   XtInheritTranslations,
    /* query_geometry */             QueryGeometry,
    /* display_accelerator */        NULL,
    /* extension */                  NULL,
  },    
  { /* Here is the Composite class record. */ 
    /* geometry_manager */           GeometryManager,
    /* change_managed */             ChangeManaged,
    /* insert_child */               XtInheritInsertChild,
    /* delete_child */               XtInheritDeleteChild,
    /* extension */                  NULL,
  },    
  { /* Here is the Constaint class record. */ 
    /* constraint_resources */       NULL,
    /* constraint_num_resources */   0,
    /* constraint_size */            0, 
    /* constraint_initialize */      NULL,
    /* constraint_destroy */         NULL,
    /* constraint_set_values */      NULL,
    /* extension */                  NULL,
  },    
  { /* Here is the XmManager class record. */ 
    /* translations */               XtInheritTranslations,
    /* syn_resources */              NULL,
    /* num_syn_resources */          0,
    /* syn_constraint_resources */   NULL,
    /* num_syn_constraint_resources */ 0,
    /* parent_process */             XmInheritParentProcess,
    /* extension */                  NULL,
  },    
  { /*  RwsFileSelector class record. */ 
    /* extension */                  NULL,
  }    
};

externaldef(rwsfileselectorwidgetclass) WidgetClass rwsFileSelectorWidgetClass =
    (WidgetClass) &rwsFileSelectorClassRec;



#if NeedFunctionPrototypes
static void Initialize( Widget request_w, Widget new_w, ArgList args, Cardinal *num_args)
#else
static void Initialize(request_w,new_w,args,num_args)
Widget request_w;
Widget new_w;
ArgList args;
Cardinal *num_args;
#endif
{

      RwsFileSelectorWidget	file = (RwsFileSelectorWidget) new_w;
      RwsFileSelectorWidget	request_file = (RwsFileSelectorWidget) request_w;
      Arg	largs[11];
      int	n;
      XmFontList	fontlist;
      char	wd[256];
      
      
      file->file.dir_label = XtVaCreateWidget(RwsFileSelectorCurrentDir,
					      xmLabelGadgetClass,
					      new_w,
					      XmNalignment, XmALIGNMENT_BEGINNING,
					      NULL);

      if ( file->file.editable) {
	    file->file.file_name = XtVaCreateWidget(RwsFileSelectorFileName,
						    xmTextFieldWidgetClass,
						    new_w,
						    XmNeditable, True,
						    NULL);

	    XtAddCallback(file->file.file_name,
			  XmNactivateCallback,
			  (XtCallbackProc) textfieldCB,
			  (XtPointer) new_w);
	    
      }
      else 
	  file->file.file_name = NULL;
  

      fontlist = XmFontListCreate(request_file->file.file_font,
				  FILE_FONT);
      if ( fontlist != NULL ) 
	    fontlist = XmFontListAdd(fontlist,
				     request_file->file.dir_font,
				     DIR_FONT);

      n=0;
      XtSetArg( largs[n], XmNselectionPolicy, XmBROWSE_SELECT );n++;
      XtSetArg( largs[n], XmNvisualPolicy, XmCONSTANT );n++;
      XtSetArg( largs[n], XmNscrollBarDisplayPolicy, XmSTATIC );n++;
      XtSetArg( largs[n], XmNvisibleItemCount, request_file->file.num_dir_entries );n++;

      if ( fontlist != NULL ) {
	    XtSetArg( largs[n], XmNfontList, fontlist );n++;
      }
      

      if ( file->file.file_name != NULL ) { 
	    XtSetArg( largs[n], XmNbottomAttachment, XmATTACH_WIDGET );n++;
	    XtSetArg( largs[n], XmNbottomWidget, file->file.file_name );n++;
      }
      else {
	    XtSetArg( largs[n], XmNbottomAttachment, XmATTACH_FORM );n++;
      }
      
      
      file->file.file_list = XmCreateScrolledList(new_w,
						  RwsFileSelectorFileList,
						  largs,
						  n);

      XtAddCallback(file->file.file_list,
		    XmNbrowseSelectionCallback,
		    (XtCallbackProc) listCB,
		    (XtPointer) file);

      XtAddCallback(file->file.file_list,
		    XmNdefaultActionCallback,
		    (XtCallbackProc) listCB,
		    (XtPointer) file);
      
      
      if ( fontlist != NULL ) 
	    XmFontListFree(fontlist);

      XtManageChild(file->file.file_list); 
      XtManageChild(file->file.dir_label); 

      if ( file->file.editable)
	    XtManageChild(file->file.file_name); 


      chdir(request_file->file.current_dir);
      getcwd( wd, sizeof(wd) );

      file->file.current_dir = XtNewString( wd );
      
      updateFileList( (Widget) file);
      
}


#if NeedFunctionPrototypes
static void Destroy( Widget request_w)
#else
static void Destroy(request_w)
Widget request_w;
#endif
{
      RwsFileSelectorWidget	file = (RwsFileSelectorWidget) request_w;

      XFreeFont(XtDisplay(request_w), file->file.file_font);
      
      XFreeFont(XtDisplay(request_w), file->file.dir_font);
}


#if NeedFunctionPrototypes
static void Redisplay( Widget w, XEvent *event, Region region)
#else
static void Redisplay(w,event,region)
Widget w;
XEvent *event; 
Region region;
#endif
{
      RwsFileSelectorWidget	file = (RwsFileSelectorWidget) w;


#ifdef HAVE_MOTIF_2

      XmeClearBorder(XtDisplay(w),
		     XtWindow(w),
		     0,0,
		     XtWidth(w),
		     XtHeight(w),
		     file->manager.shadow_thickness);
      
		   

      XmeDrawShadows(XtDisplay(w),
		     XtWindow(w),
		     file->manager.top_shadow_GC,
		     file->manager.bottom_shadow_GC,
		     0,0,
		     XtWidth(w),XtHeight(w),
		     file->manager.shadow_thickness,
		     file->file.shadow_type);

      XmeRedisplayGadgets( w, event, region) ;

#endif

#ifdef HAVE_MOTIF_1_2
      _XmClearBorder(XtDisplay(w),
		     XtWindow(w),
		     0,0,
		     XtWidth(w),
		     XtHeight(w),
		     file->manager.shadow_thickness);

      _XmDrawShadows(XtDisplay(w),
		   XtWindow(w),
		   file->manager.top_shadow_GC,
		   file->manager.bottom_shadow_GC,
		   0,0,
		   XtWidth(w),XtHeight(w),
		   file->manager.shadow_thickness,
		   file->file.shadow_type);

      _XmRedisplayGadgets( w, event, region) ;

#endif

#ifdef HAVE_MOTIF_1_1
	_XmClearShadowType(w,
			XtWidth(w),XtHeight(w),
			file->manager.shadow_thickness,
			0);

	_XmDrawShadwType(w,
			file->file.shadow_type,
			XtWidth(w),XtHeight(w),
			file->manager.shadow_thickness,
			0,
			file->manager.top_shadow_GC,
                   	file->manager.bottom_shadow_GC);

	_XmRedisplayGadgets( w, event, region) ;
#endif
                   
}


#if NeedFunctionPrototypes
static Boolean SetValues( Widget old_w, Widget request_w, Widget new_w, ArgList args, Cardinal *num_args)
#else
static Boolean SetValues(old_w, request_w,new_w,args,num_args)
Widget old_w;
Widget request_w;
Widget new_w;
ArgList args;
Cardinal *num_args;
#endif
{

      RwsFileSelectorWidget	old_file = (RwsFileSelectorWidget) old_w;
      RwsFileSelectorWidget	request_file = (RwsFileSelectorWidget) request_w;
      RwsFileSelectorWidget	new_file = (RwsFileSelectorWidget) new_w;
      char	wd[256];
      XmFontList	fontlist;
      
      

      if ( request_file->file.current_dir != old_file->file.current_dir ) {
	    if ( strcmp(request_file->file.current_dir, old_file->file.current_dir) ) {

		  chdir(request_file->file.current_dir);
		  getcwd( wd, sizeof(wd) );

		  new_file->file.current_dir = XtNewString( wd );

		  if ( new_file->file.editable )
			XtVaSetValues(new_file->file.file_name,
				      XmNvalue,NULL,
				      NULL);
		  

		  XtFree( old_file->file.current_dir );
	    }
	    else	
		  new_file->file.current_dir = request_file->file.current_dir;
	    
      }

      if (request_file->file.file_font != old_file->file.file_font || 
	  request_file->file.dir_font != old_file->file.dir_font ) {

	    fontlist = XmFontListCreate(request_file->file.file_font,
					FILE_FONT);
      
	    if ( fontlist != NULL ) {
		  fontlist = XmFontListAdd(fontlist,
					   request_file->file.dir_font,
					   DIR_FONT);
		  XtVaSetValues( request_file->file.file_list, XmNfontList, fontlist );

		  XmFontListFree(fontlist);

	    }

	    XFreeFont(XtDisplay(old_w), old_file->file.file_font);
      
	    XFreeFont(XtDisplay(old_w), old_file->file.dir_font);

      }
      else { 
	    new_file->file.file_font = request_file->file.file_font;
	    new_file->file.dir_font = request_file->file.dir_font;
      }
      
      updateFileList( (Widget) new_file);

      return (True);

}



#if NeedFunctionPrototypes
static XtGeometryResult GeometryManager (Widget child, XtWidgetGeometry *request, XtWidgetGeometry *reply)
#else
static XtGeometryResult GeometryManager (child, request, reply)
Widget child;  
XtWidgetGeometry *request;
XtWidgetGeometry *reply;
#endif
{

      XtWidgetGeometry	parent_req;
      XtGeometryResult	res;
      Dimension	cw,ch,cbw;
      Widget	file = XtParent(child);
      
      
      

      if ( (request->request_mode & CWX ) || ( request->request_mode & CWY) ) { 
	    return ( XtGeometryNo );
      }
      
/* store the current values of the child, just-in-case. */

      cw = XtWidth(child);
      ch = XtHeight(child);
      cbw = XtBorderWidth(child);
      
/* update the child */
      if ( request->request_mode & CWWidth ) 
	    XtWidth(child) = request->width;
      if ( request->request_mode & CWHeight ) 
	    XtHeight(child) = request->height;
      if ( request->request_mode & CWBorderWidth ) 
	    XtBorderWidth(child) = request->border_width;

/* make a request to the file width for the change in size */


      parent_req.width = 0;
      parent_req.height = 0;
      
      calcSize(file,&parent_req.width,&parent_req.height);
      

      parent_req.request_mode = CWWidth | CWHeight;
      
      if ( request->request_mode & XtCWQueryOnly )
	    parent_req.request_mode |= XtCWQueryOnly;
      
      res = XtMakeGeometryRequest(file,
				  &parent_req,
				  NULL );
      

/* ignore compromises */
      if ( res == XtGeometryAlmost ) {
	    res = XtGeometryNo;
      }
      
	    
/* restore the childs size as before */
      if ( res == XtGeometryNo || request->request_mode & XtCWQueryOnly ) {
	    
	    XtWidth(child) = cw;
	    XtHeight(child) = ch;
	    XtBorderWidth(child) = cbw;
      }
      else 
	    doLayout( file );

      return ( res ); 
      
}


#if NeedFunctionPrototypes
static void ChangeManaged( Widget request_w)
#else
static void ChangeManaged(request_w)
Widget request_w;
#endif
{

      Dimension	w,h;
      
      
      if ( ! XtIsRealized(request_w) ) { 
	    
	    w = XtWidth(request_w); 
	    
	    h = XtHeight(request_w);
      }
      else { 
	    w = 0;
	    h = 0;
      }
      
/* calc the ideal size of the widget */
      calcSize(request_w,&w,&h);
      

/* wait until we get either a yes or a no from our parent */
      while( XtMakeResizeRequest(request_w,w,h,&w,&h) == XtGeometryAlmost )
	    ;

/* we now have a parent agreed size, so layout the children */

      doLayout(request_w); 
      

#ifdef HAVE_MOTIF_2
      XmeNavigChangeManaged(request_w);
#else
      _XmNavigChangeManaged(request_w);
#endif

}

#if NeedFunctionPrototypes
static void calcSize(Widget widget, Dimension *width, Dimension *height)
#else
static void calcSize(widget, width,height)
Widget	widget;
Dimension	*width;
Dimension	*height;
#endif
{

      RwsFileSelectorWidget	file = (RwsFileSelectorWidget) widget;
      XtWidgetGeometry	preferred,want;
      Widget	list;
      Dimension	w=0,h=0;
      

      list = XtParent(file->file.file_list);


      XtQueryGeometry(file->file.dir_label,
		      NULL,
		      &preferred);
      
      h += preferred.height;
      w = MAX(preferred.width,w);
      
      
      if ( file->file.editable ) { 
	    XtQueryGeometry(file->file.file_name,
			    NULL,
			    &preferred);
	    
	    h += preferred.height;
	    w = MAX(preferred.width,w);

	    h += ( 2 * XtBorderWidth(file->file.file_name)) ;
	    
      }
      
      want.request_mode = CWHeight;
      want.height = XtHeight(widget) - h - 10;
      want.width = 0;
      

      XtQueryGeometry(file->file.file_list,
		      NULL,
		      &preferred);

      h += preferred.height;
      w = MAX(preferred.width,w);
	  
/* 4 is padding between children and frame */
 
      h += (2 * ( file->manager.shadow_thickness + 4 )) ;
      w += (2 * ( file->manager.shadow_thickness + 4 )) ;
 
/* only update if 0 is supplied */

      if ( ! *width )
	    *width = w;
      if ( ! *height )
	    *height = h;

      return;
      
      
}


#if NeedFunctionPrototypes
static XtGeometryResult QueryGeometry( Widget widget,XtWidgetGeometry *request, XtWidgetGeometry *reply)
#else
static XtGeometryResult QueryGeometry(widget, request, reply)
Widget widget;
XtWidgetGeometry *request;
XtWidgetGeometry *reply;
#endif
{

      if ( !XtIsRealized(widget) ) { 
	    
	    reply->width = XtWidth(widget);
	    reply->height = XtHeight(widget);

      }
      else { 
	    reply->width = 0;
	    reply->height = 0;
      }
      
      calcSize(widget, &reply->width,&reply->height);
      
#ifdef HAVE_MOTIF_2
      return XmeReplyToQueryGeometry(widget, request, reply) ;
#else

      reply->request_mode = CWWidth | CWHeight;

      return XtGeometryAlmost;
      
#endif
      
}

#if NeedFunctionPrototypes
static void doLayout( Widget widget)
#else
static void doLayout(widget)
Widget widget;
#endif
{
 
      RwsFileSelectorWidget	file = (RwsFileSelectorWidget) widget;

      Dimension	cw=0,ch=0;
      Position	x,y;
      Dimension	hspace,vspace,extra;
      Widget	list; 
      Dimension iw,ih,listh;

/* must use the parent of list (the scrolled window) for all size calcs */  
      list = XtParent(file->file.file_list);


/* internal sizes of the file widget */
      iw = XtWidth(widget) - ( 4* file->manager.shadow_thickness);	/* 4 != 2 => since I want a constant offset as left margin */
      ih = XtHeight(widget) - ( 2* file->manager.shadow_thickness);
      
    
/* first get the width/height of the children */

      ch += XtHeight(file->file.dir_label);
      cw = MAX(XtWidth(file->file.dir_label),cw);

      ch += XtHeight(list);
      cw = MAX(XtWidth(list),cw);

      if ( file->file.editable ) {
	    ch += XtHeight(file->file.file_name);
	    cw = MAX(XtWidth(file->file.file_name),cw);
      }

      if ( iw  > cw )
	    hspace = 2 * file->manager.shadow_thickness;
      else
	    hspace = file->manager.shadow_thickness;
      
      if ( ih  > ch ) {
	    vspace = (Dimension) (ih - ch) / 4;
	    extra = (Dimension) ((ih - ( ch + (2*vspace)) ) / (file->composite.num_children - 1));
      }
      else {
	    vspace = file->manager.shadow_thickness;
	    extra = 0;
      }
      
      
      x = hspace;
      y = vspace;


#ifdef HAVE_MOTIF_2
      XmeConfigureObject(file->file.dir_label,
			 x,y,
			 XtWidth(widget)-(hspace*2),
			 XtHeight(file->file.dir_label),
			 XtBorderWidth(file->file.dir_label));

#else
      
      _XmConfigureObject(file->file.dir_label,
			 x,y,
			 XtWidth(widget)-(hspace*2),
			 XtHeight(file->file.dir_label),
			 XtBorderWidth(file->file.dir_label));

#endif

      y += ( XtHeight(file->file.dir_label) + extra );
      
      listh = XtHeight(list);
      
/*       listh = iw - XtHeight(file->file.dir_label); 
      
      if ( file->file.editable ) 
	    listh -= ( XtHeight(file->file.file_name) + (2 * XtBorderWidth(file->file.file_name)));
*/

#ifdef HAVE_MOTIF_2
      XmeConfigureObject(list,
			 x,y,
			 XtWidth(widget)-(hspace*2),
			 listh,
			 XtBorderWidth(list));

#else
      
      
      _XmConfigureObject(list,
			 x,y,
			 XtWidth(widget)-(hspace*2),
			 listh,
			 XtBorderWidth(list));
#endif

      if ( file->file.editable ) { 
	    
	    y += listh;

#ifdef HAVE_MOTIF_2
	    XmeConfigureObject(file->file.file_name,
			       x,y,
			       XtWidth(widget)-(hspace*2),
			       XtHeight(file->file.file_name),
			       XtBorderWidth(file->file.file_name));

#else
      
	    _XmConfigureObject(file->file.file_name,
			       x,y,
			       XtWidth(widget)-(hspace*2),
			       XtHeight(file->file.file_name),
			       XtBorderWidth(file->file.file_name));
#endif
      }	    
      
}

#if NeedFunctionPrototypes
static void Resize( Widget widget)
#else
static void Resize(widget)
Widget widget;
#endif
{


      doLayout(widget);
      
}




#if NeedFunctionPrototypes
static void updateFileList( Widget w)
#else
static void updateFileList(w)
Widget w;
#endif
{

      DIR	*dir;
      struct dirent *entry;
      RwsFileSelectorWidget file = (RwsFileSelectorWidget) w;
      XmString	xmstr;
      char	path[256];
      struct stat buff;
      int	i,num_entries=0;
      char	**entries;
      

/* update the directory label */

      xmstr = XmStringCreateSimple(file->file.current_dir);
      
      XtVaSetValues(file->file.dir_label,
		    XmNlabelString, xmstr,
		    NULL);
      
      XmStringFree(xmstr);

/* delete all the entries in the list */

      XmListDeleteAllItems(file->file.file_list);
      
      dir = opendir(file->file.current_dir);
      
      if ( dir == NULL )
	    perror("Rws: File.c---UpdateFileList().opendir()");
      

      while( (entry = readdir(dir) ) != NULL ) { 

	    num_entries++;
      }
      

      entries = (char **) XtMalloc(sizeof(char *) * num_entries );
      
      rewinddir(dir);
      
      i=0;
      
      while( (entry = readdir(dir) ) != NULL ) { 
      
	    entries[i] = XtNewString(entry->d_name);
	    i++;
      }
      
      qsort(entries, 
	    num_entries, 
	    sizeof(char *),
	    sortDir);

      for ( i=0; i < num_entries; i++ ) { 
 
	    sprintf(path,"%s/%s",file->file.current_dir,entries[i]);
	    
	    stat(path,&buff);
	
	    if ( S_ISDIR(buff.st_mode) )
		  xmstr = XmStringCreate(entries[i],DIR_FONT);
	    else
		  xmstr = XmStringCreate(entries[i],FILE_FONT);
		  
	    XmListAddItemUnselected( file->file.file_list, xmstr, 0 ); 

	    XtFree(entries[i]);

	    XmStringFree(xmstr);
	    
	    
      }

      XtFree( (char *) entries );
      closedir(dir);
      

}



#if NeedFunctionPrototypes
static int sortDir( _Xconst void *e1, _Xconst void  *e2)
#else
static int sortDir(e1, e2)
#ifdef NO_CONST
void	*e1;
void	*e2;
#else
const	void *e1;
const	void *e2;
#endif
#endif
{

      char 	**s1;
      char 	**s2;

      s1 = (char **) e1;
      s2 = (char **) e2;
      
      return( strcmp(*s1,*s2) );
      

}


#if NeedFunctionPrototypes
static void textfieldCB(Widget text, XtPointer client, XtPointer call )
#else
static void textfieldCB(text,client,call)
Widget	text;
XtPointer	client;
XtPointer	call;
#endif
{
      RwsFileSelectorWidget file = (RwsFileSelectorWidget) client;
      RwsFileSelectorCallbackStruct call_data;
      char	*tmp;
      char	path[256];
      struct stat buff;
      
      

      call_data.reason = RwsCR_TYPED_FILENAME;
      
      call_data.dir = file->file.current_dir;


      tmp = XmTextFieldGetString(text);

      call_data.file = tmp;

      if ( file->file.file_selected_cb )
	    XtCallCallbacks( (Widget) file,
			    RwsNfileSelectedCallback,
			    &call_data);



      if ( ! file->file.auto_open_dirs ) {
		  
	    if ( file->file.file_selected_cb )
		  XtCallCallbacks( (Widget) file,
				  RwsNfileSelectedCallback,
				  &call_data);
		  
      }
      else {
	    
	    sprintf(path,"%s/%s",file->file.current_dir,tmp);
	    
	    if ( ! stat(path,&buff) ) {
	    
/* if the file is a dir, then open it and update the list */
		  if ( S_ISDIR(buff.st_mode) ) {
			XtVaSetValues((Widget) file,
				      RwsNcurrentDirectory, path,
				      NULL);
		  }
		  else {		
			if ( file->file.file_selected_cb )
			      XtCallCallbacks( (Widget) file,
					      RwsNfileSelectedCallback,
					      &call_data);
		  }
	    }
	    else {
		  if ( file->file.file_selected_cb )
			XtCallCallbacks( (Widget) file,
					RwsNfileSelectedCallback,
					&call_data);
	    }
	    
      }

      XtFree(tmp);

}


#if NeedFunctionPrototypes
static void listCB(Widget text, XtPointer client, XmListCallbackStruct *call )
#else
static void listCB(text,client,call)
Widget	text;
XtPointer	client;
XmListCallbackStruct	*call;
#endif
{
      RwsFileSelectorWidget file = (RwsFileSelectorWidget) client;
      RwsFileSelectorCallbackStruct call_data;
      char	path[256],*name;
      struct	stat	buff;
      
      call_data.reason = RwsCR_SELECTED_FILENAME;
      
      call_data.dir = file->file.current_dir;

      path[0]= '\0';
      

      if ( call->item  ) {

/* if the item isn't a file, then try the dir charset , else bomb out*/
	    if ( ! XmStringGetLtoR(call->item, FILE_FONT,&name) )
		  if ( !XmStringGetLtoR(call->item, DIR_FONT,&name))
			return;
	    
	    if ( ! file->file.auto_open_dirs ) {
		  
		  call_data.file = name;

		  if ( file->file.editable )
			XtVaSetValues(file->file.file_name,
				      XmNvalue, name,
				      NULL);
		  
		  if ( file->file.file_selected_cb )
			XtCallCallbacks( (Widget) file,
					RwsNfileSelectedCallback,
					&call_data);
		  
	    }
	    else {
		  
		  sprintf(path,"%s/%s",file->file.current_dir,name);
		  
		  stat(path,&buff);
		  
/* if the file is a dir, then open it and update the list */
		  if ( S_ISDIR(buff.st_mode) )
			XtVaSetValues((Widget) file,
				      RwsNcurrentDirectory, path,
				      NULL);
		  else {		
				    
			if ( file->file.editable )
			      XtVaSetValues(file->file.file_name,
					    XmNvalue, name,
					    NULL);

			call_data.file = name;
			
			if ( file->file.file_selected_cb )
			      XtCallCallbacks( (Widget) file,
					      RwsNfileSelectedCallback,
					      &call_data);
		  }
	    }
	    XtFree(name);
      }
      
}

#if NeedFunctionPrototypes
Widget RwsCreateFileSelector(Widget parent, char *name, ArgList args, Cardinal nargs)
#else
Widget RwsCreateFileSelector(parent,name,args,nargs)
Widget	parent;
char	*name;
ArgList	args;
Cardinal nargs;
#endif
{

      return( XtCreateWidget(name,rwsFileSelectorWidgetClass,parent,args,nargs) );
      

}

#if NeedFunctionPrototypes
Widget RwsFileSelectorGetChild(Widget file, char *child)
#else
Widget RwsFileSelectorGetChild(file,child)
Widget	file;
char	*child;
#endif
{

      return( XtNameToWidget(file,child) );

}
