static char rcsid[] = "$Id: mail.c,v 1.6 1995/03/27 12:49:11 richardo Exp $ (c) Richard M. Offer 1993, 1994,1995";
/* mail.c --- displays num messages in mailbox(es)

Copyright (c) 1993,1994 Richard M. Offer.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


Although the GPL allows you to modify the code to your hearts content,
could you be polite and send me a copy of any changes (but not patches, my
code may have changed). If you are considering adding additional
features, you might me better contacting me to make sure I'm not one
step ahead of you :-)

richard.

*/

#include <Rtc.h>

#ifdef WANT_MAILBOX_WATCHER

static int rtcCountMailMsgs(
#if NeedFunctionPrototypes
			RTCObject	*object
#endif
			    );


static void rtcUpdateMailBoxLabel(
#if NeedFunctionPrototypes
			RTCObject	*object
#endif
			    );

static void rtcMailBoxTimeOut(
#if NeedFunctionPrototypes
			RTCObject	*object
#endif
			    );

static void rtcMailBoxFlash(
#if NeedFunctionPrototypes
			RTCObject	*object
#endif
			    );

static void rtcMailBoxCB(
#if NeedFunctionPrototype
			 Widget	widget,
			 RTCObject	*object,
			 XtPointer	call
#endif
			 );


#if NeedFunctionPrototypes
ObjectReturnType RtcParseMailBox(RTCMaster *master, RTCObject *parent, RTCObject *object,char *line)
#else
ObjectReturnType RtcParseMailBox(master, parent,object,line)
RTCMaster	*master;
RTCObject	*parent;
RTCObject	*object;
char		*line;
#endif
{
      char	keyword[32]; 		/* all keywords *will* fit into this */
      int	num_chars,i;
      char	*ptr,*options;

      sscanf(line,"%s%n",keyword,&num_chars);
      
      while ( isspace(line[num_chars++] ))
	    ;
      
      
      num_chars--;
      
      ptr = &line[num_chars];

/* removes trailing new-line */

      line[strlen(line)-1] = '\0';

/* parse the name of the cascade button */
      num_chars = RtcExtractString(&object->name,ptr,"\"\"");

      ptr += num_chars;

/* get any options */
      num_chars = RtcExtractString(&options,ptr,"[]");

      if ( num_chars ) { 
	    RtcParseOptionsList(object,options);

	    if ( master->resources.msgLevel == (unsigned char) Diagnostics ) {
		  if ( object->option_mask) {
			RtcMsg(master,Diagnostics,"Options set on %s -> ",object->name);
			
			i=0;
		     
			while ( object->options && object->options[i] != NULL ) {
			      RtcMsg(master,Diagnostics,"%d ",
				     object->options[i]->type);

			      i++;
			}

			RtcMsg(master,Diagnostics,"\n");
			
		  }
		  
	    }
 
	    ptr += num_chars;

      }

      sscanf(ptr,"%s",keyword);
 
      object->data = RtcExpandShellVariable(keyword,strlen(keyword));
      object->command = (char *) 1;

      object->parent = parent;
 
      if ( object->parent->children == NULL )
	    object->parent->children = (RTCObject **) XtMalloc(	sizeof(RTCObject *) * (object->parent->num_children+1));
      else
	    object->parent->children = (RTCObject **) XtRealloc(( char *)object->parent->children,
								sizeof(RTCObject *) * (object->parent->num_children+1));

       object->parent->children[object->parent->num_children] = object;
      
      object->parent->num_children++;

      return ( Child );
      
}


#if NeedFunctionPrototypes
void	RtcCreateMailBox(RTCObject *object)
#else
void RtcCreateMailBox(object)
RTCObject	*object;
#endif
{

      int	i=0,n;
      Widget	button;
      Arg	args[5];
      char	label[64];
      XmString	xmstr;
      Pixel	fore;
      extern XtAppContext	AppContext;

/* must give it an initial label, otherwise we can get a stupid size */      
      sprintf(label,object->name,rtcCountMailMsgs(object));
      xmstr = XmStringCreateLtoR(label,"menu-buttons");

      n=0;
      XtSetArg( args[n], XmNlabelType, XmSTRING);n++;
      XtSetArg( args[n], XmNlabelString, xmstr);n++;
      
      button = XmCreateCascadeButton(object->parent->widget,
				     "mail-box",
				     args,
				     n);

      XtVaGetValues(button,XmNforeground,&fore,NULL);
      XtVaSetValues(button,XmNuserData, fore,NULL);

      XmStringFree(xmstr);
      

#ifdef WANT_HELP      
      if ( object->option_mask & ( HelpMask | HelpFileMask ) ) {
	    XtAddCallback(button, 
			  XmNhelpCallback, 
			  (XtCallbackProc) RtcDisplayContextHelp,
			  (XtPointer) object);
      }
#endif      

      if ( ! (object->option_mask & TimeMask ) ) {

	    if ( object->options == NULL )
		  object->options = (RTCOption ** ) XtMalloc( sizeof(RTCOption *) );
	    else {

		  while ( object->options && object->options[i] != NULL )
			i++;


		  object->options = (RTCOption ** ) XtRealloc( (char * ) object->options, sizeof(RTCOption *) * (i+1));

	    }	    
	    object->options[i] = (RTCOption *) XtMalloc( sizeof(RTCOption) );
	    
	    object->options[i]->type = TimeMask;
	    
	    object->options[i]->value = XtNewString("900"); /* default to be 15 minutes */
	    
	    i++; 

	    object->options = (RTCOption ** ) XtRealloc( (char * ) object->options, sizeof(RTCOption *) * (i+1));
	    
	    object->options[i] = NULL;
	    
	    
	    object->option_mask  =  object->option_mask | TimeMask ;
	    
      }

      XtAppAddTimeOut(AppContext,
		      0L,
		      (XtTimerCallbackProc) rtcMailBoxTimeOut,
		      (XtPointer) object);
      
      XtAddCallback( button,
		    XmNactivateCallback,
		    (XtCallbackProc) rtcMailBoxCB,
		    (XtPointer) object);
      


      object->widget = button;
      
      XtManageChild( button );

      
}

#if NeedFunctionPrototypes
static void rtcMailBoxCB(Widget widget, RTCObject *object, XtPointer call)
#else
static void rtcMailBoxCB(widget,object,call)
Widget	widget;
RTCObject	*object;
XtPointer	call;
#endif
{

      rtcUpdateMailBoxLabel(object); 

}

#if NeedFunctionPrototypes
static void rtcMailBoxTimeOut(RTCObject *object)
#else
static void rtcMailBoxTimeOut(object)
RTCObject	*object;
#endif
{
      static int pause=0;
      int	i=0;
      
      extern XtAppContext AppContext;
      
      rtcUpdateMailBoxLabel(object); 

      if ( pause == 0 ) {
	    while ( object->options && object->options[i] != NULL ) {

		  if ( object->options[i]->type & TimeMask ) {
		  
			pause = atoi( object->options[i]->value );
		  
			break;
		  
		  }
		  
		  i++;
	    }
      }
      

      XtAppAddTimeOut(AppContext,
		      pause*1000L,
		      (XtTimerCallbackProc) rtcMailBoxTimeOut,
		      (XtPointer) object);

}

#if NeedFunctionPrototypes
static void rtcMailBoxFlash(RTCObject *object)
#else
static void rtcMailBoxFlash(object)
RTCObject	*object;
#endif
{
      static int count=0, period=500L;
      Pixel	fore,back,user;
      
      extern XtAppContext AppContext;

      if ( count < 21  && object->command != (char *) 1 ) {

	  XtVaGetValues(object->widget,
			XmNforeground,&fore, 
			XmNbackground,&back,
			XmNuserData, &user,NULL);

	  if ( fore == back ) {
	      XtVaSetValues(object->widget,
			    XmNforeground, user,
			    NULL);
	      count++;
	  }
	  else {
	      XtVaSetValues(object->widget,
			    XmNforeground, back,
			    NULL);
	  }

	  XtAppAddTimeOut(AppContext,
			  period,
			  (XtTimerCallbackProc) rtcMailBoxFlash,
			  (XtPointer) object);

	  period *= 0.95;

      }
      else
	  count = 0;

}


#if NeedFunctionPrototypes
static void rtcUpdateMailBoxLabel(RTCObject *object)
#else
static void rtcUpdateMailBoxLabel(object)
RTCObject	*object;
#endif
{

      char	label[64];
      XmString	xmstr;

      static 	time_t last_updated=0;
      struct	stat buf;
      Pixel	user;
      extern XtAppContext	AppContext;

      if ( stat(object->data,&buf) ) {
	    RtcMsg(object->master,Error,"Cannot Open Mailbox %s\n",object->data);
	    RtcMsg(object->master,Diagnostics,"Mailbox Error # %d\n",errno);
      }
      else { 

	    if ( buf.st_mtime > last_updated ) {
/* if the mailbox has been modified (ie the modification time is newer than the last time it was accessed), then... */

/* i suppose this could be extended to play a sound file (I _hate_ it
   when people do that), or pop up a dialog, but i'll settle for
   changing the colour of the label....  
*/
		sprintf(label,object->name,rtcCountMailMsgs(object));
		
		xmstr = XmStringCreateLtoR(label,"menu-buttons");
		
		XtVaSetValues(object->widget,
			      XmNlabelString, xmstr,
			      NULL);
		
		XmStringFree( xmstr );
		
		object->command = (char *) 0;

		XtAppAddTimeOut(AppContext,
				0L,
				(XtTimerCallbackProc) rtcMailBoxFlash,
				(XtPointer) object);
      
		last_updated = buf.st_mtime;
		  
	    }
	    else { 

		object->command = (char *) 1;

		XtVaGetValues(object->widget,
			      XmNuserData, &user,NULL);

		XtVaSetValues(object->widget,
			      XmNforeground, user,
			      NULL);
	    }

      }
      
      
}

#if NeedFunctionPrototypes
static int rtcCountMailMsgs(RTCObject *object)
#else
static int rtcCountMailMsgs(object)
RTCObject	*object;
#endif
{

      FILE	*fp;
      char	line[MAX_LINE_LEN];
      static int len= -1;
      int	n=0;

      if ( len == -1 )
	    len = strlen(SITE_MAIL_SEPARATOR);
      
      if ( (fp=fopen(object->data,"r")) != NULL ) {

	    while ( fgets(line,MAX_LINE_LEN,fp) != NULL ) {
		  if ( ! strncmp(line,SITE_MAIL_SEPARATOR,len) )
			n++;
	    }

	    fclose(fp);
	    
	    
	    return ( n );

      }
      else
	    return ( 0 );
      
}


#endif
