/*--------------------------------*-C-*---------------------------------*
 * File:	sbar.h
 *
 * Copyright 1992 John Bovey, University of Kent at Canterbury.
 *
 * You can do what you like with this source code as long as you don't try
 * to make money out of it and you include an unaltered copy of this
 * message (including the copyright).
 *
 * This module has been heavily modified by R. Nation
 * <nation@rocket.sanders.lockheed.com>
 * No additional restrictions are applied
 *
 * Additional modifications by mj olesen <olesen@me.QueensU.CA>
 * No additional restrictions are applied.
 *
 * As usual, the author accepts no responsibility for anything, nor does
 * he guarantee anything whatsoever.
 *----------------------------------------------------------------------*/
#ifndef _SBAR_H
#define _SBAR_H

#ifndef SCROLLBAR_NONE
typedef struct {
   struct {
      Window win;
      GC gc;
   } up, dn, sb;
   int w, h;			/* height excluding arrows */
#ifdef SCROLLBAR_ANY
   int type;
#  define SBAR_NONE	0
#  define SBAR_XTERM	1
#  define SBAR_ARROWS	2
#endif
} sbar_t;

extern sbar_t	sbar;
#ifndef SBAR_WIDTH
# define SBAR_WIDTH	12	/* width of scrollBar */
#endif
#undef SBAR_HEIGHT
#define SBAR_HEIGHT	SBAR_WIDTH
#endif

#ifdef __cplusplus
extern "C" {
#endif
   extern void	sbar_init (Window win, XGCValues *gcv);
   extern void	sbar_down_reset (void);
   extern void	sbar_up_reset (void);
   extern void	sbar_show (int length, int low, int high);
#ifdef __cplusplus
}
#endif
#endif	/* whole file */
/*----------------------- end-of-file (C header) -----------------------*/
