/* worldmap - a world map display program
   Copyright (C) 1998 Andrew Skypeck
  
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.
  
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
  
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * resources.h - application resources for ssi
 */

#ifndef RESOURCES_H
#define RESOURCES_H

#include <X11/Intrinsic.h>
#include <X11/Shell.h>

#define XtNlogo           "logo"
#define XtNscrolledMap    "scrolledMap"
#define XtNuseShm         "useShm"

#define XtCLogo           "Logo"
#define XtCScrolledMap    "ScrolledMap"
#define XtCUseShm         "UseShm"

/* structure to hold custom resources and options */
typedef struct {
  String logo;
  Boolean scrolled_map;
  Boolean use_shm;
} InstanceRecord;

InstanceRecord instance_record;

/* custom resource definitions */
static XtResource custom_resources[] = {
  {
    XtNlogo,
    XtCLogo,
    XtRString,
    sizeof(String),
    XtOffsetOf(InstanceRecord, logo),
    XtRString,
    (XtPointer) NULL
  },
  {
    XtNscrolledMap,
    XtCScrolledMap,
    XtRBoolean,
    sizeof(Boolean),
    XtOffsetOf(InstanceRecord, scrolled_map),
    XtRImmediate,
    (XtPointer) False
  },
  {
    XtNuseShm,
    XtCUseShm,
    XtRBoolean,
    sizeof(Boolean),
    XtOffsetOf(InstanceRecord, use_shm),
    XtRImmediate,
    (XtPointer) False
  },
};

/* command line option table for non-toolkit options */
static XrmOptionDescRec custom_options[] = {
  {"-logo",           "*logo",           XrmoptionSepArg, NULL},
  {"-scrolledMap",    "*scrolledMap",    XrmoptionNoArg,  "True"},
  {"-useShm",         "*useShm",         XrmoptionNoArg,  "True"},
};

/* fallback resources so program looks and works ok without an
   external resource file, assumes color! */
static String fallback_resources[] = {
  "*background: gray70",
  "*XmDialogShell*background: Gray60",
  "*XmDialogShell*XmTextField.background: white",
  "*XmDialogShell*XmList.background: white",
  "*openDialog.dialogTitle: Guile Scheme Interpreter",
  "*openDialog.pattern: *.scm",
  "*fontList: -*-helvetica-bold-r-normal-*-14-*-*-*-*-*-*-*",
  "*XmTextField.fontList: -*-courier-medium-r-normal-*-12-*",
  "*XmList.fontList: -*-courier-medium-r-normal-*-12-*",
  "*messageLabel.fontList: -*-helvetica-medium-r-normal-*-12-*-*-*-*-*-*-*",
  "*scrolledWindow.width: 600",
  "*scrolledWindow.height: 300",
  "*map.width: 600",
  "*map.height: 400",
  "*map.projection: miller",
  "*map.background: black",
  "*map.drawCoastline: false",
  "*map.coastlineColor: blue",
  "*map.drawGrid: false",
  "*map.gridColor: gray",
  "*map.drawIslands: true",
  "*map.islandColor: forest green",
  "*map.lakeColor: blue",
  "*map.landColor: forest green",
  "*map.oceanColor: navy",
  "*map.drawBoundaries: true",
  "*map.boundaryColor: firebrick",
  "*map.riverColor: skyblue",
  "*map.zoomBoxColor: pink",
  NULL,
};

#endif /* RESOURCES_H */
