/*
 * xtutil.h
 */

#ifndef XTUTIL_H
#define XTUTIL_H

#include <X11/Intrinsic.h>
#include <X11/Shell.h>

typedef union {
  int int_value;
  float float_value;
} FloatArg;

/* macros for setting VaArgs in Set and Get Values */
#define VaStringArg(A, B) XtVaTypedArg, A, XmRString, B, strlen(B) + 1
#define VaFloatArg(A, B) A, B.int_value
#define DoubleArray(P) XtRealloc(P, 2 * XtNumber(P))

Widget TopLevel(Widget widget);
void CenterDialogOnce(Widget dialog, XtPointer client_data,
		      XtPointer call_data);

/* convienience Xt converter functions */
Pixel ColorNameToPixel(Widget widget, char *color_name);
Font FontNameToFont(Widget widget, char *font_name);

#endif /* XTUTIL_H */
