/*-
# X-BASED ABACUS
#
#  xabacus.c
#
###
#
#  Copyright (c) 1994 - 96	David Albert Bagley, bagleyd@bigfoot.com
#
#                   All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee is hereby granted,
#  provided that the above copyright notice appear in all copies and
#  that both that copyright notice and this permission notice appear in
#  supporting documentation, and that the name of the author not be
#  used in advertising or publicity pertaining to distribution of the
#  software without specific, written prior permission.
#
#  This program is distributed in the hope that it will be "useful",
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
*/

/*-
  Version 4: 94/05/07 Xt
  Version 3: 93/02/03 Motif
  Version 2: 91/12/17 XView
  Version 1: 91/02/14 SunView
*/

#include <stdlib.h>
#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/cursorfont.h>
#include "Abacus.h"
#include "abacus.xbm"

#define MAXDIGITS 256		/* This limits the number of bars */
#define MAXPROGNAME 80
#define MAXNAME (MAXDIGITS+MAXPROGNAME)

static void CallbackAbacus(Widget w, caddr_t client_data, abacusCallbackStruct * call_data);

static char prog[MAXPROGNAME + 2];
static char title[MAXNAME + 1];
static Arg  arg[2];

static void
Usage(void)
{
	(void) fprintf(stderr, "usage: xabacus\n");
	(void) fprintf(stderr,
	     "\t[-geometry [{width}][x{height}][{+-}{xoff}[{+-}{yoff}]]]\n");
	(void) fprintf(stderr,
		"\t[-display [{host}]:[{vs}]][-fg {color}] [-bg {color}]\n");
	(void) fprintf(stderr,
		 "\t[-bead {color}] [-{border|bd} {color}] [-bars {int}]\n");
	(void) fprintf(stderr,
		       "\t[-spaces {int}] [-tnumber {int}] [-bnumber {int}] [-tfactor {int}]\n");
	(void) fprintf(stderr,
	"\t[-bfactor {int}] [-[no]torient] [-[no]borient] [-delay msecs]\n");
	exit(1);
}

static XrmOptionDescRec options[] =
{
	{"-fg", "*abacus.Foreground", XrmoptionSepArg, NULL},
	{"-bg", "*Background", XrmoptionSepArg, NULL},
	{"-foreground", "*abacus.Foreground", XrmoptionSepArg, NULL},
	{"-background", "*Background", XrmoptionSepArg, NULL},
	{"-bead", "*abacus.beadColor", XrmoptionSepArg, NULL},
	{"-border", "*abacus.beadBorder", XrmoptionSepArg, NULL},
	{"-bd", "*abacus.beadBorder", XrmoptionSepArg, NULL},
	{"-bars", "*abacus.bars", XrmoptionSepArg, NULL},
	{"-spaces", "*abacus.spaces", XrmoptionSepArg, NULL},
	{"-tnumber", "*abacus.topNumber", XrmoptionSepArg, NULL},
	{"-bnumber", "*abacus.bottomNumber", XrmoptionSepArg, NULL},
	{"-tfactor", "*abacus.topFactor", XrmoptionSepArg, NULL},
	{"-bfactor", "*abacus.bottomFactor", XrmoptionSepArg, NULL},
	{"-torient", "*abacus.topOrient", XrmoptionNoArg, "TRUE"},
	{"-notorient", "*abacus.topOrient", XrmoptionNoArg, "FALSE"},
	{"-borient", "*abacus.bottomOrient", XrmoptionNoArg, "TRUE"},
	{"-noborient", "*abacus.bottomOrient", XrmoptionNoArg, "FALSE"},
	{"-delay", "*abacus.delay", XrmoptionSepArg, NULL}
};

int
main(int argc, char **argv)
{
	Widget      toplevel, abacus;

	(void) sprintf(prog, "%s =", argv[0]);
	(void) sprintf(title, "%s%s", prog, "0");
	toplevel = XtInitialize(title, "Abacus", options, XtNumber(options),
				&argc, argv);
	if (argc != 1)
		Usage();
	XtSetArg(arg[0], XtNiconPixmap,
		 XCreateBitmapFromData(XtDisplay(toplevel),
				       RootWindowOfScreen(XtScreen(toplevel)),
			 (char *) abacus_bits, abacus_width, abacus_height));
	XtSetArg(arg[1], XtNinput, True);
	XtSetValues(toplevel, arg, 2);
	abacus = XtCreateManagedWidget("abacus", abacusWidgetClass, toplevel,
				       NULL, 0);
	XtAddCallback(abacus, XtNselectCallback, (XtCallbackProc) CallbackAbacus,
		      (XtPointer) NULL);
	XtRealizeWidget(toplevel);
	XGrabButton(XtDisplay(abacus), AnyButton, AnyModifier, XtWindow(abacus),
		TRUE, ButtonPressMask | ButtonMotionMask | ButtonReleaseMask,
		    GrabModeAsync, GrabModeAsync, XtWindow(abacus),
		    XCreateFontCursor(XtDisplay(abacus), XC_crosshair));
	XtMainLoop();

#ifdef VMS
	return 1;
#else
	return 0;
#endif
}

static void
CallbackAbacus(Widget w, caddr_t client_data, abacusCallbackStruct * call_data)
{
	(void) sprintf(title, "%s%s", prog, call_data->buffer);
	XtSetArg(arg[0], XtNtitle, title);
	XtSetValues(XtParent(w), arg, 1);
}
