/*-----------------------------------------------------------------*/
/* alpha.h --- vectored font information for xcircuit 		   */
/*-----------------------------------------------------------------*/

/* Uppercase set */

XPoint A1_pts[] = {{0, 0}, {10, 26}, {20, 0}};
XPoint A2_pts[] = {{4, 10}, {16, 10}};
XPoint B1_pts[] = {{0, 0}, {0, 26}, {10, 26}, {15, 24}, {17, 20}, {17, 18},
	{13, 14}, {0, 14}};
XPoint B2_pts[] = {{0, 0}, {13, 0}, {17, 2}, {19, 6}, {19, 8}, {17, 12}, 
	{13, 14}};
XPoint RLeft_pts[] = {{14, 0}, {8, 0}, {2, 4}, {0, 10}, {0, 16}, {2, 22},
	{8, 26}, {14, 26}, {20, 22}};
XPoint C_pts[] = {{14, 0}, {20, 4}};
XPoint D_pts[] = {{0, 0}, {12, 0}, {18, 4}, {20, 10}, {20, 16}, {18, 22},
	{12, 26}, {0, 26}, {0, 0}};
XPoint E1_pts[] = {{18, 0}, {0, 0}, {0, 26}, {18, 26}};
XPoint E2_pts[] = {{0, 14}, {14, 14}};
XPoint F1_pts[] = {{0, 0}, {0, 26}, {16, 26}};
XPoint F2_pts[] = {{0, 14}, {12, 14}};
XPoint G_pts[] = {{14, 0}, {20, 2}, {22, 6}, {22, 12}, {14, 12}};
XPoint H1_pts[] = {{0, 0}, {0, 26}};
XPoint H2_pts[] = {{19, 0}, {19, 26}};
XPoint H3_pts[] = {{0, 14}, {19, 14}};
XPoint I_pts[] = {{2, 0}, {2, 26}};
XPoint J_pts[] = {{0, 6}, {2, 2}, {6, 0}, {8, 0}, {12, 2}, {14, 6}, {14, 26}};
XPoint K1_pts[] = {{18, 26}, {0, 10}};
XPoint K2_pts[] = {{18, 0}, {6, 14}};
XPoint L_pts[] = {{0, 26}, {0, 0}, {16, 0}};
XPoint M_pts[] = {{0, 0}, {0, 26}, {12, 0}, {24, 26}, {24, 0}};
XPoint N_pts[] = {{0, 0}, {0, 26}, {20, 0}, {20, 26}};
XPoint O_pts[] = {{14, 0}, {20, 4}, {22, 10}, {22, 16}, {20, 22}};
XPoint P_pts[] = {{0, 0}, {0, 26}, {13, 26}, {17, 22}, {17, 18}, {13, 14},
	{0, 14}};
XPoint Q_pts[] = {{23, 0}, {14, 6}};
XPoint R_pts[] = {{8, 14}, {19, 0}};
XPoint S_pts[] = {{0, 6}, {2, 2}, {6, 0}, {12, 0}, {16, 2}, {18, 6}, {18, 8},
	{14, 12}, {2, 18}, {0, 20}, {0, 22}, {2, 24}, {6, 26}, {12, 26},
	{16, 24}};
XPoint T1_pts[] = {{9, 0}, {9, 26}};
XPoint T2_pts[] = {{0, 26}, {18, 26}};
XPoint U_pts[] = {{0, 26}, {0, 8}, {2, 4}, {4, 2}, {8, 0}, {13, 0}, {17, 2},
	{19, 4}, {21, 8}, {21, 26}};
XPoint V_pts[] = {{0, 26}, {11, 0}, {22, 26}};
XPoint W_pts[] = {{0, 26}, {8, 0}, {16, 26}, {24, 0}, {32, 26}};
XPoint X1_pts[] = {{0, 0}, {20, 26}};
XPoint X2_pts[] = {{0, 26}, {20, 0}};
XPoint Y1_pts[] = {{0, 26}, {10, 14}, {10, 0}};
XPoint Y2_pts[] = {{20, 26}, {10, 14}};
XPoint Z_pts[] = {{0, 26}, {18, 26}, {0, 0}, {18, 0}};

/* Courier font special alphabet characters */

XPoint Cbase_pts[]={{2, 0}, {16, 0}};
XPoint CI1_pts[] ={{9, 0}, {9, 26}};
XPoint CI2_pts[] ={{2, 26}, {15, 26}};
XPoint CM_pts[] = {{0, 0}, {0, 26}, {10, 8}, {20, 26}, {20, 0}};
XPoint CT_pts[] = {{0, 20}, {0, 26}, {18, 26}, {18, 20}};
XPoint CW_pts[] = {{0, 26}, {5, 0}, {10, 18}, {15, 0}, {20, 26}};
XPoint Cdot_pts[]={{10, 24}, {10, 23}};
XPoint Ci_pts[] = {{10, 0}, {10, 16}, {5, 16}};
XPoint Cj_pts[] = {{0, -6}, {4, -6}, {8, -4}, {10, -2}, {10, 16}, {2, 16}};
XPoint Cl_pts[] = {{10, 0}, {10, 26}, {4, 26}};
XPoint Cf1_pts[] ={{6, 0}, {6, 24}, {9, 26}, {13, 26}, {18, 24}};
XPoint Cf2_pts[] ={{0, 16}, {18, 16}}; 
XPoint Cr1_pts[] = {{6, 0}, {6, 16}, {1, 16}};
XPoint Cr2_pts[] = {{6, 12}, {14, 16}, {17, 16}, {20, 14}};
XPoint Ct_pts[] = {{6, 26}, {6, 2}, {10, 0}, {12, 0}, {18, 3}};
XPoint Cm2_pts[] = {{0, 14}, {4, 16}, {8, 16}, {10, 14}, {10, 0}};
XPoint Cm3_pts[] = {{10, 14}, {14, 16}, {18, 16}, {20, 14}, {20, 0}};

/* Times-Roman font special alphabet characters */

XPoint TI1_pts[] = {{0, 0}, {4, 0}};
XPoint TI2_pts[] = {{0, 26}, {4, 26}};
XPoint TJ_pts[] = {{0, 4}, {1, 2}, {4, 0}, {7, 0}, {9, 2}, {11, 6}, {11, 26}};
XPoint TQ_pts[] = {{11, 0}, {15, -3}, {20, -5}};
XPoint TT_pts[] = {{0, 24}, {0, 26}, {18, 26}, {18, 24}};
XPoint Tbase_pts[] = {{2, 0}, {6, 0}};
XPoint Tdot_pts[] = {{4, 21}, {4, 22}};
XPoint Te_pts[] = {{1, 12}, {15, 12}, {14, 14}};
XPoint Tf_pts[] = {{4, 0}, {4, 24}, {6, 26}, {10, 26}, {12, 24}};
XPoint Tg1_pts[] = {{5, 5}, {10, 5}, {13, 7}, {13, 11}, {10, 15}, {6, 16},
	{3, 15}, {0, 12}, {0, 8}, {5, 5}, {3, 3}, {11, 1}, {17, -1}, {17, -5},
	{10, -8}, {4, -8}, {0, -5}, {0, -2}, {5, 2}};
XPoint Tg2_pts[] = {{11, 13}, {14, 13}, {17, 15}};
XPoint Ti_pts[] = {{4, 0}, {4, 16}, {2, 14}};
XPoint Tj_pts[] = {{-3, -4}, {0, -6}, {2, -6}, {4, -4}, {4, 16}, {2, 14}};
XPoint Tl_pts[] = {{4, 0}, {4, 26}, {2, 24}};
XPoint Tr_pts[] = {{4, 14}, {7, 16}, {9, 16}, {11, 14}};
XPoint Ts_pts[] = {{0, 2}, {3, 0}, {9, 0}, {12, 2}, {12, 4}, {10, 6}, {1, 10},
	{0, 12}, {0, 14}, {3, 16}, {9, 16}, {12, 14}};
XPoint Tt_pts[] = {{4, 26}, {4, 2}, {6, 0}, {9, 2}};

/* lowercase set */

XPoint a1_pts[] = {{16, 0}, {14, 2}, {14, 12}, {10, 16}, {4, 16}, {2, 14}};
XPoint a2_pts[] = {{14, 2}, {10, 0}, {4, 0}, {0, 2}, {0, 4}, {4, 8}, {14, 8}};
XPoint b_pts[] = {{0, 2}, {4, 0}, {8, 0}, {12, 2}, {14, 6}, {14, 10}, {12, 14},
	{8, 16}, {4, 16}, {0, 14}};
XPoint c_pts[] = {{14, 2}, {10, 0}, {6, 0}, {2, 2}, {0, 6}, {0, 10}, {2, 14},
	{6, 16}, {10, 16}, {14, 14}};
XPoint d_pts[] = {{14, 0}, {14, 26}};
XPoint e_pts[] = {{0, 8}, {16, 8}, {16, 10}, {14, 14}};
XPoint f1_pts[] = {{4, 0}, {4, 24}, {6, 26}, {10, 26}};
XPoint f2_pts[] = {{0, 18}, {8, 18}}; 
XPoint g_pts[] = {{2, -4}, {4, -6}, {10, -6}, {14, -4}, {14, 16}};
XPoint h_pts[] = {{0, 14}, {4, 16}, {10, 16}, {14, 12}, {14, 0}};
XPoint i1_pts[] = {{2, 0}, {2, 16}};
XPoint i2_pts[] = {{2, 21}, {2, 22}};
XPoint j1_pts[] = {{-3, -6}, {0, -6}, {2, -4}, {2, 16}};
XPoint k1_pts[] = {{0, 8}, {12, 16}};
XPoint k2_pts[] = {{14, 0}, {4, 10}};
XPoint m1_pts[] = {{0, 0}, {0, 16}};
XPoint m2_pts[] = {{0, 14}, {5, 16}, {10, 16}, {13, 14}, {13, 0}};
XPoint m3_pts[] = {{13, 14}, {18, 16}, {23, 16}, {26, 14}, {26, 0}};
XPoint o_pts[] = {{6, 0}, {2, 2}, {0, 6}, {0, 10}, {2, 14}, {6, 16}, {8, 16},
	{12, 14}, {14, 10}, {14, 6}, {12, 2}, {8, 0}, {6, 0}};
XPoint p_pts[] = {{0, 16}, {0, -6}};
XPoint q_pts[] = {{14, 16}, {14, -6}};
XPoint r_pts[] = {{0, 14}, {4, 16}, {8, 16}, {10, 14}};
XPoint s_pts[] = {{0, 2}, {4, 0}, {10, 0}, {14, 2}, {14, 4}, {12, 6}, {2, 10},
	{0, 12}, {0, 14}, {4, 16}, {10, 16}, {14, 14}};
XPoint t_pts[] = {{4, 26}, {4, 2}, {6, 0}, {8, 0}};
XPoint u1_pts[] = {{0, 16}, {0, 4}, {4, 0}, {10, 0}, {14, 2}};
XPoint u2_pts[] = {{14, 0}, {14, 16}};
XPoint v_pts[] = {{0, 16}, {8, 0}, {16, 16}};
XPoint w_pts[] = {{0, 16}, {6, 0}, {12, 16}, {18, 0}, {24, 16}};
XPoint x1_pts[] = {{0, 0}, {14, 16}};
XPoint x2_pts[] = {{0, 16}, {14, 0}};
XPoint y1_pts[] = {{0, 16}, {8, 0}};
XPoint y2_pts[] = {{14, 16}, {6, -4}, {4, -6}, {2, -6}};
XPoint z_pts[] = {{0, 16}, {14, 16}, {0, 0}, {14, 0}};

/* greek uppercase */

XPoint Delta_pts[] = {{0, 0}, {20, 0}};
XPoint Gamma1_pts[] = {{2, 0}, {2, 26}};
XPoint Gamma2_pts[] = {{0, 26}, {18, 26}};
XPoint Pi1_pts[] = {{18, 0}, {18, 26}};
XPoint Pi2_pts[] = {{0, 26}, {20, 26}};
XPoint Theta_pts[] = {{4, 14}, {16, 14}};
XPoint Sigma_pts[] = {{20, 0}, {0, 0}, {12, 14}, {0, 26}, {20, 26}};
XPoint Phi1_pts[] = {{12, 0}, {12, 26}};
XPoint Phi2_pts[] = {{8, 4}, {4, 6}, {2, 8}, {0, 12}, {0, 14}, {2, 18},
	{4, 20}, {8, 22}, {16, 22}, {20, 20}, {22, 18}, {24, 14}, {24, 12},
	{22, 8}, {20, 6}, {16, 4}, {8, 4}};
XPoint Omega_pts[] = {{2, 2}, {4, 0}, {10, 0}, {10, 2}, {6, 4}, {2, 8}, {0, 12},
	{0, 16}, {2, 20}, {6, 24}, {10, 26}, {16, 26}, {20, 24}, {24, 20},
	{26, 16}, {26, 12}, {24, 8}, {20, 4}, {16, 2}, {16, 0}, {22, 0},
	{24, 2}};
XPoint Chi_pts[] = {{4, 14}, {14, 14}};
XPoint Psi_pts[] = {{0, 26}, {2, 24}, {2, 20}, {0, 16}, {0, 14}, {2, 10},
	{6, 8}, {18, 8}, {22, 10}, {24, 14}, {24, 16}, {22, 20}, {22, 24},
	{24, 26}};
XPoint Upsi1_pts[] = {{10, 0}, {10, 12}, {8, 18}, {6, 22}, {2, 26}, {0, 26}};
XPoint Upsi2_pts[] = {{10, 12}, {16, 24}, {18, 26}, {20, 24}};

/* greek lowercase */

XPoint ath_pts[] = {{0, 18}, {2, 16}, {2, 8}, {4, 4}, {8, 0}, {12, 0}, {16, 2},
	{18, 8}, {18, 20}, {16, 24}, {12, 26}, {8, 26}, {6, 24}, {6, 22},
	{8, 20}, {14, 20}, {18, 18}, {20, 16}};
XPoint asig_pts[] = {{4, -4}, {8, -6}, {12, -6}, {14, -4}, {14, -2}, {12, 0},
	{6, 0}, {2, 2}, {0, 6}, {0, 10}, {2, 14}, {6, 16}, {16, 16}};
XPoint adel_pts[] = {{2, 22}, {6, 26}, {12, 26}, {14, 22}, {16, 16}, {16, 6},
	{14, 2}, {10, 0}, {6, 0}, {2, 2}, {0, 6}, {0, 10}, {2, 14}, {6, 16},
	{10, 16}, {14, 14}, {16, 10}};
XPoint aphi_pts[] = {{8, -6}, {8, 12}, {10, 16}, {12, 16}, {16, 14}, {16, 6},
	{14, 2}, {10, 0}, {6, 0}, {2, 2}, {0, 6}, {0, 12}, {2, 16}, {4, 16}};
XPoint aomega1_pts[] = {{0, 14}, {4, 16}, {20, 16}};
XPoint aomega2_pts[] = {{4, 16}, {0, 8}, {0, 6}, {2, 2}, {4, 0}, {8, 0},
	{10, 4}, {10, 8}};
XPoint aomega3_pts[] = {{10, 4}, {14, 0}, {18, 0}, {20, 4}, {20, 10}, {18, 16}};

XPoint alpha_pts[] = {{18, 0}, {16, 2}, {12, 12}, {10, 16}, {6, 16}, {2, 14},
	{0, 10}, {0, 6}, {2, 2}, {6, 0}, {10, 0}, {12, 2}, {16, 16}};
XPoint beta1_pts[] = {{0, 0}, {0, 20}, {2, 24}, {6, 26}, {10, 26}, {12, 24},
	{12, 20}, {10, 18}, {6, 16}, {4, 16}};
XPoint beta2_pts[] = {{6, 16}, {12, 14}, {14, 8}, {14, 2}, {10, 0}, {6, 0},
	{2, 2}};
XPoint beta3_pts[] = {{0, -6}, {0, 0}};
XPoint chi1_pts[] = {{0, -6}, {14, 16}};
XPoint chi2_pts[] = {{0, 14}, {2, 16}, {4, 14}, {12, -4}, {14, -4}, {12, -4}};
XPoint delta_pts[] = {{6, 16}, {2, 14}, {0, 10}, {0, 6}, {2, 2}, {6, 0},
	{10, 0}, {14, 4}, {14, 10}, {12, 14}, {4, 22}, {4, 24}, {6, 26},
	{8, 26}, {10, 24}};
XPoint epsilon_pts[] = {{12, 4}, {8, 0}, {2, 0}, {0, 2}, {0, 6}, {2, 8},
	{6, 8}, {2, 10}, {0, 12}, {0, 14}, {4, 16}, {8, 16}, {10, 14}};
XPoint phi_pts[] = {{8, -6}, {8, 22}};
XPoint gamma_pts[] = {{0, 16}, {2, 16}, {4, 12}, {8, 0}, {8, -4}, {6, -6}, 
	{6, -4}, {10, 8}, {12, 12}, {12, 16}};
XPoint eta1_pts[] = {{0, 14}, {2, 16}, {4, 14}, {4, 0}};
XPoint eta2_pts[] = {{4, 14}, {8, 16}, {12, 16}, {16, 12}, {16, -6}};
XPoint iota_pts[] = {{2, 16}, {2, 2}, {4, 0}, {6, 2}};
XPoint kappa1_pts[] = {{0, 8}, {10, 14}, {14, 16}};
XPoint kappa2_pts[] = {{2, 8}, {12, 0}};
XPoint lambda1_pts[] = {{0, 0}, {6, 16}};
XPoint lambda2_pts[] = {{0, 24}, {2, 26}, {4, 24}, {12, 2}, {14, 0}, {16, 2}};
XPoint mu1_pts[] = {{0, -6}, {0, 16}};
XPoint mu2_pts[] = {{0, 2}, {4, 0}, {8, 0}, {12, 4}};
XPoint mu3_pts[] = {{12, 16}, {12, 2}, {14, 0}, {16, 2}};
XPoint nu_pts[] = {{0, 14}, {2, 16}, {4, 14}, {8, 0}, {14, 10}, {16, 14},
	{16, 16}};
XPoint omicron_pts[] = {{6, 0}, {2, 2}, {0, 6}, {0, 10}, {2, 14}, {6, 16},
	{10, 16}, {14, 14}, {16, 10}, {16, 6}, {14, 2}, {10, 0}, {6, 0}};
XPoint pi1_pts[] = {{0, 0}, {2, 4}, {2, 16}};
XPoint pi2_pts[] = {{0, 16}, {14, 16}};
XPoint pi3_pts[] = {{10, 16}, {10, 2}, {12, 0}, {14, 2}};
XPoint theta1_pts[] = {{6, 0}, {2, 2}, {0, 8}, {0, 18}, {2, 24}, {6, 26},
	{10, 26}, {14, 24}, {16, 18}, {16, 8}, {14, 2}, {10, 0}, {6, 0}};
XPoint theta2_pts[] = {{0, 14}, {16, 14}};
XPoint rho_pts[] = {{0, -6}, {0, 10}, {2, 14}, {6, 16}, {10, 16}, {12, 14},
	{14, 10}, {14, 6}, {12, 2}, {8, 0}, {4, 0}, {0, 4}};
XPoint sigma_pts[] = {{10, 16}, {16, 16}};
XPoint tau1_pts[] = {{0, 14}, {2, 16}, {12, 16}};
XPoint tau2_pts[] = {{6, 16}, {6, 2}, {8, 0}, {10, 2}};
XPoint ups_pts[] = {{0, 14}, {2, 16}, {4, 14}, {4, 4}, {6, 0}, {12, 0},
	{14, 2}, {16, 6}, {16, 12}, {14, 16}};
XPoint omega1_pts[] = {{4, 16}, {2, 14}, {0, 10}, {0, 6}, {2, 2}, {4, 0},
	{8, 0}, {10, 4}, {10, 14}};
XPoint omega2_pts[] = {{10, 4}, {12, 0}, {16, 0}, {18, 2}, {20, 6}, {20, 10},
	{18, 14}, {16, 16}};
XPoint xi1_pts[] = {{2, 26}, {0, 24}, {2, 22}, {12, 22}};
XPoint xi2_pts[] = {{8, 22}, {4, 20}, {0, 16}, {2, 14}, {8, 10}, {12, 12},
	{4, 12}, {0, 8}, {0, 2}, {4, 0}, {12, 0}, {14, -2}, {14, -4}, {10, -6},
	{4, -6}};
XPoint psi1_pts[] = {{10, -6}, {10, 22}};
XPoint psi2_pts[] = {{0, 14}, {2, 16}, {4, 14}, {4, 12}, {2, 8}, {2, 4}, {6, 0},
	{14, 0}, {18, 4}, {18, 12}, {16, 16}};
XPoint zeta_pts[] = {{10, 22}, {6, 20}, {2, 16}, {0, 10}, {0, 2}, {4, 0},
	{12, 0}, {14, -2}, {14, -4}, {10, -6}, {4, -6}};

/* numbers */

XPoint num0_pts[] = {{6, 0}, {2, 4}, {0, 10}, {0, 16}, {2, 22}, {6, 26},
	{12, 26}, {16, 22}, {18, 16}, {18, 10}, {16, 4}, {12, 0}, {6, 0}};
XPoint num1_pts[] = {{4, 0}, {4, 26}, {2, 22}, {0, 20}};
XPoint num2_pts[] = {{18, 0}, {0, 0}, {4, 4}, {16, 12}, {18, 16}, {18, 20},
	{16, 24}, {12, 26}, {8, 26}, {4, 24}, {2, 22}};
XPoint num3_1_pts[] = {{0, 4}, {2, 2}, {6, 0}, {10, 0}, {14, 2}, {16, 6},
	{16, 10}, {12, 14}, {8, 14}};
XPoint num3_2_pts[] = {{12, 14}, {16, 18}, {16, 20}, {14, 24}, {10, 26},
	{6, 26}, {2, 24}, {0, 22}};
XPoint num4_pts[] = {{16, 0}, {16, 26}, {0, 8}, {18, 8}};
XPoint num5_pts[] = {{0, 2}, {4, 0}, {10, 0}, {14, 2}, {16, 6}, {16, 12},
	{14, 16}, {10, 18}, {4, 18}, {0, 16}, {2, 26}, {14, 26}};
XPoint num6_pts[] = {{16, 24}, {12, 26}, {6, 26}, {2, 22}, {0, 16}, {0, 10},
	{2, 4}, {6, 0}, {12, 0}, {16, 2}, {18, 6}, {18, 12}, {16, 16},
	{12, 18}, {6, 18}, {2, 16}, {0, 14}};
XPoint num7_pts[] = {{6, 0}, {6, 4}, {8, 12}, {16, 26}, {0, 26}};
XPoint num8_pts[] = {{6, 0}, {2, 2}, {0, 4}, {0, 8}, {4, 12}, {14, 16},
	{16, 20}, {16, 22}, {12, 26}, {6, 26}, {2, 22}, {2, 20}, {4, 16},
	{14, 12}, {18, 8}, {18, 4}, {16, 2}, {12, 0}, {6, 0}};
XPoint num9_pts[] = {{2, 2}, {6, 0}, {12, 0}, {16, 4}, {18, 10}, {18, 18},
	{16, 24}, {12, 26}, {6, 26}, {2, 24}, {0, 20}, {0, 16}, {2, 12},
	{6, 10}, {12, 10}, {16, 12}, {18, 14}};

/* punctuation and miscellaneous */

XPoint box_pts[] = {{0, 0}, {0, 26}, {20, 26}, {20, 0}, {0, 0}};
XPoint excl1_pts[] = {{2, 6}, {2, 26}};
XPoint excl2_pts[] = {{2, 0}, {2, 1}};
XPoint quote1_pts[] = {{2, 26}, {2, 22}};
XPoint quote2_pts[] = {{6, 26}, {6, 22}};
XPoint comma_pts[] = {{4, 0}, {4, -2}, {2, -4}}; 
XPoint lparen_pts[] = {{6, -5}, {2, 0}, {0, 6}, {0, 16}, {2, 22}, {6, 27}};
XPoint rparen_pts[] = {{0, -5}, {4, 0}, {6, 6}, {6, 16}, {4, 22}, {0, 27}};
XPoint minus_pts[] = {{0, 12}, {12, 12}};
XPoint plus_pts[] = {{6, 6}, {6, 18}};
XPoint pound1_pts[] = {{6, 26}, {2, 0}, {4, 8}, {0, 8}, {16, 8}};
XPoint pound2_pts[] = {{0, 18}, {16, 18}};
XPoint pound3_pts[] = {{10, 0}, {14, 26}};
XPoint quest1_pts[] = {{0, 22}, {4, 26}, {10, 26}, {14, 22}, {14, 18}, {12, 14},
	{6, 8}, {6, 6}};
XPoint quest2_pts[] = {{6, 0}, {6, 0}};
XPoint colon1_pts[] = {{2, 6}, {2, 6}};
XPoint colon2_pts[] = {{2, 20}, {2, 20}};
XPoint semi1_pts[] = {{2, 0}, {2, -2}, {0, -4}};
XPoint semi2_pts[] = {{2, 16}, {2, 16}};
XPoint equal1_pts[] = {{0, 10}, {12, 10}};
XPoint equal2_pts[] = {{0, 14}, {12, 14}};
XPoint less_pts[] = {{12, 6}, {0, 12}, {12, 18}};
XPoint more_pts[] = {{0, 6}, {12, 12}, {0, 18}};
XPoint slash_pts[] = {{0, 0}, {10, 26}};
XPoint at1_pts[] = {{22, 2}, {14, 0}, {10, 0}, {6, 2}, {2, 6}, {0, 10}, {0, 16},
	{2, 20}, {6, 24}, {10, 26}, {16, 26}, {20, 24}, {24, 20}, {26, 16}, 
	{26, 12}, {24, 8}, {22, 6}, {18, 4}, {16, 8}, {18, 20}};
XPoint at2_pts[] = {{18, 18}, {16, 20}, {12, 20}, {8, 18}, {6, 14}, {6, 8},
	{10, 6}, {14, 6}, {16, 8}};
XPoint dollar1_pts[] = {{0, 6}, {2, 4}, {6, 2}, {10, 2}, {14, 4}, {16, 6},
	{16, 8}, {14, 10}, {2, 18}, {0, 18}, {0, 20}, {2, 22}, {6, 24},
	{10, 24}, {14, 22}, {16, 20}};
XPoint dollar2_pts[] = {{8, -2}, {8, 28}};
XPoint per1_pts[] = {{6, 24}, {4, 26}, {2, 26}, {0, 24}, {0, 20}, {2, 18}, 
	{4, 18}, {6, 20}, {6, 24}, {10, 24}, {14, 26}, {0, 0}};
XPoint per2_pts[] = {{10, 0}, {8, 2}, {8, 6}, {10, 8}, {12, 8}, {14, 6},
	{14, 2}, {12, 0}, {10, 0}};
XPoint ast1_pts[] = {{4, 8}, {4, 16}};
XPoint ast2_pts[] = {{0, 10}, {8, 14}};
XPoint ast3_pts[] = {{0, 14}, {8, 10}};
XPoint amper_pts[] = {{16, 0}, {2, 20}, {2, 24}, {4, 26}, {8, 26}, {10, 24},
	{10, 20}, {8, 18}, {2, 14}, {0, 10}, {0, 6}, {2, 2}, {6, 0}, {8, 0},
	{12, 2}, {14, 6}, {14, 8}};
XPoint lbrack_pts[] = {{6, -2}, {0, -2}, {0, 28}, {6, 28}};
XPoint rbrack_pts[] = {{0, -2}, {6, -2}, {6, 28}, {0, 28}};
XPoint backsl_pts[] = {{10, 0}, {0, 26}};
XPoint caret_pts[] = {{0, 20}, {6, 26}, {12, 20}};
XPoint under_pts[] = {{0, 0}, {20, 0}};
XPoint upneg_pts[] = {{20, 26}, {40, 26}};
XPoint apost_pts[] = {{4, 26}, {2, 24}, {2, 22}};
XPoint lbrace_pts[] = {{6, -4}, {4, -4}, {2, -2}, {2, 10}, {0, 12}, {2, 14},
	{2, 26}, {4, 28}, {6, 28}};
XPoint rbrace_pts[] = {{0, -4}, {2, -4}, {4, -2}, {4, 10}, {6, 12}, {4, 14},
	{4, 26}, {2, 28}, {0, 28}};
XPoint vbar_pts[] = {{2, -2}, {2, 28}};
XPoint tilde_pts[] = {{0, 12}, {2, 14}, {4, 14}, {8, 12}, {10, 12}, {12, 14}};

XPoint Forall_pts[] = {{4, 16}, {16, 16}};
XPoint Every1_pts[] = {{0, 0}, {18, 0}, {18, 26}, {0, 26}};
XPoint Every2_pts[] = {{4, 14}, {18, 14}};
XPoint backe1_pts[] = {{0, 0}, {8, 0}, {12, 2}, {14, 6}, {14, 10}, {12, 14},
	{8, 16}, {0, 16}};
XPoint backe2_pts[] = {{2, 8}, {14, 8}};
XPoint approx_pts[] = {{0, 18}, {2, 20}, {4, 20}, {8, 18}, {10, 18}, {12, 20}};
XPoint thfore1_pts[] = {{0, 8}, {0, 8}};
XPoint thfore2_pts[] = {{12, 8}, {12, 8}};
XPoint thfore3_pts[] = {{6, 18}, {6, 18}};
XPoint perpen1_pts[] = {{0, 8}, {12, 8}};
XPoint perpen2_pts[] = {{6, 8}, {6, 18}};

/* Extended Character Set --- Accents */

XPoint umlaut1_pts[] = {{6, 30}, {6, 31}};
XPoint umlaut2_pts[] = {{12, 30}, {12, 31}};
XPoint apos2_pts[] =   {{9, 28}, {9, 32}};
XPoint bar_pts[] =     {{6, 30}, {14, 30}};
XPoint uml21_pts[] =   {{6, 28}, {8, 32}};
XPoint uml22_pts[] =   {{10, 28}, {12, 32}};
XPoint vee_pts[] =     {{6, 32}, {10, 28}, {14, 32}};
XPoint uu_pts[] =      {{6, 32}, {8, 29}, {13, 29}, {15, 32}};
XPoint hat_pts[] =     {{6, 28}, {10, 32}, {14, 28}};
XPoint grave_pts[] =   {{8, 32}, {12, 28}};
XPoint acute_pts[] =   {{8, 28}, {12, 32}};
XPoint util_pts[] =    {{6, 29}, {8, 32}, {9, 32}, {11, 29}, {12, 29}, {14, 32}};
XPoint cedilla_pts[] = {{8, 0}, {6, -2}, {10, -4}, {8, -6}};
XPoint ced2_pts[] =    {{6, 0}, {6, -2}, {8, -4}, {10, -4}};

/* Extended Character Set --- Miscellaneous */

XPoint prime_pts[] = {{0, 20}, {4, 26}};
XPoint dprime_pts[] = {{6, 20}, {10, 26}};
XPoint upexcl1_pts[] = {{2, 0}, {2, 20}};
XPoint upexcl2_pts[] = {{2, 25}, {2, 26}};
XPoint centslash_pts[] = {{0, -6}, {14, 22}};
XPoint aslash_pts[] = {{0, 0}, {14, 26}};
XPoint yencross_pts[] = {{0, 8}, {20, 8}, {10, 8}, {10, 14}, {0, 14}, {20, 14}};
XPoint itf_pts[] = {{-2,-4}, {0, -6}, {2, -4}, {6, 24}, {8, 26}, {10, 24}};
XPoint sy1_pts[] = {{0, -2}, {2, -6}, {6, -6}, {10, -2}, {10, 0}, {2, 8}, {0, 12},
	{0, 14}, {4, 18}};
XPoint sy2_pts[] = {{8, 2}, {12, 6}, {12, 8}, {10, 12}, {2, 20}, {2, 22}, {6, 26},
	{10, 26}, {12, 22}};
XPoint inf1_pts[] = {{16, 6}, {12, 6}, {6, 16}, {2, 16}, {0, 12}, {0, 10}, {2, 6},
	{6, 6}, {12, 16}, {16, 16}};
XPoint inf2_pts[] = {{16, 16}, {18, 12}, {18, 10}, {16, 6}};
XPoint pound_pts[] = {{18, 2}, {16, 0}, {14, 0}, {4, 4}, {2, 4}, {0, 2}, {2, 0},
	{4, 0}, {8, 6}, {8, 10}, {6, 20}, {6, 22}, {8, 26}, {12, 26}, {16, 24}};
XPoint leq_pts[] = {{0, 2}, {12, 2}};
XPoint lvbar_pts[] = {{2, -8}, {2, 28}};
XPoint fi_pts[] = {{0, 18}, {12, 18}, {12, 0}};
XPoint fl_pts[] = {{10, 26}, {12, 24}, {12, 26}, {12, 18}};
XPoint uquest1_pts[] = {{14, 4}, {10, 0}, {4, 0}, {0, 4}, {0, 8}, {2, 12},
	{8, 18}, {8, 20}};
XPoint uquest2_pts[] = {{8, 25}, {8, 26}};
XPoint bullet_pts[] = {{0, 9}, {0, 12}, {3, 14}, {6, 12}, {6, 9}, {3, 7}, {0, 9}};
XPoint degree_pts[] = {{0, 21}, {0, 24}, {3, 26}, {6, 24}, {6, 21}, {3, 19}, {0, 21}};
XPoint circ_pts[] = {{7, 21}, {7, 24}, {10, 26}, {13, 24}, {13, 21}, {10, 19}, {7, 21}};
XPoint times1_pts[] = {{4, 6}, {16, 18}};
XPoint times2_pts[] = {{4, 18}, {16, 6}};
XPoint div1_pts[] = {{6, 6}, {7, 6}};
XPoint div2_pts[] = {{6, 20}, {7, 20}};
XPoint neq_pts[] = {{0, 6}, {12, 18}};
XPoint teq_pts[] = {{0, 6}, {12, 6}};
XPoint dots1_pts[] = {{8, 0}, {8, 1}};
XPoint dots2_pts[] = {{16, 0}, {16, 1}};
XPoint quote3_pts[] = {{2, 22}, {4, 24}, {4, 26}};
XPoint quote4_pts[] = {{6, 22}, {8, 24}, {8, 26}};
XPoint quote5_pts[] = {{0, 22}, {0, 24}, {2, 26}};
XPoint quote6_pts[] = {{4, 22}, {4, 24}, {6, 26}};
XPoint quote7_pts[] = {{8, 0}, {8, -2}, {6, -4}};
XPoint gqt1_pts[] = {{2, 4}, {8, 11}, {2, 18}};
XPoint gqt2_pts[] = {{8, 4}, {14, 11}, {8, 18}};
XPoint gqt3_pts[] = {{6, 4}, {0, 11}, {6, 18}};
XPoint gqt4_pts[] = {{12, 4}, {6, 11}, {12, 18}};
XPoint dag1_pts[] = {{4, 0}, {4, 24}};
XPoint dag2_pts[] = {{0, 20}, {8, 20}};
XPoint dag3_pts[] = {{0, 4}, {8, 4}};
XPoint para1_pts[] = {{6, 0}, {6, 26}};
XPoint para2_pts[] = {{10, 0}, {10, 26}};
XPoint para3_pts[] = {{6, 14}, {4, 14}, {0, 18}, {0, 22}, {4, 26}, {12, 26}};
XPoint per3_pts[] = {{20, 0}, {18, 2}, {18, 6}, {20, 8}, {22, 8}, {24, 6},
	{24, 2}, {22, 0}, {20, 0}};
XPoint sy21_pts[] = {{16, 0}, {14, 2}, {16, 6}, {16, 10}, {14, 14}, {16, 16}}; 
XPoint sy22_pts[] = {{0, 0}, {2, 2}, {0, 6}, {0, 10}, {2, 14}, {0, 16}};
XPoint arrw0_pts[] = {{0, 12}, {34, 12}};
XPoint arrw1_pts[] = {{10, -4}, {10, 30}};
XPoint larrw_pts[] = {{10, 2}, {0, 12}, {10, 22}};
XPoint rarrw_pts[] = {{24, 2}, {34, 12}, {24, 22}};
XPoint uarrw_pts[] = {{0, 20}, {10, 30}, {20, 20}};
XPoint darrw_pts[] = {{0, 6}, {10, -4}, {20, 6}};
XPoint lang_pts[] = {{8, -4}, {0, 11}, {8, 26}};
XPoint rang_pts[] = {{0, -4}, {8, 11}, {0, 26}};

/*-----------------------------------------------------------------*/

alpha Achar = { 29, 2, {3, 2, 0}, {A1_pts, A2_pts, NULL}};
alpha Bchar = { 29, 2, {8, 7, 0}, {B1_pts, B2_pts, NULL}};
alpha Cchar = { 31, 2, {9, 2, 0}, {RLeft_pts, C_pts, NULL}};
alpha Dchar = { 31, 1, {9, 0, 0}, {D_pts, NULL, NULL}};
alpha Echar = { 29, 2, {4, 2, 0}, {E1_pts, E2_pts, NULL}};
alpha Fchar = { 27, 2, {3, 2, 0}, {F1_pts, F2_pts, NULL}};
alpha Gchar = { 33, 2, {9, 5, 0}, {RLeft_pts, G_pts, NULL}};
alpha Hchar = { 31, 3, {2, 2, 2}, {H1_pts, H2_pts, H3_pts}};
alpha Ichar = { 12, 1, {2, 0, 0}, {I_pts, NULL, NULL}};
alpha Jchar = { 21, 1, {7, 0, 0}, {J_pts, NULL, NULL}};
alpha Kchar = { 29, 3, {2, 2, 2}, {H1_pts, K1_pts, K2_pts}};
alpha Lchar = { 24, 1, {3, 0, 0}, {L_pts, NULL, NULL}};
alpha Mchar = { 35, 1, {5, 0, 0}, {M_pts, NULL, NULL}};
alpha Nchar = { 31, 1, {4, 0, 0}, {N_pts, NULL, NULL}};
alpha Ochar = { 33, 2, {9, 5, 0}, {RLeft_pts, O_pts, NULL}};
alpha Pchar = { 29, 1, {7, 0, 0}, {P_pts, NULL, NULL}};
alpha Qchar = { 33, 3, {9, 5, 2}, {RLeft_pts, O_pts, Q_pts}};
alpha Rchar = { 31, 2, {7, 2, 0}, {P_pts, R_pts, NULL}};
alpha Schar = { 29, 1, {15, 0, 0}, {S_pts, NULL, NULL}};
alpha Tchar = { 27, 2, {2, 2, 0}, {T1_pts, T2_pts, NULL}};
alpha Uchar = { 31, 1, {10, 0, 0}, {U_pts, NULL, NULL}};
alpha Vchar = { 29, 1, {3, 0, 0}, {V_pts, NULL, NULL}};
alpha Wchar = { 41, 1, {5, 0, 0}, {W_pts, NULL, NULL}};
alpha Xchar = { 29, 2, {2, 2, 0}, {X1_pts, X2_pts, NULL}};
alpha Ychar = { 29, 2, {3, 2, 0}, {Y1_pts, Y2_pts, NULL}};
alpha Zchar = { 27, 1, {4, 0, 0}, {Z_pts, NULL, NULL}};

alpha CIchar ={ 27, 3, {2, 2, 2}, {Cbase_pts, CI1_pts, CI2_pts}};
alpha CMchar ={ 27, 1, {5, 0, 0}, {CM_pts, NULL, NULL}};
alpha CTchar ={ 27, 2, {2, 4, 0}, {T1_pts, CT_pts, NULL}};
alpha CWchar ={ 27, 1, {5, 0, 0}, {CW_pts, NULL, NULL}};
alpha Cfchar ={ 27, 3, {2, 5, 2}, {Cbase_pts, Cf1_pts, Cf2_pts}};
alpha Cichar ={ 27, 3, {2, 2, 3}, {Cbase_pts, Cdot_pts, Ci_pts}};
alpha Cjchar ={ 27, 2, {6, 2, 0}, {Cj_pts, Cdot_pts, NULL}};
alpha Clchar ={ 27, 2, {2, 3, 0}, {Cbase_pts, Cl_pts, NULL}};
alpha Cmchar ={ 27, 3, {2, 5, 5}, {m1_pts, Cm2_pts, Cm3_pts}};
alpha Crchar ={ 27, 3, {2, 3, 3}, {Cbase_pts, Cr1_pts, Cr2_pts}};
alpha Ctchar ={ 27, 2, {2, 5, 0}, {Cf2_pts, Ct_pts, NULL}};

alpha achar = { 24, 2, {6, 7, 0}, {a1_pts, a2_pts, NULL}};
alpha bchar = { 24, 2, {2, 10, 0}, {H1_pts, b_pts, NULL}};
alpha cchar = { 21, 1, {10, 0, 0}, {c_pts, NULL, NULL}};
alpha dchar = { 24, 2, {10, 2, 0}, {c_pts, d_pts, NULL}};
alpha echar = { 24, 2, {10, 4, 0}, {c_pts, e_pts, NULL}};
alpha fchar = { 12, 2, {4, 2, 0}, {f1_pts, f2_pts, NULL}};
alpha gchar = { 24, 2, {10, 5, 0}, {c_pts, g_pts, NULL}};
alpha hchar = { 24, 2, {2, 5, 0}, {H1_pts, h_pts, NULL}};
alpha ichar = { 10, 2, {2, 2, 0}, {i1_pts, i2_pts, NULL}};
alpha jchar = { 10, 2, {4, 2, 0}, {j1_pts, i2_pts, NULL}};
alpha kchar = { 21, 3, {2, 2, 2}, {H1_pts, k1_pts, k2_pts}};
alpha lchar = { 10, 1, {2, 0, 0}, {I_pts, NULL, NULL}};
alpha mchar = { 35, 3, {2, 5, 5}, {m1_pts, m2_pts, m3_pts}};
alpha nchar = { 24, 2, {2, 5, 0}, {m1_pts, h_pts, NULL}};
alpha ochar = { 24, 1, {13, 0, 0}, {o_pts, NULL, NULL}};
alpha pchar = { 24, 2, {10, 2, 0}, {b_pts, p_pts, NULL}};
alpha qchar = { 24, 2, {10, 2, 0}, {c_pts, q_pts, NULL}};
alpha rchar = { 14, 2, {2, 4, 0}, {m1_pts, r_pts, NULL}};
alpha schar = { 21, 1, {12, 0, 0}, {s_pts, NULL, NULL}};
alpha tchar = { 12, 2, {2, 4, 0}, {f2_pts, t_pts, NULL}};
alpha auchar ={ 24, 2, {5, 2, 0}, {u1_pts, u2_pts, NULL}};
alpha vchar = { 21, 1, {3, 0, 0}, {v_pts, NULL, NULL}};
alpha wchar = { 32, 1, {5, 0, 0}, {w_pts, NULL, NULL}};
alpha xchar = { 21, 2, {2, 2, 0}, {x1_pts, x2_pts, NULL}};
alpha ychar = { 21, 2, {2, 4, 0}, {y1_pts, y2_pts, NULL}};
alpha zchar = { 21, 1, {4, 0, 0}, {z_pts, NULL, NULL}};

/* Different spacing rules for some Times-Roman characters */

alpha TAchar = { 31, 2, {3, 2, 0}, {A1_pts, A2_pts, NULL}};
alpha TCchar = { 29, 2, {9, 2, 0}, {RLeft_pts, C_pts, NULL}};
alpha TEchar = { 27, 2, {4, 2, 0}, {E1_pts, E2_pts, NULL}};
alpha TFchar = { 25, 2, {3, 2, 0}, {F1_pts, F2_pts, NULL}};
alpha TGchar = { 31, 2, {9, 5, 0}, {RLeft_pts, G_pts, NULL}};
alpha TIchar = { 14, 3, {2, 2, 2}, {I_pts, TI1_pts, TI2_pts}};
alpha TJchar = { 16, 1, {7, 0, 0}, {TJ_pts, NULL, NULL}};
alpha TKchar = { 31, 3, {2, 2, 2}, {H1_pts, K1_pts, K2_pts}};
alpha TLchar = { 27, 1, {3, 0, 0}, {L_pts, NULL, NULL}};
alpha TMchar = { 37, 1, {5, 0, 0}, {M_pts, NULL, NULL}};
alpha TOchar = { 31, 2, {9, 5, 0}, {RLeft_pts, O_pts, NULL}};
alpha TPchar = { 24, 1, {7, 0, 0}, {P_pts, NULL, NULL}};
alpha TQchar = { 31, 3, {9, 5, 3}, {RLeft_pts, O_pts, TQ_pts}};
alpha TRchar = { 29, 2, {7, 2, 0}, {P_pts, R_pts, NULL}};
alpha TSchar = { 24, 1, {15, 0, 0}, {S_pts, NULL, NULL}};
alpha TTchar = { 27, 2, {2, 4, 0}, {T1_pts, TT_pts, NULL}};
alpha TVchar = { 31, 1, {3, 0, 0}, {V_pts, NULL, NULL}};
alpha TWchar = { 39, 1, {5, 0, 0}, {W_pts, NULL, NULL}};
alpha TXchar = { 31, 2, {2, 2, 0}, {X1_pts, X2_pts, NULL}};
alpha TYchar = { 31, 2, {3, 2, 0}, {Y1_pts, Y2_pts, NULL}};

alpha Tachar = { 19, 2, {6, 7, 0}, {a1_pts, a2_pts, NULL}};
alpha Tbchar = { 21, 2, {2, 10, 0}, {H1_pts, b_pts, NULL}};
alpha Tcchar = { 19, 1, {10, 0, 0}, {c_pts, NULL, NULL}};
alpha Tdchar = { 21, 2, {10, 2, 0}, {c_pts, d_pts, NULL}};
alpha Techar = { 19, 2, {10, 3, 0}, {c_pts, Te_pts, NULL}};
alpha Tfchar = { 14, 3, {5, 2, 2}, {Tf_pts, f2_pts, Tbase_pts}};
alpha Tgchar = { 21, 2, {19, 3, 0}, {Tg1_pts, Tg2_pts, NULL}};
alpha Thchar = { 21, 2, {2, 5, 0}, {H1_pts, h_pts, NULL}};
alpha Tichar = { 12, 3, {3, 2, 2}, {Ti_pts, Tdot_pts, Tbase_pts}};
alpha Tjchar = { 12, 2, {6, 2, 0}, {Tj_pts, Tdot_pts, NULL}};
alpha Tlchar = { 12, 2, {3, 2, 0}, {Tl_pts, Tbase_pts, NULL}};
alpha Tmchar = { 33, 3, {2, 5, 5}, {m1_pts, m2_pts, m3_pts}};
alpha Tnchar = { 21, 2, {2, 5, 0}, {m1_pts, h_pts, NULL}};
alpha Tochar = { 21, 1, {13, 0, 0}, {o_pts, NULL, NULL}};
alpha Tpchar = { 21, 2, {10, 2, 0}, {b_pts, p_pts, NULL}};
alpha Tqchar = { 21, 2, {10, 2, 0}, {c_pts, q_pts, NULL}};
alpha Trchar = { 14, 3, {3, 4, 2}, {Ti_pts, Tr_pts, Tbase_pts}};
alpha Tschar = { 16, 1, {12, 0, 0}, {Ts_pts, NULL, NULL}};
alpha Ttchar = { 12, 2, {2, 4, 0}, {f2_pts, Tt_pts, NULL}};
alpha Tuchar = { 21, 2, {5, 2, 0}, {u1_pts, u2_pts, NULL}};
alpha Twchar = { 31, 1, {5, 0, 0}, {w_pts, NULL, NULL}};
alpha Tzchar = { 19, 1, {4, 0, 0}, {z_pts, NULL, NULL}};

/* Greek (symbol) font */

alpha Deltachar = { 30, 2, {2, 3, 0}, {Delta_pts, A1_pts, NULL}};
alpha Lambdachar= { 32, 1, {3, 0, 0}, {A1_pts, NULL, NULL}};
alpha Phichar   = { 33, 2, {2, 17, 0}, {Phi1_pts, Phi2_pts, NULL}};
alpha Gammachar = { 30, 2, {2, 2, 0}, {Gamma1_pts, Gamma2_pts, NULL}};
alpha Pichar	= { 34, 3, {2, 2, 2}, {Gamma1_pts, Pi1_pts, Pi2_pts}};
alpha Thetachar = { 32, 3, {9, 5, 2}, {RLeft_pts, O_pts, Theta_pts}};
alpha Sigmachar = { 29, 1, {5, 0, 0}, {Sigma_pts, NULL, NULL}};
alpha Chichar	= { 28, 3, {2, 2, 2}, {Delta_pts, Pi2_pts, Chi_pts}};
alpha Psichar   = { 36, 2, {2, 14, 0}, {Phi1_pts, Psi_pts, NULL}};
alpha Omegachar = { 34, 1, {22, 0, 0}, {Omega_pts, NULL, NULL}};
alpha Upsilchar = { 30, 2, {6, 4, 0}, {Upsi1_pts, Upsi2_pts, NULL}};
alpha GrYchar =   { 26, 2, {3, 2, 0}, {Y1_pts, Y2_pts, NULL}};

alpha alphachar = { 29, 1, {13, 0, 0}, {alpha_pts, NULL, NULL}};
alpha betachar  = { 24, 3, {10, 7, 2}, {beta1_pts, beta2_pts, beta3_pts}};
alpha chichar	= { 26, 2, {2, 6, 0}, {chi1_pts, chi2_pts, NULL}};
alpha deltachar = { 23, 1, {15, 0, 0}, {delta_pts, NULL, NULL}};
alpha epsichar  = { 22, 1, {13, 0, 0}, {epsilon_pts, NULL, NULL}};
alpha phichar	= { 24, 2, {2, 13, 0}, {phi_pts, omicron_pts, NULL}};
alpha gammachar = { 25, 1, {10, 0, 0}, {gamma_pts, NULL, NULL}};
alpha etachar	= { 27, 2, {4, 5, 0}, {eta1_pts, eta2_pts, NULL}};
alpha iotachar	= { 18, 1, {4, 0, 0}, {iota_pts, NULL, NULL}};
alpha kappachar = { 27, 3, {2, 3, 2}, {m1_pts, kappa1_pts, kappa2_pts}};
alpha lambdachar= { 27, 2, {2, 6, 0}, {lambda1_pts, lambda2_pts, NULL}};
alpha muchar	= { 27, 3, {2, 4, 4}, {mu1_pts, mu2_pts, mu3_pts}};
alpha nuchar	= { 25, 1, {7, 0, 0}, {nu_pts, NULL, NULL}};
alpha omicrchar	= { 24, 1, {13, 0, 0}, {omicron_pts, NULL, NULL}};
alpha pichar	= { 26, 3, {3, 2, 4}, {pi1_pts, pi2_pts, pi3_pts}};
alpha thetachar	= { 23, 2, {13, 2, 0}, {theta1_pts, theta2_pts, NULL}};
alpha rhochar	= { 28, 1, {12, 0, 0}, {rho_pts, NULL, NULL}};
alpha sigmachar	= { 28, 2, {13, 2, 0}, {omicron_pts, sigma_pts, NULL}};
alpha tauchar	= { 22, 2, {3, 4, 0}, {tau1_pts, tau2_pts, NULL}};
alpha upsilchar = { 27, 1, {10, 0, 0}, {ups_pts, NULL, NULL}};
alpha omegachar = { 31, 2, {9, 8, 0}, {omega1_pts, omega2_pts, NULL}};
alpha xichar	= { 23, 2, {4, 15, 0}, {xi1_pts, xi2_pts, NULL}};
alpha psichar	= { 33, 2, {2, 11, 0}, {psi1_pts, psi2_pts, NULL}};
alpha zetachar	= { 22, 2, {4, 11, 0}, {xi1_pts, zeta_pts, NULL}};

alpha alttheta	= { 30, 1, {18, 0, 0}, {ath_pts, NULL, NULL}};
alpha altsigma	= { 22, 1, {13, 0, 0}, {asig_pts, NULL, NULL}};
alpha altphi	= { 28, 1, {14, 0, 0}, {aphi_pts, NULL, NULL}};
alpha altomega	= { 31, 3, {3, 8, 6}, {aomega1_pts, aomega2_pts, aomega3_pts}}; 

alpha num0char = {26, 1, {13, 0, 0}, {num0_pts, NULL, NULL}};
alpha num1char = {12, 1, {4, 0, 0}, {num1_pts, NULL, NULL}};
alpha num2char = {26, 1, {11, 0, 0}, {num2_pts, NULL, NULL}};
alpha num3char = {24, 2, {9, 8, 0}, {num3_1_pts, num3_2_pts, NULL}};
alpha num4char = {26, 1, {4, 0, 0}, {num4_pts, NULL, NULL}}; 
alpha num5char = {24, 1, {12, 0, 0}, {num5_pts, NULL, NULL}};
alpha num6char = {26, 1, {17, 0, 0}, {num6_pts, NULL, NULL}};
alpha num7char = {24, 1, {5, 0, 0}, {num7_pts, NULL, NULL}};
alpha num8char = {26, 1, {19, 0, 0}, {num8_pts, NULL, NULL}};
alpha num9char = {26, 1, {17, 0, 0}, {num9_pts, NULL, NULL}};

alpha ctrlchar = {  0, 1, {5, 0, 0}, {box_pts, NULL, NULL}};
alpha spacechar = {14, 0, {0, 0, 0}, {NULL, NULL, NULL}};
alpha exclchar = { 12, 2, {2, 2, 0}, {excl1_pts, excl2_pts, NULL}};
alpha quotechar = {16, 2, {2, 2, 0}, {quote1_pts, quote2_pts, NULL}};
alpha commachar = {14, 1, {3, 0, 0}, {comma_pts, NULL, NULL}};
alpha lparenchar ={14, 1, {6, 0, 0}, {lparen_pts, NULL, NULL}};
alpha rparenchar ={14, 1, {6, 0, 0}, {rparen_pts, NULL, NULL}};
alpha pluschar = { 20, 2, {2, 2, 0}, {plus_pts, minus_pts, NULL}};
alpha minuschar = {20, 1, {2, 0, 0}, {minus_pts, NULL, NULL}};
alpha poundchar = {24, 3, {5, 2, 2}, {pound1_pts, pound2_pts, pound3_pts}};
alpha questchar = {22, 2, {8, 2, 0}, {quest1_pts, quest2_pts, NULL}};
alpha colonchar = {12, 2, {2, 2, 0}, {colon1_pts, colon2_pts, NULL}};
alpha semichar = { 12, 2, {3, 2, 0}, {semi1_pts, semi2_pts, NULL}};
alpha equalchar = {20, 2, {2, 2, 0}, {equal1_pts, equal2_pts, NULL}};
alpha lesschar = { 20, 1, {3, 0, 0}, {less_pts, NULL, NULL}};
alpha morechar = { 20, 1, {3, 0, 0}, {more_pts, NULL, NULL}};
alpha periodchar ={12, 1, {2, 0, 0}, {excl2_pts, NULL, NULL}};
alpha slashchar = {18, 1, {2, 0, 0}, {slash_pts, NULL, NULL}};
alpha atchar = {   32, 2, {20, 9, 0}, {at1_pts, at2_pts, NULL}};
alpha dollarchar ={24, 2, {16, 2, 0}, {dollar1_pts, dollar2_pts, NULL}};
alpha percentchar={22, 2, {12, 9, 0}, {per1_pts, per2_pts, NULL}};
alpha asterchar = {16, 3, {2, 2, 2}, {ast1_pts, ast2_pts, ast3_pts}};
alpha amperchar = {24, 1, {17, 0, 0}, {amper_pts, NULL, NULL}};
alpha lbrackchar ={14, 1, {4, 0, 0}, {lbrack_pts, NULL, NULL}};
alpha underchar = {28, 1, {2, 0, 0}, {under_pts, NULL, NULL}};
alpha rbrackchar ={14, 1, {4, 0, 0}, {rbrack_pts, NULL, NULL}};
alpha backslchar ={18, 1, {2, 0, 0}, {backsl_pts, NULL, NULL}};
alpha caretchar = {20, 1, {3, 0, 0}, {caret_pts, NULL, NULL}};
alpha apostchar = {12, 1, {3, 0, 0}, {apost_pts, NULL, NULL}};
alpha upnegchar = {46, 1, {2, 0, 0}, {upneg_pts, NULL, NULL}};
alpha lbracechar ={14, 1, {9, 0, 0}, {lbrace_pts, NULL, NULL}};
alpha rbracechar ={14, 1, {9, 0, 0}, {rbrace_pts, NULL, NULL}};
alpha vbarchar = { 12, 1, {2, 0, 0}, {vbar_pts, NULL, NULL}};
alpha tildechar = {20, 1, {6, 0, 0}, {tilde_pts, NULL, NULL}};
alpha forallchar ={28, 2, {3, 2, 0}, {V_pts, Forall_pts, NULL}};
alpha everychar = {26, 2, {4, 2, 0}, {Every1_pts, Every2_pts, NULL}};
alpha backechar = {22, 2, {8, 2, 0}, {backe1_pts, backe2_pts, NULL}};
alpha approxchar ={20, 3, {2, 2, 6}, {equal1_pts, equal2_pts, approx_pts}};
alpha therefchar ={20, 3, {2, 2, 2}, {thfore1_pts, thfore2_pts, thfore3_pts}};
alpha perpenchar ={20, 2, {2, 2, 0}, {perpen1_pts, perpen2_pts, NULL}};

alpha upexclchar ={12, 2, {2, 2, 0}, {upexcl1_pts, upexcl2_pts, NULL}};
alpha centchar = { 22, 2, {10, 2, 0},{c_pts, centslash_pts, NULL}};
alpha lbchar  = { 28, 2, {15, 2, 0}, {pound_pts, theta2_pts, NULL}}; 
alpha aslashchar ={20, 1, {2, 0, 0}, {aslash_pts, NULL, NULL}}; 
alpha yenchar = { 28, 3, {3, 2, 6},  {Y1_pts, Y2_pts, yencross_pts}};
alpha itfchar = { 20, 2, {6, 2, 0},  {itf_pts, f2_pts, NULL}};
alpha sy1char = { 22, 2, {9, 9, 0},  {sy1_pts, sy2_pts, NULL}};
alpha fichar  = { 22, 2, {4, 3, 0},  {f1_pts, fi_pts, NULL}};
alpha flchar  = { 22, 3, {4, 3, 4},  {f1_pts, fi_pts, fl_pts}};
alpha bulltchar ={14, 1, {7, 0, 0},  {bullet_pts, NULL, NULL}};
alpha dotschar = {24, 3, {2, 2, 2},  {excl2_pts, dots1_pts, dots2_pts}};
alpha uqestchar ={22, 2, {8, 2, 0},  {uquest1_pts, uquest2_pts, NULL}};
alpha circchar ={ 28, 1, {7, 0, 0},  {circ_pts, NULL, NULL}};

alpha prmchar = { 14, 1, {2, 0, 0},  {prime_pts, NULL, NULL}};
alpha leqchar = { 26, 2, {3, 2, 0},  {less_pts, leq_pts, NULL}};
alpha infchar = { 32, 2, {10, 4, 0}, {inf1_pts, inf2_pts, NULL}};
alpha degrechar ={18, 1, {7, 0, 0},  {degree_pts, NULL, NULL}};
alpha dprmchar = {21, 2, {2, 2, 0},  {prime_pts, dprime_pts, NULL}}; 
alpha geqchar = { 26, 2, {3, 2, 0},  {more_pts, leq_pts, NULL}};
alpha timeschar ={26, 2, {2, 2, 0},  {times1_pts, times2_pts, NULL}};
alpha propchar ={ 24, 1, {10, 0, 0}, {inf1_pts, NULL, NULL}};
alpha derivchar ={23, 1, {17, 0, 0}, {adel_pts, NULL, NULL}};
alpha divchar = { 27, 3, {2, 2, 2},  {div1_pts, div2_pts, minus_pts}};
alpha neqchar = { 27, 3, {2, 2, 2},  {equal1_pts, equal2_pts, neq_pts}};
alpha teqchar = { 27, 3, {2, 2, 2},  {equal1_pts, equal2_pts, teq_pts}};
alpha lvbarchar ={12, 1, {2, 0, 0},  {lvbar_pts, NULL, NULL}};
alpha simchar = { 20, 2, {6, 6, 0},  {tilde_pts, approx_pts, NULL}};
alpha pmchar =  { 27, 3, {2, 2, 2},  {plus_pts, minus_pts, teq_pts}};
alpha rqtchar = { 18, 2, {3, 3, 0},  {quote3_pts, quote4_pts, NULL}};
alpha lqtchar = { 18, 2, {3, 3, 0},  {quote5_pts, quote6_pts, NULL}};
alpha rqt2char ={ 18, 2, {3, 3, 0},  {comma_pts, quote7_pts, NULL}};
alpha rgqtchar ={ 24, 2, {3, 3, 0},  {gqt1_pts, gqt2_pts, NULL}};
alpha lgqtchar ={ 24, 2, {3, 3, 0},  {gqt3_pts, gqt4_pts, NULL}};
alpha rsangchar={ 18, 1, {3, 0, 0},  {gqt1_pts, NULL, NULL}};
alpha lsangchar={ 18, 1, {3, 0, 0},  {gqt3_pts, NULL, NULL}};
alpha dagchar = { 16, 2, {2, 2, 0},  {dag1_pts, dag2_pts, NULL}};
alpha ddagchar ={ 16, 3, {2, 2, 2},  {dag1_pts, dag2_pts, dag3_pts}};
alpha dotchar = { 14, 1, {2, 0, 0},  {uquest2_pts, NULL, NULL}};
alpha parachar ={ 18, 3, {2, 2, 6},  {para1_pts, para2_pts, para3_pts}};
alpha oslchar = { 22, 2, {13, 2, 0}, {o_pts, x1_pts, NULL}};
alpha Oslchar = { 30, 3, {9, 5, 2},  {RLeft_pts, O_pts, X1_pts}};
alpha ssetchar ={ 22, 2, {10, 7, 0}, {beta1_pts, beta2_pts, NULL}};
alpha perzerchar={22, 2, {12, 9, 9}, {per1_pts, per2_pts, per3_pts}};
alpha sy2char = { 24, 3, {10, 6, 6}, {c_pts, sy21_pts, sy22_pts}};
alpha larrwchar={ 42, 2, {2, 3, 0},  {arrw0_pts, larrw_pts, NULL}};
alpha rarrwchar={ 42, 2, {2, 3, 0},  {arrw0_pts, rarrw_pts, NULL}};
alpha lrarwchar={ 30, 2, {2, 3, 3},  {arrw0_pts, rarrw_pts, larrw_pts}};
alpha uarrwchar={ 27, 2, {2, 3, 0},  {arrw1_pts, uarrw_pts, NULL}};
alpha darrwchar={ 27, 2, {2, 3, 0},  {arrw1_pts, darrw_pts, NULL}};
alpha rangchar ={ 16, 1, {3, 0, 0},  {rang_pts, NULL, NULL}};
alpha langchar ={ 16, 1, {3, 0, 0},  {lang_pts, NULL, NULL}};

alpha gravchar ={ 28, 1, {2, 0, 0}, {grave_pts, NULL, NULL}};
alpha acutchar ={ 28, 1, {2, 0, 0}, {acute_pts, NULL, NULL}};
alpha hatchar = { 28, 1, {3, 0, 0}, {hat_pts, NULL, NULL}};
alpha tilchar = { 28, 1, {6, 0, 0}, {util_pts, NULL, NULL}};
alpha barchar = { 28, 1, {2, 0, 0}, {bar_pts, NULL, NULL}};
alpha uuchar =  { 28, 1, {4, 0, 0}, {uu_pts, NULL, NULL}};
alpha umlchar = { 28, 2, {2, 2, 0}, {umlaut1_pts, umlaut2_pts, NULL}};
alpha uml2char ={ 28, 2, {2, 2, 0}, {uml21_pts, uml22_pts, NULL}};
alpha veechar = { 28, 1, {3, 0, 0}, {vee_pts, NULL, NULL}};
alpha cedchar = { 28, 1, {4, 0, 0}, {cedilla_pts, NULL, NULL}};
alpha ced2char ={ 28, 1, {4, 0, 0}, {ced2_pts, NULL, NULL}};
alpha apos2char={ 28, 1, {2, 0, 0}, {apos2_pts, NULL, NULL}};

/*----------------------------------------------------------------------*/
/* Note:  indices 1 through 17 are reserved for font information,  	*/
/* and must declare width = 0, which is done in ctrlchar. 		*/

alphaptr alphabet[] = {
   &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar,
   &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar,
   &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar,
   &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar,
   &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar,
   &ctrlchar, &ctrlchar,
   &spacechar, &exclchar, &quotechar, &poundchar, &dollarchar, &percentchar, 
   &amperchar, &apostchar, &lparenchar, &rparenchar, &asterchar, &pluschar, 
   &commachar, &minuschar, &periodchar, &slashchar,
   &num0char, &num1char, &num2char, &num3char, &num4char, &num5char, 
   &num6char, &num7char, &num8char, &num9char, &colonchar, &semichar, 
   &lesschar, &equalchar, &morechar, &questchar, &atchar,
   &TAchar, &Bchar, &TCchar, &Dchar, &TEchar, &TFchar, &TGchar, &Hchar, &TIchar,
   &TJchar, &TKchar, &TLchar, &TMchar, &Nchar, &TOchar, &TPchar, &TQchar, &TRchar,
   &TSchar, &TTchar, &Uchar, &TVchar, &TWchar, &TXchar, &TYchar, &Zchar, 
   &lbrackchar, &backslchar, &rbrackchar, &caretchar, &underchar, &apostchar,
   &Tachar, &Tbchar, &Tcchar, &Tdchar, &Techar, &Tfchar, &Tgchar, &Thchar, &Tichar, 
   &Tjchar, &kchar, &Tlchar, &Tmchar, &Tnchar, &Tochar, &Tpchar, &Tqchar, &rchar, 
   &Tschar, &Ttchar, &Tuchar, &vchar, &Twchar, &xchar, &ychar, &Tzchar, 
   &lbracechar, &vbarchar, &rbracechar, &tildechar, &ctrlchar,
   &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar,
   &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar,
   &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar,
   &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar,
   &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar,
   /* extended character set, starting at 161d */
   &upexclchar, &centchar, &lbchar, &aslashchar, &yenchar, &itfchar, &sy1char,
   &sy2char, &apos2char, &lqtchar, &lgqtchar, &lsangchar, &rsangchar, &fichar,
   &flchar, &ctrlchar, &minuschar, &dagchar, &ddagchar, &dotchar, &ctrlchar,
   &parachar, &bulltchar, &commachar, &rqt2char, &rqtchar, &rgqtchar, &dotschar,
   &perzerchar, &ctrlchar, &uqestchar, &ctrlchar, &gravchar, &acutchar, &hatchar,
   &tilchar, &barchar, &uuchar, &dotchar, &umlchar, &ctrlchar, &circchar,
   &cedchar, &ctrlchar, &uml2char, &ced2char, &veechar, &ctrlchar, &ctrlchar,
   &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar,
   &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar,
   &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar,
   &ctrlchar, &ctrlchar, &Oslchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar,
   &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar,
   &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &oslchar, &ctrlchar, &ssetchar,
   &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar,
};

alphaptr helveticabet[] = {
   &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar,
   &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar,
   &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar,
   &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar,
   &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar,
   &ctrlchar, &ctrlchar,
   &spacechar, &exclchar, &quotechar, &poundchar, &dollarchar, &percentchar, 
   &amperchar, &apostchar, &lparenchar, &rparenchar, &asterchar, &pluschar, 
   &commachar, &minuschar, &periodchar, &slashchar,
   &num0char, &num1char, &num2char, &num3char, &num4char, &num5char, 
   &num6char, &num7char, &num8char, &num9char, &colonchar, &semichar, 
   &lesschar, &equalchar, &morechar, &questchar, &atchar,
   &Achar, &Bchar, &Cchar, &Dchar, &Echar, &Fchar, &Gchar, &Hchar, &Ichar,
   &Jchar, &Kchar, &Lchar, &Mchar, &Nchar, &Ochar, &Pchar, &Qchar, &Rchar,
   &Schar, &Tchar, &Uchar, &Vchar, &Wchar, &Xchar, &Ychar, &Zchar, 
   &lbrackchar, &backslchar, &rbrackchar, &caretchar, &underchar, &apostchar,
   &achar, &bchar, &cchar, &dchar, &echar, &fchar, &gchar, &hchar, &ichar, 
   &jchar, &kchar, &lchar, &mchar, &nchar, &ochar, &pchar, &qchar, &rchar, 
   &schar, &tchar, &auchar, &vchar, &wchar, &xchar, &ychar, &zchar, 
   &lbracechar, &vbarchar, &rbracechar, &tildechar, &ctrlchar,
   &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar,
   &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar,
   &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar,
   &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar,
   &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar,
   /* extended character set, starting at 161d */
   &upexclchar, &centchar, &lbchar, &aslashchar, &yenchar, &itfchar, &sy1char,
   &sy2char, &apos2char, &lqtchar, &lgqtchar, &lsangchar, &rsangchar, &fichar,
   &flchar, &ctrlchar, &minuschar, &dagchar, &ddagchar, &dotchar, &ctrlchar,
   &parachar, &bulltchar, &commachar, &rqt2char, &rqtchar, &rgqtchar, &dotschar,
   &perzerchar, &ctrlchar, &uqestchar, &ctrlchar, &gravchar, &acutchar, &hatchar,
   &tilchar, &barchar, &uuchar, &dotchar, &umlchar, &ctrlchar, &circchar,
   &cedchar, &ctrlchar, &uml2char, &ced2char, &veechar, &ctrlchar, &ctrlchar,
   &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar,
   &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar,
   &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar,
   &ctrlchar, &ctrlchar, &Oslchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar,
   &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar,
   &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &oslchar, &ctrlchar, &ssetchar,
   &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar,
};

#define COURIER_WIDTH 27

alphaptr courierbet[] = {
   &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar,
   &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar,
   &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar,
   &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar,
   &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar,
   &ctrlchar, &ctrlchar,
   &spacechar, &exclchar, &quotechar, &poundchar, &dollarchar, &percentchar, 
   &amperchar, &apostchar, &lparenchar, &rparenchar, &asterchar, &pluschar, 
   &commachar, &minuschar, &periodchar, &slashchar,
   &num0char, &num1char, &num2char, &num3char, &num4char, &num5char, 
   &num6char, &num7char, &num8char, &num9char, &colonchar, &semichar, 
   &lesschar, &equalchar, &morechar, &questchar, &atchar,
   &Achar, &Bchar, &Cchar, &Dchar, &Echar, &Fchar, &Gchar, &Hchar, &CIchar,
   &Jchar, &Kchar, &Lchar, &CMchar, &Nchar, &Ochar, &Pchar, &Qchar, &Rchar,
   &Schar, &CTchar, &Uchar, &Vchar, &CWchar, &Xchar, &Ychar, &Zchar, 
   &lbrackchar, &backslchar, &rbrackchar, &caretchar, &underchar, &apostchar,
   &achar, &bchar, &cchar, &dchar, &echar, &Cfchar, &gchar, &hchar, &Cichar, 
   &Cjchar, &kchar, &Clchar, &Cmchar, &nchar, &ochar, &pchar, &qchar, &Crchar, 
   &schar, &Ctchar, &auchar, &vchar, &wchar, &xchar, &ychar, &zchar, 
   &lbracechar, &vbarchar, &rbracechar, &tildechar, &ctrlchar,
   &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar,
   &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar,
   &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar,
   &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar,
   &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar,
   /* extended character set, starting at 161d */
   &upexclchar, &centchar, &lbchar, &aslashchar, &yenchar, &itfchar, &sy1char,
   &sy2char, &apos2char, &lqtchar, &lgqtchar, &lsangchar, &rsangchar, &fichar,
   &flchar, &ctrlchar, &minuschar, &dagchar, &ddagchar, &dotchar, &ctrlchar,
   &parachar, &bulltchar, &commachar, &rqt2char, &rqtchar, &rgqtchar, &dotschar,
   &perzerchar, &ctrlchar, &uqestchar, &ctrlchar, &gravchar, &acutchar, &hatchar,
   &tilchar, &barchar, &uuchar, &dotchar, &umlchar, &ctrlchar, &circchar,
   &cedchar, &ctrlchar, &uml2char, &ced2char, &veechar, &ctrlchar, &ctrlchar,
   &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar,
   &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar,
   &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar,
   &ctrlchar, &ctrlchar, &Oslchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar,
   &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar,
   &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &oslchar, &ctrlchar, &ssetchar,
   &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar,
};

alphaptr symbolbet[] = {
   &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar,
   &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar,
   &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar,
   &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar,
   &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar,
   &ctrlchar, &ctrlchar,
   &spacechar, &exclchar, &forallchar, &poundchar, &everychar, &percentchar,
   &amperchar, &backechar, &lparenchar, &rparenchar, &asterchar, &pluschar,
   &commachar, &minuschar, &periodchar, &slashchar,
   &num0char, &num1char, &num2char, &num3char, &num4char, &num5char,
   &num6char, &num7char, &num8char, &num9char, &colonchar, &semichar,
   &lesschar, &equalchar, &morechar, &questchar, &approxchar,
   &TAchar, &Bchar, &Xchar, &Deltachar, &TEchar, &Phichar, &Gammachar, 
   &Hchar, &TIchar, &alttheta, &TKchar, &Lambdachar, &TMchar, &Nchar, &TOchar, 
   &Pichar, &Thetachar, &TPchar, &Sigmachar, &TTchar, &GrYchar, &altsigma, 
   &Omegachar, &Chichar, &Psichar, &Zchar,
   &lbrackchar, &therefchar, &rbrackchar, &perpenchar, &underchar, &upnegchar,
   &alphachar, &betachar, &chichar, &deltachar, &epsichar, &phichar, 
   &gammachar, &etachar, &iotachar, &altphi, &kappachar, &lambdachar, &muchar,
   &nuchar, &omicrchar, &pichar, &thetachar, &rhochar, &sigmachar, &tauchar,
   &upsilchar, &altomega, &omegachar, &xichar, &psichar, &zetachar,
   &lbracechar, &vbarchar, &rbracechar, &tildechar, &ctrlchar,
   &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar,
   &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar,
   &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar,
   &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar,
   &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar,
   /* extended character set, starting at 161d */
   &Upsilchar, &prmchar, &leqchar, &aslashchar, &infchar, &itfchar, &ctrlchar,
   &ctrlchar, &ctrlchar, &ctrlchar, &lrarwchar, &larrwchar, &uarrwchar, &rarrwchar,
   &darrwchar, &degrechar, &pmchar, &dprmchar, &geqchar, &timeschar, &propchar,
   &derivchar, &bulltchar, &divchar, &neqchar, &teqchar, &simchar, &dotschar,
   &lvbarchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar,
   &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar,
   &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar,
   &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar,
   &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar,
   &ctrlchar, &langchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar,
   &lvbarchar, &ctrlchar, &ctrlchar, &lvbarchar, &ctrlchar, &ctrlchar, &ctrlchar,
   &ctrlchar, &lvbarchar, &ctrlchar, &rangchar, &ctrlchar, &ctrlchar, &ctrlchar,
   &ctrlchar, &ctrlchar, &lvbarchar, &ctrlchar, &ctrlchar, &lvbarchar, &ctrlchar,
   &ctrlchar, &ctrlchar, &ctrlchar, &ctrlchar,
};

/*-----------------------------------------------------------------*/
