/*-------------------------------------------------------------------------*/
/* rcfile.c --- Load initialization variables from the .xcircuitrc file	   */
/*-------------------------------------------------------------------------*/
   
/*-------------------------------------------------------------------------*/
/*      written by Tim Edwards, 9/9/96                                     */
/*-------------------------------------------------------------------------*/

#include <stdio.h>
#include <string.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include "Xw/Xw.h"

#define Loaded 2

/*-------------------------------------------------------------------------*/
/* Local includes                                                          */
/*-------------------------------------------------------------------------*/

#include "xcircuit.h"

/*-------------------------------------------------------------------------*/
/* Global Variable definitions						   */
/*-------------------------------------------------------------------------*/

extern char _STR2[250], _STR[150];
extern char **fonts;
extern short fontcount;
extern Clientdata areastruct;
extern short beeper;

/*-------------------------------------------------------------------------*/

loadrcfile()
{
   char *userdir = getenv("HOME");
   FILE *fd;
   char temp[250], commandstr[30], type[50], value[50];
   char *cmdptr;
   short liboverride = False;

   sprintf(_STR2, "%s", USER_RC_FILE);     /* Name imported from Makefile */

   /* try first in current directory, then look in user's home directory */

   if ((fd = fopen(_STR2, "r")) == NULL) {
      sprintf(_STR2, "%s/%s", userdir, USER_RC_FILE);
      if ((fd = fopen(_STR2, "r")) == NULL) goto end;
   }

   while (fgets(temp, 249, fd) != NULL) {
      sscanf(temp, "%s", commandstr);
      for(cmdptr = commandstr; isspace(*cmdptr); cmdptr++);

      /* very liberal about comment line characters */

      if (*cmdptr == '#' || *cmdptr == '%' || *cmdptr == ';');

      else if (!strcmp(cmdptr, "override")) {
	 sscanf(temp, "%*s %s", _STR);
	 if (!strcmp(_STR, "default")) {
	    sscanf(temp, "%*s %*s %s", value);
	    if (!strcmp(value, "library") || !strcmp(value, "libraries")) {
	       liboverride = True;
	    }
         }
      }

      /* load builtin libraries */

      else if (!strcmp(cmdptr, "library")) {

	 /* if loading of default libraries is not overridden, load them first */

	 if (liboverride == False) {
	    sprintf(_STR, BUILTINS_FILE);
	    loadlibrary(LIBRARY);
	    liboverride = Loaded;
	 }

	 sscanf(temp, "%*s %s", _STR);
	 loadlibrary(LIBRARY);
	 liboverride = Loaded;
      }

      /* load extra fonts */

      else if (!strcmp(cmdptr, "font")) {
	 sscanf(temp, "%*s %s", _STR2);
	 fonts = (char **) realloc (fonts, (fontcount + 1) * sizeof(char *));
         fonts[fontcount] = (char *) malloc (sizeof(char));
         setnewfont(NULL, fonts[fontcount]);
      }

      /* set variables */
 
      else if (!strcmp(cmdptr, "set")) {
	 sscanf(temp, "%*s %s", _STR);
	 if (!strcmp(_STR, "default")) {
	    sscanf(temp, "%*s %*s %s %s", type, value);
	    if (!strcmp(type, "font")) topsetfont(value);
         }
	 else if (!strcmp(_STR, "boxedit")) {
	    sscanf(temp, "%*s %*s %s", value);
	    if (!strcmp(value, "rhomboid-x")) boxedit(NULL, RHOMBOIDX, NULL);
	    else if (!strcmp(value, "rhomboid-y")) boxedit(NULL, RHOMBOIDY, NULL);
	    else if (!strcmp(value, "manhattan")) boxedit(NULL, MANHATTAN, NULL);
	    else if (!strcmp(value, "normal")) boxedit(NULL, NORMAL, NULL);

         }
	 else if (!strcmp(_STR, "linewidth")) {
	    sscanf(temp, "%*s %*s %*s %f", &areastruct.wirewidth[0]);
	 }
         else if (!strcmp(_STR, "beep")) {
	    sscanf(temp, "%*s %*s %s %s", type, value);
	    if (!strcmp(type, "off")) beeper = 0;
	 }
         else if (!strcmp(_STR, "colorscheme")) {
	    sscanf(temp, "%*s %*s %s", value);
	    if (!strcmp(value, "inverse") || !strcmp(value, "2"))
	       setcolorscheme(False);
 	 }
      }
   }

   /* arrange the loaded libraries */

end:
   if (liboverride != Loaded) {
      sprintf(_STR, BUILTINS_FILE);
      loadlibrary(LIBRARY);
   }
   composelib(LIBRARY);
}

#undef Loaded
